/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.LandscapeClassObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;

public abstract class LandscapeObject {
    public static final String COLOUR_ID = "color";
    public static final String LABEL_COLOUR_ID = "labelcolor";
    public static final String OPEN_COLOUR_ID = "opencolor";
    private static final int MAX_RGB = 255;
    private static int m_edge_mode = 0;
    protected static LandscapeObject m_infoShown = null;
    private LandscapeClassObject m_parentClass;
    private Color m_objectColor = null;
    private int m_style = -1;
    private JComponent m_swingObject;
    private Hashtable m_attributes;

    protected String qt(String str) {
        return AttributeValueItem.qt(str);
    }

    private static String taColor(Color color1) {
        int red = color1.getRed();
        int green = color1.getGreen();
        int blue = color1.getBlue();
        return "(" + (double)red / 255.0 + " " + (double)green / 255.0 + " " + (double)blue / 255.0 + ")";
    }

    protected boolean logEdit(UndoableEdit undoableEdit) {
        return this.getDiagram().logEdit(undoableEdit);
    }

    public JComponent getSwingObject() {
        return this.m_swingObject;
    }

    public void setSwingObject(JComponent swingObject) {
        this.m_swingObject = swingObject;
    }

    public LandscapeClassObject getParentClass() {
        return this.m_parentClass;
    }

    public LandscapeClassObject derivedFrom(int i) {
        return i == 0 ? this.m_parentClass : null;
    }

    public void setParentClass(LandscapeClassObject parentClass) {
        this.m_parentClass = parentClass;
    }

    public void updateParentClass(LandscapeClassObject parentClass) {
        if (parentClass != this.m_parentClass) {
            new UpdateParentClass(this, parentClass);
        }
    }

    public Diagram getDiagram() {
        return this.m_parentClass.getDiagram();
    }

    public boolean hasStyle() {
        return this.m_style >= 0;
    }

    public int getStyle() {
        int ret = this.m_style;
        if (ret < 0) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getStyle()) < 0) {
                ++i;
            }
        }
        return ret;
    }

    public String getStyleName(int style) {
        return "";
    }

    public void setStyle(int value) {
        this.m_style = value;
    }

    public void updateStyle(int value) {
        if (value != this.m_style) {
            new UpdateStyle(this, value);
        }
    }

    public Color getColorWhenOpen() {
        return null;
    }

    public void setColorWhenOpen(Color color) {
        System.out.println("Can't setColorWhenOpen(" + color + ") on " + this);
    }

    public boolean hasColorWhenOpen() {
        return false;
    }

    public boolean hasObjectColor() {
        return this.m_objectColor != null;
    }

    public Color getObjectColor() {
        Color ret = this.m_objectColor;
        if (ret == null) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getObjectColor()) == null) {
                ++i;
            }
        }
        return ret;
    }

    public void setObjectColor(Color color) {
        this.m_objectColor = color;
    }

    public void updateObjectColor(Color color) {
        if (color == null ? this.m_objectColor == null : color.equals(this.m_objectColor)) {
            return;
        }
        new UpdateObjectColor(this, color);
    }

    public Color getLabelColor() {
        return null;
    }

    public void setLabelColor(Color color) {
        System.out.println("Can't setLabelColor(" + color + ") on " + this);
    }

    public void updateLabelColor(Color color) {
        System.out.println("Can't updateLabelColor(" + color + ") on " + this);
    }

    public boolean hasLabelColor() {
        return false;
    }

    public int getLsAttributesSize() {
        if (this.m_attributes == null) {
            return 0;
        }
        return this.m_attributes.size();
    }

    public Attribute getLsAttribute(String id) {
        if (this.m_attributes != null) {
            return (Attribute)this.m_attributes.get(id);
        }
        return null;
    }

    public Attribute getLsAttributeAt(int index) {
        if (this.m_attributes != null) {
            Enumeration en = this.m_attributes.elements();
            while (en.hasMoreElements()) {
                Object attr = en.nextElement();
                if (index == 0) {
                    return (Attribute)attr;
                }
                --index;
            }
        }
        return null;
    }

    public Enumeration getLsAttributesEnum() {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.elements();
    }

    public void putLsAttribute(Attribute attr) {
        if (this.m_attributes == null) {
            this.m_attributes = new Hashtable(5);
        }
        this.m_attributes.put(attr.id, attr);
    }

    public void addAttribute(Attribute attr) {
        if (this.processFirstOrder(attr)) {
            return;
        }
        Attribute curAttr = this.getLsAttribute(attr.id);
        if (curAttr != null) {
            this.m_attributes.remove(attr.id);
        }
        this.putLsAttribute(attr);
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, Object type, Object val) {
        Object[] ent = new Object[]{st.get(id), type, val};
        v.addElement(ent);
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, int val) {
        this.regRawAttribute(v, st, id, Attribute.INT, new Integer(val));
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, double val) {
        this.regRawAttribute(v, st, id, Attribute.DOUBLE, new Double(val));
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, String val) {
        this.regRawAttribute(v, st, id, Attribute.STRING, val);
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, int[] val) {
        this.regRawAttribute(v, st, id, Attribute.INT_LIST, val);
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, double[] val) {
        this.regRawAttribute(v, st, id, Attribute.DOUBLE_LIST, val);
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, String[] val) {
        this.regRawAttribute(v, st, id, Attribute.STRING_LIST, val);
    }

    public void regAttributeRaw(Vector v, Hashtable st, Attribute attr, boolean classType) {
        if (attr.avi == null) {
            if (classType) {
                this.regRawAttribute(v, st, attr.id, Attribute.NULL, null);
            }
        } else if (classType || !attr.cloneOnAssign) {
            if (attr.avi.next != null) {
                int num = 0;
                AttributeValueItem avi = attr.avi;
                while (avi != null) {
                    avi = avi.next;
                    ++num;
                }
                String[] sl = new String[num];
                avi = attr.avi;
                int i = 0;
                avi = attr.avi;
                while (avi != null) {
                    sl[i] = avi.value;
                    avi = avi.next;
                    ++i;
                }
                this.regRawAttribute(v, st, attr.id, sl);
            } else {
                this.regRawAttribute(v, st, attr.id, attr.avi.value);
            }
        }
    }

    public void regRawAttribute(Vector v, Hashtable st, String id, Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        double[] dl = new double[]{(double)red / 255.0, (double)green / 255.0, (double)blue / 255.0};
        this.regRawAttribute(v, st, id, dl);
    }

    public boolean processFirstOrder(Attribute attr) {
        if (attr.id.equals(COLOUR_ID)) {
            this.setObjectColor(attr.parseColour());
            return true;
        }
        if (attr.id.equals(LABEL_COLOUR_ID)) {
            this.setLabelColor(attr.parseColour());
            return true;
        }
        if (attr.id.equals(OPEN_COLOUR_ID)) {
            this.setColorWhenOpen(attr.parseColour());
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String id) {
        Attribute attr = new Attribute(id, null);
        this.addAttribute(attr);
        return true;
    }

    public boolean addRawAttribute(String id, String val) {
        AttributeValueItem avi = new AttributeValueItem(val);
        Attribute attr = new Attribute(id, avi);
        this.addAttribute(attr);
        return true;
    }

    public boolean addRawAttribute(String id, double val) {
        System.out.println("0");
        return false;
    }

    public boolean addRawAttribute(String id, int val) {
        return false;
    }

    public boolean addRawAttribute(String id, int[] val) {
        return false;
    }

    public boolean addRawAttribute(String id, double[] val) {
        if (id.equals(COLOUR_ID)) {
            this.setObjectColor(new Color((float)val[0], (float)val[1], (float)val[2]));
            return true;
        }
        if (id.equals(LABEL_COLOUR_ID)) {
            this.setLabelColor(new Color((float)val[0], (float)val[1], (float)val[2]));
            return true;
        }
        if (id.equals(OPEN_COLOUR_ID)) {
            this.setColorWhenOpen(new Color((float)val[0], (float)val[1], (float)val[2]));
            return true;
        }
        return false;
    }

    public boolean addRawAttribute(String id, String[] val) {
        AttributeValueItem favi = null;
        AttributeValueItem lavi = null;
        int num = val.length;
        for (int i = 0; i < num; ++i) {
            AttributeValueItem avi = new AttributeValueItem(val[i]);
            if (lavi != null) {
                lavi.next = avi;
            }
            if (favi == null) {
                favi = avi;
            }
            lavi = avi;
        }
        Attribute attr = new Attribute(id, favi);
        this.addAttribute(attr);
        return true;
    }

    public void replaceAttribute(Attribute newAttr) {
        this.addAttribute(newAttr);
    }

    public void writeAttributes(PrintStream ps, LandscapeObject parentClass, boolean classType) throws IOException {
        Color color1;
        Color color;
        if (this.hasObjectColor() && !(color = this.getObjectColor()).equals(color1 = parentClass != null ? parentClass.getObjectColor() : null)) {
            ps.print(" color = " + LandscapeObject.taColor(color) + "\n");
        }
        if (this.hasLabelColor() && !(color = this.getLabelColor()).equals(color1 = parentClass != null ? parentClass.getLabelColor() : null)) {
            ps.print(" labelcolor = " + LandscapeObject.taColor(color) + "\n");
        }
        if (this.hasColorWhenOpen() && !(color = this.getColorWhenOpen()).equals(color1 = parentClass != null ? parentClass.getColorWhenOpen() : null)) {
            ps.print(" opencolor = " + LandscapeObject.taColor(color) + "\n");
        }
        if (this.m_attributes != null) {
            Enumeration en = this.m_attributes.elements();
            while (en.hasMoreElements()) {
                Attribute attr = (Attribute)en.nextElement();
                attr.writeAttribute(ps, parentClass, classType);
            }
        }
    }

    public void getLsAttributesRaw(Vector v, Hashtable st, boolean classType) {
        if (this.hasObjectColor()) {
            this.regRawAttribute(v, st, COLOUR_ID, this.getObjectColor());
        }
        if (this.hasLabelColor()) {
            this.regRawAttribute(v, st, LABEL_COLOUR_ID, this.getLabelColor());
        }
        if (this.hasColorWhenOpen()) {
            this.regRawAttribute(v, st, OPEN_COLOUR_ID, this.getColorWhenOpen());
        }
        if (this.m_attributes != null) {
            Enumeration en = this.m_attributes.elements();
            while (en.hasMoreElements()) {
                Attribute attr = (Attribute)en.nextElement();
                this.regAttributeRaw(v, st, attr, classType);
            }
        }
    }

    public static void setEdgeMode(int mode) {
        m_edge_mode = mode;
    }

    public static int getEdgeMode() {
        return m_edge_mode;
    }

    public int getPrimaryAttributeCount() {
        return 0;
    }

    public int getLsAttributeCount() {
        return this.getPrimaryAttributeCount() + this.getLsAttributesSize() + 1;
    }

    public boolean canEditName(int index) {
        int primary = this.getPrimaryAttributeCount();
        return index >= primary;
    }

    public boolean canEditAttribute(int index) {
        int primary = this.getPrimaryAttributeCount();
        if (index < primary) {
            return true;
        }
        return (index -= primary) < this.getLsAttributesSize();
    }

    public String getLsAttributeNameAt(int index) {
        if ((index -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attr = this.getLsAttributeAt(index);
        if (attr == null) {
            return null;
        }
        return attr.id;
    }

    public Object getLsAttributeValueAt(int index) {
        if ((index -= this.getPrimaryAttributeCount()) == this.getLsAttributesSize()) {
            return "";
        }
        Attribute attr = this.getLsAttributeAt(index);
        if (attr == null) {
            return null;
        }
        return attr.avi;
    }

    private boolean unknownAttributeName(String name) {
        String name1;
        int i = 0;
        while ((name1 = this.getLsAttributeNameAt(i)) != null) {
            if (name.equals(name1)) {
                System.out.println("Can't rename generic attribute to '" + name + "': attribute already exists");
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean setAttributeNameAt(int index, Object value) {
        int primary = this.getPrimaryAttributeCount();
        if (index < primary) {
            return false;
        }
        String name = (String)value;
        if ((index -= primary) == this.getLsAttributesSize()) {
            if (name.equals("")) {
                return false;
            }
            if (!this.unknownAttributeName(name)) {
                return false;
            }
            new UpdateLsAttributeName(this, null, name);
            return true;
        }
        Attribute attr = this.getLsAttributeAt(index);
        if (attr == null) {
            return false;
        }
        if (name.equals("")) {
            new UpdateLsAttributeName(this, attr.id, null);
            return true;
        }
        if (name.equals(attr.id)) {
            return false;
        }
        if (!this.unknownAttributeName(name)) {
            return false;
        }
        new UpdateLsAttributeName(this, attr.id, name);
        return true;
    }

    public void setAttributeValueAt(int index, Object value) {
        Attribute attr = this.getLsAttributeAt(index -= this.getPrimaryAttributeCount());
        if (attr == null) {
            return;
        }
        new UpdateLsAttributeValue(this, attr, (AttributeValueItem)value);
    }

    public int getLsAttributeTypeAt(int index) {
        if (index < this.getLsAttributeCount() - 1) {
            return 11;
        }
        return 0;
    }

    public int getLsAttributeOffset(String id) {
        int i = 0;
        String name;
        while ((name = this.getLsAttributeNameAt(i)) != null) {
            if (name.equals(id)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean defaultValue(String id, Object object) {
        Object object1;
        int i;
        return object != null && (i = this.getLsAttributeOffset(id)) >= 0 && object.equals(object1 = this.getLsAttributeValueAt(i));
    }

    class UpdateLsAttributeValue
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        AttributeValueItem m_oldValue;
        AttributeValueItem m_newValue;
        Attribute m_attribute;

        UpdateLsAttributeValue(LandscapeObject o, Attribute attribute, AttributeValueItem newValue) {
            this.m_o = o;
            this.m_attribute = attribute;
            this.m_oldValue = attribute.avi;
            this.m_newValue = newValue;
            if (LandscapeObject.this.logEdit(this)) {
                this.redo();
            }
        }

        public String getPresentationName() {
            if (this.m_newValue == null) {
                return this.m_o + " remove Attribute " + this.m_attribute.id + " value";
            }
            if (this.m_oldValue == null) {
                return this.m_o + " add Attribute " + this.m_attribute.id + " value";
            }
            return this.m_o + " replace Attribute " + this.m_attribute.id + " value";
        }

        public void undo() {
            this.m_attribute.avi = this.m_oldValue;
        }

        public void redo() {
            this.m_attribute.avi = this.m_newValue;
        }
    }

    class UpdateLsAttributeName
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        String m_oldName;
        String m_newName;
        Attribute m_attribute;

        protected void exchange(String oldName, String newName) {
            if (oldName != null) {
                LandscapeObject.this.m_attributes.remove(oldName);
            }
            if (newName != null) {
                this.m_attribute.id = newName;
                LandscapeObject.this.putLsAttribute(this.m_attribute);
            } else if (LandscapeObject.this.getLsAttributesSize() == 0) {
                LandscapeObject.this.m_attributes = null;
            }
        }

        UpdateLsAttributeName(LandscapeObject o, String oldName, String newName) {
            this.m_o = o;
            if (oldName != null) {
                this.m_attribute = LandscapeObject.this.getLsAttribute(oldName);
                if (this.m_attribute == null) {
                    oldName = null;
                }
            }
            if (oldName == null) {
                if (newName == null) {
                    return;
                }
                this.m_attribute = new Attribute(newName, null);
            } else if (oldName.equals(newName)) {
                return;
            }
            this.m_newName = newName;
            if (LandscapeObject.this.logEdit(this)) {
                this.exchange(this.m_oldName, this.m_newName);
            }
        }

        public String getPresentationName() {
            if (this.m_newName == null) {
                return this.m_o + " delete Attribute " + this.m_oldName;
            }
            if (this.m_oldName == null) {
                return this.m_o + " create Attribute " + this.m_newName;
            }
            return this.m_o + " rename Attribute " + this.m_oldName + " to " + this.m_newName;
        }

        public void undo() {
            this.exchange(this.m_newName, this.m_oldName);
        }

        public void redo() {
            this.exchange(this.m_oldName, this.m_newName);
        }
    }

    class UpdateStyle
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        int m_old;
        int m_new;

        UpdateStyle(LandscapeObject o, int value) {
            this.m_o = o;
            this.m_old = o.m_style;
            this.m_new = value;
            if (LandscapeObject.this.logEdit(this)) {
                o.m_style = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " Style " + this.m_o.getStyleName(this.m_new);
        }

        public void undo() {
            this.m_o.m_style = this.m_old;
        }

        public void redo() {
            this.m_o.m_style = this.m_new;
        }
    }

    class UpdateObjectColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        Color m_old;
        Color m_new;

        UpdateObjectColor(LandscapeObject o, Color value) {
            this.m_o = o;
            this.m_old = o.m_objectColor;
            this.m_new = value;
            if (LandscapeObject.this.logEdit(this)) {
                o.m_objectColor = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " ObjectColor ";
        }

        public void undo() {
            this.m_o.m_objectColor = this.m_old;
        }

        public void redo() {
            this.m_o.m_objectColor = this.m_new;
        }

        public void paintComponent(Graphics g, int x, int y) {
            this.paintComponentColor(g, x, y, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateParentClass
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject m_o;
        LandscapeClassObject m_old;
        LandscapeClassObject m_new;

        UpdateParentClass(LandscapeObject o, LandscapeClassObject value) {
            this.m_o = o;
            this.m_old = o.m_parentClass;
            this.m_new = value;
            if (LandscapeObject.this.logEdit(this)) {
                o.m_parentClass = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " ParentClass " + this.m_new;
        }

        public void undo() {
            this.m_o.m_parentClass = this.m_old;
        }

        public void redo() {
            this.m_o.m_parentClass = this.m_new;
        }
    }
}

