/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.undo.UndoableEdit;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MyPaintableUndoableEdit;
import lsedit.MyUndoableEdit;

public abstract class LandscapeObject3D
extends LandscapeObject {
    private String m_id;
    private String m_description;
    private String m_label;
    private Color m_labelColor = null;
    private Color m_colorWhenOpen;

    public String toString() {
        return this.m_id;
    }

    public String getId() {
        return this.m_id;
    }

    public void setId(String id) {
        this.m_id = id;
    }

    public boolean hasId(String id) {
        return this.m_id.equals(id);
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String description) {
        if (description != null && description.length() == 0) {
            description = null;
        }
        this.m_description = description;
    }

    public void updateDescription(String description) {
        if (description == null ? this.m_description == null : description.equals(this.m_description)) {
            return;
        }
        new UpdateDescription(this, description);
    }

    protected void setLabel(String label) {
        JComponent swingObject = this.getSwingObject();
        this.m_label = label;
        if (swingObject != null) {
            swingObject.setToolTipText(label);
        }
    }

    public void updateLabel(String label) {
        if (label == null ? this.m_label == null : label.equals(this.m_label)) {
            return;
        }
        new UpdateLabel(this, label);
    }

    protected String getLabel() {
        return this.m_label;
    }

    public boolean hasLabelColor() {
        return this.m_labelColor != null;
    }

    public Color getLabelColor() {
        Color ret = this.m_labelColor;
        if (ret == null) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getLabelColor()) == null) {
                ++i;
            }
        }
        return ret;
    }

    public void setLabelColor(Color color) {
        this.m_labelColor = color;
    }

    public void updateLabelColor(Color color) {
        if (color == null ? this.m_labelColor == null : color.equals(this.m_labelColor)) {
            return;
        }
        new UpdateLabelColor(this, color);
    }

    public boolean hasColorWhenOpen() {
        return this.m_colorWhenOpen != null;
    }

    public Color getColorWhenOpen() {
        Color ret = this.m_colorWhenOpen;
        if (ret == null) {
            LandscapeClassObject superclass;
            int i = 0;
            while ((superclass = this.derivedFrom(i)) != null && (ret = superclass.getColorWhenOpen()) == null) {
                ++i;
            }
        }
        return ret;
    }

    public void setColorWhenOpen(Color color) {
        this.m_colorWhenOpen = color;
    }

    public void updateColorWhenOpen(Color color) {
        if (color == null ? this.m_colorWhenOpen == null : color.equals(this.m_colorWhenOpen)) {
            return;
        }
        new UpdateColorWhenOpen(this, color);
    }

    public boolean canEditAttribute(int index) {
        if (index == 0) {
            return false;
        }
        return super.canEditAttribute(index);
    }

    class UpdateColorWhenOpen
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        Color m_old;
        Color m_new;

        UpdateColorWhenOpen(LandscapeObject3D o, Color value) {
            this.m_o = o;
            this.m_old = o.m_colorWhenOpen;
            this.m_new = value;
            if (LandscapeObject3D.this.logEdit(this)) {
                o.m_colorWhenOpen = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " ColorWhenOpen ";
        }

        public void undo() {
            this.m_o.m_colorWhenOpen = this.m_old;
        }

        public void redo() {
            this.m_o.m_colorWhenOpen = this.m_new;
        }

        public void paintComponent(Graphics g, int x, int y) {
            this.paintComponentColor(g, x, y, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateLabelColor
    extends MyPaintableUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        Color m_old;
        Color m_new;

        UpdateLabelColor(LandscapeObject3D o, Color value) {
            this.m_o = o;
            this.m_old = o.m_labelColor;
            this.m_new = value;
            if (LandscapeObject3D.this.logEdit(this)) {
                o.m_labelColor = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " LabelColor ";
        }

        public void undo() {
            this.m_o.m_labelColor = this.m_old;
        }

        public void redo() {
            this.m_o.m_labelColor = this.m_new;
        }

        public void paintComponent(Graphics g, int x, int y) {
            this.paintComponentColor(g, x, y, this.m_new);
        }

        public int getPreferredWidth() {
            return this.getPreferredWidthColor(this.m_o);
        }
    }

    class UpdateLabel
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        String m_old;
        String m_new;

        UpdateLabel(LandscapeObject3D o, String value) {
            this.m_o = o;
            this.m_old = o.m_label;
            this.m_new = value;
            if (LandscapeObject3D.this.logEdit(this)) {
                o.m_label = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " Label " + this.m_new;
        }

        public void undo() {
            this.m_o.m_label = this.m_old;
        }

        public void redo() {
            this.m_o.m_label = this.m_new;
        }
    }

    class UpdateDescription
    extends MyUndoableEdit
    implements UndoableEdit {
        LandscapeObject3D m_o;
        String m_old;
        String m_new;

        UpdateDescription(LandscapeObject3D o, String value) {
            this.m_o = o;
            this.m_old = o.m_description;
            this.m_new = value;
            if (LandscapeObject3D.this.logEdit(this)) {
                o.m_description = value;
            }
        }

        public String getPresentationName() {
            return this.m_o + " Description";
        }

        public void undo() {
            this.m_o.m_description = this.m_old;
        }

        public void redo() {
            this.m_o.m_description = this.m_new;
        }
    }
}

