/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.IOException;
import java.io.InputStream;
import lsedit.Attribute;
import lsedit.AttributeRecord;
import lsedit.AttributeValueItem;
import lsedit.MsgOut;
import lsedit.TA_StreamTokenizer;
import lsedit.Tuple;

public class LandscapeTokenStream {
    public static final int SCHEME_TUPLE = 0;
    public static final int SCHEME_ATTRIBUTE = 1;
    public static final int FACT_TUPLE = 2;
    public static final int FACT_ATTRIBUTE = 3;
    public static final int INCLUDE_FILE = 4;
    public static final int ERROR = -1;
    public static final int NONE = -2;
    public static final int EOF = 99;
    protected static final String SCHEME_ID = "SCHEME";
    protected static final String FACT_ID = "FACT";
    protected static final String TUPLE_ID = "TUPLE";
    protected static final String ATTRIBUTE_ID = "ATTRIBUTE";
    protected static final String INCLUDE_ID = "INCLUDE";
    protected static boolean debug = false;
    protected boolean fatalError = false;
    protected String fileName;
    protected TA_StreamTokenizer ts;
    protected String token1;
    protected String token2;
    protected String includeFile;
    protected int ttype3;

    public static void setDebugOn() {
        debug = true;
    }

    protected void debugOut(String msg) {
        if (debug) {
            System.out.println(msg);
        }
    }

    protected int nextToken() throws IOException {
        int ttype = this.ts.nextToken();
        if (debug) {
            switch (ttype) {
                case -1: {
                    System.out.println("Token(EOF)");
                    break;
                }
                case -3: {
                    System.out.println("WordToken(\"" + this.ts.sval + '\"' + ")");
                    break;
                }
                case -2: {
                    System.out.println("NumberToken(#" + this.ts.nval + ")");
                    break;
                }
                default: {
                    System.out.println("CharToken('" + (char)ttype + "')");
                }
            }
        }
        return ttype;
    }

    protected void skipRecord() throws IOException {
        int ttype;
        while ((ttype = this.nextToken()) != -1 && ttype != 123) {
        }
        if (ttype != 123) {
            return;
        }
        while ((ttype = this.nextToken()) != -1 && ttype != 125) {
        }
    }

    protected void pushBack() {
        this.ts.pushBack();
    }

    protected AttributeValueItem parseList() throws IOException {
        this.debugOut("parseList:");
        AttributeValueItem avi = null;
        AttributeValueItem tail = null;
        block5: while (true) {
            switch (this.nextToken()) {
                case 41: {
                    return avi;
                }
                case 40: {
                    AttributeValueItem list = this.parseList();
                    if (avi == null) {
                        avi = list;
                    } else {
                        tail.nextList = list;
                    }
                    tail = list;
                    continue block5;
                }
                case -3: {
                    AttributeValueItem navi = new AttributeValueItem(this.ts.sval);
                    if (avi == null) {
                        avi = navi;
                    } else {
                        tail.next = navi;
                    }
                    tail = navi;
                    continue block5;
                }
            }
            break;
        }
        this.error("Expecting list, value, or ')'");
        this.pushBack();
        return null;
    }

    protected AttributeValueItem parseNested(String id) throws IOException {
        this.debugOut("parseNested:");
        AttributeRecord ar = new AttributeRecord(id);
        ar.attributes = this.parseAttributes();
        return new AttributeValueItem(ar);
    }

    protected AttributeValueItem parseAVI(String attributeId) throws IOException {
        AttributeValueItem avi;
        int ttype = this.nextToken();
        switch (ttype) {
            case 40: {
                avi = this.parseList();
                break;
            }
            case 123: {
                avi = this.parseNested(attributeId);
                break;
            }
            case -3: {
                avi = new AttributeValueItem(this.ts.sval);
                break;
            }
            default: {
                this.error("Expecting attribute value");
                avi = null;
            }
        }
        return avi;
    }

    protected Attribute parseAttributes() throws IOException {
        this.debugOut("parseAttributes:");
        Attribute attrList = null;
        Attribute prev = null;
        int ttype;
        while ((ttype = this.nextToken()) != 125) {
            AttributeValueItem avi;
            if (ttype != -3) {
                this.error("Expecting attribute id");
                return null;
            }
            String attributeId = this.ts.sval;
            if (this.nextToken() != 61) {
                this.pushBack();
                avi = null;
            } else {
                avi = this.parseAVI(attributeId);
                if (avi == null) {
                    return null;
                }
            }
            Attribute newAttr = new Attribute(attributeId, avi);
            if (attrList == null) {
                attrList = newAttr;
            } else {
                prev.next = newAttr;
            }
            prev = newAttr;
        }
        return attrList;
    }

    public LandscapeTokenStream(InputStream is, String fileName) {
        this.fileName = fileName;
        this.ts = new TA_StreamTokenizer(is);
    }

    public void freeHashTable() {
        this.ts.freeHashTable();
    }

    protected AttributeValueItem parseAttributeValueItem() throws IOException {
        AttributeValueItem avi = this.parseAVI("");
        int ttype = this.nextToken();
        if (ttype != -1) {
            avi = null;
        }
        return avi;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextSection() throws IOException {
        String type;
        String graph;
        this.debugOut("nextSection: ");
        if (this.fatalError) {
            return 99;
        }
        if (this.token1 != null) {
            if (this.ttype3 != 58) {
                this.error("Expecting section header ':'");
                return -1;
            }
            graph = this.token1;
            type = this.token2;
            this.token1 = null;
            this.token2 = null;
        } else {
            int ttype = this.nextToken();
            if (ttype == -1) {
                return 99;
            }
            if (ttype != -3) {
                this.error("Expecting graph id");
                return -1;
            }
            graph = this.ts.sval;
            if (this.nextToken() != -3) {
                this.error("Expecting section type id");
                return -1;
            }
            type = this.ts.sval;
            if (this.nextToken() != 58) {
                this.error("Expecting ':'");
                return -1;
            }
        }
        if (graph.equals(SCHEME_ID)) {
            if (type.equals(TUPLE_ID)) {
                return 0;
            }
            if (type.equals(ATTRIBUTE_ID)) {
                return 1;
            }
            this.error("Bad section type");
            return -1;
        }
        if (graph.equals(FACT_ID)) {
            if (type.equals(TUPLE_ID)) {
                return 2;
            }
            if (type.equals(ATTRIBUTE_ID)) {
                return 3;
            }
            this.error("Bad section type");
            return -1;
        }
        if (graph.equals(INCLUDE_ID)) {
            this.includeFile = type;
            return 4;
        }
        this.error("Bad section id");
        return -1;
    }

    public String getIncludeFile() {
        return this.includeFile;
    }

    public void setForTuples() {
    }

    public Tuple nextTuple() throws IOException {
        this.debugOut("nextTuple:");
        if (this.fatalError) {
            return null;
        }
        int ttype = this.nextToken();
        if (ttype == -1) {
            return null;
        }
        if (ttype != -3) {
            this.error("Expecting word token");
            this.fatalError = true;
            return null;
        }
        String verb = this.ts.sval;
        if (this.nextToken() != -3) {
            this.error("Expecting word token");
            this.fatalError = true;
            return null;
        }
        String object = this.ts.sval;
        ttype = this.nextToken();
        if (ttype == 58) {
            this.token1 = verb;
            this.token2 = object;
            this.ttype3 = ttype;
            return null;
        }
        if (ttype != -3) {
            this.error("Error in tuple parse");
            this.fatalError = true;
            return null;
        }
        String subject = this.ts.sval;
        return new Tuple(verb, object, subject);
    }

    public void setForRecords() {
    }

    public AttributeRecord nextRecord() throws IOException {
        String id;
        Attribute attrList;
        this.debugOut("nextRecord: ");
        if (this.fatalError) {
            return null;
        }
        do {
            int ttype;
            if ((ttype = this.nextToken()) == -1) {
                return null;
            }
            if (ttype == 40) {
                id = "(";
                boolean firstToken = true;
                while ((ttype = this.nextToken()) != 41) {
                    if (ttype == -1) {
                        this.error("Expected ')'");
                        return null;
                    }
                    if (ttype != -3) {
                        this.errorNS("Unexpected char '" + (char)this.ts.ttype + "' in relation id - Partial id: " + id);
                        this.skipRecord();
                        return this.nextRecord();
                    }
                    if (firstToken) {
                        id = id + this.ts.sval;
                        firstToken = false;
                        continue;
                    }
                    id = id + " " + this.ts.sval;
                }
                id = id + ")";
            } else {
                if (ttype != -3) {
                    this.error("Expecting object id");
                    this.skipRecord();
                    return this.nextRecord();
                }
                id = this.ts.sval;
            }
            this.debugOut("Processing record for: " + id);
            if (this.nextToken() == 123) continue;
            this.token1 = id;
            this.token2 = this.ts.sval;
            if (this.nextToken() != 58) {
                this.token1 = null;
                this.token2 = null;
                this.error("Expecting section header");
                this.skipRecord();
                return this.nextRecord();
            }
            this.ttype3 = 58;
            return null;
        } while ((attrList = this.parseAttributes()) == null);
        AttributeRecord ar = new AttributeRecord(id);
        ar.attributes = attrList;
        return ar;
    }

    public void errorNS(String msg) {
        MsgOut.println("*** Error (" + this.fileName + ":" + this.ts.lineno() + "): " + msg);
    }

    public void error(String msg) {
        MsgOut.println("*** Error (" + this.fileName + ":" + this.ts.lineno() + "): " + msg + ". Found " + this.ts.sval);
    }

    public void warning(String msg) {
        MsgOut.println(">>> Warning (" + this.fileName + ":" + this.ts.lineno() + "): " + msg);
    }
}

