/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JApplet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.undo.UndoableEdit;
import lsedit.Attribute;
import lsedit.AttributeValueItem;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.Elision_CS_Button;
import lsedit.Elision_CU_Button;
import lsedit.Elision_I_Button;
import lsedit.Elision_c_Button;
import lsedit.Elision_s_Button;
import lsedit.Elision_u_Button;
import lsedit.EntityInstance;
import lsedit.Feedback;
import lsedit.Find;
import lsedit.FindBox;
import lsedit.Find_Button;
import lsedit.FontBiggerButton;
import lsedit.FontSmallerButton;
import lsedit.HistoryBox;
import lsedit.InternalBufferStream;
import lsedit.LegendBox;
import lsedit.LsLink;
import lsedit.MapBox;
import lsedit.MsgOut;
import lsedit.MySplitPane;
import lsedit.QueryBox;
import lsedit.Query_C_Button;
import lsedit.Query_Clear_Button;
import lsedit.Query_b_Button;
import lsedit.Query_f_Button;
import lsedit.RelationInstance;
import lsedit.ResultBox;
import lsedit.RightTabbedPane;
import lsedit.SortVector;
import lsedit.TextBox;
import lsedit.TextTree;
import lsedit.ToolBarButton;
import lsedit.ToolBarEventHandler;
import lsedit.Util;
import lsedit.Version;
import lsedit.ViewModeHandler;

public class LandscapeViewerCore
extends Do
implements ToolBarEventHandler {
    protected static final String TITLE = "Software Landscape Viewer";
    protected static final int GAP = 4;
    protected static final int DROPDOWN_WIDTH = 150;
    protected static final int DROPDOWN_HEIGHT = 25;
    protected static final int TOP_CTRL_DELTA = 50;
    public static final int FA_LOAD = 0;
    public String editURL = null;
    public String aboutURL = null;
    public String helpURL = null;
    public String startEntity = null;
    public String lsPath = null;
    protected Vector lsPath_bg = new Vector();
    protected String prefURL;
    protected String prefInvokeURL;
    protected String user;
    protected static final int RELN_ALL = 10;
    protected JFrame af = null;
    protected JApplet m_applet = null;
    protected AppletContext ac = null;
    protected static final String m_leftTextBoxHelp = "Displays the 'description' for the current landscape.";
    protected static final String m_rightTextBoxHelp = "Displays the 'description' for the closed (not a container) entity currently under the mouse cursor.";
    protected static final String m_feedbackHelp = "Displays feedback from the program. Examples include errors, warnings, and confirmations of action.";
    protected static final String m_nameBoxHelp = "Displays the landscape entity, edge, or application button/box currently under the mouse cursor.";
    protected static double m_mainSplitRatio = 0.8;
    protected static double m_secondSplitRatio = 0.1;
    protected static double m_thirdSplitRatio = 0.5;
    protected static int m_openFrames = 1;
    protected JFrame m_frame;
    protected Container m_contentPane;
    protected JToolBar m_toolBar = null;
    protected JComboBox m_lsDropDown = null;
    protected MySplitPane m_thirdSplitPane = null;
    protected JSplitPane m_secondSplitPane = null;
    protected JSplitPane m_mainSplitPane = null;
    protected JScrollPane m_scrollLeftTextBox = null;
    protected JPanel m_leftPanel = null;
    protected JPanel m_rightPanel = null;
    protected JLabel m_leftTextBoxTitle = null;
    protected TextBox m_leftTextBox = null;
    protected JScrollPane m_scrollRightTextBox = null;
    protected JLabel m_rightTextBoxTitle = null;
    protected TextBox m_rightTextBox = null;
    protected Feedback m_feedback = null;
    protected Feedback m_nameBox = null;
    protected JScrollPane m_scrollDiagram = null;
    protected Diagram m_diagram = null;
    protected RightTabbedPane m_rightTabbedPane = null;
    protected LegendBox m_legendBox = null;
    protected MapBox m_mapBox = null;
    protected QueryBox m_queryBox = null;
    protected ResultBox m_resultBox = null;
    protected TextTree m_tocBox = null;
    protected HistoryBox m_historyBox = null;
    protected EntityInstance currentNameEntity = null;
    protected ViewModeHandler m_modeHandler;
    protected String lsSavePath;
    protected String lsSaveSuffix;
    protected String lsSaveCmd;
    protected Vector m_clipboard = null;
    protected int mode = 0;
    protected ToolBarButton[] toolButton = new ToolBarButton[]{new Find_Button(this), new Query_f_Button(this), new Query_b_Button(this), new Query_C_Button(this), new Query_Clear_Button(this), new Elision_c_Button(this), new Elision_I_Button(this), new Elision_u_Button(this), new Elision_CU_Button(this), new Elision_s_Button(this), new Elision_CS_Button(this), new FontSmallerButton(this), new FontBiggerButton(this)};
    protected static final String indAdd = "  ";
    protected Find findResults = null;
    protected boolean modeHandlingActive = false;
    protected RelationInstance m_currentEdge = null;
    protected EntityInstance m_currentDescEntity = null;
    protected static int EC_CNT = 40;
    private int curCursor = 0;
    private int m_anticipateCursor = 0;
    protected boolean waitActive = false;

    protected void repaintTabs() {
        if (this.m_rightTabbedPane != null) {
            this.m_rightTabbedPane.revalidate();
        }
    }

    public String getTitle() {
        return TITLE;
    }

    public JMenuBar genMenu() {
        JMenuBar mb = new JMenuBar();
        JMenu m = new JMenu("Menu");
        Do.refreshMenuItem(m, this);
        m.addSeparator();
        Do.findMenuItem(m, this);
        m.addSeparator();
        this.bestEdgeMenuItem(m, this);
        m.addSeparator();
        this.showMenuItem(m, this);
        m.addSeparator();
        mb.add(m);
        m = new JMenu("Help");
        Do.helpMenuItem(m, this, "Viewer");
        mb.add(m);
        return mb;
    }

    protected int getNumToolButtons() {
        return 6;
    }

    protected void computeMinInfoHeight() {
        Dimension d;
        int left = 0;
        int right = 0;
        if (this.m_leftTextBoxTitle != null && this.m_leftTextBoxTitle.isVisible()) {
            d = this.m_leftTextBoxTitle.getMinimumSize();
            left += d.height;
        }
        if (this.m_scrollLeftTextBox != null && this.m_scrollLeftTextBox.isVisible()) {
            d = this.m_scrollLeftTextBox.getMinimumSize();
            left += d.height;
        }
        if (this.m_feedback != null && this.m_feedback.isVisible()) {
            d = this.m_feedback.getMinimumSize();
            left += d.height;
        }
        d = new Dimension(100, left);
        this.m_leftPanel.setMinimumSize(d);
        if (this.m_rightTextBoxTitle != null && this.m_rightTextBoxTitle.isVisible()) {
            d = this.m_rightTextBoxTitle.getMinimumSize();
            right += d.height;
        }
        if (this.m_scrollRightTextBox != null && this.m_scrollRightTextBox.isVisible()) {
            d = this.m_scrollRightTextBox.getMinimumSize();
            right += d.height;
        }
        if (this.m_nameBox != null && this.m_nameBox.isVisible()) {
            d = this.m_nameBox.getMinimumSize();
            right += d.height;
        }
        d = new Dimension(100, right);
        this.m_rightPanel.setMinimumSize(d);
    }

    protected void genHistoryBox(Dimension d) {
    }

    protected void genMainGUI(int diagramPercentWidth, int diagramPercentHeight) {
        int width = this.m_contentPane.getWidth();
        int height = this.m_contentPane.getHeight();
        Dimension min = new Dimension(100, 50);
        if (diagramPercentWidth > 0 && diagramPercentHeight > 0) {
            m_secondSplitRatio = 1.0 - (double)diagramPercentHeight / 100.0;
            m_mainSplitRatio = (double)diagramPercentWidth / 100.0;
        }
        this.m_contentPane.setVisible(false);
        if (this.getNumToolButtons() > 0 || this.m_lsDropDown != null) {
            this.m_toolBar = new JToolBar();
            this.m_toolBar.setRollover(true);
            if (this.m_lsDropDown != null) {
                this.m_toolBar.add(this.m_lsDropDown);
            }
            for (int i = 0; i < this.getNumToolButtons(); ++i) {
                this.m_toolBar.add(this.toolButton[i]);
            }
            this.m_toolBar.setFloatable(false);
            this.m_toolBar.setSize(width - 8, 24);
            this.m_contentPane.add((Component)this.m_toolBar, "North");
        }
        int w = (int)((double)width * m_mainSplitRatio / 2.0);
        int h = (int)((double)height * m_secondSplitRatio);
        Dimension d = new Dimension(w, h);
        this.m_leftPanel = new JPanel(new BorderLayout());
        this.m_leftPanel.setPreferredSize(d);
        this.m_leftPanel.setVisible(true);
        this.m_leftTextBoxTitle = new JLabel();
        this.m_leftTextBoxTitle.setBackground(Diagram.boxColour);
        this.m_leftTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_leftTextBoxTitle.setFont(TextBox.m_titleFont);
        this.m_leftTextBoxTitle.setSize(w, 20);
        this.m_leftPanel.add((Component)this.m_leftTextBoxTitle, "North");
        this.m_scrollLeftTextBox = new JScrollPane();
        this.m_leftTextBox = new TextBox(this, this.m_scrollLeftTextBox, m_leftTextBoxHelp);
        this.m_leftTextBox.setSize(w, h - 40);
        this.m_scrollLeftTextBox.setSize(w, h - 40);
        this.m_leftPanel.add((Component)this.m_scrollLeftTextBox, "Center");
        this.m_feedback = new Feedback(this, m_feedbackHelp);
        this.m_feedback.setSize(w, 20);
        this.m_leftPanel.add((Component)this.m_feedback, "South");
        this.m_rightPanel = new JPanel(new BorderLayout());
        this.m_rightPanel.setPreferredSize(d);
        this.m_rightPanel.setVisible(true);
        this.m_rightTextBoxTitle = new JLabel();
        this.m_rightTextBoxTitle.setBackground(Diagram.boxColour);
        this.m_rightTextBoxTitle.setForeground(TextBox.titleColor);
        this.m_rightTextBoxTitle.setFont(TextBox.m_titleFont);
        this.m_rightTextBoxTitle.setSize(w, 20);
        this.m_rightPanel.add((Component)this.m_rightTextBoxTitle, "North");
        this.m_scrollRightTextBox = new JScrollPane();
        this.m_rightTextBox = new TextBox(this, this.m_scrollRightTextBox, m_rightTextBoxHelp);
        this.m_rightTextBox.setSize(w, h - 40);
        this.m_scrollRightTextBox.setSize(w, h - 40);
        this.m_rightPanel.add((Component)this.m_scrollRightTextBox, "Center");
        this.m_nameBox = new Feedback(this, m_nameBoxHelp);
        this.m_nameBox.setSize(w, 20);
        this.m_rightPanel.add((Component)this.m_nameBox, "South");
        this.computeMinInfoHeight();
        this.m_thirdSplitPane = new MySplitPane(1, this.m_leftPanel, this.m_rightPanel);
        this.m_thirdSplitPane.setOneTouchExpandable(true);
        this.m_thirdSplitPane.setDividerLocation(m_thirdSplitRatio);
        h = height - h - 24;
        w = (int)((double)width * m_mainSplitRatio);
        this.m_scrollDiagram = new JScrollPane();
        this.m_scrollDiagram.setSize(w, h);
        this.m_secondSplitPane = new JSplitPane(0, this.m_thirdSplitPane, this.m_scrollDiagram);
        this.m_secondSplitPane.setOneTouchExpandable(true);
        this.m_secondSplitPane.setDividerLocation(m_secondSplitRatio);
        w = (int)((double)width - (double)width * m_mainSplitRatio);
        h = height - 24;
        this.m_rightTabbedPane = new RightTabbedPane();
        this.m_legendBox = new LegendBox(this, this.m_rightTabbedPane);
        this.m_mapBox = new MapBox(this, this.m_rightTabbedPane);
        this.m_queryBox = new QueryBox(this, this.m_rightTabbedPane);
        this.m_resultBox = new ResultBox(this, this.m_rightTabbedPane);
        this.m_tocBox = new TextTree(this, this.m_rightTabbedPane);
        d = new Dimension(w, h);
        this.m_legendBox.setSize(d);
        this.m_mapBox.setSize(d);
        this.m_queryBox.setSize(d);
        this.m_resultBox.setSize(d);
        this.m_tocBox.setSize(d);
        this.m_rightTabbedPane.setSize(d);
        this.m_legendBox.setPreferredSize(d);
        this.m_mapBox.setPreferredSize(d);
        this.m_queryBox.setPreferredSize(d);
        this.m_resultBox.setPreferredSize(d);
        this.m_tocBox.setPreferredSize(d);
        this.m_rightTabbedPane.setPreferredSize(d);
        this.genHistoryBox(d);
        this.m_legendBox.activate();
        this.m_secondSplitPane.setMinimumSize(min);
        this.m_rightTabbedPane.setMinimumSize(min);
        this.m_mainSplitPane = new JSplitPane(1, this.m_secondSplitPane, this.m_rightTabbedPane);
        this.m_mainSplitPane.setOneTouchExpandable(true);
        this.m_mainSplitPane.setSize(width, height - 24);
        this.m_mainSplitPane.setDividerLocation(m_mainSplitRatio);
        this.m_contentPane.add((Component)this.m_mainSplitPane, "Center");
        this.m_contentPane.setVisible(true);
    }

    protected void genModeHandlers() {
        this.m_modeHandler = new ViewModeHandler();
        this.m_modeHandler.init(this);
    }

    protected void genGUI(int diagramPercentWidth, int diagramPercentHeight) {
        this.genMainGUI(diagramPercentWidth, diagramPercentHeight);
    }

    protected void setLeftBox() {
        if (this.m_diagram != null) {
            EntityInstance root = this.m_diagram.getDrawRoot();
            String label = root.getLabel();
            String title = root.getTitle();
            String desc = root.getDescription();
            if (desc == null) {
                desc = root.getContainedBy() == null ? "The " + label + " landscape." : "The " + label + " " + root.getEntityClass().getLabel();
            }
            String topline = title != null ? title + " (" + label + ")" : label;
            this.m_leftTextBoxTitle.setText(topline);
            this.m_leftTextBox.set(desc);
        }
    }

    protected void about() {
        if (this.aboutURL != null) {
            this.showURL(this.aboutURL, 2);
        }
    }

    protected void help() {
        if (this.helpURL != null) {
            this.showURL(this.helpURL, 5);
        }
    }

    protected void setVisibility(JComponent bd, boolean state) {
        if (bd != null) {
            bd.setVisible(state);
        }
    }

    protected void readyMsg() {
        this.doFeedback(this.getTitle() + " " + 7 + "." + 0 + " (build " + 15 + ") Started.");
    }

    protected void init_core(int diagramPercentWidth, int diagramPercentHeight) {
        this.m_contentPane.setBackground(Color.lightGray);
        EntityInstance.generateFonts();
        this.genModeHandlers();
        this.genGUI(diagramPercentWidth, diagramPercentHeight);
        this.m_diagram = new Diagram(this, true);
        this.initialLoad();
        this.showInfo("");
    }

    protected void initialLoad() {
        if (this.lsPath == null) {
            MsgOut.dprintln("Empty landscape");
            if (this.m_leftTextBox != null) {
                this.m_leftTextBoxTitle.setText("Empty Landscape");
                this.m_leftTextBox.set("Select 'Open landscape' from 'File' menu to load a new landscape.");
            }
            this.readyMsg();
        } else if (this.m_diagram != null) {
            MsgOut.dprintln("Load: " + this.lsPath);
            String rc = this.m_diagram.loadDiagram(this.lsPath, this.lsPath_bg, null);
            if (rc != null) {
                this.error("Load failed (" + rc + ") for: " + this.lsPath);
                System.out.println("Load failed (" + rc + ") for: " + this.lsPath);
            } else {
                this.m_diagram.prepostorder();
                this.setDiagram(this.m_diagram);
                if (this.startEntity == null) {
                    this.m_diagram.navigateTo();
                } else {
                    EntityInstance e = this.m_diagram.getEntity(this.startEntity);
                    if (e == null) {
                        this.error("Entity not found: '" + this.startEntity + "'");
                    } else {
                        this.m_diagram.setPreserveEntityMarks(0);
                        this.m_diagram.setPreserveRelationMarks(0);
                        this.m_diagram.navigateTo(e);
                    }
                }
                this.setLeftBox();
                this.readyMsg();
            }
        }
        if (this.m_rightTabbedPane != null && this.m_rightTabbedPane.isVisible()) {
            this.m_legendBox.activate();
        }
        this.requestFocus();
        this.setDirectEdge();
        if (this.m_diagram != null) {
            switch (this.m_diagram.getEdgeMode()) {
                case 69: {
                    this.setBestEdge();
                    break;
                }
                case 97: {
                    this.setTbEdge();
                }
            }
        }
    }

    protected void goTo(Vector res) {
        this.doFeedback("");
        this.m_diagram.clearFlags();
        EntityInstance e = (EntityInstance)res.elementAt(0);
        EntityInstance pe = e.getContainedBy();
        Enumeration en = res.elements();
        while (en.hasMoreElements()) {
            e = (EntityInstance)en.nextElement();
            e.setRedBoxFlag();
        }
        this.m_diagram.setPreserveEntityMarks(32768);
        this.m_diagram.setPreserveRelationMarks(0);
        if (pe != this.m_diagram.getDrawRoot()) {
            this.m_diagram.navigateTo(pe);
        }
        SortVector.byString(res);
        this.showResults("FIND RESULTS:", res);
        this.setLeftBox();
        this.m_rightTextBoxTitle.setText("");
        this.m_rightTextBox.set("");
        this.redrawDg();
    }

    protected void find() {
        Pattern pattern = FindBox.Create(this.m_frame, "Find Landscape Entities");
        if (pattern != null) {
            this.findResults = new Find(pattern, this.m_diagram.getRootInstance());
            if (this.findResults.foundCount() > 0) {
                this.goTo(this.findResults.firstResult());
                if (this.findResults.haveNextResult()) {
                    this.m_rightTextBox.set("Use F3 to step forward through layers found and F2 to step back");
                }
            } else {
                this.error("No entities found which match search pattern.");
            }
        }
    }

    protected void findNext() {
        if (this.findResults == null) {
            this.error("No search has occured.");
        } else if (this.findResults.foundCount() == 0) {
            this.error("No search results.");
        } else {
            Vector result = this.findResults.nextResult();
            if (result == null) {
                this.error("No more results available.");
            } else {
                this.goTo(this.findResults.nextResult());
            }
        }
    }

    protected void findPrev() {
        if (this.findResults == null) {
            this.error("No search has occured.");
        } else if (this.findResults.foundCount() == 0) {
            this.error("No search results.");
        } else {
            Vector result = this.findResults.prevResult();
            if (result == null) {
                this.error("At first result.");
            } else {
                this.goTo(result);
            }
        }
    }

    public void init_app(JFrame af, JApplet applet, int diagramPercentWidth, int diagramPercentHeight) {
        this.af = af;
        this.m_applet = applet;
        this.init_core(diagramPercentWidth, diagramPercentHeight);
    }

    protected void setDiagram(Diagram diagram) {
        this.m_diagram = diagram;
        if (diagram != null) {
            diagram.setVisible(true);
            if (this.m_modeHandler != null) {
                diagram.setModeHandler(this.m_modeHandler);
            }
        }
        if (this.m_tocBox != null) {
            if (!this.isTocHidden()) {
                this.setTocHidden(true);
            }
            this.setTocHidden(this.TOC_HIDDEN_DEFAULT);
            if (this.m_tocBox.isVisible()) {
                this.m_tocBox.repaint();
            }
        }
        if (this.m_legendBox != null) {
            this.m_legendBox.fillLegendBox();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.fillQueryBox();
        }
        if (this.m_rightTabbedPane != null) {
            this.m_rightTabbedPane.validate();
        }
        if (this.m_historyBox != null) {
            this.m_historyBox.fillHistoryBox();
        }
        this.m_scrollDiagram.setViewportView(diagram);
    }

    public String getParameter(String name) {
        if (this.m_applet != null) {
            return this.m_applet.getParameter(name);
        }
        return System.getProperty(name);
    }

    public void repaintDg() {
        this.m_diagram.revalidate();
        if (this.m_mapBox.isActive()) {
            this.m_mapBox.revalidate();
        }
    }

    public void redrawDg() {
        this.waitCursorOn();
        this.m_diagram.redrawDiagram();
        this.waitCursorOff();
    }

    protected boolean isReadWrite() {
        return false;
    }

    public void showURL(String urlName, int target) {
        MsgOut.vprintln("URL: " + urlName + " - target: " + target);
        try {
            URL newURL = this.m_applet != null ? new URL(this.m_applet.getDocumentBase(), urlName) : new URL(new URL("http://swag.uwaterloo.ca"), urlName);
            switch (target) {
                case 0: {
                    this.ac.showDocument(newURL, "_top");
                    break;
                }
                case 5: {
                    this.ac.showDocument(newURL, "_blank");
                    break;
                }
                case 2: {
                    this.ac.showDocument(newURL, "Map");
                    break;
                }
                case 4: {
                    this.ac.showDocument(newURL, "List");
                }
            }
        }
        catch (MalformedURLException ex) {
            MsgOut.println("Malformed URL: " + urlName);
        }
        catch (IOException ex) {
            MsgOut.println("Couldn't access URL: " + urlName);
        }
    }

    public void showResults(String title, Vector v, boolean activateBox) {
        this.m_resultBox.setResultTitle(title);
        if (v.size() > 0) {
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                this.m_resultBox.addResultEntity(e);
            }
        } else {
            this.m_resultBox.addText("No entities");
        }
        this.m_resultBox.validate();
    }

    public void showResults(String title, Vector v) {
        this.showResults(title, v, true);
    }

    public void doFeedback(String str) {
        if (this.m_feedback != null) {
            this.m_feedback.set(str);
        }
    }

    public void showInfo(String str) {
        if (this.m_nameBox != null) {
            this.m_nameBox.set(str);
        }
    }

    public void error(String msg) {
        this.doFeedback(msg);
        System.out.print("\u0007");
        System.out.flush();
    }

    public void clearFeedback() {
        this.m_feedback.set("");
    }

    protected String filePrompt(String banner, String default_file, int mode) {
        String name;
        int ret;
        JFileChooser fd = new JFileChooser();
        fd.setDialogTitle(banner);
        fd.setFileSelectionMode(0);
        if (default_file != null) {
            fd.setSelectedFile(new File(default_file));
        }
        if ((ret = mode == 0 ? fd.showOpenDialog(this.m_contentPane) : fd.showSaveDialog(this.m_contentPane)) == 0) {
            File file = fd.getSelectedFile();
            name = file.getAbsolutePath();
        } else {
            name = null;
        }
        return name;
    }

    protected void showDescription(RelationInstance ri, boolean showOpens) {
        if (ri != this.m_currentEdge) {
            this.m_currentEdge = ri;
            this.currentNameEntity = null;
            EntityInstance src = ri.m_drawSrc;
            EntityInstance dst = ri.m_drawDst;
            String info = src == null ? "??null??" : Util.quoted(src.getLabel());
            info = info + " " + ri.getRelationClass().getLabel() + "";
            info = dst == null ? info + "??null??" : info + Util.quoted(dst.getLabel());
            this.showInfo(info);
        }
    }

    protected void showDescription(EntityInstance e, boolean showOpens) {
        if (e != this.currentNameEntity) {
            EntityInstance pe;
            this.currentNameEntity = e;
            this.m_currentEdge = null;
            String str = e == null ? "" : ((pe = e.getEnterableParent()) != null ? pe.getLabel() + " . " + e.getLabel() : e.getLabel());
            this.showInfo(str);
        }
        if (e != null && this.m_currentDescEntity != e && (!e.isOpen() || showOpens) && e.getEntityClass() != null) {
            String label = e.getLabel();
            String title = e.getTitle();
            String desc = e.getDescription();
            if (desc == null) {
                desc = "The " + e.getLabel() + " " + e.getEntityClass().getLabel() + ".";
            }
            String topline = " (" + e.getEntityClass().getLabel() + (e.hasChildren() ? " - " + e.numChildren() + " items)" : ")");
            topline = title != null ? title + topline : label + topline;
            this.m_rightTextBoxTitle.setText(topline);
            this.m_rightTextBox.set(desc);
            this.m_currentDescEntity = e;
        }
    }

    public void fillHistoryBox() {
        if (this.m_historyBox != null && this.m_historyBox.isActive()) {
            this.m_historyBox.fillHistoryBox();
        }
    }

    public void setTocHidden(boolean value) {
        if (this.isTocHidden() != value) {
            super.setTocHidden(value);
            if (this.m_tocBox != null) {
                this.m_tocBox.fillTOC();
            }
        }
    }

    public Vector getClipboard() {
        return this.m_clipboard;
    }

    public void insertTOC(EntityInstance container, EntityInstance e) {
        if (!this.isTocHidden()) {
            this.m_tocBox.insertTOC(container, e);
        }
    }

    public void deleteTOC(EntityInstance e) {
        if (!this.isTocHidden()) {
            this.m_tocBox.deleteTOC(e);
        }
    }

    public void deleteJustMeTOC(EntityInstance e) {
        if (!this.isTocHidden()) {
            this.m_tocBox.deleteJustMeTOC(e);
        }
    }

    public void newEntity(EntityInstance container) {
        this.doFeedback("Landscape viewer may not create new Entities");
    }

    public void DeleteEntity(Object object) {
        this.doFeedback("Landscape viewer may not delete Entities");
    }

    public void moveEntityContainment(EntityInstance newparent, EntityInstance e) {
        if (newparent != e.getContainedBy()) {
            this.doFeedback("Landscape viewer may not change containment hierarchy");
        }
    }

    public void deleteContainer(EntityInstance e) {
        this.doFeedback("Landscape viewer may not delete containers");
    }

    protected boolean testForClose() {
        return this.af != null;
    }

    public void processKey(int key, int modifiers, Object object) {
        if (modifiers == 2) {
            switch (key) {
                case 113: {
                    if (this.testForClose()) {
                        System.exit(0);
                    }
                    return;
                }
                case 119: {
                    if (!this.testForClose()) {
                        return;
                    }
                    if (m_openFrames == 1) {
                        System.exit(0);
                        return;
                    }
                    this.m_frame.setVisible(false);
                    this.m_frame.dispose();
                    --m_openFrames;
                    return;
                }
                case 114: {
                    this.redrawDg();
                    return;
                }
                case 102: {
                    this.find();
                    return;
                }
                case 116: {
                    if (this.m_tocBox != null) {
                        this.m_tocBox.switch_TOC();
                    }
                    return;
                }
                case 100: {
                    if (this.m_diagram.set_to_viewport()) {
                        this.doFeedback("Diagram set to viewport");
                    }
                    return;
                }
            }
        } else if ((modifiers & 8) != 0) {
            switch (key) {
                case 81: {
                    boolean state = !this.isQueryPersist();
                    this.setQueryPersist(state);
                    this.doFeedback("Query persistence set to: " + (state ? "On" : "Off"));
                    return;
                }
                case 69: {
                    this.m_diagram.setEdgeMode(0);
                    this.setBestEdge();
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: best edge.");
                    return;
                }
                case 97: {
                    this.m_diagram.setEdgeMode(1);
                    this.setTbEdge();
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: top/bottom.");
                    return;
                }
                case 101: {
                    this.m_diagram.setEdgeMode(2);
                    this.setDirectEdge();
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    this.doFeedback("Edge mode set to: direct.");
                    return;
                }
                case 68: {
                    boolean show = !this.isShowDesc();
                    this.setShowDesc(show);
                    this.setVisibility(this.m_leftTextBoxTitle, show);
                    this.setVisibility(this.m_scrollLeftTextBox, show);
                    this.setVisibility(this.m_rightTextBoxTitle, show);
                    this.setVisibility(this.m_scrollRightTextBox, show);
                    this.computeMinInfoHeight();
                    this.m_secondSplitPane.revalidate();
                    return;
                }
                case 66: {
                    boolean show = !this.isShowFeedback();
                    this.setShowFeedback(show);
                    this.setVisibility(this.m_feedback, show);
                    this.setVisibility(this.m_nameBox, show);
                    this.computeMinInfoHeight();
                    this.m_secondSplitPane.revalidate();
                    return;
                }
                case 83: {
                    boolean show = !this.isShowClients();
                    this.setShowClients(show);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 115: {
                    boolean show = !this.isShowSuppliers();
                    this.setShowSuppliers(show);
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 116: {
                    this.setTopClients(!this.isTopClients());
                    this.navigateTo(this.m_diagram.getDrawRoot());
                    return;
                }
                case 107: {
                    boolean show = !this.isShowCardinals();
                    this.setShowCardinals(show);
                    this.m_diagram.redrawDiagram();
                    return;
                }
                case 80: {
                    boolean use = !this.isUseCompaction();
                    this.setUseCompaction(use);
                    this.m_diagram.redrawDiagram();
                    return;
                }
                case 84: {
                    this.m_tocBox.activate();
                    return;
                }
                case 108: {
                    this.m_legendBox.activate();
                    return;
                }
                case 109: {
                    this.m_mapBox.activate();
                    return;
                }
                case 113: {
                    this.m_queryBox.activate();
                    return;
                }
                case 114: {
                    this.m_resultBox.activate();
                    return;
                }
                case 122: {
                    boolean state = !this.isFixScrollBars();
                    this.setFixScrollBars(state);
                    if (state) {
                        this.m_scrollDiagram.setVerticalScrollBarPolicy(22);
                        this.m_scrollDiagram.setHorizontalScrollBarPolicy(32);
                        this.doFeedback("Diagram scroll bars permanently enabled");
                    } else {
                        this.m_scrollDiagram.setVerticalScrollBarPolicy(20);
                        this.m_scrollDiagram.setHorizontalScrollBarPolicy(30);
                        this.doFeedback("Diagram scroll bars will appear as needed");
                    }
                    return;
                }
                case 76: {
                    JComponent right;
                    JComponent left;
                    boolean state = !this.isLeftTabbox();
                    this.setLeftTabbox(state);
                    this.m_mainSplitPane.setLeftComponent(null);
                    this.m_mainSplitPane.setRightComponent(null);
                    if (state) {
                        left = this.m_rightTabbedPane;
                        right = this.m_secondSplitPane;
                    } else {
                        left = this.m_secondSplitPane;
                        right = this.m_rightTabbedPane;
                    }
                    int divider = left.getWidth();
                    Dimension min = new Dimension(100, 50);
                    left.setMinimumSize(min);
                    right.setMinimumSize(min);
                    this.m_mainSplitPane.setLeftComponent(left);
                    this.m_mainSplitPane.setRightComponent(right);
                    this.m_mainSplitPane.setDividerLocation(divider);
                    return;
                }
                case 75: {
                    boolean state = !this.isVisibleEdges();
                    this.setVisibleEdges(state);
                    this.redrawDg();
                }
                case 118: {
                    boolean show = !this.isTocHidden();
                    this.setTocHidden(show);
                    return;
                }
                case 112: {
                    if (this.m_tocBox != null) {
                        this.m_tocBox.toc_path();
                    }
                    return;
                }
            }
        } else if (modifiers == 1) {
            switch (key) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.m_queryBox.activate();
                    this.m_queryBox.toggleRelationActivity(key - 48);
                    this.repaintDg();
                    this.requestFocus();
                    return;
                }
            }
        } else if (modifiers == 0) {
            switch (key) {
                case 47: {
                    boolean state = !LandscapeViewerCore.isFontCorrection();
                    LandscapeViewerCore.setFontCorrection(state);
                    this.doFeedback("Font adjustment set to " + (state ? "on" : "off") + ".");
                    this.repaint();
                    return;
                }
                case 27: {
                    this.m_diagram.clearFlags();
                    this.doFeedback("Query/selection cleared");
                    this.m_diagram.setPreserveEntityMarks(0);
                    this.m_diagram.setPreserveRelationMarks(0);
                    this.redrawDg();
                    this.m_resultBox.clear();
                    this.m_modeHandler.reset();
                    return;
                }
                case 81: {
                    this.m_queryBox.toggleGroupingFlag();
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.m_legendBox.activate();
                    this.m_legendBox.toggleRelationVisibility(key - 48);
                    this.redrawDg();
                    this.requestFocus();
                    return;
                }
                case 1137: {
                    this.findPrev();
                    return;
                }
                case 1138: {
                    this.findNext();
                    return;
                }
                case 76: {
                    boolean show = !this.isLiftEdges();
                    this.setLiftEdges(show);
                    this.m_diagram.revalidate();
                    return;
                }
                case 1136: {
                    JOptionPane.showMessageDialog(this.m_frame, this.getTitle() + " " + Version.Details(this.getDiagram()), "About " + this.getTitle(), 0);
                    return;
                }
                case 1146: {
                    this.about();
                    return;
                }
                case 1147: {
                    this.help();
                    return;
                }
            }
        }
        if (this.m_modeHandler != null) {
            this.m_modeHandler.processKey(key, modifiers, object);
        }
    }

    public void dialogAction(Object[] results, int type) {
    }

    protected void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void navigateTo(EntityInstance e) {
        EntityInstance oldRoot = this.m_diagram.getDrawRoot();
        this.m_diagram.setPreserveEntityMarks(0);
        this.m_diagram.setPreserveRelationMarks(0);
        this.m_diagram.navigateTo(e);
        this.setLeftBox();
        this.m_diagram.clearFlags();
        this.m_rightTextBoxTitle.setText("");
        this.m_rightTextBox.set("");
        this.doFeedback("Now showing: " + e.getLabel());
        this.validate();
    }

    public void followLink(String url, int target) {
        this.showURL(url, target);
    }

    public void followLink(EntityInstance e, boolean newViewer) {
        Attribute attr = e.getLsAttribute("navlink");
        this.m_diagram.setPreserveEntityMarks(0);
        this.m_diagram.setPreserveRelationMarks(0);
        if (attr == null) {
            this.navigateTo(e);
            return;
        }
        AttributeValueItem avi = attr.avi;
        if (avi == null) {
            this.navigateTo(e);
            return;
        }
        while (avi != null) {
            String file = LsLink.expand(avi.value, e, this);
            if (file != null) {
                if (newViewer) {
                    this.followLink(file, 1);
                } else if (attr.avi.next != null) {
                    String tgtStr = Util.expand(avi.next.value, this);
                    int target = LsLink.convertTarget(tgtStr);
                    if (target == 6) {
                        this.navigateTo(e);
                    } else {
                        this.followLink(file, target);
                    }
                } else {
                    this.error("No target: " + attr.avi.value);
                }
            }
            avi = avi.nextList;
        }
    }

    protected void doSetCursor(int cursor) {
        if (this.m_frame != null) {
            this.m_frame.setCursor(cursor);
        }
    }

    public void setFrame(JFrame frame) {
        this.m_frame = frame;
        this.m_contentPane = frame.getContentPane();
    }

    public JFrame getFrame() {
        return this.m_frame;
    }

    public JPanel getContentPane() {
        return (JPanel)this.m_contentPane;
    }

    public Diagram getDiagram() {
        return this.m_diagram;
    }

    public TextTree getTocBox() {
        return this.m_tocBox;
    }

    public LegendBox getLegendBox() {
        return this.m_legendBox;
    }

    public MapBox getMapBox() {
        return this.m_mapBox;
    }

    public QueryBox getQueryBox() {
        return this.m_queryBox;
    }

    public ResultBox getResultBox() {
        return this.m_resultBox;
    }

    public void add(JComponent c) {
        this.m_contentPane.add(c);
    }

    public void repaint() {
        this.m_contentPane.repaint();
    }

    public void validate() {
        this.m_contentPane.validate();
    }

    public void requestFocus() {
        this.m_contentPane.requestFocus();
    }

    public Graphics getGraphics() {
        return this.m_contentPane.getGraphics();
    }

    public int getHeight() {
        return this.m_contentPane.getHeight();
    }

    public void setCursor(int cursor) {
        if (this.curCursor != cursor) {
            this.curCursor = cursor;
            if (!this.waitActive) {
                this.doSetCursor(cursor);
            }
        }
    }

    public void resetAnticipateCursor() {
        this.m_anticipateCursor = 0;
    }

    public void setAnticipateCursor(int cursor) {
        this.m_anticipateCursor = cursor;
    }

    public void useAnticipateCursor() {
        this.setCursor(this.m_anticipateCursor);
    }

    public void waitCursorOn() {
        if (!this.waitActive) {
            this.waitActive = true;
            this.doSetCursor(3);
        }
    }

    public void waitCursorOff() {
        if (this.waitActive) {
            this.waitActive = false;
            this.doSetCursor(this.curCursor);
        }
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        if (key <= 90) {
            if (key >= 65) {
                if ((modifiers & 1) != 0) {
                    modifiers &= 0xFFFFFFFE;
                } else {
                    key += 32;
                }
            }
        } else if (key >= 112 && key <= 123 && (modifiers & 0xA) == 0) {
            key += 1024;
        }
        this.processKey(key, modifiers, object);
    }

    public boolean isViewer() {
        return true;
    }

    public boolean getGroupQueryFlag() {
        return this.m_queryBox.getGroupingFlag();
    }

    public void setRightTextBox(String title, String description) {
        this.m_rightTextBoxTitle.setText(title);
        this.m_rightTextBox.set(description);
    }

    public InternalBufferStream getInternalBufferStream() {
        return null;
    }

    public Enumeration enumEntityClasses() {
        return this.m_diagram.enumEntityClasses();
    }

    public Enumeration enumEntityClassesInOrder() {
        return this.m_diagram.enumEntityClassesInOrder();
    }

    public Enumeration enumRelationClassesInOrder() {
        return this.m_diagram.enumRelationClassesInOrder();
    }

    public void beginUndoRedo(String name) {
        if (this.m_diagram != null) {
            this.m_diagram.beginUndoRedo(name);
        }
    }

    public void endUndoRedo() {
        if (this.m_diagram != null) {
            this.m_diagram.endUndoRedo();
        }
    }

    public JApplet getApplet() {
        return this.m_applet;
    }

    public void classChanges() {
        if (this.m_legendBox != null) {
            this.m_legendBox.fillLegendBox();
        }
        if (this.m_queryBox != null) {
            this.m_queryBox.fillQueryBox();
        }
    }

    public Vector getEdits() {
        if (this.m_diagram != null) {
            return this.m_diagram.getEdits();
        }
        return null;
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_diagram.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_diagram.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean redo) {
        if (this.m_diagram != null) {
            this.m_diagram.massChange(undoableEdit, redo);
            this.redrawDg();
            this.doFeedback("Changes " + (redo ? "redone" : "undone"));
        }
    }

    public void discardAllEdits() {
        if (this.m_diagram != null) {
            this.m_diagram.discardAllEdits();
        }
    }

    int getDiagramX() {
        return this.m_scrollDiagram.getX();
    }

    int getDiagramY() {
        return this.m_scrollDiagram.getY();
    }
}

