/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EditAttribute;
import lsedit.EntityChkBox;
import lsedit.EntityClass;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.RelnChkBox;

public class LegendBox
extends JComponent {
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected LandscapeViewerCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected static final Font titleFont = new Font("Helvetica", 1, 12);
    public static final String m_helpStr = "This box shows the types of entities and relations that are present in the current landscape.";
    protected JLabel m_ulabel;
    protected JLabel m_elabel1;
    protected JLabel m_elabel2;
    protected JLabel m_rlabel;
    protected JLabel m_flabel1;
    protected JLabel m_flabel2;
    protected int m_width;
    protected int m_height;

    public LegendBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_ulabel = new JLabel("Entities");
        this.m_ulabel.setForeground(Color.red);
        this.m_ulabel.setFont(titleFont);
        this.m_elabel1 = new JLabel("Pass cursor over entity for description.");
        this.m_elabel1.setForeground(Color.black);
        this.m_elabel1.setFont(textFont);
        this.m_elabel2 = new JLabel("Right click for menu.");
        this.m_elabel2.setForeground(Color.black);
        this.m_elabel2.setFont(textFont);
        this.m_rlabel = new JLabel("Relations");
        this.m_rlabel.setForeground(Color.red);
        this.m_rlabel.setFont(titleFont);
        this.m_flabel1 = new JLabel("Checkboxes select visible relations.");
        this.m_flabel1.setForeground(Color.black);
        this.m_flabel1.setFont(textFont);
        this.m_flabel2 = new JLabel("Right click for menu.");
        this.m_flabel2.setForeground(Color.black);
        this.m_flabel2.setFont(textFont);
        this.setLayout(null);
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setHorizontalScrollBarPolicy(30);
        this.m_scrollPane.setVerticalScrollBarPolicy(20);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("Legend", null, this.m_scrollPane, m_helpStr);
    }

    public LandscapeViewerCore getLegendLs() {
        return this.m_ls;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return active != null && this.m_scrollPane == active;
    }

    protected void add(JComponent component) {
        Dimension d = component.getPreferredSize();
        int width = d.width;
        int height = d.height;
        if (width > this.m_width) {
            this.m_width = width;
        }
        component.setBounds(5, this.m_height, width, height);
        super.add(component);
        this.m_height += height;
    }

    public void fillLegendBox() {
        Enumeration en;
        Diagram diagram = this.m_ls.getDiagram();
        this.removeAll();
        this.m_width = 0;
        this.m_height = 0;
        boolean item = false;
        int n = 0;
        int h = Do.fontHeight(textFont);
        this.m_height += 10;
        this.add(this.m_ulabel);
        if (diagram != null) {
            en = diagram.enumEntityClassesInOrder();
            while (en.hasMoreElements()) {
                EntityClass ec = (EntityClass)en.nextElement();
                String id = ec.getId();
                if (id.equals("$ENTITY")) continue;
                this.m_height += 10;
                this.add(new EntityLabel(this, ec, ++n, h));
            }
        }
        if (n == 0) {
            this.m_height += 10;
            this.add(new EntityLabel(this, diagram.m_entityBaseClass, ++n, h));
        }
        this.m_height += 10;
        this.add(this.m_elabel1);
        this.add(this.m_elabel2);
        this.m_height += 20;
        this.add(this.m_rlabel);
        this.m_height += 5;
        n = 0;
        if (diagram != null) {
            en = diagram.enumRelationClassesInOrder();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                if (rc.excludeReln()) continue;
                this.add(new VisibleRelnChkBox(this, rc, ++n));
            }
        }
        if (n == 0) {
            this.add(new VisibleRelnChkBox(this, diagram.m_relationBaseClass, ++n));
        }
        this.m_height += 20;
        this.add(this.m_flabel1);
        this.add(this.m_flabel2);
        this.m_width += 5;
        this.m_height += 10;
        Dimension dimension = new Dimension(this.m_width, this.m_height);
        this.setPreferredSize(dimension);
        this.setBounds(0, 0, this.m_width, this.m_height);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void toggleRelationVisibility(int key) {
        int cnt = this.getComponentCount();
        boolean ns = true;
        if (key == 0) {
            Component c;
            int i;
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof VisibleRelnChkBox) || ((VisibleRelnChkBox)c).getIndex() != 1) continue;
                ns = !((VisibleRelnChkBox)c).isClassVisible();
                break;
            }
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof VisibleRelnChkBox) || ns == ((VisibleRelnChkBox)c).isClassVisible()) continue;
                ((VisibleRelnChkBox)c).doClick();
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof VisibleRelnChkBox) || ((VisibleRelnChkBox)c).getIndex() != key) continue;
                ((VisibleRelnChkBox)c).doClick();
                break;
            }
        }
    }

    class VisibleRelnChkBox
    extends RelnChkBox
    implements ItemListener,
    MouseListener {
        protected LegendBox m_legendBox;
        protected JPopupMenu m_popup;

        public VisibleRelnChkBox(LegendBox legendBox2, RelationClass rc, int index) {
            super(rc, index, rc.isClassVisible());
            this.m_legendBox = legendBox2;
            this.addItemListener(this);
            this.addMouseListener(this);
        }

        public boolean isClassVisible() {
            return this.m_rc.isClassVisible();
        }

        public void setClassVisible(boolean value) {
            if (this.isClassVisible() != value) {
                this.m_rc.setClassVisible(value);
                LegendBox.this.m_ls.getDiagram().redrawDiagram();
            }
        }

        public void itemStateChanged(ItemEvent ev) {
            this.setClassVisible(ev.getStateChange() == 1);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent ev) {
            if (ev.isMetaDown()) {
                int x = ev.getX();
                int y = ev.getY();
                this.m_popup = new JPopupMenu("Relation menu");
                JMenuItem mi = new JMenuItem("Display hierarchy");
                mi.addActionListener(new DisplayClassHierarchy(mi, this.m_legendBox, this.m_rc, x, y));
                this.m_popup.add(mi);
                mi = new JMenuItem("Edit attributes");
                mi.addActionListener(new EditRelationClassAttributes(LegendBox.this.m_ls, this.m_rc));
                this.m_popup.add(mi);
                this.m_legendBox.add(this.m_popup);
                this.m_popup.show(this, x, y);
            }
        }

        public void mouseReleased(MouseEvent ev) {
        }
    }

    private class EntityLabel
    extends EntityChkBox
    implements ItemListener,
    MouseListener {
        protected LegendBox m_legendBox;
        protected JPopupMenu m_popup;

        public EntityLabel(LegendBox legendBox2, EntityClass ec, int index, int h) {
            super(ec, index, h, false);
            this.m_popup = null;
            this.m_legendBox = legendBox2;
            this.setFont(textFont);
            this.addItemListener(this);
            this.addMouseListener(this);
        }

        public void setClassShown(boolean value) {
            if (this.m_ec.isShown() != value) {
                this.m_ec.setShown(value);
                LegendBox.this.m_ls.getDiagram().redrawDiagram();
            }
        }

        public void itemStateChanged(ItemEvent ev) {
            this.setClassShown(ev.getStateChange() == 1);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent ev) {
            if (ev.isMetaDown()) {
                int x = ev.getX();
                int y = ev.getY();
                if (this.m_popup == null) {
                    this.m_popup = new JPopupMenu("Class menu");
                    JMenuItem mi = new JMenuItem("Display hierarchy");
                    mi.addActionListener(new DisplayClassHierarchy(mi, this.m_legendBox, this.m_ec, x, y));
                    this.m_popup.add(mi);
                    mi = new JMenuItem("Edit attributes");
                    mi.addActionListener(new EditClassAttributes(this.m_legendBox, this.m_ec));
                    this.m_popup.add(mi);
                    this.m_legendBox.add(this.m_popup);
                }
                this.m_popup.show(this, x, y);
            }
        }

        public void mouseReleased(MouseEvent ev) {
        }
    }

    private class EditRelationClassAttributes
    implements ActionListener {
        private LandscapeViewerCore m_ls;
        private RelationClass m_relation;

        public EditRelationClassAttributes(LandscapeViewerCore ls, RelationClass relation) {
            this.m_ls = ls;
            this.m_relation = relation;
        }

        public void actionPerformed(ActionEvent e) {
            EditAttribute.Create(this.m_ls, this.m_relation);
        }
    }

    private class EditClassAttributes
    implements ActionListener {
        private LegendBox m_legendBox;
        private EntityClass m_entity;

        public EditClassAttributes(LegendBox legendBox2, EntityClass entity) {
            this.m_legendBox = legendBox2;
            this.m_entity = entity;
        }

        public void actionPerformed(ActionEvent e) {
            EditAttribute.Create(LegendBox.this.m_ls, this.m_entity);
        }
    }

    private class DisplayClassHierarchy
    implements ActionListener {
        private LegendBox m_legendBox;
        private LandscapeClassObject m_landscapeClass;
        int m_x;
        int m_y;
        JPopupMenu m_popup = null;

        public DisplayClassHierarchy(JMenuItem menuitem, LegendBox legendBox2, LandscapeClassObject landscapeClass, int x, int y) {
            Enumeration parentElements = landscapeClass.getParentElements();
            if (parentElements == null || !parentElements.hasMoreElements()) {
                menuitem.setEnabled(false);
            }
            this.m_legendBox = legendBox2;
            this.m_landscapeClass = landscapeClass;
            this.m_x = x;
            this.m_y = y;
        }

        public void actionPerformed(ActionEvent e) {
            Enumeration parentElements = this.m_landscapeClass.getParentElements();
            if (parentElements != null && parentElements.hasMoreElements()) {
                String label = this.m_landscapeClass.getLabel();
                JPopupMenu popup = new JPopupMenu(label);
                while (parentElements.hasMoreElements()) {
                    LandscapeClassObject parent = (LandscapeClassObject)parentElements.nextElement();
                    JMenuItem mi = new JMenuItem(parent.getLabel());
                    mi.addActionListener(new DisplayClassHierarchy(mi, this.m_legendBox, parent, this.m_x, this.m_y));
                    popup.add(mi);
                }
                LegendBox.this.m_ls.add(popup);
                popup.show(this.m_legendBox, this.m_x, this.m_y);
            }
        }
    }
}

