/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;

public class MapBox
extends JComponent
implements Scrollable {
    protected static final int GAP = 5;
    protected static final Font textFont = new Font("Helvetica", 0, 10);
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected LandscapeViewerCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected String m_title;
    protected int m_last_scrollPane_width = 0;
    protected double m_last_ratio = 0.0;
    public static final String m_helpStr = "This box shows stylized versions of landscapes representing the path from the top of the containment hierarchy to the current landscape, with green boxes highlighting steps in the path.";

    public MapBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_title = "Map";
        this.setLayout(null);
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(tabbedPane.getBounds());
        this.setBounds(tabbedPane.getBounds());
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab(this.m_title, null, this.m_scrollPane, m_helpStr);
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return active != null && this.m_scrollPane == active;
    }

    public Dimension getPreferredSize() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            this.m_last_ratio = 0.0;
        } else {
            Insets insets = this.m_scrollPane.getInsets();
            int width = this.m_scrollPane.getWidth() - 5 - insets.right - insets.left;
            int diagram_width = diagram.getWidth();
            int diagram_height = diagram.getHeight();
            double ratio = (double)diagram_height / (double)diagram_width;
            if (width != this.m_last_scrollPane_width || ratio != this.m_last_ratio) {
                int box_width = width - 5;
                if (box_width < 0) {
                    box_width = 0;
                }
                int box_height = (int)((double)box_width * ratio);
                int cnt = this.getComponentCount();
                int height = cnt * (box_height + 5);
                Dimension d = new Dimension(width, height);
                this.setPreferredSize(d);
                this.setSize(d);
                this.setMaximumSize(d);
                this.m_last_scrollPane_width = width;
                this.m_last_ratio = ratio;
            }
        }
        return super.getPreferredSize();
    }

    public void addAll(EntityInstance e) {
        EntityInstance parent;
        if (e != null && (parent = e.getContainedBy()) != null) {
            this.addAll(parent);
            if (e.isEnterable()) {
                this.add(new Map(this, e));
            }
        }
    }

    public void fill(EntityInstance e) {
        this.removeAll();
        this.addAll(e);
        this.m_last_scrollPane_width = -1;
        this.getPreferredSize();
    }

    public void validate() {
        double ratio = this.m_last_ratio;
        if (ratio > 0.0) {
            int x = 5;
            int y = 0;
            int width = this.m_last_scrollPane_width - 10;
            int height = (int)((double)width * ratio);
            Dimension d = new Dimension(width, height);
            int cnt = this.getComponentCount();
            for (int i = 0; i < cnt; ++i) {
                Map map = (Map)this.getComponent(i);
                map.setLocation(x, y);
                map.setSize(d);
                map.setMinimumSize(d);
                map.setPreferredSize(d);
                map.setMaximumSize(d);
                y += height + 5;
            }
        }
    }

    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    class Map
    extends JComponent
    implements MouseListener {
        protected int m_style;
        protected MapBox m_mapBox;
        protected JLabel m_label;
        protected EntityInstance m_entity;

        public Map(MapBox mapBox2, EntityInstance entity) {
            this.setLayout(null);
            this.m_style = 0;
            this.m_mapBox = mapBox2;
            EntityInstance parent = entity.getContainedBy();
            if (parent != null) {
                this.m_label = new JLabel(parent.getLabel(), 0);
            }
            this.m_label.setForeground(Color.black);
            this.m_label.setFont(textFont);
            this.m_label.setLocation(0, 0);
            this.add(this.m_label);
            this.m_entity = entity;
            this.setToolTipText(entity.getLabel());
            this.addMouseListener(this);
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.m_label.setSize(width, 20);
        }

        public void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int lheight = this.m_label.getHeight();
            if (this.m_style != 0) {
                g.setColor(Diagram.boxColour);
                g.draw3DRect(0, 0, width - 2, height - 2, this.m_style == 1);
            }
            g.setColor(Color.black);
            g.drawLine(0, height - 1, width - 1, height - 1);
            EntityInstance parent = this.m_entity.getContainedBy();
            if (parent != null) {
                parent.paintMap(g, (int)((double)width * 0.166), lheight + 5, (int)((double)width * 0.66), height - lheight - 10, this.m_entity, 0);
            }
        }

        public void validate() {
            super.validate();
            int width = MapBox.this.m_last_scrollPane_width - 10;
            int label_height = this.m_label.getHeight();
            this.m_label.setBounds(0, 0, width, label_height);
        }

        public String toString() {
            return "Map " + this.m_label.getText() + " " + this.getBounds();
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.m_style = 1;
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.m_style = 0;
            this.repaint();
        }

        public void mousePressed(MouseEvent ev) {
            this.m_style = 2;
            this.repaint();
        }

        public void mouseReleased(MouseEvent ev) {
            this.m_style = 0;
            MapBox.this.m_ls.followLink(this.m_entity.getContainedBy(), false);
        }
    }
}

