/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;
import lsedit.RealPoint;
import lsedit.RelationInstance;

public class MoveModeHandler
extends LandscapeModeHandler {
    protected EdgePoint m_ept;

    protected RealPoint getFactors(int x, int y) {
        double hf;
        double wf;
        Rectangle lyt = this.m_ept.getEntity().getDiagramBounds();
        double xp = x;
        double yp = y;
        double dl = Math.abs(xp - (double)lyt.x);
        double dr = Math.abs(xp - (double)(lyt.x + lyt.width));
        double dt = Math.abs(yp - (double)lyt.y);
        double db = Math.abs(yp - (double)(lyt.y + lyt.height));
        if (dl < dr) {
            if (dt < db) {
                if (dt < dl) {
                    wf = (xp - (double)lyt.x) / (double)lyt.width;
                    hf = 0.0;
                } else {
                    wf = 0.0;
                    hf = (yp - (double)lyt.y) / (double)lyt.height;
                }
            } else if (db < dl) {
                wf = (xp - (double)lyt.x) / (double)lyt.width;
                hf = 1.0;
            } else {
                wf = 0.0;
                hf = (yp - (double)lyt.y) / (double)lyt.height;
            }
        } else if (dt < db) {
            if (dt < dr) {
                wf = (xp - (double)lyt.x) / (double)lyt.width;
                hf = 0.0;
            } else {
                wf = 1.0;
                hf = (yp - (double)lyt.y) / (double)lyt.height;
            }
        } else if (db < dr) {
            wf = (xp - (double)lyt.x) / (double)lyt.width;
            hf = 1.0;
        } else {
            wf = 1.0;
            hf = (yp - (double)lyt.y) / (double)lyt.height;
        }
        wf = Math.max(0.0, Math.min(1.0, wf));
        hf = Math.max(0.0, Math.min(1.0, hf));
        return new RealPoint(wf, hf);
    }

    protected boolean moveIOStart(int x, int y) {
        this.m_ls.setCursor(1);
        this.m_ls.redrawDg();
        RealPoint factors = this.getFactors(x, y);
        this.m_ls.doFeedback("I/O point at factors (" + factors.getX() + ", " + factors.getY() + ")");
        return true;
    }

    protected void moveIOMotion(int x, int y) {
        RealPoint factors = this.getFactors(x, y);
        this.m_ls.setCursor(1);
        this.m_ept.m_wf = factors.getX();
        this.m_ept.m_hf = factors.getY();
        this.m_ept.isDefault = false;
        this.m_ept.rescale();
        this.m_ls.doFeedback("I/O point at factors (" + this.m_ept.getX() + "/" + factors.getX() + ", " + this.m_ept.getY() + "/" + factors.getY() + ")");
    }

    protected void moveIOEnd(MouseEvent ev) {
        this.m_ls.redrawDg();
    }

    public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        this.m_ept = null;
        return false;
    }

    public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ept = null;
        if (!this.m_ls.isViewer()) {
            this.m_ept = ri.mouseOverEdgePoint(x, y);
            if (this.m_ept != null) {
                this.moveIOStart(x, y);
                return true;
            }
        }
        return false;
    }

    public boolean relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.m_ept != null) {
            this.moveIOMotion(x, y);
        }
        return true;
    }

    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_ls.clearFeedback();
        if (this.m_ept != null) {
            this.moveIOEnd(ev);
        }
    }
}

