/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import lsedit.Diagram;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.RelnChkBox;

public class QueryBox
extends JComponent {
    protected static final Font textFont = new Font("Helvetica", 0, 11);
    protected static final Font titleFont = new Font("Helvetica", 1, 12);
    public static final String m_helpStr = "This box shows the relations which are active during queries";
    protected static final int MARGIN = 5;
    protected static final int GAP = 5;
    protected LandscapeViewerCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JLabel m_ulabel;
    protected JLabel m_footer1;
    protected JLabel m_footer2;
    protected int m_width;
    protected int m_height;
    protected GrpChkBox m_grpChk;

    public QueryBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.setBackground(Diagram.boxColour);
        this.m_ulabel = new JLabel("Relations");
        this.m_ulabel.setFont(titleFont);
        this.m_ulabel.setForeground(Color.black);
        this.m_ulabel.setBackground(Diagram.boxColour);
        this.m_footer1 = new JLabel("Checkboxes select active relations.");
        this.m_footer1.setFont(textFont);
        this.m_footer1.setForeground(Color.black);
        this.m_footer1.setBackground(Diagram.boxColour);
        this.m_footer2 = new JLabel("Click relation arrow for description.");
        this.m_footer2.setFont(textFont);
        this.m_footer2.setForeground(Color.black);
        this.m_footer2.setBackground(Diagram.boxColour);
        this.m_grpChk = new GrpChkBox(this.m_ls, "Group with queries");
        this.m_grpChk.setFont(textFont);
        this.m_grpChk.setForeground(Color.black);
        this.m_grpChk.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("Queries", null, this.m_scrollPane, m_helpStr);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return active != null && this.m_scrollPane == active;
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    protected void add(JComponent component) {
        Dimension d = component.getPreferredSize();
        int width = d.width;
        int height = d.height;
        if (width > this.m_width) {
            this.m_width = width;
        }
        component.setBounds(5, this.m_height, width, height);
        super.add(component);
        this.m_height += height;
    }

    public void fillQueryBox() {
        this.removeAll();
        this.m_width = 0;
        this.m_height = 10;
        this.add(this.m_ulabel);
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            int n = 0;
            this.m_height += 5;
            Enumeration en = dg.enumRelationClassesInOrder();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                String id = rc.getId();
                if (rc.excludeReln()) continue;
                this.add(new ActiveRelnChkBox(rc, ++n));
            }
        }
        this.m_height += 20;
        this.add(this.m_footer1);
        this.add(this.m_footer2);
        this.m_height += 10;
        this.add(this.m_grpChk);
        Dimension dimension = new Dimension(this.m_width, this.m_height);
        this.setPreferredSize(dimension);
        this.setBounds(0, 0, this.m_width, this.m_height);
    }

    public void toggleRelationActivity(int key) {
        int cnt = this.getComponentCount();
        if (key == 0) {
            Component c;
            int i;
            boolean ns = true;
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)c).getIndex() != 1) continue;
                ns = !((ActiveRelnChkBox)c).isActive();
                break;
            }
            for (i = 0; i < cnt; ++i) {
                c = this.getComponent(i);
                if (!(c instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)c).isActive() == ns) continue;
                ((ActiveRelnChkBox)c).doClick();
            }
        } else {
            for (int i = 0; i < cnt; ++i) {
                Component c = this.getComponent(i);
                if (!(c instanceof ActiveRelnChkBox) || ((ActiveRelnChkBox)c).getIndex() != key) continue;
                ((ActiveRelnChkBox)c).doClick();
                break;
            }
        }
    }

    public void toggleGroupingFlag() {
        this.m_grpChk.doClick();
    }

    public boolean getGroupingFlag() {
        return this.m_grpChk.isSelected();
    }

    protected class GrpChkBox
    extends JCheckBox
    implements ItemListener {
        protected LandscapeViewerCore m_ls;

        GrpChkBox(LandscapeViewerCore ls, String label) {
            super(label);
            this.m_ls = ls;
            this.addItemListener(this);
        }

        protected void grpStateInfo() {
            this.m_ls.doFeedback("Entities " + (this.isSelected() ? "are" : "aren't") + " grouped with queries");
        }

        public void itemStateChanged(ItemEvent ev) {
            this.grpStateInfo();
            this.m_ls.requestFocus();
        }
    }

    class ActiveRelnChkBox
    extends RelnChkBox
    implements ItemListener {
        public ActiveRelnChkBox(RelationClass rc, int index) {
            super(rc, index, rc.isActive());
            this.addItemListener(this);
        }

        public boolean isActive() {
            return this.m_rc.isActive();
        }

        public void setActive(boolean value) {
            if (this.m_rc.isActive() != value) {
                this.m_rc.setActiveState(value);
                this.repaint();
            }
        }

        public void itemStateChanged(ItemEvent ev) {
            this.setActive(ev.getStateChange() == 1);
        }
    }
}

