/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityClassPair;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationClass
extends LandscapeClassObject {
    protected static final String FACTOR_ID = "class_iofactor";
    protected static final String RELATION_BASE_CLASS_ID = "$RELATION";
    protected boolean m_active = true;
    protected boolean m_visible = true;
    private Vector m_relationList = new Vector();
    protected int ordinal;

    public RelationClass(String id, int nid, RelationClass prc, Diagram dg) {
        this.setId(id);
        this.setNid(nid);
        this.setLabel(id);
        this.setDiagram(dg);
        this.setStyle(0);
        this.addParentClass(prc);
        this.setObjectColor(Color.black);
    }

    public String getStyleName(int style) {
        return Util.getLineStyleName(style);
    }

    public boolean excludeReln() {
        String id = this.getId();
        return id.equals("contain") || id.equals(RELATION_BASE_CLASS_ID);
    }

    public void addRelation(EntityClass ec1, EntityClass ec2) {
        EntityClassPair p = new EntityClassPair(ec1, ec2);
        if (this.m_relationList == null) {
            this.m_relationList = new Vector();
        }
        this.m_relationList.addElement(p);
    }

    public RelationInstance newRelation(EntityInstance e1, EntityInstance e2) {
        RelationInstance ri = new RelationInstance(this, e1, e2);
        this.makeInstanceOfUs(ri);
        return ri;
    }

    public void writeRelations(PrintStream ps) throws IOException {
        Enumeration en = this.m_relationList.elements();
        while (en.hasMoreElements()) {
            EntityClassPair ep = (EntityClassPair)en.nextElement();
            ps.print(this.qt(this.getId()) + " " + this.qt(ep.entityClass1.getId()) + " " + this.qt(ep.entityClass2.getId()) + "\n");
        }
    }

    public void getRelationsRaw(Vector v, Hashtable st) {
        Enumeration en = this.m_relationList.elements();
        while (en.hasMoreElements()) {
            EntityClassPair ep = (EntityClassPair)en.nextElement();
            Integer[] tup = new Integer[]{(Integer)st.get(this.getId()), (Integer)st.get(ep.entityClass1.getId()), (Integer)st.get(ep.entityClass2.getId())};
            v.addElement(tup);
        }
    }

    public void writeAttributes(PrintStream ps) throws IOException {
        if (this.getNid() >= 2) {
            ps.print("(" + this.qt(this.getId()) + ") {\n");
            super.writeAttributes(ps);
            ps.print("}\n\n");
        }
    }

    public boolean isClassVisible() {
        return this.m_visible;
    }

    public void setClassVisible(boolean state) {
        this.m_visible = state;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActiveState(boolean state) {
        this.m_active = state;
    }

    public String addParentClass(RelationClass inherits) {
        return this.addParentClass(inherits, RELATION_BASE_CLASS_ID);
    }

    public void setOrdinal(int ord) {
        this.ordinal = ord;
    }

    public double getIOfactor() {
        Attribute attr = this.getLsAttribute(FACTOR_ID);
        if (attr != null) {
            return Util.parseReal(attr.avi.value);
        }
        Diagram diagram = this.getDiagram();
        if (diagram.allowElision()) {
            double num = diagram.numVisibleRelationClasses();
            return (double)(this.ordinal + 1) / (num + 1.0);
        }
        double num = diagram.numRelationClasses();
        return num > 2.0 ? (double)(this.getNid() - 1) / (num - 1.0) : 0.5;
    }

    public int getPrimaryAttributeCount() {
        return 6;
    }

    public String getLsAttributeNameAt(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "id";
                break;
            }
            case 1: {
                name = "class_label";
                break;
            }
            case 2: {
                name = "class_description";
                break;
            }
            case 3: {
                name = "class_style";
                break;
            }
            case 4: {
                name = "color";
                break;
            }
            case 5: {
                name = "labelcolor";
                break;
            }
            default: {
                name = super.getLsAttributeNameAt(index);
            }
        }
        return name;
    }

    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                value = this.getId();
                break;
            }
            case 1: {
                value = this.getLabel();
                break;
            }
            case 2: {
                value = this.getDescription();
                break;
            }
            case 3: {
                value = new Integer(this.getStyle());
                break;
            }
            case 4: {
                value = this.getObjectColor();
                break;
            }
            case 5: {
                value = this.getLabelColor();
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    public void setAttributeValueAt(int index, Object value) {
        switch (index) {
            case 0: {
                this.setId((String)value);
                break;
            }
            case 1: {
                this.updateLabel((String)value);
                break;
            }
            case 2: {
                this.updateDescription((String)value);
                break;
            }
            case 3: {
                this.updateStyle((Integer)value);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)value);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)value);
                break;
            }
            default: {
                super.setAttributeValueAt(index, value);
            }
        }
    }

    public int getLsAttributeTypeAt(int index) {
        int ret;
        switch (index) {
            case 0: 
            case 1: {
                ret = 3;
                break;
            }
            case 2: {
                ret = 12;
                break;
            }
            case 3: {
                ret = 14;
                break;
            }
            case 4: 
            case 5: {
                ret = 7;
                break;
            }
            default: {
                ret = super.getLsAttributeTypeAt(index);
            }
        }
        return ret;
    }
}

