/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Util;

public class RelationComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    protected static final Color HIGHLIGHT_COLOUR = Color.yellow;
    protected static final int HIGHLIGHT_DIM = 4;
    protected static final int RECURSIVE_LOOP_RADIUS = 8;
    protected static final int RECURSIVE_LOOP_DIAMETER = 16;
    protected static final int[] m_arc_xp = new int[]{0, 0, 7};
    protected static final int[] m_arc_yp = new int[]{7, 0, 7};
    protected static final int NEAR_POINT_THRESHOLD = 1;
    protected static final int NEAR_LINE_THRESHOLD2 = 1;
    protected static final int NEAR_LOOP_THRESHOLD = 1;
    public static final int DRAW_TAIL_MARK = 1;
    public static final int DRAW_CENTRE_MARK = 2;
    public static final int DRAW_ARROW_MARK = 4;
    private RelationInstance m_relationInstance;
    private Object m_drawInfo;
    private int timeStamp = -1;

    public static void getLineBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        int y2;
        int y1;
        int x2;
        int x1;
        if (srcX <= dstX) {
            x1 = srcX;
            x2 = dstX;
        } else {
            x1 = dstX;
            x2 = srcX;
        }
        if (srcY <= dstY) {
            y1 = srcY;
            y2 = dstY;
        } else {
            y1 = dstY;
            y2 = srcY;
        }
        if (Util.LINE_W > 1) {
            int w = x2 - x1;
            int h = y2 - y1;
            int shift = Util.LINE_W / 2;
            if (h > 2 * w) {
                x1 -= shift;
                x2 += shift;
            }
            if (w >= 2 * h) {
                y1 -= shift;
                y2 += shift;
            }
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public static void includeTailBounds(int srcX, int srcY, Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int x = srcX - 3;
        int y = srcY - 3;
        if (x < x1) {
            x1 = x;
        }
        if (y < y1) {
            y1 = y;
        }
        y += 6;
        if ((x += 6) > x2) {
            x2 = x;
        }
        if (y > y2) {
            y2 = y;
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public static void includeCentreBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int x = (srcX + dstX - 4) / 2;
        int y = (srcY + dstY - 4) / 2;
        if (x < x1) {
            x1 = x;
        }
        if (y < y1) {
            y1 = y;
        }
        y += 4;
        if ((x += 4) > x2) {
            x2 = x;
        }
        if (y > y2) {
            y2 = y;
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public static void includeArrowBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
        int x1 = r.x;
        int y1 = r.y;
        int x2 = x1 + r.width;
        int y2 = y1 + r.height;
        int[] x3 = new int[3];
        int[] y3 = new int[3];
        if (Util.getArrow(srcX, srcY, dstX, dstY, x3, y3)) {
            for (int i = 0; i < 3; ++i) {
                int x = x3[i];
                int y = y3[i];
                if (x < x1) {
                    x1 = x;
                }
                if (y < y1) {
                    y1 = y;
                }
                if (x > x2) {
                    x2 = x;
                }
                if (y <= y2) continue;
                y2 = y;
            }
        }
        r.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public static boolean nearPoint(int srcX, int srcY, int x, int y) {
        int diff = x - srcX;
        if (diff < 0) {
            diff = -diff;
        }
        if (diff > 1) {
            return false;
        }
        diff = y - srcY;
        if (diff < 0) {
            diff = -diff;
        }
        return diff <= 1;
    }

    public static boolean nearLine(int srcX, int srcY, int dstX, int dstY, int x, int y) {
        double py;
        double ly;
        double px;
        double lx;
        double dist2;
        if (srcX == dstX && srcY == dstY) {
            return RelationComponent.nearPoint(srcX, srcY, x, y);
        }
        double rx = x;
        double vx = dstX - srcX;
        double ry = y;
        double vy = dstY - srcY;
        double t = ((rx - (double)srcX) * vx + (ry - (double)srcY) * vy) / (vx * vx + vy * vy);
        return t >= 0.0 && t <= 1.0 && (dist2 = (lx = rx - (px = (double)srcX + t * vx)) * lx + (ly = ry - (py = (double)srcY + t * vy)) * ly) <= 1.0;
    }

    protected Vector points(boolean allowElision) {
        EdgeInfo edgeInfo;
        EntityInstance ep;
        EntityInstance next;
        EntityInstance endDown;
        EntityInstance endUp;
        boolean supplier;
        RelationInstance relationInstance = this.m_relationInstance;
        EntityInstance root = relationInstance.getDiagram().getDrawRoot();
        EntityInstance drawSrc = relationInstance.getDrawSrc();
        EntityInstance drawDst = relationInstance.getDrawDst();
        RelationClass parentClass = relationInstance.getRelationClass();
        OutElidedInfo outElided = null;
        InElidedInfo inElided = null;
        boolean client = !root.hasDescendantOrSelf(drawSrc);
        boolean bl = supplier = !root.hasDescendantOrSelf(drawDst);
        if (!client && !supplier) {
            endDown = endUp = drawSrc.commonAncestor(drawDst);
        } else if (client) {
            endUp = drawSrc.getContainedBy();
            endDown = root.getContainedBy();
        } else {
            endUp = root.getContainedBy();
            endDown = drawDst.getContainedBy();
        }
        if (endUp == null) {
            System.out.println("C Error: " + relationInstance + " " + client + " " + supplier);
            return null;
        }
        if (endDown == null) {
            System.out.println("S Error: " + relationInstance + " " + client + " " + supplier);
            return null;
        }
        Vector<LineInfo> v1 = new Vector<LineInfo>();
        Vector<LineInfo> v2 = new Vector<LineInfo>();
        int edgeMode = relationInstance.getEdgeMode();
        EntityInstance sp = drawSrc;
        while ((next = sp.getContainedBy()) != endUp) {
            sp = next;
        }
        EntityInstance dp = drawDst;
        while ((next = dp.getContainedBy()) != endDown) {
            dp = next;
        }
        Rectangle spLyt = sp.getDiagramBounds();
        Rectangle dpLyt = dp.getDiagramBounds();
        int style = allowElision && (relationInstance.getSrc() != drawSrc || relationInstance.getDst() != drawDst) ? 2 : relationInstance.getStyle();
        int embellished = 1;
        if (relationInstance.isMarked(512)) {
            embellished |= 2;
        }
        EdgePoint pt1 = null;
        EdgePoint ppt = null;
        EntityInstance e = drawSrc;
        while (e != endUp) {
            if (e == null) {
                MsgOut.println("Error in points: (" + parentClass.getId() + " " + relationInstance + ")");
                return null;
            }
            ep = e.getContainedBy();
            pt1 = e.getOutPoint(relationInstance, edgeMode, spLyt, dpLyt);
            if (ppt != null) {
                if (allowElision && e.isExitingRelationElided(parentClass)) {
                    outElided = new OutElidedInfo();
                    outElided.setOutElidedInfo(pt1, dpLyt);
                    outElided.setStyle(style);
                    v1.addElement(outElided);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(ppt, pt1);
                edgeInfo.setStyle(style);
                edgeInfo.setEmbellished(embellished);
                embellished &= 0xFFFFFFFE;
                v1.addElement(edgeInfo);
            }
            ppt = pt1;
            e = ep;
        }
        embellished &= 0xFFFFFFFE;
        embellished |= 4;
        EdgePoint pt2 = null;
        ppt = null;
        e = drawDst;
        while (e != endDown) {
            ep = e.getContainedBy();
            pt2 = e.getOutPoint(relationInstance, edgeMode, dpLyt, spLyt);
            if (ppt != null) {
                if (allowElision && e.isEnteringRelationElided(parentClass)) {
                    inElided = new InElidedInfo();
                    inElided.setInElidedInfo(spLyt, pt2);
                    inElided.setStyle(style);
                    v2.addElement(inElided);
                    break;
                }
                edgeInfo = new EdgeInfo();
                edgeInfo.setEdgeInfo(pt2, ppt);
                edgeInfo.setStyle(style);
                edgeInfo.setEmbellished(embellished);
                embellished &= 0xFFFFFFFB;
                v2.addElement(edgeInfo);
            }
            ppt = pt2;
            e = ep;
        }
        if (outElided == null && inElided == null) {
            edgeInfo = new EdgeInfo();
            edgeInfo.setEdgeInfo(pt1, pt2);
            v1.addElement(edgeInfo);
        } else if (inElided == null) {
            v2.removeAllElements();
        } else if (outElided == null) {
            v1.removeAllElements();
        }
        for (int i = v2.size() - 1; i >= 0; --i) {
            v1.addElement((LineInfo)v2.elementAt(i));
        }
        return v1;
    }

    public RelationComponent(RelationInstance relationInstance) {
        this.setLayout(null);
        this.m_relationInstance = relationInstance;
        relationInstance.setSwingObject(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void computeBounds(Rectangle r) {
        if (this.m_drawInfo == null) {
            r.setBounds(0, 0, 0, 0);
        } else if (this.m_drawInfo instanceof DrawInfo) {
            ((DrawInfo)this.m_drawInfo).getBounds(r);
        } else {
            int x1 = Integer.MAX_VALUE;
            int x2 = Integer.MIN_VALUE;
            int y1 = Integer.MAX_VALUE;
            int y2 = Integer.MIN_VALUE;
            Enumeration en = ((Vector)this.m_drawInfo).elements();
            while (en.hasMoreElements()) {
                int y;
                DrawInfo drawInfo = (DrawInfo)en.nextElement();
                drawInfo.getBounds(r);
                int x = r.x;
                if (x < x1) {
                    x1 = x;
                }
                if ((y = r.y) < y1) {
                    y1 = y;
                }
                y += r.height;
                if ((x += r.width) > x2) {
                    x2 = x;
                }
                if (y <= y2) continue;
                y2 = y;
            }
            r.setBounds(x1, y1, x2 - x1, y2 - 1);
        }
    }

    public boolean contains(int x, int y) {
        if (super.contains(x, y)) {
            x += this.getX();
            y += this.getY();
            if (this.m_drawInfo != null) {
                if (this.m_drawInfo instanceof DrawInfo) {
                    return ((DrawInfo)this.m_drawInfo).contains(x, y);
                }
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    if (!((DrawInfo)en.nextElement()).contains(x, y)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EdgePoint mouseOverEdgePoint(int x, int y) {
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                return ((DrawInfo)this.m_drawInfo).mouseOverEdgePoint(x, y);
            }
            Enumeration en = ((Vector)this.m_drawInfo).elements();
            while (en.hasMoreElements()) {
                EdgePoint ep = ((DrawInfo)en.nextElement()).mouseOverEdgePoint(x, y);
                if (ep == null) continue;
                return ep;
            }
        }
        return null;
    }

    public void validate() {
        RelationInstance relationInstance = this.m_relationInstance;
        super.validate();
        EntityInstance drawSrc = relationInstance.getDrawSrc();
        if (drawSrc == null) {
            return;
        }
        EntityInstance drawDst = relationInstance.getDrawDst();
        if (drawDst == null) {
            return;
        }
        if (relationInstance.isMarked(1)) {
            if (this.m_drawInfo == null || !(this.m_drawInfo instanceof ArcInfo)) {
                this.m_drawInfo = new ArcInfo();
            }
            ((ArcInfo)this.m_drawInfo).setArc(drawSrc.getDiagramX() + drawSrc.getWidth() - 8, drawSrc.getDiagramY() - 8);
        } else {
            Rectangle srcLyt = drawSrc.getDiagramBounds();
            Rectangle dstLyt = drawDst.getDiagramBounds();
            int edgeMode = relationInstance.getEdgeMode();
            if (relationInstance.isMarked(48)) {
                DrawInfo drawInfo;
                Enumeration en;
                OutElidedInfo out = null;
                InElidedInfo in = null;
                if (relationInstance.isMarked(16)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof OutElidedInfo) {
                            out = (OutElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            en = ((Vector)this.m_drawInfo).elements();
                            while (en.hasMoreElements()) {
                                drawInfo = (DrawInfo)en.nextElement();
                                if (!(drawInfo instanceof OutElidedInfo)) continue;
                                out = (OutElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (out == null) {
                        out = new OutElidedInfo();
                    }
                    EdgePoint srcPt = drawSrc.getOutPoint(relationInstance, edgeMode, srcLyt, dstLyt);
                    out.setOutElidedInfo(srcPt, dstLyt);
                    out.setStyle(relationInstance.getStyle());
                }
                if (relationInstance.isMarked(32)) {
                    if (this.m_drawInfo != null) {
                        if (this.m_drawInfo instanceof InElidedInfo) {
                            in = (InElidedInfo)this.m_drawInfo;
                        } else if (this.m_drawInfo instanceof Vector) {
                            en = ((Vector)this.m_drawInfo).elements();
                            while (en.hasMoreElements()) {
                                drawInfo = (DrawInfo)en.nextElement();
                                if (!(drawInfo instanceof InElidedInfo)) continue;
                                in = (InElidedInfo)drawInfo;
                                break;
                            }
                        }
                    }
                    if (in == null) {
                        in = new InElidedInfo();
                    }
                    EdgePoint dstPt = drawDst.getOutPoint(relationInstance, edgeMode, dstLyt, srcLyt);
                    in.setInElidedInfo(srcLyt, dstPt);
                    in.setStyle(relationInstance.getStyle());
                }
                if (out == null) {
                    this.m_drawInfo = in;
                } else if (in == null) {
                    this.m_drawInfo = out;
                } else {
                    if (this.m_drawInfo instanceof Vector) {
                        ((Vector)this.m_drawInfo).removeAllElements();
                    } else {
                        this.m_drawInfo = new Vector();
                    }
                    ((Vector)this.m_drawInfo).addElement(out);
                    ((Vector)this.m_drawInfo).addElement(in);
                }
            } else if (relationInstance.isMarked(2)) {
                if (drawSrc.getContainedBy() == drawDst.getContainedBy() || edgeMode == 2 || !relationInstance.isMarked(4)) {
                    if (this.m_drawInfo == null || !(this.m_drawInfo instanceof EdgeInfo)) {
                        this.m_drawInfo = new EdgeInfo();
                    }
                    EdgeInfo edgeInfo = (EdgeInfo)this.m_drawInfo;
                    EdgePoint pt1 = drawSrc.getOutPoint(relationInstance, edgeMode, srcLyt, dstLyt);
                    EdgePoint pt2 = drawDst.getOutPoint(relationInstance, edgeMode, dstLyt, srcLyt);
                    edgeInfo.setEdgeInfo(pt1, pt2);
                    if (relationInstance.getSrc() != drawSrc || relationInstance.getDst() != drawDst) {
                        edgeInfo.setStyle(2);
                    } else {
                        edgeInfo.setStyle(relationInstance.getStyle());
                    }
                    int embellished = 4;
                    if (relationInstance.isMarked(512)) {
                        embellished |= 2;
                    }
                    edgeInfo.setEmbellished(embellished);
                } else {
                    this.m_drawInfo = this.points(relationInstance.isMarked(4));
                }
            }
        }
        if (this.m_drawInfo != null) {
            Rectangle r = new Rectangle();
            this.computeBounds(r);
            ++r.width;
            ++r.height;
            this.setBounds(r);
            this.repaint();
        }
    }

    public void paintComponent(Graphics g) {
        int shiftX = this.getX();
        int shiftY = this.getY();
        g.setColor(this.m_relationInstance.getObjectColor());
        if (this.m_drawInfo != null) {
            if (this.m_drawInfo instanceof DrawInfo) {
                ((DrawInfo)this.m_drawInfo).paintComponent(g, shiftX, shiftY);
            } else {
                Enumeration en = ((Vector)this.m_drawInfo).elements();
                while (en.hasMoreElements()) {
                    DrawInfo drawInfo = (DrawInfo)en.nextElement();
                    drawInfo.paintComponent(g, shiftX, shiftY);
                }
            }
        }
    }

    public String toString() {
        return "RelationComponent: " + this.m_relationInstance;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.m_relationInstance.mouseEntered();
    }

    public void mouseExited(MouseEvent e) {
        this.m_relationInstance.mouseExited();
    }

    public void mousePressed(MouseEvent ev) {
        this.m_relationInstance.mousePressed(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    public void mouseReleased(MouseEvent ev) {
        this.m_relationInstance.mouseReleased(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    public void mouseDragged(MouseEvent ev) {
        this.m_relationInstance.mouseDragged(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    public void mouseMoved(MouseEvent ev) {
        this.m_relationInstance.mouseMoved(ev, ev.getX() + this.getX(), ev.getY() + this.getY());
    }

    class EdgeInfo
    extends LineInfo {
        private int m_embellished;
        private EdgePoint m_src;
        private EdgePoint m_dst;

        EdgeInfo() {
        }

        public void setEdgeInfo(EdgePoint src, EdgePoint dst) {
            this.m_src = src;
            this.m_dst = dst;
        }

        public void setEmbellished(int embellished) {
            this.m_embellished = embellished;
        }

        public void getBounds(Rectangle r) {
            RelationComponent.getLineBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), r);
            if ((this.m_embellished & 1) != 0) {
                RelationComponent.includeTailBounds((int)this.m_src.getX(), (int)this.m_src.getY(), r);
            }
            if ((this.m_embellished & 2) != 0) {
                RelationComponent.includeCentreBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), r);
            }
            if ((this.m_embellished & 4) != 0) {
                RelationComponent.includeArrowBounds((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), r);
            }
        }

        public boolean contains(int x, int y) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), (int)this.m_dst.getX(), (int)this.m_dst.getY(), x, y);
        }

        public EdgePoint mouseOverEdgePoint(int x, int y) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), x, y)) {
                return this.m_src;
            }
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), x, y)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics g, int shiftX, int shiftY) {
            int srcX = (int)(this.m_src.getX() - (double)shiftX);
            int srcY = (int)(this.m_src.getY() - (double)shiftY);
            int dstX = (int)(this.m_dst.getX() - (double)shiftX);
            int dstY = (int)(this.m_dst.getY() - (double)shiftY);
            Util.drawSegment(g, this.m_style, srcX, srcY, dstX, dstY);
            if ((this.m_embellished & 1) != 0) {
                g.fillOval(srcX - 3, srcY - 3, 6, 6);
            }
            if ((this.m_embellished & 2) != 0) {
                Color tc = g.getColor();
                g.setColor(HIGHLIGHT_COLOUR);
                g.fillRect((srcX + dstX - 4) / 2, (srcY + dstY - 4) / 2, 4, 4);
                g.setColor(tc);
            }
            if ((this.m_embellished & 4) != 0) {
                Util.drawArrowHead(g, srcX, srcY, dstX, dstY);
            }
        }
    }

    class InElidedInfo
    extends ElidedInfo {
        int m_srcX;
        int m_srcY;
        private EdgePoint m_dst;

        InElidedInfo() {
        }

        public void setInElidedInfo(Rectangle srcLyt, EdgePoint dstPt) {
            double srcX = srcLyt.x + srcLyt.width / 2;
            double srcY = srcLyt.y + srcLyt.height / 2;
            double dx = srcX - dstPt.getX();
            double dy = srcY - dstPt.getY();
            double df = Math.sqrt(dx * dx + dy * dy);
            this.m_srcX = (int)(dstPt.getX() + dx * 2.0 * Util.ARROW_L / df);
            this.m_srcY = (int)(dstPt.getY() + dy * 2.0 * Util.ARROW_L / df);
            this.m_dst = dstPt;
        }

        public void getBounds(Rectangle r) {
            this.getBounds(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), r);
        }

        public boolean contains(int x, int y) {
            return RelationComponent.nearLine(this.m_srcX, this.m_srcY, (int)this.m_dst.getX(), (int)this.m_dst.getY(), x, y);
        }

        public EdgePoint mouseOverEdgePoint(int x, int y) {
            if (RelationComponent.nearPoint((int)this.m_dst.getX(), (int)this.m_dst.getY(), x, y)) {
                return this.m_dst;
            }
            return null;
        }

        public void paintComponent(Graphics g, int shiftX, int shiftY) {
            this.paintComponent(g, this.m_srcX - shiftX, this.m_srcY - shiftY, (int)(this.m_dst.getX() - (double)shiftX), (int)(this.m_dst.getY() - (double)shiftY));
        }
    }

    class OutElidedInfo
    extends ElidedInfo {
        private EdgePoint m_src;
        int m_dstX;
        int m_dstY;

        OutElidedInfo() {
        }

        public void setOutElidedInfo(EdgePoint srcPt, Rectangle dstLyt) {
            this.m_src = srcPt;
            double dstX = dstLyt.x + dstLyt.width / 2;
            double dstY = dstLyt.y + dstLyt.height / 2;
            double dx = srcPt.getX() - dstX;
            double dy = srcPt.getY() - dstY;
            double df = Math.sqrt(dx * dx + dy * dy);
            this.m_src = srcPt;
            this.m_dstX = (int)(srcPt.getX() - dx * 2.0 * Util.ARROW_L / df);
            this.m_dstY = (int)(srcPt.getY() - dy * 2.0 * Util.ARROW_L / df);
        }

        public void getBounds(Rectangle r) {
            this.getBounds((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, r);
        }

        public boolean contains(int x, int y) {
            return RelationComponent.nearLine((int)this.m_src.getX(), (int)this.m_src.getY(), this.m_dstX, this.m_dstY, x, y);
        }

        public EdgePoint mouseOverEdgePoint(int x, int y) {
            if (RelationComponent.nearPoint((int)this.m_src.getX(), (int)this.m_src.getY(), x, y)) {
                return this.m_src;
            }
            return null;
        }

        public void paintComponent(Graphics g, int shiftX, int shiftY) {
            this.paintComponent(g, (int)(this.m_src.getX() - (double)shiftX), (int)(this.m_src.getY() - (double)shiftY), this.m_dstX - shiftX, this.m_dstY - shiftY);
        }
    }

    class ElidedInfo
    extends LineInfo {
        ElidedInfo() {
        }

        public void getBounds(int srcX, int srcY, int dstX, int dstY, Rectangle r) {
            RelationComponent.getLineBounds(srcX, srcY, dstX, dstY, r);
            RelationComponent.includeArrowBounds(srcX, srcY, dstX, dstY, r);
        }

        public void paintComponent(Graphics g, int srcX, int srcY, int dstX, int dstY) {
            Util.drawSegment(g, this.m_style, srcX, srcY, dstX, dstY);
            Util.drawArrowHead(g, srcX, srcY, dstX, dstY);
        }
    }

    class LineInfo
    extends DrawInfo {
        int m_style;

        LineInfo() {
        }

        public void setStyle(int style) {
            this.m_style = style;
        }
    }

    class ArcInfo
    extends DrawInfo {
        int m_x;
        int m_y;

        public void setArc(int x, int y) {
            this.m_x = x;
            this.m_y = y;
        }

        public void getBounds(Rectangle r) {
            r.setBounds(this.m_x, this.m_y, 16, 16);
        }

        public boolean contains(int x, int y) {
            int r;
            int x1 = x - this.m_x - 8;
            int y1 = y - this.m_y - 8;
            return (x1 >= 0 || y1 <= 0) && (r = x1 * x1 + y1 * y1) >= 49 && r <= 81;
        }

        public void paintComponent(Graphics g, int shiftX, int shiftY) {
            g.drawArc(0, 0, 16, 16, 270, 270);
            g.fillPolygon(m_arc_xp, m_arc_yp, 3);
        }
    }

    class DrawInfo {
        DrawInfo() {
        }

        public void getBounds(Rectangle r) {
            r.setBounds(0, 0, 0, 0);
        }

        public boolean contains(int x, int y) {
            return false;
        }

        public void paintComponent(Graphics g, int shiftX, int shiftY) {
        }

        public boolean overEdgePoint(int x, int y) {
            return false;
        }

        public EdgePoint mouseOverEdgePoint(int x, int y) {
            return null;
        }
    }
}

