/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComponent;
import lsedit.Attribute;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.RelationComponent;
import lsedit.Util;

public class RelationInstance
extends LandscapeObject {
    public static final int CLIENT_SUPPLIER_EL_LEN = 16;
    protected static final int NEAR_PIXEL_SIZE = 6;
    protected static final String STYLE_ID = "style";
    protected static final int LOOP_MARK = 1;
    protected static final int NORMAL_MARK = 2;
    protected static final int ELISION_MARK = 4;
    protected static final int OUT_ELIDED_MARK = 16;
    protected static final int IN_ELIDED_MARK = 32;
    protected static final int IN_DIAGRAM_MARK = 64;
    protected static final int VALID_MARK = 256;
    public static final int GROUP_FLAG_MARK = 512;
    public static final int HIGHLIGHT_FLAG_MARK = 1024;
    public static final int ADD_RESULTS_MARK = 2048;
    public static final int IN_OUT_ELIDED = 48;
    public static final int PRESENTATION_MARKS = 1536;
    protected EntityInstance m_src;
    protected EntityInstance m_dst;
    protected EntityInstance m_drawSrc;
    protected EntityInstance m_drawDst;
    protected int m_mark = 0;

    public RelationComponent neededComponent() {
        RelationComponent relationComponent = (RelationComponent)this.getSwingObject();
        if (relationComponent == null) {
            relationComponent = new RelationComponent(this);
        }
        return relationComponent;
    }

    public void repaint() {
        JComponent relationComponent = this.getSwingObject();
        if (relationComponent != null) {
            relationComponent.repaint();
        }
    }

    public void validate() {
        JComponent relationComponent = this.getSwingObject();
        if (relationComponent != null) {
            relationComponent.validate();
        }
    }

    public EdgePoint mouseOverEdgePoint(int x, int y) {
        JComponent relationComponent = this.getSwingObject();
        if (relationComponent != null) {
            return ((RelationComponent)relationComponent).mouseOverEdgePoint(x, y);
        }
        return null;
    }

    protected boolean processFirstOrderAttributes(Attribute attr, Hashtable entities) {
        boolean hasVal;
        boolean bl = hasVal = attr.avi != null;
        if (attr.id.equals("color")) {
            if (hasVal) {
                this.setObjectColor(attr.parseColour());
            }
            return true;
        }
        if (attr.id.equals(STYLE_ID)) {
            if (hasVal) {
                this.setStyle(attr.parseInt());
            }
            return true;
        }
        return false;
    }

    public RelationInstance(RelationClass parentClass, EntityInstance src, EntityInstance dst) {
        this.setParentClass(parentClass);
        this.m_src = src;
        this.m_dst = dst;
        this.m_drawSrc = src;
        this.m_drawDst = dst;
    }

    public String getStyleName(int style) {
        return Util.getLineStyleName(style);
    }

    public void clearMark(int preserve_relation_marks) {
        RelationComponent relationComponent = (RelationComponent)this.getSwingObject();
        this.m_mark &= preserve_relation_marks;
        this.m_drawSrc = null;
        this.m_drawDst = null;
        this.setSwingObject(null);
    }

    public void orMark(int value) {
        this.m_mark |= value;
    }

    public void nandMark(int value) {
        this.m_mark &= ~value;
    }

    public boolean isMarked(int value) {
        return (this.m_mark & value) != 0;
    }

    public boolean isSrcVisible() {
        return this.m_src == this.m_drawSrc;
    }

    public boolean isDstVisible() {
        return this.m_dst == this.m_drawDst;
    }

    public void invalidateEdge() {
        this.nandMark(256);
    }

    public void setHighlightFlag() {
        if (!this.isMarked(1024)) {
            this.orMark(1024);
            this.repaint();
        }
    }

    public boolean getHighlightFlag() {
        return this.isMarked(1024);
    }

    public void clearHighlightFlag() {
        if (this.isMarked(1024)) {
            this.nandMark(1024);
            this.validate();
        }
    }

    public void setGroupAndHighlightFlag() {
        if ((this.m_mark & 0x600) != 1536) {
            this.orMark(1536);
            this.validate();
        }
    }

    public void drawHighlighted() {
        if (this.getHighlightFlag() && this.getRelationClass().isActive()) {
            this.draw(false);
        }
    }

    public void clearGroupFlag() {
        if (this.isMarked(512)) {
            this.nandMark(512);
            this.validate();
        }
    }

    public boolean getGroupFlag() {
        return this.isMarked(512);
    }

    public void draw(boolean allowElision) {
        JComponent relationComponent;
        if (this.isMarked(256)) {
            return;
        }
        RelationClass parentClass = this.getRelationClass();
        Diagram diagram = this.getDiagram();
        int marks = 0;
        if (!allowElision || parentClass.isClassVisible()) {
            if (this.m_src == null || this.m_dst == null) {
                MsgOut.println("Landscape error: null src or dst");
                return;
            }
            if (this.m_src.getContainedBy() == null) {
                MsgOut.println("drawEdge: src containedBy error " + this.m_src);
                return;
            }
            if (this.m_dst.getContainedBy() == null) {
                MsgOut.println("drawEdge: dst containedBy error " + this.m_dst);
                return;
            }
            EntityInstance src = this.m_drawSrc;
            EntityInstance dst = this.m_drawDst;
            if (src == null) {
                System.out.println("draw() " + this + " has no draw src");
                return;
            }
            if (dst == null) {
                System.out.println("draw() " + this + " has no draw dst");
                return;
            }
            EntityInstance drawRoot = diagram.getDrawRoot();
            if ((drawRoot.hasDescendantOrSelf(src) || drawRoot.hasDescendantOrSelf(dst)) && (src != dst || src == this.m_src || dst == this.m_dst)) {
                marks = 2;
                if (allowElision) {
                    EntityInstance srcParent;
                    String id = parentClass.getId();
                    EntityInstance dstParent = dst.getContainedBy();
                    if (srcParent != null && srcParent == dstParent && srcParent.isInternalRelationElided(id)) {
                        marks = 0;
                    } else {
                        if (src.isSrcRelationElided(id)) {
                            marks |= 0x10;
                        } else {
                            for (srcParent = src.getContainedBy(); srcParent != null && !srcParent.hasDescendantOrSelf(dst); srcParent = srcParent.getContainedBy()) {
                                if (!srcParent.isExitingRelationElided(id)) continue;
                                marks |= 0x10;
                                break;
                            }
                        }
                        if (dst.isDstRelationElided(id)) {
                            marks |= 0x20;
                        } else {
                            while (dstParent != null && !dstParent.hasDescendantOrSelf(src)) {
                                if (dstParent.isEnteringRelationElided(id)) {
                                    marks |= 0x20;
                                    break;
                                }
                                dstParent = dstParent.getContainedBy();
                            }
                        }
                    }
                }
                if (marks == 2 && src == dst) {
                    marks = 1;
                }
            }
        }
        if (marks == 0) {
            if (this.isMarked(64)) {
                relationComponent = this.getSwingObject();
                if (relationComponent != null) {
                    diagram.remove(relationComponent);
                    this.setSwingObject(null);
                }
                this.nandMark(64);
            }
        } else {
            marks |= 0x100;
            if (allowElision) {
                marks |= 4;
            }
            relationComponent = this.neededComponent();
            if (!this.isMarked(64)) {
                this.orMark(marks |= 0x40);
                diagram.add(relationComponent);
                relationComponent.setVisible(true);
            } else {
                this.orMark(marks);
            }
            relationComponent.validate();
        }
    }

    public void addAttribute(Attribute attr) {
        this.processFirstOrderAttributes(attr, null);
    }

    public void assignAttributes(Attribute attr, Hashtable entities) {
        while (attr != null) {
            if (attr.avi == null) {
                MsgOut.println("Null attribute assignment");
            } else if (!this.processFirstOrderAttributes(attr, entities)) {
                Attribute attrVar = this.getLsAttribute(attr.id);
                if (attrVar == null) {
                    MsgOut.println("Missing attribute '" + attr.toString() + "'");
                } else {
                    if (attrVar.cloneOnAssign) {
                        Attribute newAttr = (Attribute)attrVar.clone();
                        this.replaceAttribute(newAttr);
                    }
                    attrVar.avi = attr.avi;
                }
            }
            attr = attr.next;
        }
    }

    public void writeRelation(PrintStream ps) throws IOException {
        ps.print(this.qt(this.getParentClass().getId()) + " " + this.qt(this.m_src.getId()) + " " + this.qt(this.m_dst.getId()) + "\n");
    }

    public void writeAttributes(PrintStream ps) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream ps1 = new PrintStream(byteStream);
        RelationClass parentClass = this.getRelationClass();
        super.writeAttributes(ps1, parentClass, false);
        String s = byteStream.toString();
        if (s.length() != 0) {
            ps.print("(" + this.qt(parentClass.getId()) + " " + this.qt(this.m_src.getId()) + " " + this.qt(this.m_dst.getId()) + ") {\n" + s + "}\n");
        }
    }

    public EntityInstance getSrc() {
        return this.m_src;
    }

    public EntityInstance getDst() {
        return this.m_dst;
    }

    public EntityInstance getDrawSrc() {
        return this.m_drawSrc;
    }

    public EntityInstance getCurrentSrc() {
        if (this.m_drawSrc != null) {
            return this.m_drawSrc;
        }
        return this.m_src;
    }

    public EntityInstance getDrawDst() {
        return this.m_drawDst;
    }

    public EntityInstance getCurrentDst() {
        if (this.m_drawDst != null) {
            return this.m_drawDst;
        }
        return this.m_dst;
    }

    public RelationClass getRelationClass() {
        return (RelationClass)this.getParentClass();
    }

    public boolean matches(RelationInstance other) {
        return this.m_drawSrc == other.m_drawSrc && this.m_drawDst == other.m_drawDst;
    }

    public String toString() {
        return this.m_drawSrc + (this.m_drawSrc == this.m_src ? "" : "{" + this.m_src + "}") + "->" + this.m_drawDst + (this.m_drawDst == this.m_dst ? "" : "{" + this.m_dst + "}");
    }

    public int getPrimaryAttributeCount() {
        return 3;
    }

    public String getLsAttributeNameAt(int index) {
        String name;
        switch (index) {
            case 0: {
                name = "class";
                break;
            }
            case 1: {
                name = "color";
                break;
            }
            case 2: {
                name = STYLE_ID;
                break;
            }
            default: {
                name = super.getLsAttributeNameAt(index);
            }
        }
        return name;
    }

    public Object getLsAttributeValueAt(int index) {
        Object value;
        switch (index) {
            case 0: {
                LandscapeClassObject parentClass = this.getParentClass();
                if (parentClass == null) {
                    value = null;
                    break;
                }
                value = parentClass.getId();
                break;
            }
            case 1: {
                if (this.hasObjectColor()) {
                    value = this.getObjectColor();
                    break;
                }
                value = null;
                break;
            }
            case 2: {
                value = new Integer(this.getStyle());
                break;
            }
            default: {
                value = super.getLsAttributeValueAt(index);
            }
        }
        return value;
    }

    public void setAttributeValueAt(int index, Object value) {
        block0 : switch (index) {
            case 0: {
                if (value == null) break;
                LandscapeClassObject parentClass = this.getParentClass();
                String newId = (String)value;
                if (parentClass != null && parentClass.getId().equals(newId)) break;
                Enumeration en = this.getDiagram().enumRelationClasses();
                while (en.hasMoreElements()) {
                    RelationClass ec = (RelationClass)en.nextElement();
                    if (!ec.getId().equals(newId)) continue;
                    this.updateParentClass(ec);
                    break block0;
                }
                break;
            }
            case 1: {
                this.updateObjectColor((Color)value);
                break;
            }
            case 2: {
                this.updateStyle((Integer)value);
                break;
            }
            default: {
                super.setAttributeValueAt(index, value);
            }
        }
    }

    public int getLsAttributeTypeAt(int index) {
        int ret;
        switch (index) {
            case 0: {
                ret = 16;
                break;
            }
            case 1: {
                ret = 8;
                break;
            }
            case 2: {
                ret = 14;
                break;
            }
            default: {
                ret = super.getLsAttributeTypeAt(index);
            }
        }
        return ret;
    }

    public void mouseEntered() {
        this.getDiagram().getLs().setCursor(12);
    }

    public void mouseExited() {
        this.getDiagram().getLs().setCursor(0);
    }

    public void mousePressed(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationPressed(ev, this, diagramX, diagramY);
    }

    public void mouseReleased(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationReleased(ev, this, diagramX, diagramY);
    }

    public void mouseDragged(MouseEvent ev, int diagramX, int diagramY) {
        this.getDiagram().relationDragged(ev, this, diagramX, diagramY);
    }

    public void mouseMoved(MouseEvent ev, int diagramX, int diagramY) {
        Diagram diagram = this.getDiagram();
        if (this != m_infoShown) {
            m_infoShown = this;
            String message = this.m_src == this.m_drawSrc ? "" : Util.quoted(this.m_src.getLabel()) + "->";
            message = message + Util.quoted(this.m_drawSrc.getLabel()) + " " + this.getRelationClass().getLabel() + " " + Util.quoted(this.m_drawDst.getLabel());
            if (this.m_dst != this.m_drawDst) {
                message = message + "->" + Util.quoted(this.m_src.getLabel());
            }
            diagram.getLs().showInfo(message);
        }
        diagram.movedOverThing(ev, this, diagramX, diagramY);
    }
}

