/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeModeHandler;

public class ResizeModeHandler
extends LandscapeModeHandler {
    protected static final int RM_NONE = 0;
    protected static final int RM_LEFT = 1;
    protected static final int RM_RIGHT = 2;
    protected static final int RM_TOP = 4;
    protected static final int RM_BOTTOM = 8;
    protected static final int LR_MASK = 3;
    protected static final int TB_MASK = 12;
    protected static final int RZONE_SIZE = 5;
    protected static final double MIN_DIM = 10.0;
    protected DrawOutline m_drawOutline;
    protected Rectangle m_curLayout;
    protected Rectangle bb;
    private Rectangle m_plyt = null;
    protected int resizeMode = 0;
    protected int[] startMode = new int[]{5, 4, 6, 2, 10, 8, 9, 1};

    protected void setCurLayout(int x, int y, int width, int height) {
        if (this.m_curLayout == null) {
            this.m_curLayout = new Rectangle(x, y, width, height);
            this.m_drawOutline.setBounds(this.m_dg.getBounds());
            this.m_drawOutline.setVisible(true);
            this.m_dg.add((Component)this.m_drawOutline, 0);
        } else {
            this.m_curLayout.x = x;
            this.m_curLayout.y = y;
            this.m_curLayout.width = width;
            this.m_curLayout.height = height;
            this.m_drawOutline.repaint();
        }
    }

    protected void clearCurLayout() {
        if (this.m_curLayout != null) {
            this.m_dg.remove(this.m_drawOutline);
            this.m_curLayout = null;
        }
    }

    protected void addMode(int newMode) {
        int omode = 0;
        switch (newMode) {
            case 4: {
                omode = 8;
                break;
            }
            case 8: {
                omode = 4;
                break;
            }
            case 1: {
                omode = 2;
                break;
            }
            case 2: {
                omode = 1;
            }
        }
        if ((this.resizeMode & omode) == 0) {
            this.resizeMode |= newMode;
        }
    }

    private String resizeDescription() {
        String ret;
        if (this.resizeMode == 0) {
            ret = "NONE";
        } else {
            ret = "";
            if ((this.resizeMode & 1) != 0) {
                ret = ret + "LEFT ";
            }
            if ((this.resizeMode & 2) != 0) {
                ret = ret + "RIGHT ";
            }
            if ((this.resizeMode & 4) != 0) {
                ret = ret + "TOP ";
            }
            if ((this.resizeMode & 8) != 0) {
                ret = ret + "BOTTOM";
            }
        }
        return ret;
    }

    protected void doResizeAdjust(int mode, int xpos, int ypos) {
        int gap = 20;
        int x1 = this.m_curLayout.x;
        int y1 = this.m_curLayout.y;
        int width1 = this.m_curLayout.width;
        int height1 = this.m_curLayout.height;
        if (xpos - x1 < 4) {
            this.addMode(1);
        }
        if (x1 + width1 - xpos < 4) {
            this.addMode(2);
        }
        if (ypos - y1 < 4) {
            this.addMode(4);
        }
        if (y1 + height1 - ypos < 4) {
            this.addMode(8);
        }
        if ((mode & 4) != 0) {
            if (ypos >= this.m_plyt.y + gap) {
                height1 += y1 - ypos;
                y1 = ypos;
            }
        } else if ((mode & 8) != 0 && ypos <= this.m_plyt.y + this.m_plyt.height - gap) {
            height1 = ypos - y1;
        }
        if ((mode & 1) != 0) {
            if (xpos >= this.m_plyt.x + gap) {
                width1 += x1 - xpos;
                x1 = xpos;
            }
        } else if ((mode & 2) != 0 && xpos <= this.m_plyt.x + this.m_plyt.width - gap) {
            width1 = xpos - x1;
        }
        if ((double)width1 < 10.0) {
            x1 = this.m_curLayout.x;
            width1 = this.m_curLayout.width;
        }
        if ((double)height1 < 10.0) {
            y1 = this.m_curLayout.y;
            height1 = this.m_curLayout.height;
        }
        this.setCurLayout(x1, y1, width1, height1);
    }

    public ResizeModeHandler() {
        this.m_drawOutline = new DrawOutline(this);
    }

    public void select(Diagram dg) {
        if (this.m_dg != dg) {
            this.clearCurLayout();
            super.select(dg);
        }
    }

    public Rectangle getCurLayout() {
        return this.m_curLayout;
    }

    public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        EntityInstance parent;
        if (this.m_dg == null) {
            return false;
        }
        if (e == null || !e.getGroupKeyFlag()) {
            return false;
        }
        int rpoint = e.overResizeTab(x, y);
        if (rpoint < 0) {
            return false;
        }
        this.resizeMode = this.startMode[rpoint];
        this.setCurLayout(e.getDiagramX(), e.getDiagramY(), e.getWidth(), e.getHeight());
        if (this.m_plyt == null) {
            this.m_plyt = new Rectangle();
        }
        if ((parent = e.getContainedBy()) != null && parent.getContainedBy() != null) {
            Rectangle plyt = parent.getDiagramBounds();
            this.m_plyt.x = plyt.x;
            this.m_plyt.y = plyt.y;
            this.m_plyt.width = plyt.width;
            this.m_plyt.height = plyt.height;
        } else {
            this.m_plyt = this.m_dg.getBounds();
            this.m_plyt.x = 0;
            this.m_plyt.y = 0;
        }
        this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
        return true;
    }

    public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        double xpos = x;
        double ypos = y;
        if (this.resizeMode == 0) {
            boolean b;
            boolean l = xpos <= (double)this.m_curLayout.x;
            boolean r = xpos >= (double)(this.m_curLayout.x + this.m_curLayout.width);
            boolean t = ypos <= (double)this.m_curLayout.y;
            boolean bl = b = ypos >= (double)(this.m_curLayout.y + this.m_curLayout.height);
            if (e == this.m_dg.getDrawRoot()) {
                l = false;
                t = false;
            }
            if (l) {
                this.resizeMode = t || ypos - (double)this.m_curLayout.y < 4.0 ? 5 : (b || (double)(this.m_curLayout.y + this.m_curLayout.height) - ypos < 4.0 ? 9 : 1);
            } else if (r) {
                this.resizeMode = t || ypos - (double)this.m_curLayout.y < 4.0 ? 6 : (b || (double)(this.m_curLayout.y + this.m_curLayout.height) - ypos < 4.0 ? 10 : 2);
            } else if (t) {
                this.resizeMode = xpos - (double)this.m_curLayout.x < 4.0 ? 5 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - xpos < 4.0 ? 6 : 4);
            } else if (b) {
                this.resizeMode = xpos - (double)this.m_curLayout.x < 4.0 ? 9 : ((double)(this.m_curLayout.x + this.m_curLayout.width) - xpos < 4.0 ? 10 : 8);
            }
        }
        if (this.resizeMode != 0) {
            this.doResizeAdjust(this.resizeMode, x, y);
            this.m_ls.doFeedback("Size: " + this.m_curLayout.width + " x " + this.m_curLayout.height);
        }
        return true;
    }

    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (e != null) {
            e.setDiagramBounds(this.m_curLayout);
            this.m_dg.rescaleDiagram();
            e.validateEdges();
            e.fitTo(false);
        }
        this.m_ls.clearFeedback();
        this.clearCurLayout();
    }

    protected class DrawOutline
    extends JComponent {
        private ResizeModeHandler m_handler;

        public DrawOutline(ResizeModeHandler handler) {
            this.m_handler = handler;
            this.setForeground(Color.BLACK);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle curLayout = this.m_handler.getCurLayout();
            if (curLayout != null) {
                g.drawRect(curLayout.x, curLayout.y, curLayout.width, curLayout.height);
            }
        }
    }
}

