/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;

public class ResultBox
extends Box
implements Scrollable {
    protected static final Color m_titleColor = Color.red.darker();
    protected static final Font m_titleFont = new Font("Helvetica", 1, 14);
    protected static final Font m_textFont = new Font("Helvetica", 0, 11);
    protected static final String m_indent = "  ";
    protected static final int horizontal_margin = 10;
    protected static final int vertical_indent = 10;
    public static final String m_helpStr = "This box shows the results of queries, and groupings";
    protected LandscapeViewerCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;

    public ResultBox(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        super(1);
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(tabbedPane.getBounds());
        Dimension d = this.m_scrollPane.getSize();
        this.setLocation(0, 0);
        this.setSize(d);
        this.setPreferredSize(d);
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("Results", null, this.m_scrollPane, m_helpStr);
    }

    public void clear() {
        this.removeAll();
        this.validate();
        this.repaint();
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (this.isVisible()) {
            Component active = this.m_tabbedPane.getSelectedComponent();
            return active != null && this.m_scrollPane == active;
        }
        return false;
    }

    public void setResultTitle(String title) {
        this.clear();
        if (title != null) {
            ResultLabel label = new ResultLabel();
            label.setText(title);
            label.setHorizontalAlignment(2);
            label.setFont(m_titleFont);
            label.setForeground(m_titleColor);
            this.add(label);
            this.add(Box.createVerticalStrut(5));
        }
    }

    public void addResultEntity(EntityInstance e) {
        this.add(new ResultEntity(this.m_ls, "", e, false));
    }

    public void addRelation(RelationInstance r) {
        this.add(new ResultRelation(this.m_ls, "", r, false));
    }

    public void addForwardRelation(EntityInstance e, RelationClass rc, Vector list) {
        this.add(new ResultSet(this.m_ls, e, rc, list, true, false));
    }

    public void addBackRelation(EntityInstance e, RelationClass rc, Vector list) {
        this.add(new ResultSet(this.m_ls, e, rc, list, false, false));
    }

    protected void addRelations(EntityInstance e, RelationClass rc, Vector list, boolean src) {
        this.add(new ResultSet(this.m_ls, e, rc, list, src, true));
    }

    protected void addContents(EntityInstance e, Vector list) {
        this.add(new ResultContents(this.m_ls, e, list));
    }

    public void addText(String message) {
        if (message != null) {
            ResultLabel label = new ResultLabel();
            label.setText(message);
            label.setHorizontalAlignment(2);
            label.setForeground(Color.black);
            this.add(label);
        }
    }

    public void validate() {
        super.validate();
        this.setSize(this.getPreferredSize());
    }

    public String toString() {
        int cnt = this.getComponentCount();
        String string = "";
        for (int i = 0; i < cnt; ++i) {
            Component component = this.getComponent(i);
            string = string + component.toString() + "\n---\n";
        }
        return string;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    class ResultContents
    extends VerticalResult {
        public ResultContents(LandscapeViewerCore ls, EntityInstance entity, Vector entities) {
            this.add(new ResultSetHeader(ls, entity, entities));
            Enumeration en = entities.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                ResultEntity resultEntity = new ResultEntity(ls, ResultBox.m_indent, e, true);
                this.add(resultEntity);
            }
        }
    }

    class ResultSet
    extends VerticalResult {
        public ResultSet(LandscapeViewerCore ls, EntityInstance entity, RelationClass relationClass, Vector entities, boolean forward, boolean closure) {
            this.add(new ResultSetHeader(ls, entity, relationClass, forward, closure));
            Enumeration en = entities.elements();
            while (en.hasMoreElements()) {
                Object object = en.nextElement();
                if (object instanceof EntityInstance) {
                    EntityInstance e = (EntityInstance)object;
                    ResultEntity resultEntity = new ResultEntity(ls, ResultBox.m_indent, e, false);
                    this.add(resultEntity);
                    continue;
                }
                RelationInstance r = (RelationInstance)object;
                ResultRelation resultRelation = new ResultRelation(ls, ResultBox.m_indent, r, true);
                this.add(resultRelation);
            }
        }
    }

    class ResultSetHeader
    extends HorizontalResult {
        public ResultSetHeader(LandscapeViewerCore ls, EntityInstance entity, RelationClass relationClass, boolean forward, boolean closure) {
            String type = closure ? "*" : "?";
            ResultLabel rc = new ResultLabel();
            rc.setText(" " + relationClass.getLabel());
            rc.setHorizontalAlignment(0);
            ResultLabel label = new ResultLabel();
            if (forward) {
                ResultEntity resultEntity = new ResultEntity(ls, "", entity, false);
                label.setText(" " + type);
                label.setHorizontalAlignment(2);
                this.add(resultEntity);
                this.add(rc);
                this.add(label);
            } else {
                label = new ResultLabel();
                label.setText(type);
                label.setHorizontalAlignment(2);
                ResultEntity resultEntity = new ResultEntity(ls, " ", entity, false);
                this.add(label);
                this.add(rc);
                this.add(resultEntity);
            }
        }

        public ResultSetHeader(LandscapeViewerCore ls, EntityInstance entity, Vector list) {
            ResultEntity resultEntity = new ResultEntity(ls, "", entity, false);
            ResultLabel label = new ResultLabel();
            label.setText(" contains (" + list.size() + " items):");
            label.setHorizontalAlignment(2);
            this.add(resultEntity);
            this.add(label);
        }
    }

    class ResultRelation
    extends HorizontalResult {
        protected RelationInstance m_relation;

        public ResultRelation(LandscapeViewerCore ls, String indent, RelationInstance relation, boolean hideRc) {
            this.m_relation = relation;
            ResultEntity resultEntity = new ResultEntity(ls, indent, relation.getSrc(), false);
            this.add(resultEntity);
            if (!hideRc) {
                ResultLabel rc = new ResultLabel();
                rc.setText(" " + relation.getRelationClass().getLabel());
                rc.setHorizontalAlignment(0);
                this.add(rc);
            }
            resultEntity = new ResultEntity(ls, " ", relation.getDst(), false);
            this.add(resultEntity);
        }

        public boolean matches(RelationInstance relation) {
            return this.m_relation.matches(relation);
        }
    }

    class VerticalResult
    extends Box {
        public VerticalResult() {
            super(1);
        }

        public String toString() {
            int cnt = this.getComponentCount();
            String string = "";
            for (int i = 0; i < cnt; ++i) {
                Component component = this.getComponent(i);
                string = string + component.toString() + "\n";
            }
            return string;
        }
    }

    class HorizontalResult
    extends Box {
        public HorizontalResult() {
            super(0);
        }

        public String toString() {
            int cnt = this.getComponentCount();
            String string = "";
            for (int i = 0; i < cnt; ++i) {
                Component component = this.getComponent(i);
                string = string + component.toString();
            }
            return string;
        }
    }

    class ResultEntity
    extends ResultLabel
    implements MouseListener {
        protected LandscapeViewerCore m_ls;
        protected EntityInstance m_entity;

        public ResultEntity(LandscapeViewerCore ls, String indent, EntityInstance entity, boolean showClass) {
            this.m_ls = ls;
            this.m_entity = entity;
            String text = indent + entity.getLabel();
            if (showClass) {
                text = text + " {" + entity.getEntityClass().getLabel() + "}";
            }
            this.setText(text);
            this.setForeground(Color.blue);
            this.setToolTipText(entity.getDescription());
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.setForeground(Color.red);
            this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            this.setForeground(Color.blue);
            this.repaint();
        }

        public void mousePressed(MouseEvent ev) {
        }

        public void mouseReleased(MouseEvent ev) {
            this.setForeground(Color.blue);
            this.m_ls.followLink(this.m_entity, false);
        }
    }

    class ResultLabel
    extends JLabel {
        public ResultLabel() {
            this.setHorizontalAlignment(2);
            this.setHorizontalTextPosition(2);
            this.setFont(m_textFont);
        }

        public String toString() {
            return this.getText();
        }
    }
}

