/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.ClientSupplierCompareFn;
import lsedit.CompareFn;
import lsedit.EntityInstance;
import lsedit.HorizontalCompareFn;
import lsedit.IdCompareFn;
import lsedit.PostorderCompareFn;
import lsedit.StringCompareFn;
import lsedit.VerticalCompareFn;

public class SortVector {
    static final StringCompareFn m_stringCompareFn = new StringCompareFn();
    static final ClientSupplierCompareFn m_clientSupplierCompareFn = new ClientSupplierCompareFn();
    static final HorizontalCompareFn m_horizontalCompareFn = new HorizontalCompareFn();
    static final VerticalCompareFn m_verticalCompareFn = new VerticalCompareFn();
    static final PostorderCompareFn m_postorderCompareFn = new PostorderCompareFn();
    static final IdCompareFn m_idCompareFn = new IdCompareFn();

    private static final int partition(Vector v, int l, int r, CompareFn cf, boolean asc) {
        Object p = v.elementAt(l);
        --l;
        ++r;
        while (true) {
            boolean f;
            Object o = v.elementAt(--r);
            if (asc) {
                f = cf.compare(o, p) > 0;
            } else {
                boolean bl = f = cf.compare(o, p) < 0;
            }
            if (f) continue;
            do {
                o = v.elementAt(++l);
                if (asc) {
                    f = cf.compare(o, p) < 0;
                    continue;
                }
                boolean bl = f = cf.compare(o, p) > 0;
            } while (f);
            if (l >= r) break;
            if (cf.compare(v.elementAt(l), v.elementAt(r)) == 0) continue;
            o = v.elementAt(l);
            v.setElementAt(v.elementAt(r), l);
            v.setElementAt(o, r);
        }
        return r;
    }

    private static final void qsort(Vector v, int l, int r, CompareFn cf, boolean asc) {
        if (l < r) {
            int p = SortVector.partition(v, l, r, cf, asc);
            SortVector.qsort(v, l, p, cf, asc);
            SortVector.qsort(v, p + 1, r, cf, asc);
        }
    }

    private static final void sort(Vector v, int l, int r, CompareFn cf, boolean asc) {
        switch (r) {
            case 0: {
                return;
            }
            case 1: {
                if (cf.compare(v.elementAt(0), v.elementAt(1)) == 1) {
                    Object o = v.elementAt(0);
                    v.setElementAt(v.elementAt(1), 0);
                    v.setElementAt(o, 1);
                }
                return;
            }
        }
        SortVector.qsort(v, l, r, cf, asc);
    }

    public static void sortVector(Vector v, CompareFn cf, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, cf, ascending);
    }

    public static void byString(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_stringCompareFn, ascending);
    }

    public static void byString(Vector v) {
        SortVector.byString(v, true);
    }

    public static void byAvgX(Vector v, boolean ascending) {
        if (v != null) {
            Enumeration en = v.elements();
            while (en.hasMoreElements()) {
                EntityInstance e = (EntityInstance)en.nextElement();
                e.computeAvgX();
            }
            SortVector.sort(v, 0, v.size() - 1, m_clientSupplierCompareFn, ascending);
        }
    }

    public static void byAvgX(Vector v) {
        SortVector.byAvgX(v, true);
    }

    public static void byDiagramX(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_horizontalCompareFn, ascending);
    }

    public static void byDiagramX(Vector v) {
        SortVector.byDiagramX(v, true);
    }

    public static void byDiagramY(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_verticalCompareFn, ascending);
    }

    public static void byDiagramY(Vector v) {
        SortVector.byDiagramY(v, true);
    }

    public static void byPostorder(Vector v, boolean ascending) {
        SortVector.sort(v, 0, v.size() - 1, m_postorderCompareFn, ascending);
    }

    public static void byPostorder(Vector v) {
        SortVector.byPostorder(v, true);
    }

    public static void byId(Vector v) {
        SortVector.sort(v, 0, v.size() - 1, m_idCompareFn, true);
    }
}

