/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.Graph;
import lsedit.LandscapeLayouter;
import lsedit.LandscapeViewerCore;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ToolBarEventHandler;

public class SugiyamaLayout
extends LandscapeLayouter
implements ToolBarEventHandler {
    public SugiyamaLayout(LandscapeViewerCore ls) {
        super(ls);
    }

    public String getMenuLabel() {
        return "Coffman-Graham-Sugiyama method applied";
    }

    private int boxIndex(Vector selectedBoxes, String ID) {
        int index;
        for (index = 0; index < selectedBoxes.size() && !ID.equals(((EntityInstance)selectedBoxes.elementAt(index)).getId()); ++index) {
        }
        return index;
    }

    public String doLayout(Diagram dg) {
        boolean debug = true;
        Vector selectedBoxes = dg.getGroup();
        if (selectedBoxes == null) {
            this.beep();
            return "No group selected";
        }
        dg.beginUndoRedo("Sugiyama layout");
        int vertexID = 0;
        int groupSize = selectedBoxes.size();
        EntityInstance container = ((EntityInstance)selectedBoxes.firstElement()).getContainedBy();
        Rectangle containerLayout = container.getDiagramBounds();
        Graph graph = new Graph(groupSize, containerLayout.width, containerLayout.height, debug);
        Enumeration e = selectedBoxes.elements();
        while (e.hasMoreElements()) {
            graph.addVertex(((EntityInstance)e.nextElement()).getDiagramBounds().width);
        }
        e = selectedBoxes.elements();
        while (e.hasMoreElements()) {
            EntityInstance box = (EntityInstance)e.nextElement();
            Enumeration edge = box.srcRelListEnum();
            while (edge.hasMoreElements()) {
                EntityInstance child;
                int index;
                RelationInstance relation = (RelationInstance)edge.nextElement();
                RelationClass rc = (RelationClass)relation.getParentClass();
                if (rc != null && !rc.isClassVisible() || (index = this.boxIndex(selectedBoxes, (child = relation.getDst()).getId())) >= groupSize) continue;
                graph.addEdge(vertexID, index);
            }
            ++vertexID;
        }
        if (debug) {
            int index = 0;
            System.out.println("Graph read:");
            Enumeration e2 = selectedBoxes.elements();
            while (e2.hasMoreElements()) {
                System.out.println(index + " " + e2.nextElement());
                ++index;
            }
            graph.print();
        }
        Vector layers = graph.doCoffmanGrahamSugiyama();
        if (debug) {
            System.out.println("RESULTS");
            int level = 0;
            Enumeration e3 = layers.elements();
            while (e3.hasMoreElements()) {
                System.out.println("level " + level);
                Enumeration f = ((Vector)e3.nextElement()).elements();
                while (f.hasMoreElements()) {
                    System.out.print(f.nextElement() + " ");
                }
                System.out.println();
            }
        }
        int numLayers = layers.size();
        double layerHeight = (double)containerLayout.height / (double)numLayers;
        double curX = 20.0;
        double curY = containerLayout.height;
        Enumeration e4 = layers.elements();
        while (e4.hasMoreElements()) {
            Rectangle curLayout = null;
            Vector row = (Vector)e4.nextElement();
            double boxWidth = (double)containerLayout.width / (double)row.size();
            Enumeration f = row.elements();
            while (f.hasMoreElements()) {
                int curVertex = (Integer)f.nextElement();
                if (curVertex >= groupSize) continue;
                EntityInstance curBox = (EntityInstance)selectedBoxes.elementAt(curVertex);
                curLayout = curBox.getDiagramBounds();
                curLayout.x = (int)(curX + (boxWidth - (double)curBox.getWidth()) / 2.0);
                curLayout.y = (int)(curY - (layerHeight - (double)curBox.getHeight()) / 2.0);
                curX += boxWidth;
                curBox.setDiagramBounds(curLayout);
            }
            curY -= layerHeight;
            curX = 20.0;
        }
        dg.endUndoRedo();
        return "Graph redrawn with Coffman-Graham-Sugiyama method";
    }

    public void processKeyEvent(int key, int modifiers, Object object) {
        Diagram dg = this.m_ls.getDiagram();
        if (dg != null) {
            String rmsg = this.doLayout(dg);
            this.m_ls.doFeedback(rmsg);
            dg.rescaleDiagram();
            this.m_ls.repaintDg();
        }
    }
}

