/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JPanel;
import lsedit.Attribute;
import lsedit.AttributeRecord;
import lsedit.AttributeValueItem;
import lsedit.DataInputStream;
import lsedit.Diagram;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.InternalBufferStream;
import lsedit.LandscapeObject;
import lsedit.LandscapeTokenStream;
import lsedit.LandscapeViewerCore;
import lsedit.MsgOut;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.Tuple;
import lsedit.Util;

public class Ta
extends JPanel
implements Runnable {
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String EDGEMODE_ID = "edgemode";
    public static final String TOPCLIENTS_ID = "topclients";
    public static final String WANTCLIENTS_ID = "wantclients";
    public static final String WANTSUPPLIERS_ID = "wantsuppliers";
    public static final String WANTCARDINALS_ID = "wantcardinals";
    public static final String SCALE_ID = "scale";
    public static final String RELN_HIDDEN_ID = "reln_hidden";
    public static final String NAVLINK_ID = "navlink";
    private static final String RAW_HEADER = "#TA_RAW#";
    private static final int UPDATE_FREQ = 250;
    private static final int DEF_CAP = 2000;
    private static final float DEF_LOAD = 0.5f;
    private static final int DEF_REL_CAP = 10000;
    public static final String ROOT_ID = "$ROOT";
    private static final String BG_STR = "0.75";
    private static final String[] g_rootAttributes = new String[]{"scale", "reln_hidden", "edgemode", "navlink", "topclients", "wantclients", "wantsuppliers", "wantcardinals"};
    protected LandscapeViewerCore m_ls;
    private Diagram m_diagram;
    protected EntityInstance m_rootInstance;
    private Hashtable m_entityClasses = new Hashtable(10);
    protected Hashtable m_relationClasses = new Hashtable(5);
    protected Hashtable m_entityInstances = new Hashtable(2000, 0.5f);
    private Hashtable m_attrNames = new Hashtable(20);
    private Vector m_numToRel = new Vector(10);
    public RelationClass m_relationBaseClass;
    public EntityClass m_entityBaseClass;
    protected int m_numRelationClasses = 0;
    protected EntityClass defaultEntityClass = null;
    private int m_numEntityClasses = 0;
    private boolean universalScheme = false;
    private boolean readOnly = false;
    private Object context;
    boolean m_uses_local_coordinates;
    private boolean schemeSetup = false;
    protected String m_resString = null;
    protected int progressCount;
    protected boolean changedFlag = false;
    protected int m_numberEntities;
    protected int m_numberRelations;
    protected Vector bgpaths;

    protected Diagram getDiagram() {
        return null;
    }

    private void setReadOnly() {
        this.readOnly = true;
    }

    private void updateProgress() {
        ++this.progressCount;
        StringBuffer sb = new StringBuffer("Loading: ");
        for (int i = 0; i < this.progressCount; ++i) {
            sb.append('*');
        }
        this.m_ls.doFeedback(new String(sb));
    }

    private EntityClass addEntityClass(String id) {
        EntityClass ec = (EntityClass)this.m_entityClasses.get(id);
        if (ec == null) {
            ec = new EntityClass(id, this.m_numEntityClasses++, this.m_entityBaseClass, this.m_diagram);
            this.m_entityClasses.put(id, ec);
            if (this.defaultEntityClass == null) {
                this.defaultEntityClass = ec;
            }
        }
        return ec;
    }

    private RelationClass addRelationClass(String id) {
        RelationClass rc = (RelationClass)this.m_relationClasses.get(id);
        if (rc == null) {
            rc = new RelationClass(id, this.m_numRelationClasses, this.m_relationBaseClass, this.m_diagram);
            this.m_relationClasses.put(id, rc);
            this.m_numToRel.addElement(rc);
            ++this.m_numRelationClasses;
        }
        return rc;
    }

    private void registerAttrName(String id) {
        if (this.m_attrNames.get(id) == null) {
            this.m_attrNames.put(id, id);
        }
    }

    private void registerAttrNames(Attribute attr) {
        while (attr != null) {
            this.registerAttrName(attr.id);
            attr = attr.next;
        }
    }

    private EntityInstance addEntity(EntityClass ec, String eid) {
        EntityInstance e = ec.newEntity(eid);
        this.putEntity(e);
        this.m_rootInstance.addContainment(e);
        return e;
    }

    private void addEdge(EntityInstance src, EntityInstance dst, RelationClass rc) {
        RelationInstance ri = rc.newRelation(src, dst);
        src.addRelation(ri, dst);
    }

    private void setupUniversalScheme() {
        this.m_relationBaseClass.addRelation(this.m_entityBaseClass, this.m_entityBaseClass);
        this.universalScheme = true;
    }

    private void processSchemeTuples(LandscapeTokenStream ts) throws IOException {
        Tuple tuple;
        while ((tuple = ts.nextTuple()) != null) {
            RelationClass rc = null;
            boolean inheritance = tuple.token1.equals(INHERIT_RELN);
            if (inheritance) {
                if (tuple.token2.equals("$ENTITY")) {
                    ts.errorNS("Improper use of $ENTITY with $INHERIT");
                    return;
                }
            } else {
                rc = this.addRelationClass(tuple.token1);
            }
            EntityClass ec1 = this.addEntityClass(tuple.token2);
            EntityClass ec2 = this.addEntityClass(tuple.token3);
            if (inheritance) {
                String msg = ec1.addParentClass(ec2);
                if (msg == null) continue;
                ts.errorNS(msg);
                continue;
            }
            rc.addRelation(ec1, ec2);
        }
        return;
    }

    private void processSchemeAttributes(LandscapeTokenStream ts) throws IOException {
        AttributeRecord ar;
        while ((ar = ts.nextRecord()) != null) {
            if (ar.id.startsWith("(")) {
                StringTokenizer st = new StringTokenizer(ar.id, "() ");
                String rel = st.nextToken();
                RelationClass rc = (RelationClass)this.m_relationClasses.get(rel);
                if (rc != null) {
                    Attribute attr = ar.attributes;
                    while (attr != null) {
                        rc.addAttribute(attr);
                        attr = attr.next;
                    }
                    this.registerAttrNames(ar.attributes);
                    continue;
                }
                ts.errorNS("Can't process record. Missing relation class '" + rel + "'");
                continue;
            }
            if (ar.id.equals(ROOT_ID)) {
                Attribute attr = ar.attributes;
                while (attr != null) {
                    this.m_rootInstance.addAttribute(attr);
                    attr = attr.next;
                }
                this.registerAttrNames(ar.attributes);
                continue;
            }
            EntityClass ec = (EntityClass)this.m_entityClasses.get(ar.id);
            if (ec != null) {
                Attribute attr = ar.attributes;
                while (attr != null) {
                    ec.addAttribute(attr);
                    attr = attr.next;
                }
                this.registerAttrNames(ar.attributes);
                continue;
            }
            ts.errorNS("Can't process record. Missing entity class '" + ar.id + "'");
        }
        return;
    }

    private void processFactTuples(LandscapeTokenStream ts) throws IOException {
        Tuple tuple;
        int ne = 0;
        int nr = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        while ((tuple = ts.nextTuple()) != null) {
            if (tuple.token1.equals(INSTANCE_ID)) {
                EntityClass ec;
                EntityInstance e;
                if (++ne % 250 == 0) {
                    MsgOut.vprint(".");
                    this.updateProgress();
                    this.m_ls.showInfo("Entities: " + ne);
                }
                if ((e = this.getEntity(tuple.token2)) == null) {
                    ec = (EntityClass)this.m_entityClasses.get(tuple.token3);
                    if (ec != null) {
                        e = ec.newEntity(tuple.token2);
                        this.putEntity(e);
                        this.m_rootInstance.addContainment(e);
                        continue;
                    }
                    ts.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
                    continue;
                }
                ec = e.getEntityClass();
                if (ec.hasId(tuple.token3)) {
                    ts.warning("Redeclaration of " + e.toString());
                    continue;
                }
                ts.errorNS("Attempt to declare " + e.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + ec.getId());
                continue;
            }
            if (++nr % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.m_ls.showInfo("Relations: " + nr);
            }
            RelationClass rc = (RelationClass)this.m_relationClasses.get(tuple.token1);
            EntityInstance e1 = this.getEntity(tuple.token2);
            EntityInstance e2 = this.getEntity(tuple.token3);
            if (this.universalScheme) {
                if (rc == null) {
                    rc = this.m_relationBaseClass;
                }
                if (e1 == null) {
                    e1 = this.m_entityBaseClass.newEntity(tuple.token2);
                    this.putEntity(e1);
                    this.m_rootInstance.addContainment(e1);
                }
                if (e2 == null) {
                    e2 = this.m_entityBaseClass.newEntity(tuple.token3);
                    this.putEntity(e2);
                    this.m_rootInstance.addContainment(e2);
                }
            }
            if (rc == null) {
                ts.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
                continue;
            }
            if (e1 == null) {
                ts.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
                continue;
            }
            if (e2 == null) {
                ts.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
                continue;
            }
            EntityClass ec1 = e1.getEntityClass();
            EntityClass ec2 = e2.getEntityClass();
            if (tuple.token1.equals(CONTAIN_ID)) {
                if (e2.isMarked(0x100000)) {
                    System.out.println("Entity " + e2 + " has multiple parents");
                    continue;
                }
                if (this.m_rootInstance.removeContainment(e2)) {
                    e2.orMark(0x100000);
                    e1.addContainment(e2);
                    continue;
                }
                System.out.println("Entity " + e2 + " not in unassigned collection waiting containment");
                continue;
            }
            this.addEdge(e1, e2, rc);
        }
        this.m_numberEntities = ne;
        this.m_numberRelations = nr;
    }

    private void processFactAttributes(LandscapeTokenStream ts) throws IOException {
        AttributeRecord ar;
        int n = 0;
        MsgOut.vprint("\nFACT ATTRIBUTE : ");
        while ((ar = ts.nextRecord()) != null) {
            if (++n % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.m_ls.showInfo("Attr Records: " + n);
            }
            MsgOut.vprintln("Processing record: " + ar.id);
            if (ar.id.startsWith("(")) {
                Tuple tuple = new Tuple(ar.id);
                RelationClass rc = (RelationClass)this.m_relationClasses.get(tuple.token1);
                EntityInstance src = this.getEntity(tuple.token2);
                EntityInstance dst = this.getEntity(tuple.token3);
                if (rc == null) {
                    ts.errorNS("Can't process record for " + ar.id + ". " + "Missing relation '" + tuple.token1 + "'");
                    continue;
                }
                if (src == null) {
                    ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token2 + "'");
                    continue;
                }
                if (dst == null) {
                    ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token3 + "'");
                    continue;
                }
                RelationInstance ri = src.getRelation(rc, dst);
                if (ri == null) {
                    ts.errorNS("Can't process record. Missing relation " + ar.id);
                    continue;
                }
                ri.assignAttributes(ar.attributes, this.m_entityInstances);
                this.registerAttrNames(ar.attributes);
                continue;
            }
            EntityInstance e = ar.id.equals(ROOT_ID) ? this.m_rootInstance : this.getEntity(ar.id);
            if (e != null) {
                e.assignAttributes(ar.attributes);
                this.registerAttrNames(ar.attributes);
                continue;
            }
            if (this.universalScheme) {
                e = this.m_entityBaseClass.newEntity(ar.id);
                this.putEntity(e);
                this.m_rootInstance.addContainment(e);
                e.assignAttributes(ar.attributes);
                this.registerAttrNames(ar.attributes);
                continue;
            }
            ts.errorNS("Can't process record. Missing entity '" + ar.id + "'");
        }
    }

    private void writeRawPairs(DataOutputStream dos, Vector v) throws IOException {
        dos.writeInt(v.size());
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            Integer[] pair = (Integer[])en.nextElement();
            dos.writeInt(pair[0]);
            dos.writeInt(pair[1]);
        }
    }

    private void writeRawTriples(DataOutputStream dos, Vector v) throws IOException {
        dos.writeInt(v.size());
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            Integer[] triple = (Integer[])en.nextElement();
            dos.writeInt(triple[0]);
            dos.writeInt(triple[1]);
            dos.writeInt(triple[2]);
        }
    }

    private void writeRawAttributes(DataOutputStream dos, Vector v) throws IOException {
        dos.writeInt(v.size());
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            Object[] obj = (Object[])en.nextElement();
            dos.writeInt((Integer)obj[0]);
            Vector lv = (Vector)obj[1];
            dos.writeInt(lv.size());
            Enumeration en1 = lv.elements();
            block10: while (en1.hasMoreElements()) {
                Object[] attr = (Object[])en1.nextElement();
                dos.writeInt((Integer)attr[0]);
                int type = (Integer)attr[1];
                dos.writeInt(type);
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        dos.writeInt((Integer)attr[2]);
                        break;
                    }
                    case 2: {
                        dos.writeDouble((Double)attr[2]);
                        break;
                    }
                    case 3: {
                        dos.writeUTF((String)attr[2]);
                        break;
                    }
                    case 4: {
                        int i;
                        int[] il = (int[])attr[2];
                        int num = il.length;
                        dos.writeInt(num);
                        for (i = 0; i < num; ++i) {
                            dos.writeInt(il[i]);
                        }
                        continue block10;
                    }
                    case 5: {
                        int i;
                        double[] dl = (double[])attr[2];
                        int num = dl.length;
                        dos.writeInt(num);
                        for (i = 0; i < num; ++i) {
                            dos.writeDouble(dl[i]);
                        }
                        continue block10;
                    }
                    case 6: {
                        int i;
                        String[] sl = (String[])attr[2];
                        int num = sl.length;
                        dos.writeInt(num);
                        for (i = 0; i < num; ++i) {
                            dos.writeUTF(sl[i]);
                        }
                        break;
                    }
                }
            }
        }
    }

    private void writeSchemeTuples(PrintStream ps) throws IOException {
        ps.print("// Landscape TA file\n\n");
        ps.print("SCHEME TUPLE :\n\n// The ERD\n\n");
        Enumeration en0 = this.enumEntityClassesInOrder();
        while (en0.hasMoreElements()) {
            EntityClass ec = (EntityClass)en0.nextElement();
            if (ec == this.m_entityBaseClass) continue;
            Enumeration en = ec.getParentElements();
            while (en.hasMoreElements()) {
                EntityClass parent = (EntityClass)en.nextElement();
                if (parent == this.m_entityBaseClass) continue;
                ps.print("$INHERIT " + ec.getId() + " " + parent.getId() + "\n");
            }
        }
        ps.print("\n");
        en0 = this.enumRelationClassesInOrder();
        while (en0.hasMoreElements()) {
            RelationClass rc = (RelationClass)en0.nextElement();
            rc.writeRelations(ps);
        }
    }

    private void writeSchemeTuplesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException {
        dos.writeUTF("#1#");
        Vector<Integer[]> v = new Vector<Integer[]>();
        Enumeration en = this.enumEntityClassesInOrder();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            if (ec == this.m_entityBaseClass) continue;
            Enumeration en1 = ec.getParentElements();
            while (en1.hasMoreElements()) {
                EntityClass parent = (EntityClass)en1.nextElement();
                if (parent == this.m_entityBaseClass) continue;
                Integer[] pair = new Integer[]{(Integer)stringTable.get(ec.getId()), (Integer)stringTable.get(parent.getId())};
                v.addElement(pair);
            }
        }
        this.writeRawPairs(dos, v);
        v = new Vector();
        en = this.enumRelationClassesInOrder();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            rc.getRelationsRaw(v, stringTable);
        }
        this.writeRawTriples(dos, v);
    }

    private void processRawSchemeTuples(DataInputStream dis, Vector st) throws IOException {
        int i;
        int num = dis.readInt();
        for (i = 0; i < num; ++i) {
            String child = (String)st.elementAt(dis.readInt());
            String parent = (String)st.elementAt(dis.readInt());
            EntityClass ec1 = this.addEntityClass(child);
            EntityClass ec2 = this.addEntityClass(parent);
            ec1.addParentClass(ec2);
        }
        num = dis.readInt();
        for (i = 0; i < num; ++i) {
            String rcid = (String)st.elementAt(dis.readInt());
            String ecid1 = (String)st.elementAt(dis.readInt());
            String ecid2 = (String)st.elementAt(dis.readInt());
            RelationClass rc = this.addRelationClass(rcid);
            EntityClass ec1 = this.addEntityClass(ecid1);
            EntityClass ec2 = this.addEntityClass(ecid2);
            rc.addRelation(ec1, ec2);
        }
    }

    private void writeSchemeAttributes(PrintStream ps) throws IOException {
        ps.print("\n\nSCHEME ATTRIBUTE :\n\n");
        ps.print("// EntityClass attributes\n\n");
        Enumeration en = this.m_entityClasses.elements();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.writeAttributes(ps);
        }
        en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            rc.writeAttributes(ps);
        }
    }

    private void writeSchemeAttributesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException {
        dos.writeUTF("#2#");
        Vector v = new Vector();
        Enumeration en = this.m_entityClasses.elements();
        while (en.hasMoreElements()) {
            EntityClass ec = (EntityClass)en.nextElement();
            ec.getLsAttributesRaw(v, stringTable);
        }
        this.writeRawAttributes(dos, v);
        v = new Vector();
        en = this.m_relationClasses.elements();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            rc.getLsAttributesRaw(v, stringTable);
        }
        this.writeRawAttributes(dos, v);
    }

    private void processRawSchemeAttributes(DataInputStream dis, Vector st) throws IOException {
        int i;
        int num = dis.readInt();
        for (i = 0; i < num; ++i) {
            String ecid = (String)st.elementAt(dis.readInt());
            EntityClass ec = (EntityClass)this.m_entityClasses.get(ecid);
            this.processRawAttributes(ec, dis, st);
        }
        num = dis.readInt();
        for (i = 0; i < num; ++i) {
            String rcid = (String)st.elementAt(dis.readInt());
            RelationClass rc = (RelationClass)this.m_relationClasses.get(rcid);
            this.processRawAttributes(rc, dis, st);
        }
    }

    private void writeFactAttributes(PrintStream ps) throws IOException {
        ps.print("\n\nFACT ATTRIBUTE :\n\n");
        this.m_rootInstance.writeAttributes(ps);
    }

    private void writeFactTuples(PrintStream ps) throws IOException {
        ps.print("\n\nFACT TUPLE :\n\n");
        ps.print("// Instances of entity classes\n\n");
        this.m_rootInstance.writeInstances(ps);
        this.m_rootInstance.writeRelations(ps);
    }

    private void writeFactTuplesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException {
        dos.writeUTF("#3#");
        Vector v = new Vector();
        Enumeration en = this.m_rootInstance.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            child.getInstancesRaw(v, stringTable);
        }
        this.writeRawPairs(dos, v);
        v = new Vector();
        this.m_rootInstance.getRelationsRaw(v, stringTable, (Integer)stringTable.get(CONTAIN_ID));
        this.writeRawTriples(dos, v);
    }

    private void writeFactAttributesRaw(DataOutputStream dos, Hashtable stringTable) throws IOException {
        dos.writeUTF("#4#");
        Vector v = new Vector();
        this.m_rootInstance.getLsAttributesRaw(v, stringTable);
        this.writeRawAttributes(dos, v);
    }

    private Vector readStringTable(DataInputStream dis) throws IOException {
        Vector<String> st = new Vector<String>();
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            st.addElement(dis.readUTF());
        }
        return st;
    }

    private void processRawAttributes(LandscapeObject lo, DataInputStream dis, Vector st) throws IOException {
        int na = dis.readInt();
        for (int i = 0; i < na; ++i) {
            boolean rc;
            String aid = (String)st.elementAt(dis.readInt());
            int type = dis.readInt();
            this.registerAttrName(aid);
            switch (type) {
                case 0: {
                    rc = lo.addRawAttribute(aid);
                    break;
                }
                case 1: {
                    rc = lo.addRawAttribute(aid, dis.readInt());
                    break;
                }
                case 2: {
                    rc = lo.addRawAttribute(aid, dis.readDouble());
                    break;
                }
                case 3: {
                    rc = lo.addRawAttribute(aid, dis.readUTF());
                    break;
                }
                case 4: {
                    int j;
                    int num = dis.readInt();
                    int[] il = new int[num];
                    for (j = 0; j < num; ++j) {
                        il[j] = dis.readInt();
                    }
                    rc = lo.addRawAttribute(aid, il);
                    break;
                }
                case 5: {
                    int j;
                    int num = dis.readInt();
                    double[] dl = new double[num];
                    for (j = 0; j < num; ++j) {
                        dl[j] = dis.readDouble();
                    }
                    rc = lo.addRawAttribute(aid, dl);
                    break;
                }
                case 6: {
                    int j;
                    int num = dis.readInt();
                    String[] sl = new String[num];
                    for (j = 0; j < num; ++j) {
                        sl[j] = dis.readUTF();
                    }
                    rc = lo.addRawAttribute(aid, sl);
                    break;
                }
                default: {
                    rc = false;
                    MsgOut.println("Unknown attribute type: " + type);
                }
            }
            if (rc) continue;
            MsgOut.println("Unhandled attribute: " + aid + " - type: " + type);
        }
    }

    private void processRawFactTuples(DataInputStream dis, Vector st) throws IOException {
        int num = dis.readInt();
        EntityClass ec = null;
        int lind = -1;
        for (int i = 0; i < num; ++i) {
            String eid = (String)st.elementAt(dis.readInt());
            int ind = dis.readInt();
            if (ind != lind) {
                String ecid = (String)st.elementAt(ind);
                ec = (EntityClass)this.m_entityClasses.get(ecid);
                lind = ind;
            }
            this.addEntity(ec, eid);
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.m_ls.showInfo("Entities: " + i);
        }
        num = dis.readInt();
        RelationClass crc = (RelationClass)this.m_relationClasses.get(CONTAIN_ID);
        RelationClass rc = null;
        int lrcind = -1;
        EntityInstance e1 = null;
        int leind = -1;
        for (int i = 0; i < num; ++i) {
            int rcind = dis.readInt();
            int eind = dis.readInt();
            if (rcind != lrcind) {
                String rcid = (String)st.elementAt(rcind);
                rc = (RelationClass)this.m_relationClasses.get(rcid);
                lrcind = rcind;
            }
            if (eind != leind) {
                String eid1 = (String)st.elementAt(eind);
                e1 = this.getEntity(eid1);
                leind = eind;
            }
            String eid2 = (String)st.elementAt(dis.readInt());
            EntityInstance e2 = this.getEntity(eid2);
            if (rc == crc) {
                if (this.m_rootInstance.removeContainment(e2)) {
                    e1.addContainment(e2);
                }
            } else {
                this.addEdge(e1, e2, rc);
            }
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.m_ls.showInfo("Relations: " + i);
        }
    }

    private void processRawFactAttributes(DataInputStream dis, Vector st) throws IOException {
        int num = dis.readInt();
        for (int i = 0; i < num; ++i) {
            String eid = (String)st.elementAt(dis.readInt());
            EntityInstance e = this.getEntity(eid);
            this.processRawAttributes(e, dis, st);
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.m_ls.showInfo("Attr records: " + i);
        }
    }

    private void parseRawStream(DataInputStream dis, String src, URL context) {
        try {
            String hdr = dis.readUTF();
            if (hdr.equals(RAW_HEADER)) {
                String sec;
                Vector stringTable = this.readStringTable(dis);
                while (!(sec = dis.readUTF()).equals("#END#")) {
                    if (sec.equals("#1#")) {
                        this.processRawSchemeTuples(dis, stringTable);
                        continue;
                    }
                    if (sec.equals("#2#")) {
                        this.processRawSchemeAttributes(dis, stringTable);
                        continue;
                    }
                    if (sec.equals("#3#")) {
                        this.processRawFactTuples(dis, stringTable);
                        continue;
                    }
                    if (sec.equals("#4#")) {
                        this.processRawFactAttributes(dis, stringTable);
                        continue;
                    }
                    MsgOut.println(src + "- Bad section: " + sec);
                }
            } else {
                this.m_resString = "Not a raw TA file";
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.m_resString = e.toString();
        }
    }

    private boolean isRaw(BufferedInputStream bis) throws IOException {
        bis.mark(100);
        bis.read();
        bis.read();
        for (int i = 0; i < RAW_HEADER.length(); ++i) {
            int c = bis.read();
            if (c == RAW_HEADER.charAt(i)) continue;
            bis.reset();
            return false;
        }
        bis.reset();
        return true;
    }

    private void computeRelCoordinates() {
        if (this.m_rootInstance != null) {
            this.m_rootInstance.computeRelCoordinates(this.m_rootInstance.xRelLocal(), this.m_rootInstance.yRelLocal(), this.m_rootInstance.widthRelLocal(), this.m_rootInstance.heightRelLocal());
        }
    }

    private void parseStream(InputStream is, String src, URL context) {
        MsgOut.vprintln("Parse TA file: " + src);
        this.m_uses_local_coordinates = false;
        try {
            BufferedInputStream bis = new BufferedInputStream(is);
            if (this.isRaw(bis)) {
                DataInputStream dis = new DataInputStream(bis);
                this.parseRawStream(dis, src, context);
                dis.close();
                bis.close();
                is.close();
                return;
            }
            LandscapeTokenStream ts = new LandscapeTokenStream(bis, src);
            while (true) {
                int sec;
                if ((sec = ts.nextSection()) == 99) {
                    MsgOut.vprintln("");
                    break;
                }
                try {
                    switch (sec) {
                        case 0: {
                            this.schemeSetup = true;
                            this.universalScheme = false;
                            this.processSchemeTuples(ts);
                            this.updateProgress();
                            break;
                        }
                        case 1: {
                            if (!this.schemeSetup) {
                                this.schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processSchemeAttributes(ts);
                            this.updateProgress();
                            break;
                        }
                        case 2: {
                            if (!this.schemeSetup) {
                                this.schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processFactTuples(ts);
                            break;
                        }
                        case 3: {
                            this.processFactAttributes(ts);
                            break;
                        }
                        case 4: {
                            if (context == null) {
                                this.parseFile(ts.getIncludeFile(), null);
                            } else {
                                this.parseURL(ts.getIncludeFile(), context);
                            }
                            MsgOut.vprintln("Back to TA file: " + src);
                        }
                    }
                }
                catch (IOException e) {
                    MsgOut.println("IO error reading landscape");
                    this.m_resString = e.toString();
                    break;
                }
            }
            ts.freeHashTable();
            bis.close();
            is.close();
            if (this.m_uses_local_coordinates) {
                this.computeRelCoordinates();
            }
        }
        catch (Exception e) {
            this.m_resString = e.toString();
            System.out.println("Parse error: " + this.m_resString);
        }
    }

    private URL parseURL(String taURL, URL context) {
        this.progressCount = 0;
        this.updateProgress();
        try {
            URL lsURL = context == null ? new URL(taURL) : new URL(context, taURL);
            MsgOut.dprintln("Opening URL: " + taURL);
            InputStream is = lsURL.openStream();
            MsgOut.dprintln("opened");
            this.parseStream(is, taURL, lsURL);
            return lsURL;
        }
        catch (Exception e) {
            this.m_resString = e.toString();
            return null;
        }
    }

    private File parseFile(String taFile, File context) {
        this.progressCount = 0;
        this.updateProgress();
        try {
            File file;
            if (context == null) {
                file = new File(taFile);
            } else {
                String dir = this.getDir(context);
                file = new File(dir, taFile);
            }
            FileInputStream fis = new FileInputStream(file);
            this.parseStream(fis, taFile, null);
            return file;
        }
        catch (Exception e) {
            this.m_resString = e.toString();
            return null;
        }
    }

    private void processInternalBuffer(String taFile) {
        InternalBufferStream iis = this.m_ls.getInternalBufferStream();
        if (iis == null) {
            this.m_resString = "Internal landscape not available";
            return;
        }
        this.parseRawStream(iis, taFile, null);
        this.setReadOnly();
    }

    public Ta(LandscapeViewerCore ls) {
        this.m_ls = ls;
        this.m_diagram = this.getDiagram();
        this.m_entityBaseClass = new EntityClass("$ENTITY", this.m_numEntityClasses++, null, this.m_diagram);
        this.m_entityClasses.put("$ENTITY", this.m_entityBaseClass);
        this.m_rootInstance = new EntityInstance(this.m_entityBaseClass, ROOT_ID);
        this.m_rootInstance.prepostorder(1);
        this.m_entityInstances.put(ROOT_ID, this.m_rootInstance);
        for (int i = 0; i < g_rootAttributes.length; ++i) {
            this.m_rootInstance.addAttribute(new Attribute(g_rootAttributes[i], null));
        }
        AttributeValueItem av = new AttributeValueItem(BG_STR);
        av.next = new AttributeValueItem(BG_STR);
        av.next.next = new AttributeValueItem(BG_STR);
        this.m_rootInstance.addAttribute(new Attribute("color", av));
        this.m_relationBaseClass = new RelationClass("$RELATION", this.m_numRelationClasses++, null, this.m_diagram);
        this.m_relationClasses.put("$RELATION", this.m_relationBaseClass);
        this.m_numToRel.addElement(this.m_relationBaseClass);
        RelationClass rc = new RelationClass(CONTAIN_ID, this.m_numRelationClasses++, this.m_relationBaseClass, this.m_diagram);
        this.m_relationClasses.put(CONTAIN_ID, rc);
        this.m_numToRel.addElement(rc);
    }

    public LandscapeViewerCore getLs() {
        return this.m_ls;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public RelationClass nameToRelationClass(String name) {
        if (this.m_relationClasses.containsKey(name)) {
            return (RelationClass)this.m_relationClasses.get(name);
        }
        return null;
    }

    public EntityInstance getEntity(String name) {
        return (EntityInstance)this.m_entityInstances.get(name);
    }

    public void putEntity(EntityInstance e) {
        this.m_entityInstances.put(e.getId(), e);
    }

    public Enumeration enumRelationClasses() {
        return this.m_relationClasses.elements();
    }

    public Enumeration enumRelationClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_relationClasses);
    }

    public int numRelationClasses() {
        return this.m_numRelationClasses;
    }

    public Enumeration enumEntityClasses() {
        return this.m_entityClasses.elements();
    }

    public Enumeration enumEntityClassesInOrder() {
        return OrderedHashTableEnumeration.elements(this.m_entityClasses);
    }

    public int numEntityClasses() {
        return this.m_numEntityClasses;
    }

    public Object getContext() {
        return this.context;
    }

    public Object setContext(Object context) {
        this.context = context;
        return this.context;
    }

    public String getName() {
        if (this.context instanceof File) {
            return Util.nameFromPath(((File)this.context).getPath());
        }
        return this.m_rootInstance.getLabel();
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.context);
    }

    public String getAbsolutePath() {
        if (this.context instanceof File) {
            return ((File)this.context).getAbsolutePath();
        }
        return ((URL)this.context).toExternalForm();
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.m_numToRel.elementAt(n);
    }

    public void saveDiagram(OutputStream os, boolean markEnd) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        PrintStream ps = new PrintStream(bos);
        this.writeSchemeTuples(ps);
        this.writeSchemeAttributes(ps);
        this.writeFactTuples(ps);
        this.writeFactAttributes(ps);
        if (markEnd) {
            ps.print("END\n");
        }
        ps.flush();
        ps.close();
        this.changedFlag = false;
    }

    public void saveDiagramRaw(OutputStream os) throws IOException {
        String str;
        BufferedOutputStream bos = new BufferedOutputStream(os);
        DataOutputStream dos = new DataOutputStream(bos);
        Hashtable<String, Integer> stringHash = new Hashtable<String, Integer>();
        Vector<String> stringTable = new Vector<String>();
        int id = 0;
        Enumeration<Object> en = this.m_entityClasses.keys();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            stringHash.put(str, new Integer(id++));
            stringTable.addElement(str);
        }
        en = this.m_relationClasses.keys();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            stringHash.put(str, new Integer(id++));
            stringTable.addElement(str);
        }
        en = this.m_entityInstances.keys();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            stringHash.put(str, new Integer(id++));
            stringTable.addElement(str);
        }
        en = this.m_attrNames.keys();
        while (en.hasMoreElements()) {
            str = (String)en.nextElement();
            stringHash.put(str, new Integer(id++));
            stringTable.addElement(str);
        }
        dos.writeUTF(RAW_HEADER);
        dos.writeInt(stringTable.size());
        en = stringTable.elements();
        while (en.hasMoreElements()) {
            dos.writeUTF((String)en.nextElement());
        }
        this.writeSchemeTuplesRaw(dos, stringHash);
        this.writeSchemeAttributesRaw(dos, stringHash);
        this.writeFactTuplesRaw(dos, stringHash);
        this.writeFactAttributesRaw(dos, stringHash);
        dos.writeUTF("#END#");
        dos.flush();
        dos.close();
        bos.close();
        this.changedFlag = false;
    }

    public void run() {
        Enumeration en = this.bgpaths.elements();
        while (en.hasMoreElements()) {
            Serializable ncontext;
            String path = (String)en.nextElement();
            if (Util.isHTTP(path)) {
                ncontext = this.parseURL(path, (URL)this.context);
                continue;
            }
            ncontext = this.parseFile(path, (File)this.context);
        }
    }

    protected String backgroundLoad(Vector paths) {
        if (paths != null && paths.size() > 0) {
            this.bgpaths = paths;
            Thread thread = new Thread(this);
            thread.start();
        }
        return null;
    }

    public String loadTA(String taPath, Vector bgPaths, Object context) {
        this.m_resString = null;
        char lc = taPath.charAt(taPath.length() - 1);
        if (lc == File.separatorChar) {
            taPath = taPath.substring(0, taPath.length() - 1);
        }
        if (taPath.equals("__internal")) {
            this.processInternalBuffer(taPath);
        } else if (context instanceof URL || Util.isHTTP(taPath)) {
            MsgOut.dprintln("Parse a URL");
            this.context = this.parseURL(taPath, (URL)context);
        } else {
            MsgOut.dprintln("Parse a file");
            this.context = this.parseFile(taPath, (File)context);
        }
        if (this.context == null) {
            return this.m_resString;
        }
        return this.backgroundLoad(bgPaths);
    }

    public int getNumberEntitiesLoaded() {
        return this.m_numberEntities;
    }

    public int getNumberRelationsLoaded() {
        return this.m_numberRelations;
    }
}

