/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.MyMenuItem;

public class TextTree
extends JComponent
implements MouseListener {
    public static final String m_helpStr = "Right click for menu.";
    protected static final String[] m_say = new String[]{"Table of contents is hidden", "Press Alt-v or click to show TOC"};
    protected static final int margin = 10;
    protected static final int say_height = 30;
    protected static final Color titleColor = Color.red.darker();
    protected static final Font m_titleFont = new Font("Helvetica", 1, 14);
    protected static final Font m_textFont = new Font("Helvetica", 0, 11);
    protected LandscapeViewerCore m_ls;
    protected MyTree m_tree;
    protected JPanel m_say_panel;
    protected JComponent m_use;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected JLabel[] m_say_labels;

    public TextTree(LandscapeViewerCore ls, JTabbedPane tabbedPane) {
        this.setLayout(null);
        this.m_ls = ls;
        this.m_tabbedPane = tabbedPane;
        this.m_say_panel = new JPanel();
        this.m_say_panel.setLayout(new GridLayout(0, 1));
        int cnt = m_say.length;
        this.m_say_labels = new JLabel[cnt];
        for (int i = 0; i < cnt; ++i) {
            JLabel say;
            this.m_say_labels[i] = say = new JLabel(m_say[i]);
            say.setBackground(Diagram.boxColour);
            say.setForeground(Color.red);
            say.setFont(m_textFont);
            say.setVisible(true);
            this.m_say_panel.add(say);
        }
        this.m_say_panel.setSize(this.m_say_panel.getPreferredSize());
        this.fillTOC();
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(tabbedPane.getBounds());
        this.setBounds(tabbedPane.getBounds());
        this.m_scrollPane.setViewportView(this);
        tabbedPane.addTab("TOC", null, this.m_scrollPane, m_helpStr);
        this.addMouseListener(this);
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component active = this.m_tabbedPane.getSelectedComponent();
        return active != null && this.m_scrollPane == active;
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu m = new JPopupMenu("TOC options");
        if (this.m_use != null && this.m_use == this.m_tree && !this.m_ls.isViewer()) {
            Vector clipboard = this.m_ls.getClipboard();
            TreePath[] paths = this.m_tree.getSelectionPaths();
            if (clipboard == null || clipboard.size() == 0) {
                if (paths != null && paths.length > 0) {
                    MyMenuItem m1 = LandscapeViewerCore.cutMenuItem(m, this.m_ls);
                    m1.setObject(this);
                }
            } else if (paths != null && paths.length == 1) {
                MyMenuItem m1 = LandscapeViewerCore.pasteMenuItem(m, this.m_ls);
                m1.setObject(this);
            }
        }
        this.m_ls.tocMenuItem(m, this.m_ls);
        return m;
    }

    public Vector getGroup() {
        int cnt;
        TreePath[] paths;
        Vector<EntityInstance> ret = null;
        if (this.m_use != null && this.m_use == this.m_tree && (paths = this.m_tree.getSelectionPaths()) != null && (cnt = paths.length) > 0) {
            ret = new Vector<EntityInstance>(cnt);
            for (int i = 0; i < cnt; ++i) {
                MutableTreeNode treeNode = (MutableTreeNode)paths[i].getLastPathComponent();
                EntityInstance e = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject();
                ret.add(e);
            }
        }
        return ret;
    }

    public EntityInstance targetEntity() {
        TreePath[] paths;
        if (this.m_use != null && this.m_use == this.m_tree && (paths = this.m_tree.getSelectionPaths()) != null && paths.length == 1) {
            MutableTreeNode treeNode = (MutableTreeNode)paths[0].getLastPathComponent();
            EntityInstance e = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject();
            return e;
        }
        return null;
    }

    protected void syncSizes() {
        Dimension d = this.m_use.getPreferredSize();
        this.m_use.setSize(d);
        this.setSize(d);
    }

    public void emptyTOC() {
        this.removeAll();
        this.m_use = null;
        if (this.m_tree != null) {
            this.m_tree = null;
        }
    }

    protected void fillTOC(DefaultMutableTreeNode node, EntityInstance e) {
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            EntityInstance child = (EntityInstance)en.nextElement();
            DefaultMutableTreeNode below = new DefaultMutableTreeNode(child);
            node.add(below);
            this.fillTOC(below, child);
        }
    }

    protected void fillTOC() {
        JComponent use;
        Diagram diagram = this.m_ls.getDiagram();
        this.removeAll();
        this.m_use = null;
        this.m_tree = null;
        if (this.m_ls.isTocHidden() || diagram == null) {
            use = this.m_say_panel;
            this.setSize(use.getPreferredSize());
        } else {
            this.m_tree = new MyTree(this);
            this.m_tree.setBackground(Diagram.boxColour);
            this.m_tree.setFont(m_textFont);
            this.m_tree.setEditable(false);
            this.m_tree.setShowsRootHandles(true);
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.m_tree.getCellRenderer();
            renderer.setBackgroundNonSelectionColor(Diagram.boxColour);
            this.m_tree.setCellRenderer(renderer);
            this.m_tree.getSelectionModel().setSelectionMode(4);
            this.m_tree.setDragEnabled(true);
            EntityInstance root = diagram.getRootInstance();
            DefaultMutableTreeNode top = new DefaultMutableTreeNode(root);
            this.m_tree.setModel(new DefaultTreeModel(top, false));
            this.fillTOC(top, root);
            use = this.m_tree;
        }
        this.add(use);
        this.m_use = use;
        this.syncSizes();
        use.setVisible(true);
        this.repaint();
    }

    protected MutableTreeNode locateTreeNode(MutableTreeNode treeNode, EntityInstance e) {
        EntityInstance e1 = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject();
        if (e == e1) {
            return treeNode;
        }
        if (e1.hasDescendant(e)) {
            Enumeration<? extends TreeNode> children = treeNode.children();
            while (children.hasMoreElements()) {
                MutableTreeNode ret = this.locateTreeNode((MutableTreeNode)children.nextElement(), e);
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected MutableTreeNode locateTreeNode(EntityInstance e) {
        MutableTreeNode treeNode;
        TreePath path;
        MutableTreeNode ret = null;
        if (e != null && (path = this.m_tree.getPathForRow(0)) != null && (treeNode = (MutableTreeNode)path.getLastPathComponent()) != null) {
            ret = this.locateTreeNode(treeNode, e);
        }
        return ret;
    }

    public void insertTOC(EntityInstance parent, EntityInstance e) {
        MutableTreeNode node;
        if (this.m_use != null && this.m_use == this.m_tree && (node = this.locateTreeNode(parent)) != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(e);
            model.insertNodeInto(newNode, node, node.getChildCount());
        }
    }

    public void deleteTOC(EntityInstance e) {
        MutableTreeNode node;
        if (this.m_use != null && this.m_use == this.m_tree && (node = this.locateTreeNode(e)) != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
            model.removeNodeFromParent(node);
        }
    }

    public void deleteJustMeTOC(EntityInstance e) {
        MutableTreeNode node;
        if (this.m_use != null && this.m_use == this.m_tree && (node = this.locateTreeNode(e)) != null) {
            DefaultTreeModel model = (DefaultTreeModel)this.m_tree.getModel();
            MutableTreeNode parent = (MutableTreeNode)node.getParent();
            Enumeration<? extends TreeNode> children = node.children();
            while (children.hasMoreElements()) {
                MutableTreeNode child = (MutableTreeNode)children.nextElement();
                model.removeNodeFromParent(child);
                model.insertNodeInto(child, parent, parent.getChildCount());
            }
            model.removeNodeFromParent(node);
        }
    }

    public void validate() {
        this.m_use.setBounds(0, 0, this.getWidth(), this.getHeight());
    }

    public Dimension getPreferredSize() {
        return this.m_use.getPreferredSize();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        if (this.m_use != null) {
            this.m_use.setBounds(x, y, width, height);
        }
    }

    protected void closeAll() {
        int cnt;
        int i = cnt = this.m_tree.getRowCount();
        while (i > 0) {
            this.m_tree.collapseRow(--i);
        }
    }

    protected void expandTo(EntityInstance e) {
        this.closeAll();
        this.m_tree.clearSelection();
        if (e != null) {
            for (int cnt = 0; cnt < this.m_tree.getRowCount(); ++cnt) {
                EntityInstance e1;
                TreePath path = this.m_tree.getPathForRow(cnt);
                TreeNode treeNode = (TreeNode)path.getLastPathComponent();
                if (treeNode == null || (e1 = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject()) == null) continue;
                if (e1 == e) {
                    this.m_tree.setSelectionRow(cnt);
                    this.m_tree.scrollRowToVisible(cnt);
                    break;
                }
                if (!e1.hasDescendant(e)) continue;
                this.m_tree.expandRow(cnt);
            }
        }
    }

    public void toc_path() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram != null) {
            this.m_ls.setTocHidden(false);
            this.activate();
            EntityInstance e = diagram.getDrawRoot();
            this.expandTo(e);
            this.syncSizes();
        }
    }

    protected void expandAll() {
        for (int cnt = 0; cnt < this.m_tree.getRowCount(); ++cnt) {
            this.m_tree.expandRow(cnt);
        }
    }

    public void switch_TOC() {
        this.m_ls.setTocHidden(false);
        this.activate();
        int cnt = this.m_tree.getRowCount();
        if (cnt > 1) {
            this.closeAll();
        } else {
            this.expandAll();
        }
        this.syncSizes();
    }

    public void mouseClicked(MouseEvent ev) {
        if (!ev.isMetaDown()) {
            if (this.m_ls.isTocHidden()) {
                this.m_ls.setTocHidden(false);
            }
        } else {
            int x = ev.getX();
            int y = ev.getY();
            JPopupMenu popupMenu = this.buildPopup();
            this.add(popupMenu);
            popupMenu.show(this, x, y);
            this.remove(popupMenu);
        }
    }

    public void mouseEntered(MouseEvent ev) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent ev) {
    }

    public void mouseReleased(MouseEvent ev) {
    }

    class MyTree
    extends JTree
    implements MouseListener {
        protected TextTree m_tocBox;

        public MyTree(TextTree tocBox) {
            this.m_tocBox = tocBox;
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent ev) {
            if (ev.isMetaDown()) {
                int y;
                int x = ev.getX();
                TreePath selPath = this.getPathForLocation(x, y = ev.getY());
                if (selPath == null) {
                    this.m_tocBox.mouseClicked(ev);
                } else {
                    Diagram diagram;
                    EntityInstance e;
                    TreeNode treeNode = (TreeNode)selPath.getLastPathComponent();
                    if (treeNode != null && (e = (EntityInstance)((DefaultMutableTreeNode)treeNode).getUserObject()) != null && (diagram = TextTree.this.m_ls.getDiagram()) != null) {
                        diagram.navigateTo(e);
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent ev) {
        }

        public void mouseReleased(MouseEvent ev) {
        }
    }
}

