/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JButton;
import lsedit.Do;
import lsedit.HelpBox;
import lsedit.ToolBarEventHandler;

public abstract class ToolBarButton
extends JButton
implements MouseListener,
MouseMotionListener {
    protected static final double ARROW_L = 5.0;
    protected static final double ARROW_TH = 0.4;
    protected static final Font font = new Font("Helvetica", 0, 12);
    protected static final Font font1 = new Font("Helvetica", 0, 8);
    public static final int MARGIN = 2;
    public static final int HEIGHT = 24;
    public static final int WIDTH = 40;
    protected boolean depressed = false;
    protected boolean mouseIn = false;
    protected boolean mouseDown = false;
    private int m_key = 0;
    private int m_modifier = 0;
    protected ToolBarEventHandler teh;
    protected static HelpBox popup = null;

    protected abstract void paintIcon(Graphics var1);

    protected abstract String getDesc();

    protected void setKeystroke(int modifiers, int key) {
        if (key <= 90) {
            if (key >= 65) {
                modifiers |= 1;
            }
        } else if (key <= 122) {
            if (key >= 97) {
                modifiers &= 0xFFFFFFFE;
                key -= 32;
            }
        } else if (key >= 1024) {
            key -= 1024;
        }
        this.m_key = key;
        this.m_modifier = modifiers;
    }

    protected void drawEdge(Graphics gc, int x1, int y1, int x2, int y2) {
        gc.drawLine(x1, y1, x2, y2);
        double dx = x1 - x2;
        double dy = y1 - y2;
        double theta = Math.atan2(dy, dx);
        double len = Math.min(5.0, Math.sqrt(dx * dx + dy * dy));
        double ax = (double)x2 + len * Math.cos(theta - 0.4);
        double ay = (double)y2 + len * Math.sin(theta - 0.4);
        double bx = (double)x2 + len * Math.cos(theta + 0.4);
        double by = (double)y2 + len * Math.sin(theta + 0.4);
        int[] x = new int[3];
        int[] y = new int[3];
        x[0] = Math.round(x2);
        y[0] = Math.round(y2);
        x[1] = (int)Math.round(ax);
        y[1] = (int)Math.round(ay);
        x[2] = (int)Math.round(bx);
        y[2] = (int)Math.round(by);
        gc.fillPolygon(x, y, 3);
    }

    public ToolBarButton(ToolBarEventHandler teh) {
        this.teh = teh;
        this.setSize(40, 24);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setAlignmentY(0.5f);
        this.setToolTipText(this.getDesc());
    }

    public void paintComponent(Graphics gc) {
        Dimension dim = this.getSize();
        gc.setColor(this.getBackground());
        gc.fillRect(0, 0, dim.width, dim.height);
        gc.setColor(this.getBackground());
        if (this.depressed) {
            gc.draw3DRect(0, 0, dim.width - 1, dim.height - 1, true);
        } else if (this.mouseIn) {
            gc.draw3DRect(0, 0, dim.width - 1, dim.height - 1, !this.mouseDown);
        }
        gc.setColor(Color.black);
        String str = null;
        int dw = 0;
        if (this.m_key >= 32 && this.m_key < 256) {
            str = "" + (char)this.m_key;
            dw = 0;
        } else if (this.m_key > 0 && this.m_key < 27) {
            str = "^" + (char)(this.m_key + 64);
            dw = 2;
        }
        if (str != null) {
            gc.setFont(font);
            FontMetrics fm = gc.getFontMetrics();
            int w = fm.stringWidth(str);
            int h = Do.fontHeight(font);
            gc.drawString(str, dim.width - w + dw - 4, dim.height - (dim.height - h) / 2 - 2);
        }
        this.paintIcon(gc);
    }

    public Dimension getPreferredSize() {
        return new Dimension(40, 24);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setState(boolean state) {
        this.depressed = state;
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent ev) {
        int x = ev.getX();
        int y = ev.getY();
        this.teh.showInfo(this.getDesc());
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.mouseIn = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent ev) {
        this.mouseDown = true;
        this.repaint();
    }

    public void mouseReleased(MouseEvent ev) {
        if (this.mouseDown) {
            this.teh.processKeyEvent(this.m_key, this.m_modifier, null);
            this.mouseDown = false;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent ev) {
    }

    public void mouseMoved(MouseEvent ev) {
    }
}

