/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import lsedit.HistoryBox;
import lsedit.LandscapeViewerCore;
import lsedit.MyCompoundEdit;
import lsedit.MyPaintableUndoableEdit;
import lsedit.Ta;

public class UndoableTa
extends Ta
implements UndoableEditListener {
    protected MyUndoManager m_undoManager = new MyUndoManager();
    protected String m_compoundEditName = null;
    protected MyCompoundEdit m_compoundEdit = null;
    protected int m_compoundEditCnt = -1;

    protected void updateMenu() {
        this.m_ls.setEnabledRedo(this.m_undoManager.canRedo());
        this.m_ls.setEnabledUndo(this.m_undoManager.canUndo());
    }

    public UndoableTa(LandscapeViewerCore ls) {
        super(ls);
    }

    public Vector getEdits() {
        return this.m_undoManager.getEdits();
    }

    public UndoableEdit getEditToBeRedone() {
        return this.m_undoManager.getEditToBeRedone();
    }

    public int countEdits() {
        return this.m_undoManager.countEdits();
    }

    public void massChange(UndoableEdit undoableEdit, boolean redo) {
        this.m_undoManager.massChange(undoableEdit, redo);
    }

    public void discardAllEdits() {
        this.m_undoManager.discardAllEdits();
    }

    public boolean addEditToManager(UndoableEdit anEdit) {
        int w;
        if (anEdit instanceof MyPaintableUndoableEdit) {
            w = ((MyPaintableUndoableEdit)anEdit).getPreferredWidth();
        } else {
            FontMetrics fm = this.getFontMetrics(HistoryBox.m_textFont);
            w = fm.stringWidth(anEdit.getPresentationName());
        }
        boolean ret = this.m_undoManager.addEdit(anEdit);
        Vector v = this.getEdits();
        int h = v == null ? 0 : v.size() * 16;
        h += 5;
        if ((w += 5) > HistoryBox.m_preferredSize.width) {
            HistoryBox.m_preferredSize.width = w;
        }
        if (h > HistoryBox.m_preferredSize.height) {
            HistoryBox.m_preferredSize.height = h;
        }
        this.m_ls.fillHistoryBox();
        return ret;
    }

    public void beginUndoRedo(String name) {
        this.m_compoundEditName = name;
        this.m_compoundEdit = null;
        this.m_compoundEditCnt = 0;
    }

    public void endUndoRedo() {
        if (this.m_compoundEdit != null) {
            this.m_compoundEdit.end();
            this.m_compoundEdit = null;
        }
        this.m_compoundEditName = null;
        this.m_compoundEditCnt = -1;
    }

    public boolean logEdit(UndoableEdit anEdit) {
        boolean ret;
        if (this.m_compoundEditCnt < 0) {
            ret = this.addEditToManager(anEdit);
        } else {
            switch (this.m_compoundEditCnt) {
                case 0: {
                    ret = this.addEditToManager(anEdit);
                    break;
                }
                case 1: {
                    this.m_compoundEdit = new MyCompoundEdit(this.m_compoundEditName);
                    ret = this.m_compoundEdit.addEdit(anEdit);
                    ret = this.addEditToManager(this.m_compoundEdit);
                    break;
                }
                default: {
                    ret = this.m_compoundEdit.addEdit(anEdit);
                }
            }
            ++this.m_compoundEditCnt;
        }
        this.updateMenu();
        return ret;
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.m_undoManager.undoableEditHappened(e);
        this.updateMenu();
    }

    public void undo() {
        String s;
        if (!this.m_undoManager.canUndo()) {
            s = "Nothing to undo";
        } else {
            this.m_undoManager.undo();
            this.updateMenu();
            this.m_ls.redrawDg();
            this.repaint();
            s = "Undo done";
        }
        this.m_ls.doFeedback(s);
    }

    public void redo() {
        String s;
        if (!this.m_undoManager.canRedo()) {
            s = "Nothing to redo";
        } else {
            this.m_undoManager.redo();
            this.m_ls.doFeedback("Redo done");
            this.updateMenu();
            this.m_ls.redrawDg();
            this.repaint();
            s = "Redo done";
        }
        this.m_ls.doFeedback(s);
    }

    class MyUndoManager
    extends UndoManager {
        MyUndoManager() {
        }

        public Vector getEdits() {
            return this.edits;
        }

        public UndoableEdit getEditToBeRedone() {
            return this.editToBeRedone();
        }

        public void massChange(UndoableEdit undoableEdit, boolean redo) {
            if (redo) {
                this.redoTo(undoableEdit);
            } else {
                this.undoTo(undoableEdit);
            }
        }

        public int countEdits() {
            return this.edits.size();
        }
    }
}

