/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JFrame;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.LandscapeViewerCore;
import lsedit.LineWalker;
import lsedit.MsgOut;
import lsedit.RelationClass;
import lsedit.ScreenPoint;

public class Util {
    public static final double ARROW_L_DEFAULT = 10.0;
    public static final double ARROW_TH_DEFAULT = 0.4;
    public static final int LINE_W_DEFAULT = 1;
    public static double ARROW_L = 10.0;
    public static double ARROW_TH = 0.4;
    public static int LINE_W = 1;
    public static final int LINE_STYLE_NORMAL = 0;
    public static final int LINE_STYLE_DASHED = 1;
    public static final int LINE_STYLE_DOTTED = 2;
    public static final int LINE_STYLE_INSCRIBED = 3;
    public static final String[] lineStyleName = new String[]{"Normal", "Dashed", "Dotted", "Inscribed"};
    protected static final int DASH_LEN = 4;
    protected static final int DASH_GAP = 3;
    protected static final int DOT_LEN = 0;
    protected static final int DOT_GAP = 4;
    protected static boolean reverseZflag = false;
    protected static final Font tabFont = new Font("Helvetica", 1, 10);
    protected static final int GAP = 5;
    protected static final int INSET = 12;
    protected static final int OUTSET = 5;
    protected static final int DOT_LEN_REG = 0;
    protected static final int DOT_LEN_PRNT = 1;

    public static String formatFraction(double val) {
        if (val >= 1.0) {
            if (val == 1.0) {
                return "1";
            }
            return "" + val;
        }
        if (val <= 0.0) {
            if (val == 0.0) {
                return "0";
            }
            return "" + val;
        }
        int e1 = (int)(val * 10.0);
        int e2 = (int)(val * 100.0) - e1 * 10;
        if (e2 == 0) {
            return "0." + e1;
        }
        return "0." + e1 + e2;
    }

    public static String getLineStyleName(int style) {
        if (style < 0 || style >= lineStyleName.length) {
            return "";
        }
        return lineStyleName[style];
    }

    public static boolean drawStringClipped(Graphics g, String str, double x, double y, double width, double height, boolean centered, boolean underlined) {
        double xpos;
        String dstr;
        int pos;
        FontMetrics fm = g.getFontMetrics();
        int len = str.length();
        if ((double)fm.stringWidth(str) > width) {
            for (pos = len - 1; pos >= 0; --pos) {
                StringBuilder stringBuilder = new StringBuilder();
                if (!((double)fm.stringWidth(stringBuilder.append(str.substring(0, pos)).append("...").toString()) > width)) break;
            }
        }
        if (pos < 0) {
            return false;
        }
        if (pos == len - 1) {
            dstr = str;
            double sw = fm.stringWidth(str);
            xpos = centered ? x + width / 2.0 - sw / 2.0 : x;
        } else {
            dstr = str.substring(0, pos) + "...";
            xpos = x;
        }
        ScreenPoint pt = centered ? new ScreenPoint(xpos, y + height / 2.0 + (double)(Do.fontHeight(fm) / 2)) : new ScreenPoint(xpos, y + (double)Do.fontHeight(fm));
        g.drawString(dstr, pt.x, pt.y);
        if (underlined) {
            int sw = fm.stringWidth(dstr);
            g.drawLine(pt.x, pt.y, pt.x + sw, pt.y);
        }
        return pos == len - 1;
    }

    public static boolean drawStringClipped(Graphics g, String str, double x, double y, double width, double height) {
        return Util.drawStringClipped(g, str, x, y, width, height, false, false);
    }

    public static boolean drawUnderlinedStringClipped(Graphics g, String str, double x, double y, double width, double height) {
        return Util.drawStringClipped(g, str, x, y, width, height, false, true);
    }

    protected static int longestSubStr(String str, FontMetrics fm, int width) {
        int pos = str.indexOf(10);
        if (pos > 0) {
            str = str.substring(0, pos);
        }
        if ((pos = str.indexOf(32)) < 0 || fm.stringWidth(str) < width) {
            return str.length();
        }
        int lpos = -1;
        while (pos >= 0) {
            if (fm.stringWidth(str.substring(0, pos)) > width) {
                return lpos < 0 ? pos : lpos;
            }
            lpos = pos;
            pos = str.indexOf(pos + 1, 32);
        }
        return lpos;
    }

    public static boolean drawStringWrapped(Graphics g, String str, double x, double y, double width, double height, boolean centered, boolean underlined) {
        double ypos;
        int pos;
        FontMetrics fm = g.getFontMetrics();
        Vector<String> strs = new Vector<String>();
        if (str.indexOf(32) < 0 && str.indexOf(10) < 0) {
            return Util.drawStringClipped(g, str, x, y, width, height, centered, underlined);
        }
        while (true) {
            pos = Util.longestSubStr(str, fm, (int)width);
            strs.addElement(str.substring(0, pos));
            if (pos == str.length()) break;
            str = str.substring(pos + 1);
        }
        int fh = Do.fontHeight(fm) * 3 / 4;
        int ht = strs.size() * fh;
        Enumeration en = strs.elements();
        double d = ypos = centered ? y + (height - (double)ht) / 2.0 + (double)fh : y + (double)fh;
        while (en.hasMoreElements()) {
            double xpos;
            String dstr;
            str = (String)en.nextElement();
            int len = str.length();
            for (pos = len - 1; pos >= 0 && (double)fm.stringWidth(str.substring(0, pos)) > width; --pos) {
            }
            if (pos < 0) continue;
            if (pos == len - 1) {
                dstr = str;
                double sw = fm.stringWidth(str);
                xpos = centered ? x + width / 2.0 - sw / 2.0 : x;
            } else {
                dstr = str.substring(0, pos);
                xpos = x;
            }
            ScreenPoint pt = new ScreenPoint(xpos, ypos);
            g.drawString(dstr, pt.x, pt.y);
            if (underlined) {
                int sw = fm.stringWidth(dstr);
                g.drawLine(pt.x, pt.y, pt.x + sw, pt.y);
            }
            ypos += (double)fh;
        }
        return true;
    }

    public static boolean isUnix() {
        try {
            if (System.getProperty("file.separator").equals("/")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isHTTP(String path) {
        return path.length() > 7 && (path.substring(0, 7).equals("http://") || path.substring(0, 7).equals("HTTP://"));
    }

    public static String prefixOf(String name) {
        int ind = name.lastIndexOf(46);
        if (ind >= 0) {
            return name.substring(0, ind);
        }
        return name;
    }

    public static void drawFrame(Graphics gc, Rectangle r) {
        gc.setColor(Diagram.boxColour);
        gc.draw3DRect(0, 0, r.width - 1, r.height - 1, true);
        gc.draw3DRect(1, 1, r.width - 3, r.height - 3, true);
    }

    public static Dimension getTabDim(Graphics gc, String title) {
        gc.setFont(tabFont);
        FontMetrics fm = gc.getFontMetrics();
        int w = fm.stringWidth(title) + 10;
        int h = Do.fontHeight(tabFont) + 5;
        return new Dimension(w, h);
    }

    public static void drawTab(Graphics gc, String title, Color titleColor, int offx, boolean active) {
        boolean underlineFC = title.charAt(0) == '&';
        String dstr = underlineFC ? title.substring(1) : title;
        gc.setFont(tabFont);
        FontMetrics fm = gc.getFontMetrics();
        int h = Do.fontHeight(tabFont);
        int tabw = fm.stringWidth(dstr) + 10;
        int tabh = h + 5;
        gc.setColor(Diagram.boxColour);
        gc.draw3DRect(offx, 0, tabw, tabh, true);
        gc.draw3DRect(offx + 1, 1, tabw - 2, tabh, true);
        if (active) {
            gc.fillRect(offx + 2, 2, tabw - 3, tabh + 10);
        }
        gc.setColor(titleColor);
        gc.drawString(dstr, offx + 5, h);
        if (underlineFC) {
            int w = fm.stringWidth(title.substring(1, 2));
            gc.drawLine(offx + 5, h + 1, offx + w + 5, h + 1);
        }
    }

    public static void drawTabbedFrame(Graphics gc, Rectangle r, String title, Color titleColor, int offx) {
        int h = Do.fontHeight(tabFont) + 5;
        gc.setColor(Diagram.boxColour);
        gc.draw3DRect(0, h, r.width - 1, r.height - h - 1, true);
        gc.draw3DRect(1, h + 1, r.width - 3, r.height - h - 3, true);
        Util.drawTab(gc, title, titleColor, offx, true);
    }

    public static double parseReal(String str) {
        return new Double(str);
    }

    public static int parseInt(String str) {
        return new Integer(str);
    }

    public static boolean parseBoolean(String str) {
        return str.equals("true");
    }

    protected static String qt(String str) {
        if (str.indexOf(32) >= 0) {
            return "\"" + str + "\"";
        }
        return str;
    }

    protected static String doExpand(String src, String id, LandscapeViewerCore ls) {
        boolean found;
        String link = "";
        int pos = 0;
        int len = src.length();
        MsgOut.dprintln("Expand: " + src);
        do {
            int ind;
            boolean bl = found = ((ind = src.indexOf(36, pos)) == 0 || ind > 0 && src.charAt(ind - 1) != '\\') && ind + 1 < len;
            if (!found) continue;
            int endInd = src.indexOf(36, ind + 1);
            if (endInd < ind) {
                MsgOut.println("Missing delimitting '$' in expansion variable");
                return null;
            }
            link = link + src.substring(pos, ind);
            String var = src.substring(ind + 1, endInd);
            if (var.equals("ID")) {
                link = link + Util.qt(id);
            } else if (var.equals("IDPREFIX")) {
                int dind = id.lastIndexOf(46);
                link = dind >= 0 ? link + Util.qt(id.substring(0, dind)) : link + Util.qt(id);
            } else if (var.equals("IDSUFFIX")) {
                int dind = id.lastIndexOf(46);
                if (dind >= 0) {
                    link = link + id.substring(dind + 1);
                }
            } else if (var.equals("DGDIR")) {
                String path = ls.getDiagram().getAbsolutePath();
                String dir = Util.dirFromPath(path);
                link = link + dir;
            } else if (var.equals("DGSUFFIX")) {
                String path = ls.getDiagram().getAbsolutePath();
                String name = Util.nameFromPath(path);
                int dind = name.indexOf(46);
                if (dind >= 0) {
                    link = link + name.substring(dind + 1);
                }
            } else {
                String value = ls.getParameter(var);
                if (value != null) {
                    link = link + Util.qt(value);
                } else {
                    MsgOut.println("Parameter not found: '" + var + "'");
                    return "";
                }
            }
            pos = endInd + 1;
        } while (found && pos < len);
        if (pos < len) {
            link = link + src.substring(pos);
        }
        MsgOut.dprintln("Result: " + link);
        return link;
    }

    public static String expand(String src, String id, LandscapeViewerCore ls) {
        String nstr1;
        String nstr2 = Util.doExpand(src, id, ls);
        while (!(nstr1 = nstr2).equals(nstr2 = Util.doExpand(nstr1, id, ls))) {
        }
        return nstr1;
    }

    public static String expand(String src, LandscapeViewerCore ls) {
        return Util.expand(src, "", ls);
    }

    public static JFrame getFrame(Component c) {
        while (c != null) {
            if (c instanceof JFrame) {
                return (JFrame)c;
            }
            c = c.getParent();
        }
        return null;
    }

    public static String dirFromPath(String path) {
        int ind2;
        int ind1 = path.lastIndexOf(47);
        if (ind1 > (ind2 = path.lastIndexOf(92))) {
            return path.substring(0, ind1);
        }
        if (ind2 > ind1) {
            return path.substring(0, ind2);
        }
        return "";
    }

    public static String nameFromPath(String path) {
        int ind2;
        int ind1 = path.lastIndexOf(47);
        if (ind1 > (ind2 = path.lastIndexOf(92))) {
            return path.substring(ind1 + 1);
        }
        if (ind2 > ind1) {
            return path.substring(ind2 + 1);
        }
        return path;
    }

    public static boolean isBlack(Color c) {
        if (c == Color.black) {
            return true;
        }
        if (c.getRed() != 0) {
            return false;
        }
        if (c.getGreen() != 0) {
            return false;
        }
        return c.getBlue() == 0;
    }

    public static String quoted(String str) {
        if (str.indexOf(32) >= 0) {
            return "\"" + str + "\"";
        }
        return str;
    }

    protected static void drawLine(Graphics g, LineWalker lw) {
        ScreenPoint p1 = new ScreenPoint(0.0, 0.0);
        ScreenPoint p2 = new ScreenPoint(0.0, 0.0);
        while (lw.morePoints()) {
            lw.nextPoints(p1, p2);
            g.drawLine(p1.x, p1.y, p2.x, p2.y);
        }
    }

    protected static void drawInscribedLine(Graphics g, ScreenPoint p1, ScreenPoint p2) {
        Color cc = g.getColor();
        g.setColor(Color.gray);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.setColor(Color.white);
        if (p1.x == p2.x) {
            g.drawLine(p1.x + 1, p1.y, p2.x + 1, p2.y);
        } else {
            g.drawLine(p1.x, p1.y + 1, p2.x, p2.y + 1);
        }
        g.setColor(cc);
    }

    public static void drawTailPoint(Graphics g, int x, int y) {
        int hb = 3;
        g.fillOval(x - hb, y - hb, hb * 2, hb * 2);
    }

    public static boolean getArrow(int srcX, int srcY, int dstX, int dstY, int[] x, int[] y) {
        int dx = srcX - dstX;
        int dy = srcY - dstY;
        if (dx != 0 || dy != 0) {
            double theta = Math.atan2(dy, dx);
            double len = Math.min(ARROW_L, Math.sqrt(dx * dx + dy * dy));
            double ax = (double)dstX + len * Math.cos(theta - ARROW_TH);
            double ay = (double)dstY + len * Math.sin(theta - ARROW_TH);
            double bx = (double)dstX + len * Math.cos(theta + ARROW_TH);
            double by = (double)dstY + len * Math.sin(theta + ARROW_TH);
            x[0] = dstX;
            y[0] = dstY;
            x[1] = (int)Math.round(ax);
            y[1] = (int)Math.round(ay);
            x[2] = (int)Math.round(bx);
            y[2] = (int)Math.round(by);
            return true;
        }
        return false;
    }

    public static void drawArrowHead(Graphics g, int x1, int y1, int x2, int y2) {
        int[] x = new int[3];
        int[] y = new int[3];
        if (Util.getArrow(x1, y1, x2, y2, x, y)) {
            g.fillPolygon(x, y, 3);
        }
    }

    public static void drawArrow(Graphics g, int x1, int y1, int x2, int y2) {
        g.drawLine(x1, y1, x2, y2);
        Util.drawArrowHead(g, x1, y1, x2, y2);
    }

    public static void drawOutlineBox(Graphics g, int x, int y, int width, int height, boolean has3Dlook) {
        g.setColor(Color.gray);
        if (!has3Dlook) {
            g.drawRect(x, y, width, height);
            return;
        }
        g.drawLine(x, y, x + width, y);
        g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        g.drawLine(x + width - 1, y + height - 1, x + 1, y + height - 1);
        g.drawLine(x, y + height, x, y);
        g.setColor(Color.white);
        g.drawLine(x + 1, y + 1, x + width, y + 1);
        g.drawLine(x + width, y + 1, x + width, y + height);
        g.drawLine(x + width, y + height, x + 1, y + height);
        g.drawLine(x + 1, y + height, x + 1, y + 1);
    }

    public static void drawOutlineBox(Graphics g, Rectangle rect, boolean has3Dlook) {
        Util.drawOutlineBox(g, rect.x, rect.y, rect.width, rect.height, has3Dlook);
    }

    public static void drawGroupBox(Graphics g, int x, int y, int w, int h, String label, Color labelColour, boolean has3Dlook) {
        FontMetrics fm = g.getFontMetrics();
        int len = fm.stringWidth(label);
        int ht = Do.fontHeight(fm);
        int inset = Math.min(12, w / 12);
        if (w < inset + 5) {
            Util.drawOutlineBox(g, x, y, w, h, has3Dlook);
            return;
        }
        int x2 = len + 10 > w - inset - 5 ? x + w - 5 : x + inset + len + 10;
        g.setColor(Color.gray);
        if (has3Dlook) {
            g.drawLine(x, y + h, x, y);
            g.drawLine(x, y, x + inset, y);
            g.drawLine(x2, y, x + w, y);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + 1, y + h - 1);
            g.setColor(Color.white);
            g.drawLine(x + 1, y + h, x + 1, y + 1);
            g.drawLine(x + 1, y + 1, x + inset, y + 1);
            g.drawLine(x2, y + 1, x + w, y + 1);
            g.drawLine(x + w, y + 1, x + w, y + h);
            g.drawLine(x + w, y + h, x + 1, y + h);
        } else {
            g.drawLine(x, y + h, x, y);
            g.drawLine(x, y, x + inset, y);
            g.drawLine(x2, y, x + w, y);
            g.drawLine(x + w, y, x + w, y + h);
            g.drawLine(x + w, y + h, x, y + h);
        }
        g.setColor(labelColour);
        Util.drawStringClipped(g, label, x + inset + 5, y - ht * 2 / 3, x2 - x - 10, 100.0);
    }

    public static String mungeName(String name) {
        String tmp = name.replace(' ', '_');
        tmp = tmp.replace('/', '-');
        tmp = tmp.replace(',', '_');
        return tmp.replace('\\', '-');
    }

    public static String hashEdge(RelationClass rc, EntityInstance src, EntityInstance dst) {
        return src.getId() + rc.getId() + dst.getId();
    }

    public static int round(double val) {
        return (int)(val + 0.5);
    }

    protected static int getDotLen(Graphics g) {
        return 0;
    }

    public static void drawLine(Graphics g, ScreenPoint p1, ScreenPoint p2, int style) {
        switch (style) {
            case 0: {
                g.drawLine(p1.x, p1.y, p2.x, p2.y);
                break;
            }
            case 2: {
                LineWalker lw = new LineWalker(p1, p2, 0, 4);
                Util.drawLine(g, lw);
                break;
            }
            case 1: {
                LineWalker lw = new LineWalker(p1, p2, 4, 3);
                Util.drawLine(g, lw);
                break;
            }
            case 3: {
                Util.drawInscribedLine(g, p1, p2);
            }
        }
    }

    public static void drawSegment(Graphics g, int style, int x1, int y1, int x2, int y2) {
        int x = 0;
        int y = 0;
        int xshift = 0;
        int yshift = 0;
        for (int i = 0; i < LINE_W; ++i) {
            switch (style) {
                case 0: {
                    g.drawLine(x1 + x, y1 + y, x2 + x, y2 + y);
                    break;
                }
                case 2: {
                    LineWalker lw = new LineWalker(x1 + x, y1 + y, x2 + x, y2 + y, Util.getDotLen(g), 4);
                    Util.drawLine(g, lw);
                    break;
                }
                case 1: {
                    LineWalker lw = new LineWalker(x1 + x, y1 + y, x2 + x, y2 + y, 4, 3);
                    Util.drawLine(g, lw);
                    break;
                }
            }
            x = -x;
            y = -y;
            if ((i & 1) != 0) continue;
            if (i == 0) {
                int w = x2 - x1;
                int h = y2 - y1;
                if (w <= 0 && h <= 0) {
                    w = -w;
                    h = -h;
                }
                if (w >= 0 && h >= 0) {
                    if (2 * h >= w) {
                        xshift = 1;
                    }
                    if (2 * w >= h) {
                        yshift = -1;
                    }
                } else {
                    if (w < 0) {
                        w = -w;
                    }
                    if (h < 0) {
                        h = -h;
                    }
                    if (2 * h >= w) {
                        xshift = 1;
                    }
                    if (2 * w >= h) {
                        yshift = 1;
                    }
                }
            }
            x += xshift;
            y += yshift;
        }
    }
}

