/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import lsedit.Diagram;
import lsedit.Do;
import lsedit.EntityInstance;
import lsedit.GroupModeHandler;
import lsedit.LandscapeModeHandler;
import lsedit.LandscapeViewerCore;
import lsedit.MoveModeHandler;
import lsedit.MyMenuItem;
import lsedit.NavigateModeHandler;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ResizeModeHandler;
import lsedit.ResultBox;
import lsedit.SortVector;

public class ViewModeHandler
extends LandscapeModeHandler {
    protected static final int MENU_BASE = 2000;
    protected static final double SMALL_SCALE_UP = 1.2;
    protected static final double SMALL_SCALE_DOWN = 0.8;
    protected static final String SMALL_SCALE_STRING = "20%";
    protected MoveModeHandler m_moveHandler;
    protected ResizeModeHandler m_resizeHandler;
    protected NavigateModeHandler m_navHandler;
    protected GroupModeHandler m_groupingHandler;
    protected LandscapeModeHandler m_handler = null;
    private long m_lastUp;
    protected JPopupMenu m_rootEntityPopup;
    protected JPopupMenu m_entityPopup;
    protected JPopupMenu m_relationPopup;
    protected int[] resizeCursor = new int[]{6, 8, 7, 11, 5, 9, 4, 10};
    protected int curX;
    protected int curY;

    protected JPopupMenu buildRootPopup() {
        JPopupMenu m = new JPopupMenu("Root options");
        JMenu m1 = new JMenu("Draw");
        Do.fontMenuItem(m1, this.m_ls);
        m.add(m1);
        m1 = new JMenu("Move");
        Do.groupAllMenuItem(m1, this.m_ls);
        m.addSeparator();
        Do.scaleMenuItem(m1, this.m_ls);
        m.add(m1);
        return m;
    }

    protected JPopupMenu buildEntityPopup() {
        JPopupMenu m = new JPopupMenu("Entity options");
        Do.queryMenuItem(m, this.m_ls);
        m.addSeparator();
        Do.hideMenuItem(m, this.m_ls);
        m.addSeparator();
        Do.groupAllMenuItem(m, this.m_ls);
        m.addSeparator();
        Do.scaleMenuItem(m, this.m_ls);
        return m;
    }

    protected JPopupMenu buildRelationPopup() {
        JPopupMenu m = new JPopupMenu("Edge options");
        Do.navigateEdgeMenu(m, this.m_ls);
        return m;
    }

    public void processSelectList(Vector edges, int key) {
        EntityInstance drawDst;
        EntityInstance drawSrc;
        RelationInstance edge;
        ResultBox resultBox = this.m_ls.getResultBox();
        resultBox.setResultTitle("SELECTED RELATIONS:");
        Enumeration en = edges.elements();
        while (en.hasMoreElements()) {
            edge = (RelationInstance)en.nextElement();
            drawSrc = edge.getDrawSrc();
            drawDst = edge.getDrawDst();
            switch (key) {
                case 105: {
                    drawSrc.orAllContainedSrcRelationsDstUnder(drawDst);
                    break;
                }
                case 79: {
                    drawDst.orDstRelationsSrcUnder(drawDst);
                    break;
                }
                case 111: {
                    drawSrc.orSrcRelationsDstUnder(drawDst);
                }
            }
        }
        en = edges.elements();
        block11: while (en.hasMoreElements()) {
            edge = (RelationInstance)en.nextElement();
            drawSrc = edge.getDrawSrc();
            drawDst = edge.getDrawDst();
            switch (key) {
                case 105: {
                    drawSrc.addSrcDstRelations(2048, resultBox);
                    continue block11;
                }
                case 79: {
                    drawDst.addDstRelations(2048, resultBox);
                    continue block11;
                }
                case 111: {
                    drawSrc.addSrcRelations(2048, resultBox);
                    continue block11;
                }
            }
            resultBox.addRelation(edge);
        }
        resultBox.validate();
        this.m_dg.selectEdges(edges);
    }

    protected void selectEntity(EntityInstance e) {
        if (e.getGroupFlag()) {
            if (e != this.m_dg.getKeyEntity()) {
                this.m_dg.setKeyEntity(e);
            }
        } else {
            EntityInstance old_ke = this.m_dg.getKeyEntity();
            if (old_ke != null) {
                this.m_dg.clearGroupFlags();
            }
            this.m_dg.setKeyEntity(e);
        }
    }

    protected void doHandleElision(int key, Object object) {
        Vector grp = this.m_dg.targetEntities(object);
        if (grp == null) {
            return;
        }
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance ge = (EntityInstance)en.nextElement();
            switch (key) {
                case 99: {
                    this.m_dg.toggleContainElision(ge);
                    break;
                }
                case 117: {
                    this.m_dg.toggleDstElision(ge);
                    break;
                }
                case 115: {
                    this.m_dg.toggleSrcElision(ge);
                    break;
                }
                case 85: {
                    if (!ge.isOpen()) break;
                    this.m_dg.toggleEnteringElision(ge);
                    break;
                }
                case 83: {
                    if (!ge.isOpen()) break;
                    this.m_dg.toggleExitingElision(ge);
                    break;
                }
                case 73: {
                    if (!ge.isOpen()) break;
                    this.m_dg.toggleInternalElision(ge);
                }
            }
        }
        this.m_dg.redrawDiagram();
    }

    protected void handleElision(int key, Object object) {
        String em = "";
        switch (key) {
            case 99: {
                em = "Containment";
                this.doHandleElision(key, object);
                break;
            }
            case 117: {
                em = "Target ";
                this.doHandleElision(key, object);
                break;
            }
            case 115: {
                em = "Source ";
                this.doHandleElision(key, object);
                break;
            }
            case 85: {
                em = "Entering";
                this.doHandleElision(key, object);
                break;
            }
            case 83: {
                em = "Exiting";
                this.doHandleElision(key, object);
                break;
            }
            case 73: {
                em = "Internal edges";
                this.doHandleElision(key, object);
            }
        }
        this.m_ls.doFeedback(em + " elision toggled for group");
    }

    protected void edgeNavigateSrc(Object object) {
        RelationInstance ri = this.m_dg.targetRelation(object);
        if (ri == null) {
            return;
        }
        this.navigateTo(ri.getSrc());
    }

    protected void edgeNavigateDst(Object object) {
        RelationInstance ri = this.m_dg.targetRelation(object);
        if (ri == null) {
            return;
        }
        this.navigateTo(ri.getDst());
    }

    protected void handleEdgeExpansion(int key, Object object) {
        String msg1;
        Vector edges = this.m_dg.targetRelations(object);
        if (edges == null) {
            return;
        }
        String msg = null;
        switch (key) {
            case 105: {
                msg1 = "Opened sources and destinations of edges.";
                break;
            }
            case 79: {
                msg1 = "Opened sources of edges.";
                break;
            }
            case 111: {
                msg1 = "Opened destination of edges.";
                break;
            }
            case 73: {
                msg1 = "Closed source and destination of edges";
                break;
            }
            case 67: {
                msg1 = "Closed source of edges";
                break;
            }
            default: {
                msg1 = "Closed source and destination of edges";
            }
        }
        EntityInstance drawRoot = this.m_dg.getDrawRoot();
        Enumeration en = edges.elements();
        while (en.hasMoreElements()) {
            EntityInstance dst;
            EntityInstance src;
            EntityInstance visible;
            RelationInstance ri = (RelationInstance)en.nextElement();
            block7 : switch (key) {
                case 79: 
                case 105: {
                    visible = ri.getDrawSrc();
                    src = ri.getSrc();
                    while ((src = src.getContainedBy()) != null) {
                        if (src.isDstRelationElided("contain")) {
                            src.clearContainElision();
                            msg = msg1;
                        }
                        if (src != visible) continue;
                        break block7;
                    }
                    break;
                }
                case 67: 
                case 73: {
                    dst = ri.getDst();
                    src = ri.getSrc();
                    while ((src = src.getContainedBy()) != null && drawRoot.hasDescendant(src) && src != dst && !src.hasDescendant(dst)) {
                        if (src.isDstRelationElided("contain")) continue;
                        src.setContainElision();
                        msg = msg1;
                    }
                    break;
                }
            }
            block11 : switch (key) {
                case 105: 
                case 111: {
                    visible = ri.getDrawDst();
                    dst = ri.getDst();
                    while ((dst = dst.getContainedBy()) != null) {
                        if (dst.isDstRelationElided("contain")) {
                            dst.clearContainElision();
                            msg = msg1;
                        }
                        if (dst != visible) continue;
                        break block11;
                    }
                    break;
                }
                case 73: 
                case 99: {
                    dst = ri.getDst();
                    src = ri.getSrc();
                    while ((dst = dst.getContainedBy()) != null && drawRoot.hasDescendant(dst) && src != dst && !dst.hasDescendant(src)) {
                        if (dst.isDstRelationElided("contain")) continue;
                        dst.setContainElision();
                        msg = msg1;
                    }
                    break;
                }
            }
        }
        if (msg != null) {
            this.processSelectList(edges, key);
            this.m_ls.doFeedback(msg);
            this.m_ls.redrawDg();
        } else {
            switch (key) {
                case 79: 
                case 105: 
                case 111: {
                    msg = "No further expansion is possible";
                    break;
                }
                default: {
                    msg = "No further contraction is possible";
                }
            }
            this.m_ls.error(msg);
        }
    }

    protected boolean goodQueryEdge(EntityInstance src, EntityInstance dst, EntityInstance root) {
        if (src.hasDescendant(dst) || dst.hasDescendant(src)) {
            return false;
        }
        if (src.isClientOrSupplier()) {
            return root.hasDescendant(dst);
        }
        return true;
    }

    protected int addToForwardEntityList(EntityInstance te, EntityInstance e, RelationClass rc, Vector list) {
        EntityInstance root = this.m_dg.getDrawRoot();
        int num = 0;
        Enumeration en = e.srcLiftedRelationElements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (ri.getRelationClass() != rc) continue;
            EntityInstance dst = ri.getDst();
            EntityInstance vdst = ri.getDrawDst();
            if (vdst == null || !this.goodQueryEdge(te, dst, root)) continue;
            ri.setHighlightFlag();
            dst.setRedBoxFlag();
            if (list.indexOf(vdst) >= 0) continue;
            vdst.setRedBoxFlag();
            if (this.m_ls.getGroupQueryFlag()) {
                vdst.setGroupFlag();
            }
            list.addElement(vdst);
            ++num;
        }
        return num;
    }

    protected int addForwardRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln) {
        Vector list = new Vector();
        int num = this.addToForwardEntityList(e, e, rc, list);
        if (num > 0 || alwaysShowReln) {
            resultBox.addForwardRelation(e, rc, list);
        }
        return num;
    }

    protected int showForwardEdges(EntityInstance e, ResultBox resultBox) {
        int num = 0;
        if (!e.isSupplier()) {
            Enumeration en = this.m_dg.enumRelationClasses();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                if (!rc.isActive()) continue;
                num += this.addForwardRelation(e, rc, resultBox, false);
            }
        }
        return num;
    }

    protected void getSrcRelationWithClosure(EntityInstance e, Vector list) {
        EntityInstance root = this.m_dg.getDrawRoot();
        Enumeration en = e.srcRelationElements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            EntityInstance dst = ri.getDst();
            boolean visited = dst.isMarked(32768);
            ri.setHighlightFlag();
            if (list.indexOf(ri) < 0) {
                list.addElement(ri);
            }
            if (visited) continue;
            dst.setRedBoxFlag();
            if (this.m_ls.getGroupQueryFlag()) {
                dst.setGroupFlag();
            }
            this.getSrcRelationWithClosure(dst, list);
        }
    }

    protected int addRelations(EntityInstance e, RelationClass rc, Vector list, ResultBox resultBox, boolean src) {
        int num = 0;
        if (list.size() > 0) {
            Vector<RelationInstance> sublist = new Vector<RelationInstance>();
            Enumeration en = list.elements();
            while (en.hasMoreElements()) {
                RelationInstance ri = (RelationInstance)en.nextElement();
                if (ri.getRelationClass() != rc) continue;
                ri.setHighlightFlag();
                sublist.add(ri);
                ++num;
            }
            if (num > 0) {
                resultBox.addRelations(e, rc, sublist, src);
            }
        }
        return num;
    }

    protected int showSrcEdgesWithClosure(EntityInstance e, ResultBox resultBox) {
        Vector list = new Vector();
        int num = 0;
        this.m_dg.clearQueryFlags();
        this.getSrcRelationWithClosure(e, list);
        this.m_dg.clearQueryFlags();
        Enumeration en = this.m_dg.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (!rc.isActive()) continue;
            num += this.addRelations(e, rc, list, resultBox, true);
        }
        return num;
    }

    public int addToBackEntityList(EntityInstance te, EntityInstance e, RelationClass rc, Vector list) {
        int num = 0;
        EntityInstance root = this.m_dg.getDrawRoot();
        Enumeration en = e.dstLiftedRelationElements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            if (ri.getRelationClass() != rc) continue;
            EntityInstance src = ri.getSrc();
            EntityInstance vsrc = ri.getDrawSrc();
            if (vsrc == null || !this.goodQueryEdge(src, te, root)) continue;
            ri.setHighlightFlag();
            src.setRedBoxFlag();
            if (list.indexOf(vsrc) >= 0) continue;
            vsrc.setRedBoxFlag();
            if (this.m_ls.getGroupQueryFlag()) {
                vsrc.setGroupFlag();
            }
            list.addElement(vsrc);
            ++num;
        }
        return num;
    }

    public int addBackRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln) {
        Vector list = new Vector();
        int num = this.addToBackEntityList(e, e, rc, list);
        if (num > 0 || alwaysShowReln) {
            resultBox.addBackRelation(e, rc, list);
        }
        return num;
    }

    public int showBackEdges(EntityInstance e, ResultBox resultBox) {
        int num = 0;
        if (!e.isClient()) {
            Enumeration en = this.m_dg.enumRelationClasses();
            while (en.hasMoreElements()) {
                RelationClass rc = (RelationClass)en.nextElement();
                if (!rc.isActive()) continue;
                num += this.addBackRelation(e, rc, resultBox, false);
            }
        }
        return num;
    }

    protected void getDstRelationWithClosure(EntityInstance e, Vector list) {
        Enumeration en = e.dstRelationElements();
        while (en.hasMoreElements()) {
            RelationInstance ri = (RelationInstance)en.nextElement();
            EntityInstance src = ri.getSrc();
            boolean visited = src.isMarked(32768);
            ri.setHighlightFlag();
            if (list.indexOf(ri) < 0) {
                list.addElement(ri);
            }
            if (visited) continue;
            src.setRedBoxFlag();
            if (this.m_ls.getGroupQueryFlag()) {
                src.setGroupFlag();
            }
            this.getDstRelationWithClosure(src, list);
        }
    }

    protected int showDstEdgesWithClosure(EntityInstance e, ResultBox resultBox) {
        Vector list = new Vector();
        int num = 0;
        this.m_dg.clearQueryFlags();
        this.getDstRelationWithClosure(e, list);
        this.m_dg.clearQueryFlags();
        Enumeration en = this.m_dg.enumRelationClasses();
        while (en.hasMoreElements()) {
            RelationClass rc = (RelationClass)en.nextElement();
            if (!rc.isActive()) continue;
            num += this.addRelations(e, rc, list, resultBox, false);
        }
        return num;
    }

    protected int showContents(EntityInstance e, ResultBox resultBox) {
        Vector list = new Vector();
        int n = 0;
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            list.add(en.nextElement());
            ++n;
        }
        if (n > 0) {
            SortVector.byString(list);
        }
        resultBox.addContents(e, list);
        return n;
    }

    protected int showContentsWithClosure(EntityInstance e, ResultBox resultBox) {
        int n = this.showContents(e, resultBox);
        Enumeration en = e.getChildren();
        while (en.hasMoreElements()) {
            n += this.showContentsWithClosure((EntityInstance)en.nextElement(), resultBox);
        }
        return n;
    }

    protected int doQueryEntity(EntityInstance e, int query, ResultBox resultBox) {
        switch (query) {
            case 102: {
                return this.showForwardEdges(e, resultBox);
            }
            case 98: {
                return this.showBackEdges(e, resultBox);
            }
            case 70: {
                return this.showSrcEdgesWithClosure(e, resultBox);
            }
            case 66: {
                return this.showDstEdgesWithClosure(e, resultBox);
            }
            case 67: {
                return this.showContents(e, resultBox);
            }
            case 65: {
                return this.showContentsWithClosure(e, resultBox);
            }
        }
        return 0;
    }

    protected void queryEntity(int query, Object object) {
        String title;
        ResultBox resultBox = this.m_ls.getResultBox();
        Vector grp = this.m_dg.targetEntities(object);
        if (!this.m_dg.getQueryPersistance()) {
            this.m_dg.clearQueryFlags();
        }
        switch (query) {
            case 102: {
                title = "FORWARD QUERY";
                break;
            }
            case 70: {
                title = "FORWARD QUERY (closure)";
                break;
            }
            case 98: {
                title = "BACKWARD QUERY";
                break;
            }
            case 66: {
                title = "BACKWARD QUERY (closure)";
                break;
            }
            default: {
                title = null;
            }
        }
        resultBox.setResultTitle(title);
        if (grp == null || grp.isEmpty()) {
            this.m_ls.error("No entity or group is selected");
            resultBox.validate();
            return;
        }
        int num = 0;
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance ge = (EntityInstance)en.nextElement();
            num += this.doQueryEntity(ge, query, resultBox);
        }
        if (num == 0) {
            resultBox.addText("NO ENTITIES");
        }
        resultBox.validate();
        this.m_dg.clearDrawEdges();
    }

    protected void queryContents(int key) {
        String title;
        ResultBox resultBox = this.m_ls.getResultBox();
        Vector grp = this.m_dg.getGroup();
        switch (key) {
            case 65: {
                title = "CONTENTS (CLOSURE)";
                break;
            }
            case 67: {
                title = "CONTENTS";
                break;
            }
            default: {
                title = null;
            }
        }
        resultBox.setResultTitle(title);
        if (grp == null || grp.isEmpty()) {
            this.doQueryEntity(this.m_dg.getDrawRoot(), key, resultBox);
            resultBox.validate();
            return;
        }
        int num = 0;
        Enumeration en = grp.elements();
        while (en.hasMoreElements()) {
            EntityInstance ge = (EntityInstance)en.nextElement();
            num += this.doQueryEntity(ge, key, resultBox);
        }
        if (num == 0) {
            resultBox.addText("NO ENTITIES");
        }
        resultBox.validate();
    }

    protected void doScaleEntity(EntityInstance ge, int scale, boolean incFlag) {
        switch (scale) {
            case 120: {
                ge.scaleX(0.8, incFlag);
                break;
            }
            case 88: {
                ge.scaleX(1.2, incFlag);
                break;
            }
            case 121: {
                ge.scaleY(0.8, incFlag);
                break;
            }
            case 89: {
                ge.scaleY(1.2, incFlag);
                break;
            }
            case 122: {
                ge.scale(0.8, incFlag);
                break;
            }
            case 90: {
                ge.scale(1.2, incFlag);
            }
        }
    }

    protected void scaleEntity(int scale, boolean incFlag) {
        Vector grp = this.m_dg.getGroup();
        if (grp != null) {
            switch (grp.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    if (grp.firstElement() == this.m_dg.getDrawRoot()) break;
                }
                default: {
                    Enumeration en = grp.elements();
                    while (en.hasMoreElements()) {
                        EntityInstance ge = (EntityInstance)en.nextElement();
                        this.doScaleEntity(ge, scale, incFlag);
                    }
                    break block0;
                }
            }
        }
        switch (scale) {
            case 90: {
                if (this.m_dg.zoom(1.2, 1.2)) {
                    this.m_ls.doFeedback("Zoomed in (20%)");
                }
                return;
            }
            case 122: {
                if (this.m_dg.zoom(0.8, 0.8)) {
                    this.m_ls.doFeedback("Zoomed out (20%)");
                }
                return;
            }
            case 88: {
                if (this.m_dg.zoom(1.2, 1.0)) {
                    this.m_ls.doFeedback("Scaled X direction (20%)");
                }
                return;
            }
            case 120: {
                if (this.m_dg.zoom(0.8, 1.0)) {
                    this.m_ls.doFeedback("Scaled X direction (-20%)");
                }
                return;
            }
            case 89: {
                if (this.m_dg.zoom(1.0, 1.2)) {
                    this.m_ls.doFeedback("Scaled Y direction (20%)");
                }
                return;
            }
            case 121: {
                if (this.m_dg.zoom(1.0, 0.8)) {
                    this.m_ls.doFeedback("Scaled Y direction (-20%)");
                }
                return;
            }
        }
    }

    protected boolean exclusiveEntityCommand(int key) {
        switch (key) {
            case 10: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                return true;
            }
        }
        return false;
    }

    protected void navigateTo(EntityInstance e) {
        this.m_ls.followLink(e, false);
    }

    protected boolean handleCommands(int key, int modifiers, Object object) {
        block29: {
            block31: {
                block30: {
                    block28: {
                        if (modifiers != 2) break block28;
                        switch (key) {
                            case 97: {
                                this.m_groupingHandler.groupAll();
                                break block29;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if ((modifiers & 8) == 0) break block30;
                    switch (key) {
                        case 65: {
                            this.queryContents(key);
                            break block29;
                        }
                        case 67: 
                        case 73: 
                        case 79: 
                        case 99: 
                        case 105: 
                        case 111: {
                            this.handleEdgeExpansion(key, object);
                            return true;
                        }
                        case 78: {
                            this.edgeNavigateSrc(object);
                            return true;
                        }
                        case 110: {
                            this.edgeNavigateDst(object);
                            return true;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (modifiers != 1) break block31;
                switch (key) {
                    case 10: {
                        EntityInstance e = this.m_dg.targetEntity(object);
                        if (e == null) {
                            return false;
                        }
                        this.m_dg.setDrawRoot(e);
                        this.m_dg.navigateToDrawRootParent();
                        break block29;
                    }
                    default: {
                        return false;
                    }
                }
            }
            switch (key) {
                case 67: {
                    this.queryContents(key);
                    break;
                }
                case 66: 
                case 70: 
                case 98: 
                case 102: {
                    this.queryEntity(key, object);
                    break;
                }
                case 73: 
                case 83: 
                case 85: 
                case 99: 
                case 115: 
                case 117: {
                    this.handleElision(key, object);
                    break;
                }
                case 88: 
                case 89: 
                case 90: 
                case 120: 
                case 121: 
                case 122: {
                    this.m_ls.beginUndoRedo("Scale");
                    this.scaleEntity(key, !this.mouseIsDown);
                    this.m_ls.endUndoRedo();
                    break;
                }
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    this.m_ls.beginUndoRedo("Move");
                    this.m_groupingHandler.moveGroup(key);
                    this.m_ls.endUndoRedo();
                    break;
                }
                case 10: {
                    EntityInstance e = this.m_dg.targetEntity(object);
                    if (e == null) {
                        return false;
                    }
                    EntityInstance drawRoot = this.m_dg.getDrawRoot();
                    if (e == drawRoot) {
                        this.m_ls.error("Already in: " + e.getLabel());
                        break;
                    }
                    if (e == drawRoot.getContainedBy()) {
                        this.navigateTo(e);
                        break;
                    }
                    if (e.isClientOrSupplier()) {
                        if (e.hasChildren()) {
                            this.navigateTo(e);
                            break;
                        }
                        this.navigateTo(e.getEnterableParent());
                        break;
                    }
                    while (e.getContainedBy() != drawRoot && !e.getContainedBy().isEnterable()) {
                        e = e.getContainedBy();
                    }
                    if (e.isEnterable()) {
                        this.navigateTo(e);
                        break;
                    }
                    this.m_ls.error("Can't navigate into: " + e.getLabel());
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        this.m_ls.redrawDg();
        return true;
    }

    public ViewModeHandler() {
        this.m_moveHandler = new MoveModeHandler();
        this.m_resizeHandler = new ResizeModeHandler();
        this.m_navHandler = new NavigateModeHandler();
        this.m_groupingHandler = new GroupModeHandler(this);
    }

    public void init(LandscapeViewerCore ls) {
        super.init(ls);
        this.m_moveHandler.init(ls);
        this.m_resizeHandler.init(ls);
        this.m_navHandler.init(ls);
        this.m_groupingHandler.init(ls);
    }

    public void select(Diagram dg) {
        super.select(dg);
        this.m_moveHandler.select(dg);
        this.m_resizeHandler.select(dg);
        this.m_navHandler.select(dg);
        this.m_groupingHandler.select(dg);
    }

    public void cleanup() {
        super.cleanup();
        this.m_moveHandler.cleanup();
        this.m_resizeHandler.cleanup();
        this.m_navHandler.cleanup();
        this.m_groupingHandler.cleanup();
    }

    public void processKey(int key, int modifiers, Object object) {
        if ((modifiers & 8) != 0) {
            switch (key) {
                case 67: 
                case 73: 
                case 79: 
                case 99: 
                case 105: 
                case 111: {
                    this.handleEdgeExpansion(key, object);
                    return;
                }
                case 78: {
                    this.edgeNavigateSrc(object);
                    return;
                }
                case 110: {
                    this.edgeNavigateDst(object);
                    return;
                }
            }
        }
        this.handleCommands(key, modifiers, object);
    }

    protected static void usesObject(Object c, Object object) {
        if (c instanceof MyMenuItem) {
            ((MyMenuItem)c).setObject(object);
            return;
        }
        if (c instanceof JMenu) {
            JMenu c1 = (JMenu)c;
            int i = c1.getItemCount();
            while (i > 0) {
                JMenuItem item;
                if ((item = c1.getItem(--i)) == null) continue;
                ViewModeHandler.usesObject(item, object);
            }
            return;
        }
        if (c instanceof Container) {
            Container c1 = (Container)c;
            int i = c1.getComponentCount();
            while (i > 0) {
                ViewModeHandler.usesObject(c1.getComponent(--i), object);
            }
            return;
        }
        System.out.println("ViewModeHandler.usesObject " + c);
    }

    public void rightClickEntity(MouseEvent ev, EntityInstance e, int x, int y) {
        JPopupMenu m;
        if (e == this.m_dg.getRootInstance()) {
            m = this.m_rootEntityPopup;
            if (m == null) {
                this.m_rootEntityPopup = m = this.buildRootPopup();
            }
        } else {
            m = this.m_entityPopup;
            if (m == null) {
                this.m_entityPopup = m = this.buildEntityPopup();
            }
        }
        ViewModeHandler.usesObject(m, e);
        this.m_ls.add(m);
        m.show(this.m_ls.getContentPane(), this.m_ls.getDiagramX() + x, this.m_ls.getDiagramY() + y);
    }

    public void rightClickRelation(MouseEvent ev, RelationInstance ri, int x, int y) {
        JPopupMenu m = this.m_relationPopup;
        if (m == null) {
            this.m_relationPopup = m = this.buildRelationPopup();
        }
        ViewModeHandler.usesObject(m, ri);
        this.m_ls.add(m);
        m.show(this.m_ls.getContentPane(), this.m_ls.getDiagramX() + x, this.m_ls.getDiagramY() + y);
    }

    public boolean entityPressed(MouseEvent ev, EntityInstance e, int x, int y) {
        this.m_handler = null;
        if (ev.isMetaDown()) {
            this.rightClickEntity(ev, e, x, y);
        } else {
            this.mouseIsDown = true;
            this.curX = x;
            this.curY = y;
            if (e == this.m_dg.getDrawRoot() && this.m_dg.clearFlags()) {
                this.m_dg.redrawDiagram();
            }
            LandscapeModeHandler newHandler = null;
            if (ev.isControlDown()) {
                if (this.m_navHandler.entityPressed(ev, e, x, y)) {
                    newHandler = this.m_navHandler;
                }
            } else if (ev.isShiftDown()) {
                if (this.m_groupingHandler.entityPressed(ev, e, x, y)) {
                    newHandler = this.m_groupingHandler;
                }
            } else if (this.m_resizeHandler.entityPressed(ev, e, x, y)) {
                newHandler = this.m_resizeHandler;
            } else if (this.m_moveHandler.entityPressed(ev, e, x, y)) {
                newHandler = this.m_moveHandler;
            } else if (this.m_groupingHandler.entityPressed(ev, e, x, y)) {
                newHandler = this.m_groupingHandler;
            }
            if (newHandler != null) {
                this.m_handler = newHandler;
            }
        }
        return true;
    }

    public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.mouseIsDown) {
            long newUp = ev.getWhen();
            if (newUp - this.m_lastUp < 300L) {
                this.m_ls.setCursor(0);
                this.mouseDoubleClick(ev, e);
                this.m_lastUp = 0L;
            } else if (this.m_handler != null) {
                this.m_handler.entityReleased(ev, e, x, y);
            }
            this.m_lastUp = newUp;
            this.mouseIsDown = false;
        }
    }

    public boolean relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) {
        this.m_handler = null;
        if (ev.isMetaDown()) {
            this.rightClickRelation(ev, ri, x, y);
        } else {
            this.mouseIsDown = true;
            this.m_dg.clearFlags();
            this.curX = x;
            this.curY = y;
            LandscapeModeHandler newHandler = null;
            if (!ev.isControlDown()) {
                if (ev.isShiftDown()) {
                    if (this.m_groupingHandler.relationPressed(ev, ri, x, y)) {
                        newHandler = this.m_groupingHandler;
                    }
                } else if (this.m_moveHandler.relationPressed(ev, ri, x, y)) {
                    newHandler = this.m_moveHandler;
                } else if (this.m_groupingHandler.relationPressed(ev, ri, x, y)) {
                    newHandler = this.m_groupingHandler;
                }
                if (newHandler != null) {
                    this.m_handler = newHandler;
                }
            }
        }
        return true;
    }

    public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.mouseIsDown) {
            if (this.m_handler != null) {
                long newUp = ev.getWhen();
                if (newUp - this.m_lastUp < 300L) {
                    this.m_ls.setCursor(0);
                    this.mouseDoubleClick(ev, ri);
                    this.m_lastUp = 0L;
                } else {
                    this.m_lastUp = newUp;
                    this.m_handler.relationReleased(ev, ri, x, y);
                }
            }
            this.mouseIsDown = false;
        }
    }

    public void mouseDoubleClick(MouseEvent ev, Object object) {
        this.m_ls.processKey(10, ev.getModifiers() & 0xF, object);
    }

    public void movedOverThing(MouseEvent ev, Object thing, int x, int y) {
        int zn;
        EntityInstance e;
        if (thing instanceof EntityInstance && (e = (EntityInstance)thing) != this.m_dg.getDrawRoot() && e.getGroupKeyFlag() && (zn = e.overResizeTab(x, y)) != -1) {
            this.m_ls.setAnticipateCursor(this.resizeCursor[zn]);
            return;
        }
    }

    public boolean entityDragged(MouseEvent ev, EntityInstance e, int x, int y) {
        if (this.m_handler != null) {
            return this.m_handler.entityDragged(ev, e, x, y);
        }
        return false;
    }

    public boolean relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) {
        if (this.m_handler != null) {
            return this.m_handler.relationDragged(ev, ri, x, y);
        }
        return false;
    }
}

