/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import lsedit.LandscapeViewerCore;

public class Vista
implements Pageable,
Printable {
    static final String[] m_names = new String[]{"All", "Diagram", "TOC", "Results", "Legend", "Map", "Query"};
    static final String[] m_text = new String[]{"Maximum pages : ", "Maximum across: ", "Maximum down  : "};
    public static final int PRINT_ALL = 0;
    public static final int PRINT_DIAGRAM = 1;
    public static final int PRINT_TOC = 2;
    public static final int PRINT_RESULT = 3;
    public static final int PRINT_LEGEND = 4;
    public static final int PRINT_MAP = 5;
    public static final int PRINT_QUERY = 6;
    private int m_printing;
    private JComponent m_Component;
    private int m_NumPagesX;
    private int m_NumPagesY;
    private int m_NumPages;
    private int m_pixels_per_page_x;
    private int m_pixels_per_page_y;
    private PrinterJob m_printerJob;
    private PageFormat m_Format;
    private double m_ScaleX;
    private double m_ScaleY;

    public Vista(LandscapeViewerCore ls) {
        PrintWhat printWhat = new PrintWhat(ls);
        this.m_printing = printWhat.getPrinting();
        JComponent component = printWhat.getComponent();
        if (component == null) {
            ls.doFeedback("No component selected to print");
            return;
        }
        this.m_Component = component;
        double width = component.getWidth();
        double height = component.getHeight();
        if (width < 1.0 || height < 1.0) {
            ls.doFeedback("Component has no size");
            return;
        }
        int pages = printWhat.getPages();
        int maxX = printWhat.getMaxX();
        int maxY = printWhat.getMaxY();
        switch (pages) {
            case 0: {
                return;
            }
            case -2: {
                ls.doFeedback("Invalid number of print pages specified");
                return;
            }
        }
        switch (maxX) {
            case 0: {
                return;
            }
            case -2: {
                ls.doFeedback("Invalid maximum pages across");
                return;
            }
        }
        switch (maxY) {
            case 0: {
                return;
            }
            case -2: {
                ls.doFeedback("Invalid maximum pages down");
                return;
            }
        }
        this.m_printerJob = PrinterJob.getPrinterJob();
        this.m_printerJob.setPageable(this);
        try {
            if (this.m_printerJob.printDialog()) {
                this.m_Format = this.m_printerJob.defaultPage();
                this.m_Format = this.m_printerJob.pageDialog(this.m_Format);
                double imageableWidth = this.m_Format.getImageableWidth();
                double imageableHeight = this.m_Format.getImageableHeight();
                if (imageableWidth < 1.0 || imageableHeight < 1.0) {
                    ls.doFeedback("Output pages have no size");
                    return;
                }
                double scaleX = imageableWidth / width;
                double scaleY = imageableHeight / height;
                this.m_NumPagesX = 1;
                this.m_NumPagesY = 1;
                if (pages != -1 || maxX != -1 || maxY != -1) {
                    block20: while (true) {
                        if (scaleX <= scaleY) {
                            if (pages != -1 && (this.m_NumPagesX + 1) * this.m_NumPagesY > pages) break;
                            switch (maxX) {
                                case -1: {
                                    ++this.m_NumPagesX;
                                    scaleX = (double)this.m_NumPagesX * imageableWidth / width;
                                    continue block20;
                                }
                            }
                            if (this.m_NumPagesX >= maxX) break;
                            ++this.m_NumPagesX;
                            scaleX = (double)this.m_NumPagesX * imageableWidth / width;
                            continue;
                        }
                        if (pages != -1 && (this.m_NumPagesY + 1) * this.m_NumPagesX > pages) break;
                        switch (maxY) {
                            case -1: {
                                ++this.m_NumPagesY;
                                scaleY = (double)this.m_NumPagesY * imageableHeight / height;
                                continue block20;
                            }
                        }
                        if (this.m_NumPagesY >= maxY) break;
                        ++this.m_NumPagesY;
                        scaleY = (double)this.m_NumPagesY * imageableHeight / height;
                    }
                }
                if (scaleX < scaleY) {
                    this.m_pixels_per_page_x = 1 + (component.getWidth() - 1) / this.m_NumPagesX;
                    this.m_pixels_per_page_y = (int)((double)this.m_pixels_per_page_x * (imageableHeight / imageableWidth));
                    scaleY = scaleX;
                } else {
                    this.m_pixels_per_page_y = 1 + (component.getHeight() - 1) / this.m_NumPagesY;
                    this.m_pixels_per_page_x = (int)((double)this.m_pixels_per_page_y * (imageableWidth / imageableHeight));
                    scaleX = scaleY;
                }
                this.m_ScaleX = scaleX;
                this.m_ScaleY = scaleY;
                this.m_NumPages = this.m_NumPagesX * this.m_NumPagesY;
                PrintConfirm printConfirm = new PrintConfirm(ls);
                if (printConfirm.isOk()) {
                    ls.doFeedback("Printing " + this.m_NumPages + " pages (" + this.m_NumPagesX + " across " + this.m_NumPagesY + " down)");
                    this.m_printerJob.print();
                } else {
                    ls.doFeedback("Printing cancelled");
                }
            }
        }
        catch (PrinterException e) {
            System.out.println(e);
        }
    }

    public int getNumberOfPages() {
        if (this.m_NumPages < 0) {
            return -1;
        }
        return this.m_NumPages;
    }

    protected PageFormat getPageFormat() {
        return this.m_Format;
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex >= this.m_NumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0 || pageIndex >= this.m_NumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= 0 && pageIndex < this.m_NumPages) {
            int yLeft;
            int yPage = pageIndex / this.m_NumPagesX;
            int xPage = pageIndex - yPage * this.m_NumPagesX;
            int xOffset = xPage * this.m_pixels_per_page_x;
            int yOffset = yPage * this.m_pixels_per_page_y;
            int xLeft = this.m_Component.getWidth() - xOffset;
            if (xLeft > this.m_pixels_per_page_x) {
                xLeft = this.m_pixels_per_page_x;
            }
            if ((yLeft = this.m_Component.getHeight() - yOffset) > this.m_pixels_per_page_y) {
                yLeft = this.m_pixels_per_page_y;
            }
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(this.m_Format.getImageableX() - (double)xOffset, this.m_Format.getImageableY() - (double)yOffset);
            g2.scale(this.m_ScaleX, this.m_ScaleY);
            boolean wasBuffered = this.m_Component.isDoubleBuffered();
            this.m_Component.setDoubleBuffered(false);
            this.m_Component.paint(g2);
            this.m_Component.setDoubleBuffered(wasBuffered);
            return 0;
        }
        return 1;
    }

    public class PrintConfirm
    extends JDialog
    implements ActionListener {
        protected JButton m_ok;
        protected JButton m_cancel;
        protected boolean m_isOk;

        public PrintConfirm(LandscapeViewerCore ls) {
            super(ls.getFrame(), "Confirm", true);
            this.m_isOk = false;
            JFrame frame = ls.getFrame();
            this.setLocation(frame.getX() + 200, frame.getY() + 300);
            this.setForeground(new Color(0, 0, 0));
            this.setBackground(new Color(192, 192, 192));
            this.setFont(new Font("Dialog", 0, 12));
            Container contentPane = this.getContentPane();
            JPanel grid = new JPanel();
            grid.setLayout(new GridLayout(0, 1));
            block24: for (int i = 0; i < 17; ++i) {
                String s;
                block0 : switch (i) {
                    case 0: {
                        s = "Printing: " + m_names[Vista.this.m_printing];
                        break;
                    }
                    case 1: {
                        s = "To: " + Vista.this.m_printerJob.getPrintService();
                        break;
                    }
                    case 2: {
                        s = "Orient: ";
                        switch (Vista.this.m_Format.getOrientation()) {
                            case 1: {
                                s = s + "Portrait";
                                break block0;
                            }
                            case 0: {
                                s = s + "Landscape";
                                break block0;
                            }
                            case 2: {
                                s = s + "Reverse Landscape";
                                break block0;
                            }
                        }
                        s = s + "??";
                        break;
                    }
                    case 3: {
                        s = "Width: " + Vista.this.m_Format.getWidth() / 72.0 + " inches";
                        break;
                    }
                    case 4: {
                        s = "Height: " + Vista.this.m_Format.getHeight() / 72.0 + " inches";
                        break;
                    }
                    case 5: {
                        int copies = Vista.this.m_printerJob.getCopies();
                        if (copies == 1) continue block24;
                        s = "Copies: " + copies;
                        break;
                    }
                    case 6: {
                        if (Vista.this.m_NumPages == 1) continue block24;
                        s = "Shape: " + Vista.this.m_NumPagesX + " x " + Vista.this.m_NumPagesY + " pages";
                        break;
                    }
                    case 7: {
                        s = "Pages: " + Vista.this.m_NumPages;
                        break;
                    }
                    case 8: {
                        s = "Scale: " + Vista.this.m_ScaleX;
                        break;
                    }
                    case 9: {
                        s = "";
                        break;
                    }
                    case 10: {
                        s = "Component width: " + Vista.this.m_Component.getWidth() + " pixels";
                        break;
                    }
                    case 11: {
                        s = "Component height: " + Vista.this.m_Component.getHeight() + " pixels";
                        break;
                    }
                    case 12: {
                        s = "Imageable x: " + Vista.this.m_Format.getImageableX() / 72.0 + " inches";
                        break;
                    }
                    case 13: {
                        s = "Imageable y: " + Vista.this.m_Format.getImageableY() / 72.0 + " inches";
                        break;
                    }
                    case 14: {
                        s = "Imageable width: " + Vista.this.m_Format.getImageableWidth() / 72.0 + " inches";
                        break;
                    }
                    case 15: {
                        s = "Imageable height: " + Vista.this.m_Format.getImageableHeight() / 72.0 + " inches";
                        break;
                    }
                    case 16: {
                        s = "";
                        break;
                    }
                    default: {
                        s = "????";
                    }
                }
                JLabel label = new JLabel(s);
                grid.add(label);
            }
            contentPane.add((Component)grid, "Center");
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            panel.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            panel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            contentPane.add((Component)panel, "South");
            this.pack();
            this.show();
        }

        public boolean isOk() {
            return this.m_isOk;
        }

        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == this.m_ok) {
                this.m_isOk = true;
                this.setVisible(false);
                return;
            }
            if (source == this.m_cancel) {
                this.setVisible(false);
                return;
            }
        }
    }

    public class PrintWhat
    extends JDialog
    implements ActionListener {
        protected LandscapeViewerCore m_ls;
        protected ButtonGroup m_buttonGroup;
        protected JRadioButton[] m_radioButtons;
        protected JTextField[] m_pages;
        protected JButton m_ok;
        protected JButton m_cancel;
        protected int m_printing;
        protected int[] m_print_pages;

        public PrintWhat(LandscapeViewerCore ls) {
            JPanel panel;
            int i;
            super(ls.getFrame(), "Print", true);
            this.m_printing = -1;
            this.m_print_pages = new int[]{-2, -2, -2};
            this.m_ls = ls;
            JFrame frame = ls.getFrame();
            this.setLocation(frame.getX() + 200, frame.getY() + 300);
            this.setForeground(new Color(0, 0, 0));
            this.setBackground(new Color(192, 192, 192));
            this.setFont(new Font("Dialog", 0, 12));
            Container contentPane = this.getContentPane();
            JPanel grid = new JPanel();
            grid.setLayout(new GridLayout(0, 1));
            this.m_pages = new JTextField[3];
            for (i = 0; i < 3; ++i) {
                panel = new JPanel();
                panel.setLayout(new FlowLayout());
                JLabel label = new JLabel(m_text[i]);
                panel.add(label);
                this.m_pages[i] = new JTextField("", 5);
                panel.add(this.m_pages[i]);
                grid.add(panel);
            }
            int cnt = m_names.length;
            this.m_buttonGroup = new ButtonGroup();
            this.m_radioButtons = new JRadioButton[cnt];
            for (i = 0; i < cnt; ++i) {
                JRadioButton radioButton;
                this.m_radioButtons[i] = radioButton = new JRadioButton(m_names[i]);
                this.m_buttonGroup.add(radioButton);
                grid.add(radioButton);
            }
            contentPane.add((Component)grid, "Center");
            panel = new JPanel();
            panel.setLayout(new FlowLayout());
            this.m_ok = new JButton("Ok");
            panel.add(this.m_ok);
            this.m_ok.addActionListener(this);
            this.m_cancel = new JButton("Cancel");
            panel.add(this.m_cancel);
            this.m_cancel.addActionListener(this);
            contentPane.add((Component)panel, "South");
            this.pack();
            this.show();
        }

        public int getPages() {
            return this.m_print_pages[0];
        }

        public int getMaxX() {
            return this.m_print_pages[1];
        }

        public int getMaxY() {
            return this.m_print_pages[2];
        }

        public int getPrinting() {
            return this.m_printing;
        }

        public JComponent getComponent() {
            LandscapeViewerCore ls = this.m_ls;
            JComponent c = null;
            switch (this.m_printing) {
                case 0: {
                    c = ls.getContentPane();
                    break;
                }
                case 1: {
                    c = ls.getDiagram();
                    break;
                }
                case 2: {
                    c = ls.getTocBox();
                    break;
                }
                case 3: {
                    c = ls.getResultBox();
                    break;
                }
                case 4: {
                    c = ls.getLegendBox();
                    break;
                }
                case 5: {
                    c = ls.getMapBox();
                    break;
                }
                case 6: {
                    c = ls.getQueryBox();
                }
            }
            return c;
        }

        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source == this.m_ok) {
                int i;
                for (i = 0; i < 3; ++i) {
                    String pages = this.m_pages[i].getText();
                    if ((pages = pages.trim()).length() == 0) {
                        this.m_print_pages[i] = -1;
                        continue;
                    }
                    try {
                        this.m_print_pages[i] = Integer.parseInt(pages);
                        continue;
                    }
                    catch (Throwable exception) {
                        this.m_print_pages[i] = -2;
                    }
                }
                int cnt = m_names.length;
                for (i = 0; i < cnt; ++i) {
                    JRadioButton radioButton = this.m_radioButtons[i];
                    if (!radioButton.isSelected()) continue;
                    this.m_printing = i;
                    break;
                }
                this.setVisible(false);
                return;
            }
            if (source == this.m_cancel) {
                this.m_printing = -2;
                this.setVisible(false);
                return;
            }
        }
    }
}

