package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

import java.util.Enumeration;
import java.util.Vector;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;

public class Diagram extends UndoableTa /* extends Ta extends JPanel */ implements MouseMotionListener, UndoableEditListener, DiagramCoordinates  
{
	class ExitFlag extends JComponent implements MouseListener
	{
		protected final static int EXIT_FLAG_DIM = 8;
		protected int	m_priorcursor = -1;

		public ExitFlag()
		{
			super();
			addMouseListener(this);
		}

		public void setLocation(int x, int y)
		{
			setBounds(x, y, EXIT_FLAG_DIM, EXIT_FLAG_DIM);
		}

		public void activate()
		{
			setVisible(true);
		}

		public void paintComponent(Graphics g)
		{
//			System.out.println("Diagram.ExitFlag.paintComponent()");

			super.paintComponent(g);

			/*  Draw a small mark as shown in top left of object

				x---
				|
				|   --------
				|  |        |
				   |        |
				   |        |
	  			   |  ----  |
				   |        |
				   |        |
				   |        |
				   |________|
			*/

			g.setColor(boxColour.darker());
			g.drawRect(0, 0, EXIT_FLAG_DIM, EXIT_FLAG_DIM);
			// g.setColor(Color.black);
			g.drawLine(2, 4, 6, 4);
//			System.out.println("Diagram.paintComponent() done");
		}

		// MouseListener interface

		public void mouseClicked(MouseEvent ev)	
		{
			if (m_priorcursor != -1) {
				getLs().setCursor(m_priorcursor); 
				m_priorcursor = -1;
			}
			navigateToDrawRootParent();
		}

		public void mouseEntered(MouseEvent e)
		{
			m_priorcursor = getLs().setCursor(Cursor.HAND_CURSOR);
//			System.out.println("m_priorcursor=" + m_priorcursor);
		}

		public void mouseExited(MouseEvent e)
		{
			if (m_priorcursor != -1) {
//				System.out.println("MouseExited " + m_priorcursor);
				getLs().setCursor(m_priorcursor); 
				m_priorcursor = -1;
		}	}

		public void mousePressed(MouseEvent ev)
		{
		}

		public void mouseReleased(MouseEvent ev)
		{
		}
	}

	class UpdateDiagramZoom extends MyUndoableEdit implements UndoableEdit
	{
		double				 m_oldX, m_oldY;
		double				 m_newX, m_newY;

		UpdateDiagramZoom(double x, double y)
		{
			m_oldX      = m_zoom_x;
			m_oldY      = m_zoom_y;
			m_newX      = x;
			m_newY      = y;
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return " Zoom diagram";
		}

		public void undo()
		{
			m_zoom_x = m_oldX;
			m_zoom_y = m_oldY;
			getPreferredSize();	
			redrawDiagram();
		}

		public void redo()
		{
			m_zoom_x = m_newX;
			m_zoom_y = m_newY;
			getPreferredSize();	
			redrawDiagram();
		}
	}	

	class UpdateNewEntity extends MyUndoableEdit implements UndoableEdit
	{
		EntityInstance		 m_e;

		UpdateNewEntity(EntityInstance container)
		{
			int				n;
			String			ename;
			EntityClass		ec;
			EntityInstance	e;

			for (n = 0; ; ++n) {
				ename = "Entity#" + n;
				if (!entityExists(ename)) {
					break;
			}	}

			ec  = m_defaultEntityClass;
			m_e = e = new EntityInstance(ec, ename);
			e.setContainedBy(container);
//			e.setRelLocal(0.25, 0.25, 0.5, 0.5);
//			System.out.println("UpdateNewEntity " + ec + " " + e);
			ec.makeInstanceOfUs(e);
			if (logEdit(this)) {
				redo();
		}	}

		public EntityInstance getEntity()
		{
			return m_e;
		}

		public String getPresentationName() 
		{
			return "Create entity " + m_e;
		}

		public void undo()
		{
			cutEntity(m_e);
			redrawDiagram();
		}

		public void redo()
		{
			pasteEntity(m_e.getContainedBy(), m_e);
			redrawDiagram();
		}
	}	
	
	class UpdateNewRelation extends MyUndoableEdit implements UndoableEdit
	{
		RelationInstance		 m_ri = null;

		UpdateNewRelation(EntityInstance from, EntityInstance to)
		{
			RelationClass		ec;

//			System.out.println("UpdateNewEntity " + ec + " " + e);
			if (logEdit(this)) {
				ec   = m_defaultRelationClass;
				m_ri = new RelationInstance(ec, from, to);
				from.addSrcRelation(m_ri);
				to.addDstRelation(m_ri);
		}	}

		public RelationInstance getRelation()
		{
			return m_ri;
		}

		public String getPresentationName() 
		{
			return "Create relation " + m_ri;
		}

		public void undo()
		{
			m_ri.getSrc().removeSrcRelation(m_ri);
			m_ri.getDst().removeDstRelation(m_ri);
			redrawDiagram();
		}

		public void redo()
		{
			m_ri.getSrc().addSrcRelation(m_ri);
			m_ri.getDst().addDstRelation(m_ri);
			redrawDiagram();
		}
	}	

	class UpdateCut extends MyUndoableEdit implements UndoableEdit
	{
		Vector	m_saved_clipboard;

		UpdateCut()
		{
			m_saved_clipboard = m_clipboard;
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return "Cut";
		}

		public void undo()
		{

			LandscapeEditorCore	ls;
			Enumeration			en;
			EntityInstance		e;

			ls      = getLs();
			for (en = m_saved_clipboard.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				pasteEntity(e.getContainedBy(), e);
			}
			m_clipboard = null;
			redrawDiagram();
		}

		public void redo()
		{
			LandscapeEditorCore	ls;
			Enumeration			en;
			EntityInstance		e;

			ls      = getLs();
			for (en = m_saved_clipboard.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				cutEntity(e);
			}
			m_clipboard = m_saved_clipboard;
			prepostorder();		// Can do at end when cutting
			redrawDiagram();
		}
	}	

	class UpdatePaste extends MyUndoableEdit implements UndoableEdit
	{
		Vector				m_saved_clipboard;
		EntityInstance[]	m_oldContainers;
		EntityInstance		m_container;

		UpdatePaste( EntityInstance container)
		{
			Vector				clipboard;
			LandscapeEditorCore	ls;
			Enumeration			en;
			EntityInstance		e;
			int					i;

			ls          = getLs();
			m_saved_clipboard = clipboard = m_clipboard;
			m_container       = container;
			m_oldContainers   = new EntityInstance[clipboard.size()];
			i = 0;
			for (en = clipboard.elements(); en.hasMoreElements(); ++i) {
				e = (EntityInstance) en.nextElement();
				m_oldContainers[i] = e.getContainedBy();
			}
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return "Paste";
		}

		public void undo()
		{
			LandscapeEditorCore	ls;
			Enumeration			en;
			EntityInstance		e;
			int					i;

			ls      = getLs();
			i       = 0;
			for (en = m_saved_clipboard.elements(); en.hasMoreElements(); ++i) {
				e = (EntityInstance) en.nextElement();
				cutEntity(e);
				e.setContainedBy(m_oldContainers[i]);
			}
			m_clipboard = m_saved_clipboard;
			prepostorder();		// Can do at end when cutting
			redrawDiagram();
		}

		public void redo()
		{
			LandscapeEditorCore	ls;
			Enumeration			en;
			EntityInstance		e;

			ls      = getLs();
			for (en = m_saved_clipboard.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				pasteEntity(m_container, e);
			}
			m_clipboard = null;
			redrawDiagram();
		}
	}	

	class UpdateRelayoutAll extends MyUndoableEdit implements UndoableEdit
	{
		// This is probably the cheapest storage cost
		// We have to cache and uncache the who operation without
		// intermediate redraws since the -1's will be corrected by a redrawer
		// before we are finished undoing..

		EntityInstance[]	m_entities;
		double[]			m_xRel;
		double[]			m_yRel;
		double[]			m_widthRel;
		double[]			m_heightRel;

		protected void saveInfo(EntityInstance e, int basePreorder)
		{
			{
				int	index          = e.getPreorderNumber() - basePreorder;
			
				m_entities[index]  = e;
				m_xRel[index]      = e.xRelLocal();
				m_yRel[index]      = e.yRelLocal();
				m_widthRel[index]  = e.widthRelLocal();
				m_heightRel[index] = e.heightRelLocal();
			}

			Enumeration		en;
			EntityInstance	e1;

			for (en = e.getChildren(); en.hasMoreElements(); ) {
				e1 = (EntityInstance) en.nextElement();
				saveInfo(e1, basePreorder);
		}	}

		UpdateRelayoutAll(EntityInstance container)
		{
			int	need = container.nodesInSubtree();

			m_entities  = new EntityInstance[need];
			m_xRel      = new double[need];
			m_yRel      = new double[need];
			m_widthRel  = new double[need];
			m_heightRel = new double[need];

			saveInfo(container, container.getPreorderNumber());

			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return "Relayout subtree " + m_entities[0];
		}

		public void undo()
		{
			EntityInstance[]	entities  = m_entities;
			double[]			xRel      = m_xRel;
			double[]			yRel      = m_yRel;
			double[]			widthRel  = m_widthRel;
			double[]			heightRel = m_heightRel;
			int					length    = entities.length;
			int					i;

			for (i = 0; i < length; ++i) {
				entities[i].setRelLocal(xRel[i], yRel[i], widthRel[i], heightRel[i]);
			}
			redrawDiagram();
		}

		public void redo()
		{
			EntityInstance[]	entities  = m_entities;
			double[]			xRel      = m_xRel;
			double[]			yRel      = m_yRel;
			double[]			widthRel  = m_widthRel;
			double[]			heightRel = m_heightRel;
			int					length    = entities.length;
			int					i;

			for (i = 0; i < length; ++i) {
				entities[i].setRelLocal(-1, -1, widthRel[i], heightRel[i]);
			}
			redrawDiagram();		
		}
	}	
	
	class UpdateRelayoutChildren extends MyUndoableEdit implements UndoableEdit
	{
		// This is probably the cheapest storage cost
		// We have to cache and uncache the who operation without
		// intermediate redraws since the -1's will be corrected by a redrawer
		// before we are finished undoing..

		EntityInstance[]	m_entities;
		double[]			m_xRel;
		double[]			m_yRel;
		double[]			m_widthRel;
		double[]			m_heightRel;

		UpdateRelayoutChildren(EntityInstance container)
		{
			int				need = container.numChildren();
			Enumeration		en;
			int				i    = 0;
			EntityInstance	e;
		
			m_entities  = new EntityInstance[need];
			m_xRel      = new double[need];
			m_yRel      = new double[need];
			m_widthRel  = new double[need];
			m_heightRel = new double[need];

			for (en = container.getChildren(); en.hasMoreElements(); ++i) {
				e = (EntityInstance) en.nextElement();
				m_entities[i]  = e;
				m_xRel[i]      = e.xRelLocal();
				m_yRel[i]      = e.yRelLocal();
				m_widthRel[i]  = e.widthRelLocal();
				m_heightRel[i] = e.heightRelLocal();
			}

			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return "Relayout children " + m_entities[0];
		}

		public void undo()
		{
			EntityInstance[]	entities  = m_entities;
			double[]			xRel      = m_xRel;
			double[]			yRel      = m_yRel;
			double[]			widthRel  = m_widthRel;
			double[]			heightRel = m_heightRel;
			int					length    = entities.length;
			int					i;

			for (i = 0; i < length; ++i) {
				entities[i].setRelLocal(xRel[i], yRel[i], widthRel[i], heightRel[i]);
			}
			redrawDiagram();
		}

		public void redo()
		{
			EntityInstance[]	entities  = m_entities;
			double[]			xRel      = m_xRel;
			double[]			yRel      = m_yRel;
			double[]			widthRel  = m_widthRel;
			double[]			heightRel = m_heightRel;
			int					length    = entities.length;
			int					i;

			for (i = 0; i < length; ++i) {
				entities[i].setRelLocal(-1, -1, widthRel[i], heightRel[i]);
			}
			redrawDiagram();		
		}
	}	
	
	public class RelayoutDialog extends JDialog implements ActionListener {

		LandscapeLayouter[]			m_layouters;

		protected ButtonGroup		m_buttonGroup;
		protected JRadioButton[]	m_radioButtons;
		protected JButton[]			m_buttons;

		protected JButton			m_ok;
		protected JButton			m_cancel;
		protected String			m_msg = null;
		
		public RelayoutDialog()
		{
			super(m_ls.getFrame(), "Reconfigure layouters", true);

			Container			contentPane;
			JPanel				grid;
			JPanel				panel;
			int					x, y;
			JRadioButton		radioButton;
			JButton				button;
			int					i;
			Font				font, bold;
			LandscapeLayouter   layouter;
			int				    layouts;

			m_layouters = m_ls.getLayouters();
			layouts     = m_layouters.length;
			layouter    = m_ls.getLayouter();

			font   = FontCache.getDialogFont();
			bold   = font.deriveFont(Font.BOLD);

			x      = Diagram.this.getX() + 20;
			y      = Diagram.this.getY() + 20;
			setLocation(x, y);
			setForeground(ColorCache.get(0,0,0));
			setBackground(ColorCache.get(192,192,192));
			setFont(font);

			contentPane = getContentPane();
	
			grid           = new JPanel();
			grid.setLayout(new GridLayout(layouts, 1, 10, 10));

			m_buttonGroup  = new ButtonGroup();
			m_radioButtons = new JRadioButton[layouts];
			m_buttons      = new JButton[layouts];

			for (i = 0; i < layouts; ++i) {
				m_radioButtons[i] = radioButton = new JRadioButton(m_layouters[i].getMenuLabel());
				radioButton.setFont(bold);
				if (m_layouters[i] == layouter) {
					radioButton.setSelected(true);
				}
				m_buttonGroup.add(radioButton);
				grid.add(radioButton);
			}
			contentPane.add(grid, BorderLayout.WEST);
			 
			grid           = new JPanel();
			grid.setLayout(new GridLayout(layouts, 1, 10, 10));

			for (i = 0; i < layouts; ++i) {
				if (m_layouters[i].isConfigurable()) {
					button = new JButton("configure");
				} else {
					button = new JButton("");
				}
				m_buttons[i] = button; 
				grid.add(button);
				button.addActionListener(this);
			}
			contentPane.add(grid, BorderLayout.EAST);

			panel = new JPanel();
			panel.setLayout(new FlowLayout());

			m_ok = new JButton("Relayout subtree " + m_drawRoot);
			panel.add(m_ok);
			m_ok.addActionListener(this);
			m_cancel = new JButton("Don't Relayout");
			panel.add(m_cancel);
			m_cancel.addActionListener(this);

			contentPane.add(panel, BorderLayout.SOUTH);

			// Resize the window to the preferred size of its components

			this.pack();
			show();

		}

		public String msg()
		{
			return m_msg;
		}

		// ActionListener interface

		public void actionPerformed(ActionEvent ev)
		{
			Object			source;
			JRadioButton	radioButton;
			int				i, cnt;

			source = ev.getSource();
			cnt    = m_radioButtons.length;

			if (source == m_ok) {

				for (i = 0; i < cnt; ++i) {
					radioButton = m_radioButtons[i];
					if (radioButton.isSelected()) {
						m_ls.defaultToLayouter(i);
						doRelayoutAll();
						m_msg = "Prior graph layout deleted";
						break;
				}	}
				setVisible(false);
				return;
			}
			if (source == m_cancel) {
				setVisible(false);
				return;
			}

			for (i = 0; i < cnt; ++i) {
				if (source == m_buttons[i]) {
					m_radioButtons[i].setSelected(true);
					m_layouters[i].configure(m_ls);
					return;
			}	}
		}
	}

	// Final values

	public final static float BG = 0.75f;	// Also change BG_STR if you change this
	public final static Color boxColour = Color.lightGray;

	protected final static int GAP = 5;
	protected final static int MARGIN = GAP*2;

	protected final static double SMALL_SCALE_UP		= 1.2; 
	protected final static double SMALL_SCALE_DOWN		= 0.8; 
	protected final static String SMALL_SCALE_STRING	= "20%";

	// Values

	protected double	m_zoom_x = 1.0;		//	The zoom factor
	protected double	m_zoom_y = 1.0;

	protected EntityInstance	m_drawRoot;					// The current entity being drawn
	
	/* By putting the edges in a separate container we simplify the management of painting
		(1) We ensure that edges are painted after entities. This is because the m_edges
			components is added first.
		(2) We ensure that adding and deleting edges is efficient.
			This is because we can add at end.
	 */

	protected Container			m_edges     = null;

	/* Likewise for cardinals */

	protected Container			m_cardinals = null;

	protected int				numVisibleRelationClasses = 0;

	protected boolean			persistentQuery = false;
	protected boolean			m_loaded        = false;

	protected int				mode; 

	protected int				gridPixels = 1;

	protected int				m_preserve_entity_marks   = 0;
	protected int				m_preserve_relation_marks = 0;

	protected Attribute			relVisibilityAttr; 

	protected boolean			m_visibleEdges = true;
	protected boolean			m_drawEdges = true;

	protected int				newCnt = 0;					// Used to id new entities	
	protected boolean			undoValid = false;

	protected int				timeStamp = 0;

	protected EntityInstance	m_keyEntity;				// The currently highlight entity if any else null

	protected ExitFlag			m_exitFlag;
	protected SupplierSet		m_supplierSet;
	protected ClientSet			m_clientSet;	

	protected Vector			m_suppliers;
	protected Vector			m_dClients;
	protected Vector			m_dSuppliers;

	protected boolean			m_suppliersSorted = false;

	protected boolean			allClients = true;
	protected boolean			allSuppliers = true;

	protected boolean			m_modeHandlingActive = false;

	protected Vector m_clipboard = null;


	// -----------------
	// Protected methods
	// -----------------

	protected Diagram getDiagram()
	{
		// Hide the TA layer from having to know what the diagram is
		// While still being able to pass it into its own functions
		return(this);
	}

	protected void findClientsAndSuppliers(boolean liftEdges) 
	{
		EntityInstance	drawRoot = m_drawRoot;
		boolean			showSuppliers;
		boolean			showClients;

		if (drawRoot == m_rootInstance) {
			showSuppliers = false;
			showClients   = false;
		} else {
			showSuppliers = m_ls.isShowSuppliers();
			showClients   = m_ls.isShowClients();
		}
		m_clientSet.removeAll();
		if (showClients) {
			m_clientSet.findClients(m_rootInstance, drawRoot, liftEdges);
		} 
		m_supplierSet.removeAll();
		if (showSuppliers) {
			m_supplierSet.findSuppliers(m_rootInstance, drawRoot, liftEdges);
		}
	}
		
	protected void setVisibilityFlags() 
	{
		Enumeration en;

		numVisibleRelationClasses = 0;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
			if (!rc.excludeReln()) {
				if (rc.isClassVisible()) {
					rc.setOrdinal(numVisibleRelationClasses++);
				}
			}
		}
		m_visibleEdges = (numVisibleRelationClasses > 0);
	}

	// We are cutting this entity

	public void cutEntity(EntityInstance e)
	{
		m_ls.entityCut(e);

		// Don't allow us to remain under something cut
		if (e.hasDescendantOrSelf(m_drawRoot)) {
			navigateTo(e.getContainedBy());
		}
		// Hide all edges out of whats cut
		e.disconnectEdges(e);
		// Hide this from its parent
		e.getContainedBy().removeContainment(e);
		// Hide this from searches
		EntityCache.remove(e);
	}

	public void pasteEntity(EntityInstance parent, EntityInstance e)
	{
		parent.addContainment(e);
		// Must do this so that reconnect edges works
		prepostorder();
		e.reconnectEdges(e);
		EntityCache.put(e);
		m_ls.entityPasted(e);
	}

	// We are cutting this container but not its contents

	public void cutContainer(EntityInstance parent, EntityInstance e)
	{
		Enumeration		en;
		EntityInstance	child;

		m_ls.containerCut(e);
		// Promote our children

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			parent.addContainment(child);
		}
		e.disconnectEdgesJustMe(e);
		if (e == getDrawRoot()) {
			navigateTo(parent);
		}
		parent.removeContainment(e);
	}

	public void uncutContainer(EntityInstance parent, EntityInstance e)
	{
		Enumeration		en;
		EntityInstance	child;

		parent.addContainment(e);
		for (en = e.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			parent.removeContainment(child);
			child.setContainedBy(e);
		}

		e.reconnectEdgesJustMe(e);
		m_ls.containerUncut(e);
	}

	public void cutAndPasteEntity(EntityInstance parent, EntityInstance e)
	{
		m_ls.deleteTOC(e);
		e.getContainedBy().removeContainment(e);
		parent.addContainment(e);
		prepostorder();
		m_ls.insertTOC(e);
	}

	public void prepostorder()
	{
		m_rootInstance.prepostorder(1);
	}

/* 
	What a cautionary tale this is for a software engineering course..

	1. Somewhere in Java AWT's history someone had the bright idea of changing
	   the AWT framework so that every component could have a mouse cursor
	   associated with it instead of just the frame managing what the current
	   mouse cursor object should be at any given time.  The idea was that as
	   you moved the mouse over different objects each object would have the
	   capability of explicitly indicating what the cursor associated with the
	   mouse should be, while it hovered over that object.

	2. This means that when ever a new visible object is added to a container,
	   AWT must handle the possibility that the cursor happens to be over this
	   new object, in which case this new object should if appropriate change
	   the appearance of that mouse cursor immediately.

	3. So whenever an object is added to the AWT containment hierarchy, there
	   is an invocation to that object to change the system cursor immediately.

	   [This by the way is a less than smart implementation.. The smart thing
		to tell the component is change the cursor if the mouse pointer is over
		it and it actually cared what the cursor  should be in that unusual case]

	4. The object handles this request by walking all the way up the containment
	   heirarchy until it hits a component which actually cares what the cursor
	   looks like (in lsedit's case the topmost frame object, since tha ability
	   to associate cursors directly with objects is not used).

	5. This cursor isn't changed but the frame object doesn't know that. That
	   is because any component can over ride the frame's opinion as to what
	   the cursor should be (not that any does in lsedit).

	6. So the frame object starts off by asking itself what the mouse pointer
	   is over. To do this it walks back down through the containment heirarchy
	   asking each level if it contains the current point the mouse pointer is
	   over, recursively.  This comes close to search all components, if the
	   mouse pointer happens to be over the diagram, since entities and edges
	   dominate the number of components.

	7. Now containment is not a trivial exercise for edges.  At a minimum we
	   need to decide if the given point is within 'n' pixels of any part of
	   the line, the arrow head, etc.

	8. Having identified the deepest thing the mouse pointer is over, we walk up
	   finding the nearest component above which wishes to control the cursor
	   image, arriving back at the frame.  The frame then dutifully sets the
	   mouse cursor to what it already was.


	Now this is repeated every time we add a component.  So it is clearly an
	O(N^2) operation for N components.  So when displaying a large number of
	edges (order the number in linux or whatever) the cost of JAVA painting
	the cursor image associated with the mouse pointer, becomes prohibitive
	as the actual graph image is constructed line by line.

	I worked this out by narrowing down the performance problems when displaying
	a large ta file to: White cursor mouse arrow left on screen until lsedit
	draws = 40 seconds, while time taken was a mere 4 seconds if I cleverly fired
	up lsedit in a manner which left the cursor off the lsedit screen, somewhere
	down at the bottom of my actual screen.

	Needless to say I at first found this behaviour quite astonishing.

	Work around to correct this <<bug>> was to add to the diagram.java class
	the following special rule about what the diagram contains when not
	loaded -- nothing.

	Ian Davis
*/

	public boolean contains(int x, int y)
	{
		return (m_loaded && super.contains(x, y));
	}

	public void setPreserveEntityMarks(int value)
	{
		m_preserve_entity_marks = value;
	}

	public void setPreserveRelationMarks(int value)
	{
		m_preserve_relation_marks = value;
	}

	// For debugging
	
	
    protected void paintChildren(Graphics g) 
    {
    	super.paintChildren(g);
    }

	// For debugging
	    	
    public void repaint() 
    {
    	super.repaint();
    }
    
	// --------------
	// Public methods
	// --------------

	// This constructor is only called to create copies of diagrams
	// They are never active so don't need to assign them listeners

	public Diagram(LandscapeEditorCore ls) 
	{
		super(ls);
		setLayout(null);
		setLocation(0,0);
		setDoubleBuffered(true);
	}

	public Component add(Component c)
	{
		if (c instanceof RelationComponent) {
			return(m_edges.add(c));
		}
		if (c instanceof Cardinal) {
			return(m_cardinals.add(c));
		}
		return(super.add(c));
	}

	public void remove(Component c)
	{
		if (c instanceof RelationComponent) {
			m_edges.remove(c);
			return;
		}
		if (c instanceof Cardinal) {
			m_cardinals.remove(c);
			return;
		}
		super.remove(c);
	}

	public Diagram(LandscapeEditorCore ls, boolean makeBackup) 
	{
		super(ls);

		setLayout(null);
		setLocation(0, 0);

		m_exitFlag = new ExitFlag();
		m_exitFlag.setLocation(3, 3);

		m_supplierSet   = new SupplierSet(this);
		m_clientSet     = new ClientSet(this);	// Ignore suppliers when computing clients

		addMouseMotionListener(this);
		// The default empty instance

		// No marks are needed when the diagram is first drawn
		setPreserveEntityMarks(0);
		setPreserveRelationMarks(0);
		navigateTo(m_rootInstance);
	}

	// This logic attempts to assign a Rectangle to any component which lacks Rectangle information

	// Called from landscapeEditorCore.attach()
	// Called from landscapeEditorCore.loadLs()
	// Called from landscapeEditorCore.initialLoad()

	// Returns non-null string on error

	public String loadDiagram(String taPath, Object context) {

		Attribute	attr;
		boolean		option;
		String		ret;

		ret = loadTA(taPath, context);

		attr = m_rootInstance.getLsAttribute(EDGEMODE_ID);
		if (attr.avi == null) { 
			attr.avi = new AttributeValueItem(String.valueOf(Do.DIRECT_EDGE_STATE));
		}

		m_ls.setEdgeMode(attr.parseInt());

		attr = m_rootInstance.getLsAttribute(TOPCLIENTS_ID);
		if (attr.avi == null) {
			option   = Do.TOP_CLIENTS_DEFAULT;
			attr.avi = new AttributeValueItem(String.valueOf(option));
		} else {
			option   = attr.parseBoolean();
		}
		m_ls.setTopClients(option);

		attr = m_rootInstance.getLsAttribute(WANTCLIENTS_ID);
		if (attr.avi == null) {
			option   = Do.SHOW_CLIENTS_DEFAULT;
			attr.avi = new AttributeValueItem(String.valueOf(option));
		} else {
			option   = attr.parseBoolean();
		}
		m_ls.setShowClients(option);

		attr = m_rootInstance.getLsAttribute(WANTSUPPLIERS_ID);
		if (attr.avi == null) {
			option   = Do.SHOW_SUPPLIERS_DEFAULT;
			attr.avi = new AttributeValueItem(String.valueOf(option));
		} else {
			option   = attr.parseBoolean();
		}
		m_ls.setShowSuppliers(option);

		attr = m_rootInstance.getLsAttribute(WANTCARDINALS_ID);
		if (attr.avi == null) {
			option   = Do.SHOW_DST_CARDINALS_DEFAULT;
			attr.avi = new AttributeValueItem(String.valueOf(option));
		} else {
			option   = attr.parseBoolean();
		}
		m_ls.setShowDstCardinals(option);

		attr = m_rootInstance.getLsAttribute(RELN_HIDDEN_ID);
		relVisibilityAttr = attr;

		AttributeValueItem avi = attr.avi;

		while(avi != null) {
			RelationClass rc = (RelationClass) m_relationClasses.get(avi.value);
			rc.setClassVisible(false); 
			avi = avi.next; 
		}

		setVisibilityFlags();

		return ret;
	}

	public boolean isUndoAvailable() 
	{
		return undoValid;
	}

/*
	public Graphics getContext(Graphics gc) 
	{
		int vpwidth, vpheight;

		vpwidth = getWidth()-GAP*2;
		vpheight = getHeight() - GAP*2;
		return gc.create(getX()+GAP, getY()+GAP, vpwidth, vpheight);
	}
*/

	public void rescaleDiagram() 
	{
//		System.out.println("Diagram.rescaleDiagram");
		// Resize first so that sizes known when calling postprocess() during relocation
		m_drawRoot.resizeChildren();
		m_drawRoot.relocateChildren();
	}

	public EntityInstance intersects(Rectangle lyt)
	{
		return m_drawRoot.intersects(lyt); 
	}

	public EntityInstance containing(Rectangle lyt) 
	{
		return m_drawRoot.containing(lyt);
	}

	public Vector setGroupRegion(Rectangle lyt) 
	{ 
		EntityInstance e = m_drawRoot.getMouseOver((int) lyt.x, (int) lyt.y);

		if (e == null) {
			return null;
		}
		return e.groupRegion(lyt);
	}

	public void setMode(int mode) 
	{
		this.mode = mode; 
	}

	public void setEdgeMode(int mode) 
	{
		m_ls.setEdgeMode(mode);
		Attribute attr = m_rootInstance.getLsAttribute(EDGEMODE_ID);
		attr.avi = new AttributeValueItem(String.valueOf(mode));
	}

	public int getEdgeMode() 
	{
		return m_ls.getEdgeMode();
	}

	public EntityInstance getDrawRoot() 
	{
		return m_drawRoot; 
	}

	public void setDrawRoot(EntityInstance e)
	{
		if (e != m_drawRoot) {
			MapBox		mapBox;
			HistoryBox	historyBox;

			m_drawRoot = e;
			e.setOpen();

			mapBox = m_ls.m_mapBox;
			if (mapBox != null) {
				mapBox.fill(e);
//				System.out.println("Diagram.setDrawRoot() map box added");
			}
			m_ls.addHistoryEntity(e);
		}
	}

	public EntityInstance getRootInstance() 
	{
		return m_rootInstance;
	}

	public int getTimeStamp() 
	{
		return timeStamp;
	}

	public void removeEntitiesFromCache()
	{
		m_rootInstance.removeTreeFromCache();
		if (EntityCache.size() != 0) {
			System.out.println("Diagram.removeEntitiesFromCache failed count=" + EntityCache.size());
			EntityCache.show();
	}	}

	public void addEntitiesToCache()
	{
		m_rootInstance.addTreeToCache();
	}

	public void toggleDstElision(EntityInstance e) 
	{
		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement(); 
			if (!rc.excludeReln() && rc.isClassVisible()) {
				e.toggleDstElision(rc); 
			}
		}
	}

	public void toggleSrcElision(EntityInstance e) 
	{
		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.excludeReln() && rc.isClassVisible()) {
				e.toggleSrcElision(rc);
		}	}
	}

	public void toggleEnteringElision(EntityInstance e) 
	{

		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement(); 
			if (!rc.excludeReln() && rc.isClassVisible()) {
				e.toggleEnteringElision(rc); 
		}	}
	}

	public void toggleExitingElision(EntityInstance e) 
	{
		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements();) {
			rc = (RelationClass) en.nextElement();
			if (!rc.excludeReln() && rc.isClassVisible()) {
				e.toggleExitingElision(rc);
		}	}
	}

	public void toggleInternalElision(EntityInstance e) 
	{
		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (!rc.excludeReln() && rc.isClassVisible())
				e.toggleInternalElision(rc);
		}
	}

	public void setVisible(boolean value)
	{
		if (m_drawRoot != null) {
			m_drawRoot.setVisible(value);
	}	}
	
	public void setEdgeVisibilityState(RelationClass rc, boolean state) 
	{
		rc.setClassVisible(state);

		// List is HIDDEN relations

		if (state) {
			relVisibilityAttr.removeFromList(rc.getId());
		} else {
			relVisibilityAttr.addToList(rc.getId());
		}
		setVisibilityFlags();
	}

	public void toggleEdgeVisibility() 
	{
		Enumeration en;
		RelationClass rc;

		for (en = enumRelationClasses(); en.hasMoreElements();) {
			rc = (RelationClass) en.nextElement();
			if (!rc.excludeReln() && rc.isClassVisible()) {
				setEdgeVisibilityState(rc, false);
			}
		}
	}

	// Only draw the edges found

	public void clearDrawEdges() 
	{
//		System.out.println("clearDrawEdges");
		m_drawEdges = false;
//		java.lang.Thread.dumpStack();
//		System.out.println("-----");
	}

	// Draw all edges

	public void setDrawEdges() 
	{
//		System.out.println("setDrawEdges");
		m_drawEdges = true;
//		java.lang.Thread.dumpStack();
//		System.out.println("-----");
	}

	public boolean getDrawEdges()
	{
		return(m_drawEdges);
	}

	public Vector getHighlightedEdges() 
	{
		Vector v = new Vector();

		m_drawRoot.getHighlightedEdges(v);
		if (v.size() == 0) {
			return null;
		}
		return v;
	}

	public void clearKeyEntity()
	{
		m_keyEntity = null;
	}

	public boolean clearFlags() 
	{
		boolean ret;

		clearKeyEntity();

		ret = false;
		if (!getDrawEdges()) {
			ret = true;
			setDrawEdges();
		}
		m_rootInstance.clearAllFlags();
		if (m_drawRoot != null) {
			m_drawRoot.setOpen();
		}
		return(ret);
	}

	// Remove all RedBox and HighLight flags under the root

	public void clearQueryFlags() 
	{
		m_rootInstance.clearQueryFlags();
	}

	public void clearGroupFlags() 
	{
		clearKeyEntity();
		setDrawEdges();
		m_rootInstance.clearGroupFlags();
	}

	public boolean toggleQueryPersistence() 
	{
		persistentQuery = !persistentQuery;
		return persistentQuery;
	}

	public boolean getQueryPersistance() 
	{
		return persistentQuery;
	}

	/* Create a new edge */
	public RelationInstance newEdge(EntityInstance from, EntityInstance to)
	{
		UpdateNewRelation update = new UpdateNewRelation (from, to);
		RelationInstance rel = update. getRelation ();
		EditAttribute. Create (m_ls, rel);
		return rel;
	}
	
	/* Programatically create a new entity */

	public EntityInstance newEntity(EntityInstance container, Rectangle lyt)
	{
		UpdateNewEntity	update;
		EntityInstance	e;

		if (container == m_rootInstance && m_rootInstance.hasChildren()) {
			m_ls.error("Can't change TA tree into a forest");
			return null;
		}

		update = new UpdateNewEntity(container);
		e      = update.getEntity();
		if (lyt == null) {
			int width, height;

			width = container.getWidth();
			height = container.getHeight();

			if (e.widthRelLocal() < 0 || e.heightRelLocal() < 0) {
				EntityInstance pe;

				pe = e.getContainedBy();
				if (pe != null) {
					new UpdateRelayoutChildren(pe);
			}	}

			e.resize(width, height);
			e.relocate(container.getDiagramX(), container.getDiagramY(), width, height);
		} else {
			e.updateDiagramBounds(lyt);
		}
		EditAttribute.Create(m_ls, e);
		return(e);
	}

	// Programatically delete marked things

	public void doDelete(Object object) 
	{
		Vector				objects;
		Object				o;
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		e;
		int					mode = 0;
		String				msg;


		objects = targetEntityRelations(object);
		if (objects != null) {
			beginUndoRedo("Delete");
			for (en = objects.elements(); en.hasMoreElements(); ) {
				o = en.nextElement();
				if (o != null) {
					if (o instanceof RelationInstance) {
						ri = (RelationInstance) o;
						mode |= 1;
						ri.deleteEdge();
						continue;
					}
					if (o instanceof EntityInstance) {
						e = (EntityInstance) o;
						if (e == getDrawRoot()) {
							m_ls.doFeedback("Can't delete the draw root");
							continue;
						}
						e.updateDelete();
						mode |= 2;
						continue;
					}
					System.out.println("Can't delete object of type " + o.getClass());
			}	}
			endUndoRedo();
			if ((mode & 2) != 0) {
				clearGroupFlags();
			}
			redrawDiagram();
		}

		switch (mode) {
		case 0:	
			msg = "Nothing selected to delete";
			break;
		case 1:
			msg = "Edge(s) deleted";
			break;
		case 2:
			msg = "Entity(s) deleted";
			break;
		case 3:
			clearGroupFlags();
			msg = "Entity(s) and Edge(s) deleted";
			break;
		default:
			msg = "???";
		}
		m_ls.doFeedback(msg);
	}

	public int numVisibleRelationClasses() 
	{
		return this.numVisibleRelationClasses;
	}

	public Vector getGroup() 
	{
		Vector grp = new Vector();

		m_rootInstance.getGroup(grp);
		if (grp.isEmpty()) {
			return null;
		}
		return grp;
	}

	public Rectangle getGroupBoundingBox() 
	{
		Vector grp = getGroup();

		if (grp == null || grp.isEmpty()) {
			return null;
		}

		// Determine the bounding box of whole group

		Enumeration en0;
		double x1, y1, x2, y2;


		x1 = Double.MAX_VALUE;
		y1 = Double.MAX_VALUE;
		x2 = Double.MIN_VALUE;
		y2 = Double.MIN_VALUE;

		for (en0 = grp.elements(); en0.hasMoreElements(); ) {
			EntityInstance e = (EntityInstance) en0.nextElement();
			Rectangle lyt = e.getDiagramBounds();

			if (lyt.x < x1) 
				x1 = lyt.x;

			if (lyt.y < y1)
				y1 = lyt.y;

			if (lyt.x + lyt.width > x2)
				x2 = lyt.x + lyt.width;

			if (lyt.y + lyt.height > y2)
				y2 = lyt.y + lyt.height;
		}
		return new Rectangle((int) x1, (int) y1, (int) (x2-x1), (int) (y2-y1));
	}

	public EntityInstance getKeyEntity() 
	{
		return m_keyEntity;
	}

	public void setKeyEntity(EntityInstance e) {

		if (m_keyEntity != null) {
			m_keyEntity.clearGroupKeyFlag();		// Must do this first
			m_keyEntity.setGroupFlag();
		}
		m_keyEntity = e;
		m_keyEntity.setGroupKeyFlag();
		m_keyEntity.setGroupFlag();
	}

	public Vector getRedBoxGroup() 
	{
		Vector grp = new Vector();

		m_rootInstance.getRedBoxGroup(grp);
		if (grp.isEmpty()) {
			return null;
		}
		return grp;
	}

	public void selectEdges(Vector edges) 
	{
		Enumeration en;
		RelationInstance r;

		for (en = edges.elements(); en.hasMoreElements(); ) {
			r = (RelationInstance) en.nextElement();
			r.setGroupAndHighlightFlag();
		}
		clearDrawEdges();
	}

	public boolean isOverGroupRegion(int x, int y) 
	{
		Rectangle lyt = getGroupBoundingBox();

		if (lyt != null) {
			return lyt.contains(x, y);
		}
		return false;
	}

	public String show_groupList(ResultBox resultBox) 
	{
		Vector grp      = getGroup();
		String msg      = null;

		if (grp != null) {
			SortVector.byString(grp);
			resultBox.showResults("GROUP:", grp, "-- End of group --");
		} else {
			msg = "No entities selected";
		}
		return(msg);
	}

	public String groupAll(ResultBox resultBox) 
	{
		boolean ret;

		EntityInstance	ke      = getKeyEntity();
		EntityInstance	ge      = ke;
		Enumeration		en;
		EntityInstance	ce;
		String			msg     = null;

		if (ke == null) {
			ke = getDrawRoot();
			ge = ke;
		}

		ret = clearFlags();

		if (!ge.isOpen()) {
			ge = ge.getContainedBy();
		}

		for (en = ge.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			ce.setGroupFlag();
		}

		Vector grp = getGroup();

		if (grp != null) {
			if (!grp.contains(ke))
				ke = (EntityInstance) grp.firstElement();

			setKeyEntity(ke);
			setPreserveEntityMarks(EntityInstance.GROUP_MARK|EntityInstance.GROUPKEY_MARK);
			setPreserveRelationMarks(0);

			if (ret) {
				redrawDiagram();
			}
			msg = show_groupList(resultBox);
		} else {
			msg = "No entities selected";
		}
		return(msg);
	}

	public int getGrid() 
	{
		return gridPixels;
	}

	public void setGrid(int val) 
	{
		gridPixels = val;
	}

	public void setToViewport() 
	{
		navigateTo();
	}

	// Mark all edges as needing to be repainted

	public void invalidateAllEdges(EntityInstance root)
	{
		Enumeration en;

		/* Draw all the visible objects */

		root.invalidateAllEdges(); 

		if (root.isOpen()) {
			for (en = root.getChildren(); en.hasMoreElements(); ) {
				invalidateAllEdges((EntityInstance) en.nextElement());
		}	}
	}

	// Draw all edges marked as needing to be repainted at or under e

	protected void drawHighlightEdges(EntityInstance e)
	{
		Enumeration en;

		/* Draw all the highlight edges */

		e.drawHighlightedEdges();
		if (e.isOpen()) {
			for (en = e.getChildren(); en.hasMoreElements(); ) {
				drawHighlightEdges((EntityInstance) en.nextElement());
		}	}
	}
	// Draw all edges marked as needing to be repainted at or under e

	protected void drawAllEdges(EntityInstance e, EntityInstance under)
	{
		Enumeration en;

		/* Draw all the visible edges */

		e.drawAllEdges(under); 
		if (e.isOpen()) {
			for (en = e.getChildren(); en.hasMoreElements(); ) {
				drawAllEdges((EntityInstance) en.nextElement(), under);
		}	}
	}

	protected void doDrawEdges(EntityInstance e, EntityInstance under)
	{
		/* Draw all the visible objects */

		if (getDrawEdges()) {
			if (m_visibleEdges) {
				drawAllEdges(e, under); 
			}
		} else {
			drawHighlightEdges(e);
	}	}

	/* If this isn't changed to return true the revalidate() becomes a
	   request to revalidate the JScrollPane containing us and that for
	   some reason doesn't attempt to validate() the thing it contains.
	 */

	public boolean isValidateRoot()
	{
		return(true);
	}

	public Dimension getPreferredSize()
	{
		Dimension	preferredSize;
		JComponent	container;
		Insets		insets;
		int			mw, mh;

		container = (JComponent) getParent();
		if (container == null) {
			mw = 0;
			mh = 0;
		} else {
			insets = container.getInsets();

			mw = container.getWidth()-insets.right-insets.left;
			if (mw <= 0) {
				mw = 0;
			}
			mh = container.getHeight()-insets.bottom-insets.top;
			if (mh <= 0) {
				mw = 0;
			}
			mw = (int) (((double) mw) * m_zoom_x);
			mh = (int) (((double) mh) * m_zoom_y);
		}
		preferredSize = super.getPreferredSize();
		if (preferredSize.width != mw || preferredSize.height != mh) {
			preferredSize.setSize(mw, mh);
			setPreferredSize(preferredSize);
			container.revalidate();
		}
		return(preferredSize);
	}


/* All complex stuff is delayed until we validate to ensure that we have a
   graphic object so that we can compute sizes of labels etc. Much of this
   stuff doesn't really belong in validate -- which is supposed to be called
   only whenever the diagram changes its shape.

	synchronized(getTreeLock())  -- locks against multithreading

 */

	public void validate()
	{
		Dimension		size;
		int				mw, mh, yshift;
		Vector			clients, suppliers;
		Enumeration		en;
		Container		container;
		EntityInstance	e;
		boolean			isTopClients, liftEdges;
		Cardinal		cardinal;
		int				temp, i, cnt;

		m_loaded = false;

		size = getSize();
		mw   = size.width;
		mh   = size.height;
//		System.out.println("Diagram.validate Started validation mw=" + mw + " mh=" + mh);

		if (mw < 1 || mh < 1) {
			return;
		}

		m_ls.setCursor(Cursor.WAIT_CURSOR);

/*
		System.out.println("Diagram.validate() " + getBounds() + ".v." + "[" + m_zoom_x + "," + m_zoom_y + "]");
		java.lang.Thread.dumpStack();
		System.out.println("-----");
*/

		if (m_cardinals == null) {
			m_cardinals = new Container();
			m_cardinals.setLayout(null);
		}
		if (m_edges == null) {
			m_edges = new Container();
			m_edges.setLayout(null);
		}

		removeAll();
		m_cardinals.removeAll();

		// These go on top
		if (getLs().isShowDstCardinals() || getLs().isShowSrcCardinals()) {
			m_cardinals.setBounds(0, 0, mw, mh);
			add(m_cardinals);
		}
		// This goes under cardinals if present
		m_edges.removeAll();
		m_edges.setBounds(0,0,mw, mh);
		add(m_edges);		// Add the set of all edges


		// Clear all but the indicated marks

		if (!getDrawEdges()) {
			m_preserve_entity_marks   |= EntityInstance.REDBOX_MARK;
			m_preserve_relation_marks |= RelationInstance.HIGHLIGHT_FLAG_MARK;
		}

		m_rootInstance.clearAllMarks(m_preserve_entity_marks, m_preserve_relation_marks);
		m_drawRoot.setOpen();	// The draw root is always open

//		System.out.println("Diagram.validate() cleared all marks");

		/* This has to be delayed until we have resized things appropriately since the adding of
		   the drawRoot to the diagram causes the edges to also be added, and these need to know
		   displayable dimensions of entities
		 */

		mw       -= GAP*6;		// Maximum width  of e
		mh	     -= GAP*4;		// Maximum height of e
//		System.out.println("mw=" + mw + " mh=" + mh);
		yshift    = 0;
		clients   = null;
		suppliers = null;
		isTopClients = m_ls.isTopClients();

		// Make entity take a full footprint in the display.

		if (m_drawRoot != m_rootInstance) {
			add(m_exitFlag);
			m_exitFlag.activate();
		} else {
			// If we don't do a repaint the [-] box doesn't vanish
			repaint();
		}

//		System.out.println("Diagram.validate() added to Diagram");

		/* This performs a first cut at finding clients and suppliers
		 * It essentially collects into a vector topmost clients and suppliers
		 */

		liftEdges = m_ls.isLiftEdges();

		findClientsAndSuppliers(liftEdges);

//		System.out.println("Diagram.validate() found clients and suppliers");

		if (m_clientSet.getFullSetSize() != 0) {
			// we will either show or report not showing
			// Reduce height to allow clients
			temp = (ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT + GAP*4);
			mh  -= temp;
			if (isTopClients) {
				m_clientSet.setBounds(GAP*3, GAP*2, mw, ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT);
				yshift = temp; 
			} else {
				m_clientSet.setBounds(GAP*3, getHeight() - ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT - GAP*2, mw, ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT);
			}
//			System.out.println("Diagram.validate() m_clientSet=" + m_clientSet.getBounds());
		}

		if (m_supplierSet.getFullSetSize() != 0) {			// Reduce height to allow suppliers
			temp = (ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT + GAP*4);
			mh  -= temp;
			if (!isTopClients) {
				m_supplierSet.setBounds(GAP*3, GAP*2, mw, ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT);
				yshift = temp; 
			} else {
				m_supplierSet.setBounds(GAP*3, getHeight() - ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT - GAP*2, mw, ClientSupplierSet.CLIENT_SUPPLIER_HEIGHT);

//				System.out.println("Supplier=" + (getY() + m_supplierSet.getY() + m_supplierSet.getHeight()) + " actual=" + m_ls.getHeight());
			}
//			System.out.println("Diagram.validate() m_supplierSet=" + m_supplierSet.getBounds());
		}

		ClientSupplierSet.compact(m_clientSet, m_supplierSet);

		clients = m_clientSet.getFullSet();
		if (clients != null && clients.size() == 0) {
			clients = null;
		}

		suppliers = m_supplierSet.getFullSet();
		if (suppliers != null && suppliers.size() == 0) {
			suppliers = null;
		}

		// Must do this before calling computeAllDiagramEdges because zero sized entities are presumed closed
		// This will assign -l width/height values

		m_drawRoot.setSize(mw, mh);

//		System.out.println("Diagram.validate() resized Diagram");

		m_drawRoot.computeAllDiagramEdges(m_drawRoot, clients, suppliers, null /* No closed entity yet */, liftEdges);
//		System.out.println("Diagram.validate() computed all diagram edges");

		m_drawRoot.liftAllDiagramEdges(liftEdges);

//		System.out.println("Diagram.validate() lifted all edges");

		// This will assign -1 xrel/yrel values
		m_drawRoot.setBothLocations(0, 0, GAP*3, GAP*2+yshift);

//		System.out.println("Diagram.validate() setBothLocations");

		m_drawRoot.addUnder(this);

		// Do after lifted edges since ordering based on where edges go to/come from

		if (m_supplierSet.getFullSetSize() != 0) {	
			m_supplierSet.order();
			add(m_supplierSet);		// Add the quasi supplier box to diagram
			m_supplierSet.setVisible(true);
//			System.out.println("Diagram.validate() added Suppliers");
		}

		if (m_clientSet.getFullSetSize() != 0) {
			m_clientSet.order();
			add(m_clientSet);		// Add the quasi client box to the diagram
			m_clientSet.setVisible(true);
//			System.out.println("Diagram.validate() added Clients");
		}

		doDrawEdges(m_drawRoot, m_drawRoot);	// Marks have been previously cleared so do not need to invalidate

		if (getLs().isShowDstCardinals()) {
			EntityInstance	drawInstance;
		
			drawInstance = (EntityInstance) m_drawRoot;
			drawInstance.resetDstCardinals(m_numRelationClasses);
			drawInstance.calcDstEdgeCardinals(!getDrawEdges());
			drawInstance.showDstCardinals();
//			System.out.println("Show dst cardinals " + m_cardinals.getComponentCount());
		}

		if (getLs().isShowSrcCardinals()) {
			EntityInstance	drawInstance;
		
			drawInstance = (EntityInstance) m_drawRoot;
			drawInstance.resetSrcCardinals(m_numRelationClasses);
			drawInstance.calcSrcEdgeCardinals(!getDrawEdges());
			drawInstance.showSrcCardinals();
//			System.out.println("Show src cardinals " + m_cardinals.getComponentCount());
		}

		container = m_cardinals;
		cnt = container.getComponentCount();
		for (i = 0; i < cnt; ++i) {
			cardinal = (Cardinal) container.getComponent(i);
			cardinal.known();
		}

//		System.out.println("Diagram.validate() processed edges");

		m_ls.setCursor(Cursor.DEFAULT_CURSOR);

		m_loaded = true;
		repaint();

//		System.out.println("Diagram.validate() done");
	}

	public void redrawDiagram()
	{
		revalidate();
	}

	public boolean shouldScrollDiagram()
	{
		return(m_zoom_x > 1.0 || m_zoom_y > 1.0);
	}

	public boolean zoom(double xfactor, double yfactor) 
	{
		double x, y;

		if (xfactor <= 1.0 && yfactor <= 1.0 && m_zoom_x == 1.0 && m_zoom_y == 1.0) {
			return(false);
		}
		x = m_zoom_x * xfactor;
		y = m_zoom_y * yfactor;

		if (x < 1.0) {
			x = 1.0;
		}
		if (y < 1.0) {
			y = 1.0;
		}

		if (x != m_zoom_x || y != m_zoom_y) {
			new	UpdateDiagramZoom(x,  y);
		}
		return true;
	}

	public boolean set_to_viewport()
	{
		if (!shouldScrollDiagram()) {
			return(false);
		}
		m_zoom_x = 1.0;
		m_zoom_y = 1.0;
		// Update our preferred size
		getPreferredSize();	
		redrawDiagram();
		return true;
	}

	// Carefully decide on values for preserveEntityMarks and preserveRelationMarks before calling this

	public void navigateTo(EntityInstance e) 
	{
		// Make entity take a full footprint in the display.

		setDrawRoot(e);
		redrawDiagram();
	}

	public void navigateTo(String eid) 
	{
		EntityInstance e = EntityCache.get(eid);

		if (e != null) {
			navigateTo(e);
	}	}

	// Navigate to default entity

	public void navigateTo()
	{
		Enumeration		en;
		EntityInstance	e;
			
		en = m_rootInstance.getChildren();
		e  = m_rootInstance; 
		if (en.hasMoreElements()) {
			e = (EntityInstance) en.nextElement();
			if (en.hasMoreElements()) {
				e = m_rootInstance;
		}	}

		setPreserveEntityMarks(0);
		setPreserveRelationMarks(0);
		navigateTo(e);
	}

	public void navigateToDrawRootParent()
	{
		EntityInstance e;

		e = m_drawRoot.getEnterableParent();

		if (e == null) {
			m_ls.error("At topmost landscape");
		} else {
			// Going up
			setPreserveEntityMarks(0);
			setPreserveRelationMarks(0);
			navigateTo(e);
	}	}

	public boolean entityExists(String name) 
	{
		return (EntityCache.get(name) != null);
	}

	public boolean allowElision() 
	{
		return getDrawEdges();
	}

	public boolean isModeHandlingActive()
	{
		return(m_modeHandlingActive);
	}

	public void setModeHandlingActive(boolean value)
	{
		m_modeHandlingActive = value;
	}

	public RelationInstance targetRelation(Object object)
	{
		if (object != null) {
			if (object instanceof Vector) {
				Vector v = (Vector) object;
				switch (v.size()) {
				case 0:
					m_ls.doFeedback("Target relation set is empty");
					return(null);
				case 1:
					object = v.firstElement();
					break;
				default:
					m_ls.doFeedback("Target relation set has multiple objects in it");
					return(null);
				}
			}
			if (object instanceof RelationInstance) {
				return((RelationInstance) object);
			}
			return(null);
		}

		Vector v = getHighlightedEdges();

		if (v == null) {
			m_ls.doFeedback("Highlight the edge you wish to work on");
		} else {
			if (v.size() == 1) {
				return((RelationInstance) v.firstElement());
			}
			m_ls.doFeedback("Can't operate on " + v.size() + " highlight edges");
		}
		return(null);
	}

	public EntityInstance targetEntity(Object object)
	{
		if (object != null) {
			if (object instanceof Vector) {
				Vector v = (Vector) object;
				switch (v.size()) {
				case 0:
					m_ls.doFeedback("Target entity set is empty");
					return(null);
				case 1:
					object = v.firstElement();
					break;
				default:
					m_ls.doFeedback("Target entity set has multiple objects in it");
					return(null);
			}	}
			if (object instanceof EntityInstance) {
				return((EntityInstance) object);
			}
			return(null);
		}

		EntityInstance ke;

		ke = getKeyEntity();
		if (ke != null) {
			return(ke);
		}
		return(getDrawRoot());
	}

	public Vector targetEntityRelations(Object object)
	{
		Vector v, v1;

		if (object != null) {
			if (object instanceof Vector) {
				v = (Vector) object;
				if (v.size() > 0) {
					return(v);
				}
				m_ls.doFeedback("Target set is empty");
				return(null);
			}
			v = new Vector();
			v.addElement(object);
			return(v);
		}

		v  = getHighlightedEdges();
		v1 = getGroup();
		if (v == null) {
			v = v1;
		} else if (v1 != null) {
			v.addAll(v1);
		}
		if (v == null) {
			m_ls.doFeedback("Select the entity/relations you wish to work on");
		}
		return(v);
	}

	public LandscapeObject targetEntityRelation(Object object)
	{
		Vector v = targetEntityRelations(object);

		LandscapeObject	landscapeObject = null;

		if (v != null) {
			if (v.size() != 1) {
				m_ls.doFeedback("Select a single entity or relation that you wish to work with");
			} else {
				landscapeObject = (LandscapeObject) v.firstElement();
			}
			v = null;
		}	
		return(landscapeObject);
	}

	public Vector targetRelations(Object object)
	{
		Vector v;

		if (object != null) {
			if (object instanceof Vector) {
				v = (Vector) object;
				if (v.size() > 0) {
					return(v);
				}
				m_ls.doFeedback("Target relation set is empty");
				return(null);
			}
			v = new Vector();
			v.addElement(object);
			return(v);
		}

		v = getHighlightedEdges();

		if (v == null) {
			m_ls.doFeedback("Select the edges you wish to work on");
		}
		return(v);
	}

	public Vector targetEntities(Object object)
	{
		Vector v;

		if (object != null) {
			if (object instanceof Vector) {
				v = (Vector) object;
				if (v.size() > 0) {
					return(v);
				}
				m_ls.doFeedback("Target entity set is empty");
				return(null);
			}
			v = new Vector();
			v.addElement(object);
			return(v);
		}
		return(getGroup());
	}

	public Vector getClipboard()
	{
		return m_clipboard;
	}

	public void cutGroup(Object object, boolean addPriorCuts) 
	{
		Enumeration en;
		EntityInstance e;
		Vector		old_clipboard;
		String		msg;

		old_clipboard   = m_clipboard;
		if (old_clipboard != null && old_clipboard.size() != 0) {
			old_clipboard = m_clipboard;
			m_clipboard   = null;
		} else {
			old_clipboard = null;
		}

		TextTree	tocBox = m_ls.getTocBox();
		
		if (object != null && object == tocBox) {
			m_clipboard = tocBox.getGroup();
		} else {
			m_clipboard = getGroup();
		}

		if (m_clipboard == null || m_clipboard.size() == 0) {
			m_clipboard = old_clipboard;
			m_ls.error("Group not selected");
		} else {
			for (en = m_clipboard.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				if (e.getContainedBy() == null) {
					m_ls.error("Can't cut the root node in the diagram");
					m_clipboard = old_clipboard;
					return;
			}	}

			// Don't want a subsequent paste to try and paste X into X
			clearKeyEntity();

			// Make sure we cut descendants before ancestors so that we can still find them
			SortVector.byPostorder(m_clipboard);
			new UpdateCut();

			msg = "Group copied to clipboard";
			if (old_clipboard != null) {
				if (addPriorCuts) {
					// Don't want UpdateCut to see the appended info because it shares reference to same clipboard
					// Think this gives desired sort order?
					old_clipboard = (Vector) old_clipboard.clone();
					old_clipboard.addAll(m_clipboard);
					m_clipboard = old_clipboard;
					msg += " - old cuts preserved";
				} else {
					msg += " - old cuts discarded";
			}	}
			m_ls.doFeedback(msg);

	}	}

	public void pasteGroup(Object object) 
	{
		if (m_clipboard == null) {
			m_ls.error("Clipboard empty");
			return;
		}

		int cnt = m_clipboard.size();
		if (cnt == 0) {
			m_ls.error("Clipboard is empty");
			return;
		}

		TextTree		tocBox = m_ls.getTocBox();
		EntityInstance	pe;

		if (object != null && object == tocBox) {
			pe = tocBox.targetEntity();
		} else {
			pe = targetEntity(object);
		}
		if (pe != null) {
			new UpdatePaste(pe);
			m_ls.doFeedback("Pasted " + cnt + " entities into " + pe.getEntityLabel());
	}	}

	protected void doRelayoutAll()
	{
		new UpdateRelayoutAll(m_drawRoot);
	}

	public String relayoutAll()
	{
		RelayoutDialog relayoutDialog = new RelayoutDialog();
		String		   ret            = relayoutDialog.msg();

		relayoutDialog.dispose();
		return ret;
	}

	public String closeAll()
	{
		m_drawRoot.closeAll();
		redrawDiagram();
		return "Entities closed";
	}

	public String openAll()
	{
		m_drawRoot.openAll();
		redrawDiagram();
		return "Entities opened";
	}

	/* This doesn't work at all as expected and I have little idea why 
	   It only approximately centers on an entity e as the zoom factor changes 
	 */

	protected void centerDiagramOn(EntityInstance e)
	{
		double		zoom_x     = m_zoom_x;
		double		zoom_y     = m_zoom_y;

		if (zoom_x > 1.0 || zoom_y > 1.0) {

			JScrollPane	scrollPane = m_ls.m_scrollDiagram;
			int			x          = 0;
			int			y          = 0;

			scrollPane.validate();		// Call to fix a bug in Swing http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5066771

			JViewport	viewport      = scrollPane.getViewport();
			Dimension	extent        = viewport.getExtentSize();

			if (zoom_x > 1.0) {
				int			diagramWidth  = getWidth();
				int			minX          = (int) (((double) extent.width) / zoom_x);
				int         maxX          = diagramWidth - minX;
				
				x = e.getDiagramX()  + (e.getWidth()/2) - minX;
				if (x >= maxX) {
					x = maxX;
				} 
				if (x <= 0) {
					x = 0;
			}	} 

			if (zoom_y > 1.0) {
				int			diagramHeight = getHeight();
				int			minY          = (int) (((double) extent.height) / zoom_y);
				int			maxY          = diagramHeight - minY;
				
				y = e.getDiagramY()  + (e.getHeight()/2) - minY;
				if (y >= maxY) {
					y = maxY;
				} 
				if (y <= 0) {
					y = 0;
			}	} 

			// Source code "suggests that this changes the Location() of the diagram to -x,-y
			// making the x,y point the origin on which the view is positioned.  These seems
			// solid enough to suggest that I've the units of scale right.

			viewport.setViewPosition(new Point(x, y));

			// System.out.println(x + " " + y + " .v. " + getLocation() + " " + extent);
	}	}

	public String scaleEntity(int scale, boolean incFlag) 
	{
		Vector			grp     = getGroup();
		String			msg     = null;
		EntityInstance	e       = null;

		if (grp != null) {
			Enumeration en;

			switch (grp.size()) {
			case 0:
				break;
			case 1:
				e = (EntityInstance) grp.firstElement();
				if (e == getDrawRoot()) {
					break;
				}
			default:
				switch (scale) {
				case Do.DECREASE_MAG:
				case Do.INCREASE_MAG:
					if (e == null) {
						e = (EntityInstance) grp.firstElement();
					}
					break;
				default:
					for (en = grp.elements(); en.hasMoreElements(); ) {
						EntityInstance ge = (EntityInstance) en.nextElement();
						switch(scale) {
						case Do.DECREASE_WIDTH:
							ge.scaleX(SMALL_SCALE_DOWN, incFlag);
							break; 

						case Do.INCREASE_WIDTH:
							ge.scaleX(SMALL_SCALE_UP, incFlag);
							break; 

						case Do.DECREASE_HEIGHT:
							ge.scaleY(SMALL_SCALE_DOWN, incFlag);
							break; 

						case Do.INCREASE_HEIGHT:
							ge.scaleY(SMALL_SCALE_UP, incFlag);
							break; 

						case Do.DECREASE_SIZE:
							ge.scale(SMALL_SCALE_DOWN, incFlag);
							break;

						case Do.INCREASE_SIZE:
							ge.scale(SMALL_SCALE_UP, incFlag);
							break;
						}
					}
					return(msg);
			}	}
		}

		// Do it to root

		switch (scale) {
		case Do.INCREASE_MAG:
			if (e != null) {
				if (zoom(SMALL_SCALE_UP, SMALL_SCALE_UP)) {
					msg = "Magnified " + e.getEntityLabel();
				}
				centerDiagramOn(e);
				break;
			}
		case Do.INCREASE_SIZE:
			// Zoom in
			if (zoom(SMALL_SCALE_UP, SMALL_SCALE_UP)) {
				msg = "Zoomed in";
			}
			break;
		case Do.DECREASE_MAG:
			if (e != null) {
				if (zoom(SMALL_SCALE_DOWN, SMALL_SCALE_DOWN)) {
					msg = "Reduced " + e.getEntityLabel();
				}
				centerDiagramOn(e);
				break;
			}
		case Do.DECREASE_SIZE:
			// Zoom out
			if (zoom(SMALL_SCALE_DOWN, SMALL_SCALE_DOWN)) {
				msg = "Zoomed out";
			}
			break;

		case Do.INCREASE_WIDTH:
			if (zoom(SMALL_SCALE_UP, 1.0)) {
				msg = "Zoomed in X direction";
			}
			break;

		case Do.DECREASE_WIDTH:
			if (zoom(SMALL_SCALE_DOWN, 1.0)) {
				msg = "Zoomed out X direction";
			}
			break;

		case Do.INCREASE_HEIGHT:
			if (zoom(1.0, SMALL_SCALE_UP)) {
				msg = "Zoomed in Y direction";
			}
			break;

		case Do.DECREASE_HEIGHT:
			if (zoom(1.0, SMALL_SCALE_DOWN)) {
				msg = "Zoomed out Y direction";
			}
			break;
		}
		msg += " (" + SMALL_SCALE_STRING + ") to " + m_zoom_x + "x" + m_zoom_y;
		return(msg);
	}


	public String handleElision(int key, Object object) 
	{
		String			em     = "";
		Vector			grp    = targetEntities(object);
		boolean			closed = false;
		EntityInstance	ge, ke = null;
		Enumeration		en;

		if (grp == null  || grp.size() == 0) {
			return "Nothing selected";
		}

		switch(key)	{
		case Do.SHOW_CONTENTS:
			 // Toggle contain elision
			em = "Containment";

			if (grp.size() == 1) {
				ke = (EntityInstance) grp.elementAt(0);
			} else {
				ke = getKeyEntity();
			}
			if (ke == null) {
				return "Unable to identify key entity to open/close";
			}
			closed = ke.isDstRelationElided(Diagram.CONTAIN_ID);
			break;
		case Do.DST_EDGES:
			em = "Target ";
			break;

		case Do.SRC_EDGES:
			em = "Source "; 
			break;

		case Do.ENTERING_EDGES:
			em = "Entering";
			break; 

		case Do.EXITING_EDGES:
			em = "Exiting";
			break;

		case Do.INTERNAL_EDGES:
			em = "Internal edges";
			break;
		default:
			return(null);
		}

		for (en = grp.elements(); en.hasMoreElements(); ) {
			ge = (EntityInstance) en.nextElement();

			switch(key)	{
			case Do.SHOW_CONTENTS:
				if (ge == ke || closed == ge.isDstRelationElided(Diagram.CONTAIN_ID)) {
					ge.toggleContainElision();
				}
				break;

			case Do.DST_EDGES:
				toggleDstElision(ge);
				break;

			case Do.SRC_EDGES:
				toggleSrcElision(ge);
				break;

			case Do.ENTERING_EDGES:
				if (ge.isOpen()) {
					toggleEnteringElision(ge);
				}
				break;

			case Do.EXITING_EDGES:
				if (ge.isOpen()) {
					toggleExitingElision(ge);
				}
				break;
			
			case Do.INTERNAL_EDGES:
				if (ge.isOpen()) {
					toggleInternalElision(ge);
				}
				break;
			}
		}
		redrawDiagram();
		return(em + " elision toggled for group");
	}

	protected void processSelectList(Vector edges, int key, ResultBox resultBox) 
	{
		Enumeration			en;
		RelationInstance	edge;
		EntityInstance		drawSrc, drawDst;

		resultBox.setResultTitle("SELECTED RELATIONS:");

		for (en = edges.elements(); en.hasMoreElements(); ) {
			edge    = (RelationInstance) en.nextElement();
			drawSrc = edge.getDrawSrc();
			drawDst = edge.getDrawDst();
			switch (key) {
			case Do.EDGE_OPEN_LOW:
				drawSrc.orAllContainedSrcRelationsDstUnder(drawDst);
				break;
			case Do.EDGE_OPEN_SRC:
				drawDst.orDstRelationsSrcUnder(drawDst);
				break;
			case Do.EDGE_OPEN_DST:
				drawSrc.orSrcRelationsDstUnder(drawDst);
				break;
		}	}

		for (en = edges.elements(); en.hasMoreElements(); ) {
			edge    = (RelationInstance) en.nextElement();
			drawSrc = edge.getDrawSrc();
			drawDst = edge.getDrawDst();
			switch (key) {
			case Do.EDGE_OPEN_LOW:
				drawSrc.addSrcDstRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			case Do.EDGE_OPEN_SRC:
				drawDst.addDstRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			case Do.EDGE_OPEN_DST:
				drawSrc.addSrcRelations(RelationInstance.ADD_RESULTS_MARK, resultBox);
				break;
			default:
				resultBox.addRelation(edge);
		}	}

//		resultBox.activate();
		resultBox.done("-- End --");
		selectEdges(edges);
	}

	protected boolean handleEdgeExpansion(int key, Object object, ResultBox resultBox) 
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		visible, src, dst, drawRoot;
		String				msg, msg1;
		Vector				edges;

		edges = targetRelations(object);
		if (edges == null) {
			return false;
		}
		msg = null;

		switch (key) {
		case Do.EDGE_OPEN_LOW:
			msg1 = "Opened sources and destinations of edges.";
			break;
		case Do.EDGE_OPEN_SRC:
			msg1 = "Opened sources of edges.";
			break;
		case Do.EDGE_OPEN_DST:
			msg1 = "Opened destination of edges.";
			break;
		case Do.EDGE_CLOSE_LOW:
			msg1 = "Closed source and destination of edges";
			break;
		case Do.EDGE_CLOSE_SRC:
			msg1 = "Closed source of edges";
			break;
		default:
			msg1 = "Closed source and destination of edges";
			break;
		}

		drawRoot = getDrawRoot();

		for (en = edges.elements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();

			switch (key) {
			case Do.EDGE_OPEN_SRC:
			case Do.EDGE_OPEN_LOW:
				visible = ri.getDrawSrc();
				src     = ri.getSrc();
				for (;;) {
					src = src.getContainedBy();
					if (src == null) {
						break;
					}

					if (src.isDstRelationElided(Diagram.CONTAIN_ID)) {
//						System.out.println("Opening " + src);
						src.clearContainElision();
						msg = msg1;
					}
					if (src == visible) {
						break;
				}	}
				break;
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_SRC:
				dst = ri.getDst();
				src = ri.getSrc();
				for (;;) {
					src = src.getContainedBy();
					if (src == null) {
						break;
					}
					if (!drawRoot.hasDescendant(src)) {
						break;
					}
					if (src == dst || src.hasDescendant(dst)) {
						break;
					}
					if (src.setContainElision()) {
						msg = msg1;
				}	}
				break;
			}

			switch (key) {
			case Do.EDGE_OPEN_DST:
			case Do.EDGE_OPEN_LOW:
				visible = ri.getDrawDst();
				dst     = ri.getDst();
				for (;;) {
					dst = dst.getContainedBy();
					if (dst == null) {
						break;
					}
					if (dst.isDstRelationElided(Diagram.CONTAIN_ID)) {
						dst.clearContainElision();
						msg = msg1;
					}
					if (dst == visible) {
						break;
				}	}
				break;
			case Do.EDGE_CLOSE_LOW:
			case Do.EDGE_CLOSE_DST:
				dst = ri.getDst();
				src = ri.getSrc();
				for (;;) {
					dst = dst.getContainedBy();
					if (dst == null) {
						break;
					}
					if (!drawRoot.hasDescendant(dst)) {
						break;
					}
					if (src == dst || dst.hasDescendant(src)) {
						break;
					}
					if (dst.setContainElision()) {
						msg = msg1;
				}	}
				break;
		}	}

		if (msg != null) {
			processSelectList(edges, key, resultBox);
			m_ls.doFeedback(msg);
			return true;
		}

		switch (key) {
		case Do.EDGE_OPEN_LOW:
		case Do.EDGE_OPEN_SRC:
		case Do.EDGE_OPEN_DST:
			msg = "No further expansion is possible";
			break;
		default:
			msg = "No further contraction is possible";
		}	
		m_ls.error(msg);
		return false;
	}

	protected boolean goodQueryEdge(EntityInstance src, EntityInstance dst, EntityInstance root)
	{
		if (src.hasDescendant(dst) || dst.hasDescendant(src))
			return false;

		if (src.isClientOrSupplier()) { 
			return root.hasDescendant(dst);
		}
		return true;
	}

	protected int addToForwardEntityList(EntityInstance te, EntityInstance e, RelationClass rc, Vector list, boolean groupingFlag, boolean showInDiagram)
	{
		Enumeration		 en;
		RelationInstance ri;
		EntityInstance	 root    = getDrawRoot();
		EntityInstance	 dst, vdst, ne;

		int num = 0;

//		System.out.println("Diagram.addToForwardEdgeList " + e);
		for (en = e.srcLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
//			System.out.println("Diagram.addToForwardEdgeList " + ri);
			if (ri.getRelationClass() == rc) {
				vdst = ri.getDrawDst();
				if (vdst != null) {

					ri.setHighlightFlag();
					vdst.setRedBoxFlag();
					if (groupingFlag) {
						vdst.setGroupFlag();
		}	}	}	}

//		System.out.println("Diagram.addToForwardEdgeList " + e);
		for (en = e.srcRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
//			System.out.println("Diagram.addToForwardEdgeList " + ri);
			if (ri.getRelationClass() == rc) {
				dst  = ri.getDst();
				if (showInDiagram && !m_drawRoot.hasDescendantOrSelf(dst)) {
					continue;
				}
				if (list.indexOf(dst) < 0) {
					list.addElement(dst);
					num++;
		}	}	}
		return num;
	}

	protected int addForwardRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln, boolean groupingFlag, boolean showInDiagram)
	{
		Vector list = new Vector();

		int num = addToForwardEntityList(e, e, rc, list, groupingFlag, showInDiagram);

		if (num > 0 || alwaysShowReln) {
			resultBox.addForwardRelation(e, rc, list);
		}
		return num;
	}

	protected int showForwardEdges(EntityInstance e, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration en;
		boolean		showInDiagram = e.isMarked(EntityInstance.CLIENT_SUPPLIER);
		int			num = 0;

		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
//			System.out.println("Diagram.showForwardEdges class " + rc);
			if (rc.isActive()) {
				num += addForwardRelation(e, rc, resultBox, false, groupingFlag, showInDiagram);
//				System.out.println("Diagram.showForwardEdges num " + num);
		}	}
		return num;
	}

	// Backtrace

	public int addToBackEntityList(EntityInstance te, EntityInstance e,	RelationClass rc, Vector list, boolean groupingFlag, boolean showInDiagram)
	{
		Enumeration      en;
		RelationInstance ri;
		EntityInstance   child, src, vsrc;

		int num = 0;

		EntityInstance root = getDrawRoot();

		for (en = e.dstLiftedRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();

			if (ri.getRelationClass() == rc) {
				vsrc = ri.getDrawSrc();
				if (vsrc != null) {
					ri.setHighlightFlag();
					vsrc.setRedBoxFlag();
					if (groupingFlag) {
						vsrc.setGroupFlag();
		}	}	}	}

		for (en = e.dstRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();

			if (ri.getRelationClass() == rc) {
				src = ri.getSrc();
				if (showInDiagram && !m_drawRoot.hasDescendantOrSelf(src)) {
					continue;
				}
				if (list.indexOf(src) < 0) {
					list.addElement(src);
					num++;
		}	}	}
		return num;
	}

	public int addBackRelation(EntityInstance e, RelationClass rc, ResultBox resultBox, boolean alwaysShowReln, boolean groupingFlag, boolean showInDiagram)
	{
		Vector list = new Vector();

		int num = addToBackEntityList(e, e, rc, list, groupingFlag, showInDiagram);

		if (num > 0 || alwaysShowReln) {
			resultBox.addBackRelation(e, rc, list);
		}
		return num;
	}

	public int showBackEdges(EntityInstance e, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration		en;
		RelationClass	rc;
		boolean			showInDiagram = e.isMarked(EntityInstance.CLIENT_SUPPLIER);
		int				num = 0;


		for (en = enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();
			if (rc.isActive()) {
				num += addBackRelation(e, rc, resultBox, false, groupingFlag, showInDiagram);
		}	}	
		return num;
	}

	// Performed when FORWARD_CLOSURE is pressed

	// Get all of the relationships from visited destinations to earlier sources

	protected void getSrcRelationWithClosure(EntityInstance e, Vector list, boolean groupingFlag)
	{
		Enumeration en;
		EntityInstance root = getDrawRoot();

		for (en = e.srcRelationElements(); en.hasMoreElements(); ) {
			RelationInstance ri = (RelationInstance) en.nextElement();

			EntityInstance dst = ri.getDst();

			// Using highlight flag to mark visitation

			boolean visited = dst.isMarked(EntityInstance.REDBOX_MARK);

			ri.setHighlightFlag();

			if (list.indexOf(ri) < 0) {
				list.addElement(ri);
			}
			if (!visited) {
				dst.setRedBoxFlag();
				if (groupingFlag) {
					dst.setGroupFlag();
				}
				getSrcRelationWithClosure(dst, list, groupingFlag);
			}
		}
	}

	protected int addRelations(EntityInstance e, RelationClass rc, Vector list, ResultBox resultBox, boolean src)
	{
		int num = 0;

		if (list.size() > 0) {
			Vector	sublist = new Vector();
			Enumeration en;

			for (en = list.elements(); en.hasMoreElements(); ) {
				RelationInstance ri = (RelationInstance) en.nextElement();

				if (ri.getRelationClass() == rc) {
					ri.setHighlightFlag();
					sublist.add(ri);
					num++;
			}	}

			if (num > 0) {
				resultBox.addRelations(e, rc, sublist, src);
			}
		}

		return num;
	}

	protected int showSrcEdgesWithClosure(EntityInstance e, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration   en;
		RelationClass rc;
		Diagram		  diagram = getDiagram();
		Vector        list    = new Vector();

		int num = 0;

		diagram.clearQueryFlags();
		getSrcRelationWithClosure(e, list, groupingFlag);
		diagram.clearQueryFlags();

		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				num += addRelations(e, rc, list, resultBox, true);
		}	}
		return num;
	}

	// Backward closure

	protected void getDstRelationWithClosure(EntityInstance e, Vector list, boolean groupingFlag)
	{
		Enumeration			en;
		RelationInstance	ri;
		EntityInstance		src;
		boolean				visited;

		for (en = e.dstRelationElements(); en.hasMoreElements(); ) {
			ri = (RelationInstance) en.nextElement();
			src = ri.getSrc();

			visited = src.isMarked(EntityInstance.REDBOX_MARK);
			ri.setHighlightFlag();
			if (list.indexOf(ri) < 0) {
				list.addElement(ri);
			}

			if (!visited) {
				src.setRedBoxFlag();
				if (groupingFlag) {
					src.setGroupFlag();
				}
				getDstRelationWithClosure(src, list, groupingFlag);
			}
		}
	}

	protected int showDstEdgesWithClosure(EntityInstance e, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration en;
		Vector		list    = new Vector();
		Diagram		diagram = getDiagram();

		int num = 0;

		clearQueryFlags();
		getDstRelationWithClosure(e, list, groupingFlag);
		clearQueryFlags();


		for (en = diagram.enumRelationClasses(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();

			if (rc.isActive()) {
				num += addRelations(e, rc, list, resultBox, false);
		}	}
		return num;
	}

	protected int showContents(EntityInstance e, ResultBox resultBox) 
	{
		Enumeration en;
		Vector list = new Vector();
		int n = 0;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			list.add(en.nextElement());
			n++;
		}
		if (n > 0) {
			SortVector.byString(list);
		}
		resultBox.addContents(e, list);
		return n;
	}

	protected int showContentsWithClosure(EntityInstance e, ResultBox resultBox)
	{ 
		Enumeration en;
		int			n;

		n = showContents(e, resultBox);

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			n += showContentsWithClosure((EntityInstance) en.nextElement(), resultBox);
		}
		return n;
	}

	protected int doQueryEntity(EntityInstance e, int query, ResultBox resultBox, boolean groupingFlag) 
	{
		switch(query) {
		case Do.FORWARD_QUERY:
			return showForwardEdges(e, resultBox, groupingFlag);

		case Do.BACKWARD_QUERY:
			return showBackEdges(e, resultBox, groupingFlag);

		case Do.FORWARD_CLOSURE:
			return showSrcEdgesWithClosure(e, resultBox, groupingFlag);

			case Do.BACKWARD_CLOSURE:
			return showDstEdgesWithClosure(e, resultBox, groupingFlag);

		case Do.CONTENTS_QUERY:
			return showContents(e, resultBox);

		case Do.CONTENT_CLOSURE:
			return showContentsWithClosure(e, resultBox);

		default:
			return 0;
		}
	}

	public void queryEntity(int query, Object object, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration		en;
		Vector			grp        = targetEntities(object);
		String			title, footer;
		EntityInstance	ge;

		if (!getQueryPersistance()) {
			clearQueryFlags();
		}

		switch(query) {
		case Do.FORWARD_QUERY:
		case Do.BACKWARD_QUERY:
		{
			int	mode;

			if (query == Do.FORWARD_QUERY) {
				title = "FORWARD QUERY";
			} else {
				title = "BACKWARD QUERY";
			}
			mode = 0;
			for (en = grp.elements(); en.hasMoreElements(); ) {
				ge = (EntityInstance) en.nextElement();
				if (ge.isMarked(EntityInstance.CLIENT_SUPPLIER)) {
					mode |= 2;
				} else {
					mode |= 1;
			}	}
			switch (mode) {
			case 2:
				title += " IN DIAGRAM";
				break;
			case 3:
				title += " IN DIAGRAM WHEN CLIENT/SUPPLIER";
				break;
			}
			break;
		}
		case Do.FORWARD_CLOSURE:
			title = "FORWARD QUERY (closure)";
			break;
		case Do.BACKWARD_CLOSURE:
			title = "BACKWARD QUERY (closure)";
			break;
		default:
			title = null;
		}

		resultBox.setResultTitle(title);

		if (grp == null || grp.isEmpty()) {
			footer = "No entity or group is selected";
			m_ls.error(footer);
		} else {
			int num = 0;

			for (en = grp.elements(); en.hasMoreElements(); ) {
				ge = (EntityInstance) en.nextElement();

				num += doQueryEntity(ge, query, resultBox, groupingFlag);
			}

			if (num == 0) {
				footer = "NO ENTITIES";
			} else {
				footer = "-- End of Query --";
			}
			clearDrawEdges();
		}
		resultBox.done(footer);
	}

	protected void queryContents(int key, ResultBox resultBox, boolean groupingFlag) 
	{
		Enumeration		en;
		Vector			grp        = getGroup();
		EntityInstance  ge;
		String			title, footer;

		switch (key) {
			case Do.CONTENT_CLOSURE:
				title = "CONTENTS (CLOSURE)";
				break;
			case Do.CONTENTS_QUERY:
				title = "CONTENTS";
				break;
			default:
				title = null;
		}

		resultBox.setResultTitle(title);
		footer = "-- End of content --";

		if (grp == null || grp.isEmpty()) {
			doQueryEntity(getDrawRoot(), key, resultBox, groupingFlag);
		} else {
			int num = 0;

			for (en = grp.elements(); en.hasMoreElements(); ) {
				ge = (EntityInstance) en.nextElement();
				num += doQueryEntity(ge, key, resultBox, groupingFlag);
			}

			if (num == 0) {
				footer = "NO ENTITIES";
		}	}
		resultBox.done(footer);
	}

	//  Event handling

	public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y)
	{
		LandscapeModeHandler	modeHandler = m_ls.getModeHandler();

		m_ls.showDescription(e, true);
		modeHandler.entityPressed(ev, e, x, y);
	}

	public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y)
	{		
		LandscapeModeHandler	modeHandler = m_ls.getModeHandler();
		modeHandler.entityDragged(ev, e, x, y);
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y)
	{
		LandscapeModeHandler modeHandler = m_ls.getModeHandler();

//		System.out.println("Diagram.entityReleased=" + e);

		modeHandler.entityReleased(ev, e, x, y);
		if (y > 0) {
			m_ls.toolButton[0].requestFocus();
			m_ls.requestFocus();
	}	}		

	public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		LandscapeModeHandler modeHandler = m_ls.getModeHandler();

//		System.out.println("Diagram.relationPressed=" + ri);

		m_ls.showDescription(ri, true);
		modeHandler.relationPressed(ev, ri, x, y);
	}
	
	public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y)
	{		
		LandscapeModeHandler modeHandler = m_ls.getModeHandler();
		modeHandler.relationDragged(ev, ri, x, y);
	}
		
	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		LandscapeModeHandler modeHandler = m_ls.getModeHandler();

//		System.out.println("Diagram.relationReleased=" + ri);

		modeHandler.relationReleased(ev, ri, x, y);
		if (y > 0) {
			m_ls.toolButton[0].requestFocus();
			m_ls.requestFocus();
	}	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y)
	{
		LandscapeModeHandler modeHandler = m_ls.getModeHandler();
		
		modeHandler.movedOverThing(ev, thing, x, y);
	}

	// MouseMotionListener interface

	public void mouseDragged(MouseEvent ev)
	{
	}

	public void mouseMoved(MouseEvent ev)
	{
//		System.out.println("Diagram.mouseMoved");
		movedOverThing(ev, this, ev.getX(), ev.getY());
	}

	// DiagramCoordinates interface

	public int getDiagramX()
	{
		return(0);
	}

	public int getDiagramY()
	{
		return(0);
	}
}

