package lsedit;

import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;

import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

/* Function:
 * Clearly identify the available accelerator keys used in lsedit
 * Encapsulate the construction of menus so that menu's can be easily changed
 * Manage state of checkboxes contained with in menus
 */

public class Do 
{
	/* Utter stupidity -- the set accelerator wants the Upper case value of a letter even if it is lower
	 * case and VK_F1 is defined to have the same value as a 'p'.  So if a lower case 'p' is pressed
	 * it is ambiguous if this is really a 'p' or a F1, unless one converts to upper case and sets SHIFT_MASK.
	 * We don't want to do this stupidity since it messes up all our case statements so do a cludge
	 */

	 protected static final int FUNCTION_KEY   = 1024;

	/* N.B. For a key to be active it **MUST** be in a permanent menu -- this ensures that it is treated as an
	 * accelerator key
	 */

	/* Control keys */

	protected static final int GROUP_ALL       = 'a';
	protected static final int COPY            = 'c';	/* Reserved for future use */
	protected static final int SET_TO_VIEWPORT = 'd';
	protected static final int FIND_QUERY      = 'f';
	protected static final int NEW_LANDSCAPE   = 'n';
	protected static final int OPEN_LANDSCAPE  = 'o';
	protected static final int PRINT_LANDSCAPE = 'p';
	protected static final int QUIT_PROGRAM    = 'q';
	protected static final int REFRESH         = 'r';
	protected static final int SAVE            = 's';	/* May be combined with ALT to save RAW */
	protected static final int SAVE_AS         = 'S';
	protected static final int SWITCH_TOC      = 't';
	protected static final int PASTE           = 'v';
	protected static final int CLOSE_EDITOR    = 'w';
	protected static final int CUT             = 'x';
	protected static final int ADD_CUT         = 'X';
	protected static final int REDO			   = 'y';
	protected static final int UNDO            = 'z';

	/* Alt keys */

	protected static final int A_HORIZ_TOP       = KeyEvent.VK_UP;
	protected static final int A_VERTICAL_LEFT   = KeyEvent.VK_LEFT;
	protected static final int A_VERTICAL_RIGHT  = KeyEvent.VK_RIGHT;
	protected static final int A_HORIZ_BOTTOM    = KeyEvent.VK_DOWN;
	protected static final int TB_EDGE           = 'a';
	protected static final int CONTENT_CLOSURE   = 'A';
	protected static final int SHOW_FB           = 'B';
	protected static final int EDGE_CLOSE_SRC    = 'C';
	protected static final int EDGE_CLOSE_DST    = 'c';
	protected static final int SHOW_DESC         = 'D';
	protected static final int ARROW_DIMENSIONS  = 'd';
	protected static final int BEST_EDGE         = 'E';
	protected static final int DIRECT_EDGE       = 'e';
	protected static final int SET_FONT          = 'F';
	protected static final int A_FIT_LABEL       = 'f';
	protected static final int A_GROUP           = 'g';
	protected static final int SIDE_EDGE         = 'G';
	protected static final int SPC_VERTICAL      = 'H';
	protected static final int SZ_HEIGHT         = 'h';
	protected static final int EDGE_CLOSE_LOW    = 'I';
	protected static final int EDGE_OPEN_LOW     = 'i';
	protected static final int RELAYOUT_ALL      = 'j';
	protected static final int SHOW_DST_CARDINALS= 'k';
	protected static final int SHOW_SRC_CARDINALS= 'K';
	protected static final int VISIBLE_EDGES     = 'l';
	protected static final int LEFT_TABBOX       = 'L';
	protected static final int DECREASE_MAG      = 'm';
	protected static final int INCREASE_MAG      = 'M';
	protected static final int EDGE_NAVIGATE_DST = 'n';
	protected static final int EDGE_NAVIGATE_SRC = 'N';
	protected static final int EDGE_OPEN_SRC     = 'O';
	protected static final int EDGE_OPEN_DST     = 'o';
	protected static final int TOC_PATH          = 'p';
	protected static final int USE_COMPACTION    = 'P';
	protected static final int QUERY_PERSIST     = 'Q';
	protected static final int CLOSE_ALL		 = 'r';
	protected static final int OPEN_ALL          = 'R';
	protected static final int SHOW_CLIENTS      = 'S';
	protected static final int SHOW_SUPPLIERS    = 's';
	protected static final int TOP_CLIENTS       = 't';
	protected static final int PREV_HISTORY      = 'u';
	protected static final int NEXT_HISTORY      = 'U';
	protected static final int TOC_HIDDEN        = 'v';
	protected static final int TABS_SCROLL       = 'V';
	protected static final int SPC_HORIZ         = 'W';
	protected static final int SZ_WIDTH          = 'w';
	protected static final int SZ_WIDTH_HEIGHT   = 'x';
	protected static final int A_HORIZ_CENTER    = 'X';
	protected static final int A_VERTICAL_CENTER = 'Y';
	protected static final int FIX_SCROLLBARS    = 'z';

	/* Normal upper keys */

	protected static final int EDIT_ENTITY_CLASS = 'A';
	protected static final int BACKWARD_CLOSURE  = 'B';
	protected static final int CONTENTS_QUERY    = 'C';
	protected static final int NEW_EDGE          = 'E';
	protected static final int FORWARD_CLOSURE   = 'F';
	protected static final int GRID_INCREASE     = 'G';
	protected static final int INTERNAL_EDGES    = 'I';
	protected static final int LIFT_EDGES        = 'L';
	protected static final int MOVE_REDBOXES     = 'M';
	protected static final int GROUPING_FLAG     = 'Q';
	protected static final int EXITING_EDGES     = 'S';
	protected static final int INCREASE_LABEL_FONT = 'T';
	protected static final int ENTERING_EDGES    = 'U';
	protected static final int INCREASE_WIDTH    = 'X';
	protected static final int INCREASE_HEIGHT   = 'Y';
	protected static final int INCREASE_SIZE     = 'Z';

	/* Special upper case keys */

	protected static final int TOGGLE_RELATION_ALL = '0';
	protected static final int TOGGLE_RELATION_1   = '1';
	protected static final int TOGGLE_RELATION_2   = '2';
	protected static final int TOGGLE_RELATION_3   = '3';
	protected static final int TOGGLE_RELATION_4   = '4';
	protected static final int TOGGLE_RELATION_5   = '5';
	protected static final int TOGGLE_RELATION_6   = '6';
	protected static final int TOGGLE_RELATION_7   = '7';
	protected static final int TOGGLE_RELATION_8   = '8';
	protected static final int TOGGLE_RELATION_9   = '9';

	protected static final int ASCEND              = KeyEvent.VK_ENTER;

	/* Normal lower keys */

	protected static final int EDIT_ATTRIBUTES   = 'a';
	protected static final int BACKWARD_QUERY    = 'b';
	protected static final int SHOW_CONTENTS     = 'c';
	protected static final int NEW_ENTITY        = 'e';
	protected static final int FORWARD_QUERY     = 'f';
	protected static final int GRID_DECREASE     = 'g';
	protected static final int DELETE_CONTAINER  = 'k';
	protected static final int SUGIYAMA_LAYOUT   = 'l';
	protected static final int MATRIX_LAYOUT     = 'm';
	protected static final int SIMPLEX_LAYOUT    = 'n';
	protected static final int SRC_EDGES         = 's';
	protected static final int DECREASE_LABEL_FONT = 't';
	protected static final int DST_EDGES         = 'u';
	protected static final int DECREASE_WIDTH    = 'x';
	protected static final int DECREASE_HEIGHT   = 'y';
	protected static final int DECREASE_SIZE     = 'z';

	protected static final int TOGGLE_LEGEND_ALL = '0';
	protected static final int TOGGLE_LEGEND_1   = '1';
	protected static final int TOGGLE_LEGEND_2   = '2';
	protected static final int TOGGLE_LEGEND_3   = '3';
	protected static final int TOGGLE_LEGEND_4   = '4';
	protected static final int TOGGLE_LEGEND_5   = '5';
	protected static final int TOGGLE_LEGEND_6   = '6';
	protected static final int TOGGLE_LEGEND_7   = '7';
	protected static final int TOGGLE_LEGEND_8   = '8';
	protected static final int TOGGLE_LEGEND_9   = '9';

	/* Special keys */

	protected static final int DESCEND           = KeyEvent.VK_ENTER;
	protected static final int DELETE            = KeyEvent.VK_DELETE;
	protected static final int ESCAPE            = KeyEvent.VK_ESCAPE;

	protected static final int MOVE_GROUP_UP     = KeyEvent.VK_UP;
	protected static final int MOVE_GROUP_DOWN   = KeyEvent.VK_DOWN;
	protected static final int MOVE_GROUP_LEFT   = KeyEvent.VK_LEFT;
	protected static final int MOVE_GROUP_RIGHT  = KeyEvent.VK_RIGHT;

	protected static final int ABOUT_PROGRAM     = KeyEvent.VK_F1  + FUNCTION_KEY;	
	protected static final int FIND_PREV         = KeyEvent.VK_F2  + FUNCTION_KEY;
	protected static final int FIND_NEXT         = KeyEvent.VK_F3  + FUNCTION_KEY;
	protected static final int ABOUT_URL         = KeyEvent.VK_F11 + FUNCTION_KEY;		
	protected static final int HELP_URL          = KeyEvent.VK_F12 + FUNCTION_KEY;

	public	  static final boolean TOP_CLIENTS_DEFAULT	 = true;
	public    static final boolean SHOW_DESC_DEFAULT      = true;
	public 	  static final boolean SHOW_FB_DEFAULT       = true;
	public    static final boolean SHOW_CLIENTS_DEFAULT  = true;
	public    static final boolean SHOW_SUPPLIERS_DEFAULT= true;
	public    static final boolean SHOW_DST_CARDINALS_DEFAULT= false;
	public    static final boolean SHOW_SRC_CARDINALS_DEFAULT= false;
	public	  static final boolean USE_COMPACTION_DEFAULT= true;
	public    static final boolean QUERY_PERSIST_DEFAULT = false;
	public	  static final boolean FIX_SCROLLBARS_DEFAULT= false;
	public	  static final boolean LEFT_TABBOX_DEFAULT   = false;
	public	  static final boolean TABS_SCROLL_DEFAULT   = false;
	public	               boolean TOC_HIDDEN_DEFAULT    = true;
	public    static final boolean LIFT_EDGES_DEFAULT    = true;
	public    static final boolean VISIBLE_EDGES_DEFAULT = false;
	public    static final boolean FILL_ARROWHEAD_DEFAULT = true;
	public    static final boolean CENTER_ARROWHEAD_DEFAULT = false;

	public final static int BEST_EDGE_STATE	  = 0;			// INFLECTION POINT			
	public final static int TB_EDGE_STATE	  = 1;			// TOP BOTTOM EDGE
	public final static int DIRECT_EDGE_STATE = 2; 
	public final static int SIDE_EDGE_STATE   = 3;			// DIRECT EDGE WITH ANC/DESC on SIDE
	public final static int EDGE_STATE_DEFAULT= SIDE_EDGE_STATE;

	// These are the master values

	private boolean	m_top_clients_state    = TOP_CLIENTS_DEFAULT;
	private boolean m_show_desc_state      = SHOW_DESC_DEFAULT;
	private boolean m_show_fb_state        = SHOW_FB_DEFAULT;
	private boolean m_show_clients_state   = SHOW_CLIENTS_DEFAULT;
	private boolean m_show_suppliers_state = SHOW_SUPPLIERS_DEFAULT;
	private boolean m_show_dst_cardinals_state = SHOW_DST_CARDINALS_DEFAULT;
	private boolean m_show_src_cardinals_state = SHOW_SRC_CARDINALS_DEFAULT;
	private boolean m_use_compaction_state = USE_COMPACTION_DEFAULT;
	private boolean m_query_persist_state  = QUERY_PERSIST_DEFAULT;
	private boolean m_fix_scrollbars_state = FIX_SCROLLBARS_DEFAULT;
	private boolean m_left_tabbox_state    = LEFT_TABBOX_DEFAULT;
	private boolean m_tabs_scroll_state    = TABS_SCROLL_DEFAULT;
	private boolean m_toc_hidden_state     = TOC_HIDDEN_DEFAULT;
	private boolean m_lift_edges_state     = LIFT_EDGES_DEFAULT;
	private boolean m_visible_edges_state  = VISIBLE_EDGES_DEFAULT;

	private static boolean m_fill_arrowhead_state = FILL_ARROWHEAD_DEFAULT;
	private static boolean m_center_arrowhead_state= CENTER_ARROWHEAD_DEFAULT;

	private int		m_edge_state	       = EDGE_STATE_DEFAULT;

	private MyMenuItem          m_undo           = null;
	private MyMenuItem			m_redo           = null;

	private MyCheckBoxMenuItem	m_top_clients    = null;
	private MyCheckBoxMenuItem	m_show_desc      = null;
	private MyCheckBoxMenuItem  m_show_fb        = null;
	private MyCheckBoxMenuItem  m_show_clients   = null;
	private MyCheckBoxMenuItem  m_show_suppliers = null;
	private MyCheckBoxMenuItem  m_show_dst_cardinals = null;
	private MyCheckBoxMenuItem  m_show_src_cardinals = null;
	private MyCheckBoxMenuItem	m_use_compaction = null;
	private MyCheckBoxMenuItem  m_query_persist  = null;
	private MyCheckBoxMenuItem	m_fix_scrollbars = null;
	private MyCheckBoxMenuItem	m_left_tabbox    = null;
	private MyCheckBoxMenuItem	m_tabs_scroll	 = null;
	private MyCheckBoxMenuItem	m_toc_hidden     = null;

	
	private MyCheckBoxMenuItem  m_best_edge      = null;
	private MyCheckBoxMenuItem  m_tb_edge        = null;
	private MyCheckBoxMenuItem  m_direct_edge    = null;
	private MyCheckBoxMenuItem  m_side_edge      = null;
	private MyCheckBoxMenuItem	m_lift_edges     = null;
	private MyCheckBoxMenuItem	m_visible_edges	 = null;

	protected LandscapeLayouter	m_fliphorizontally = null; 
	protected LandscapeLayouter	m_flipvertically   = null; 
	protected LandscapeLayouter	m_gridhorizontally = null;
	protected LandscapeLayouter	m_gridvertically   = null;
	protected LandscapeLayouter	m_laysugiyama      = new SugiyamaLayout((LandscapeEditorCore) this);
	protected LandscapeLayouter m_laymatrix        = new MatrixLayout((LandscapeEditorCore) this);
	protected LandscapeLayouter	m_laysimplex       = new SimplexLayout((LandscapeEditorCore) this);

	protected LandscapeLayouter	m_layouter         = m_laysimplex;
	protected LandscapeLayouter[] m_layouters;

	public LandscapeLayouter getLayouter()
	{
		return m_layouter;
	}

	public void setLayouter(LandscapeLayouter layouter)
	{
		m_layouter = layouter;
	}

	public LandscapeLayouter[] getLayouters()
	{
		return m_layouters;
	}

	public void defaultToLayouter(int index)
	{
		if (index >= 0 && index < m_layouters.length) {
			setLayouter(m_layouters[index]);
	}	}

	public void defaultToLayouter(String name)
	{
		LandscapeLayouter	layouter;
		String				name1;
		int					i;

		for (i = m_layouters.length; i > 0; ) {
			layouter = m_layouters[--i];
			name1    = layouter.getName();
			if (name1.equalsIgnoreCase(name)) {
				defaultToLayouter(i);
				return;
	}	}	}

	public static void addSeparator(JComponent m)
	{
		if (m instanceof JMenu) {
			((JMenu) m).addSeparator();
		} else if (m instanceof JPopupMenu) {
			((JPopupMenu) m).addSeparator();
	}	}

	public static void fileMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "New  landscape",       handler, Event.CTRL_MASK, NEW_LANDSCAPE);
		new MyMenuItem(m, "Open landscape",       handler, Event.CTRL_MASK, OPEN_LANDSCAPE);
	}

	public static void fileCloseMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Save landscape",       handler, Event.CTRL_MASK,                    SAVE);
		new MyMenuItem(m, "Save landscape as",    handler, Event.CTRL_MASK | Event.SHIFT_MASK, SAVE_AS);
		new MyMenuItem(m, "Print",                handler, Event.CTRL_MASK, PRINT_LANDSCAPE);
		new MyMenuItem(m, "Close editor",		  handler, Event.CTRL_MASK, CLOSE_EDITOR);
		new MyMenuItem(m, "Quit",    		      handler, Event.CTRL_MASK, QUIT_PROGRAM);
	}

	public void setEnabledRedo(boolean value)
	{
		m_redo.setEnabled(true /* value */);
	}

	public void setEnabledUndo(boolean value)
	{
		m_undo.setEnabled(true /* value */);
	}

	public void editMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_redo = new MyMenuItem(m, "Redo", handler, Event.CTRL_MASK, REDO);
		m_undo = new MyMenuItem(m, "Undo", handler, Event.CTRL_MASK, UNDO);
//		setEnabledRedo(false);
//		setEnabledUndo(false);
		new MyMenuItem(m, "Refresh", handler, Event.CTRL_MASK, REFRESH);
	}

	public static void groupAllMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Select all children", handler,        Event.CTRL_MASK, GROUP_ALL);
	}

	public static void findMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Clear current query/group", handler, 0, ESCAPE);
		new MyMenuItem(m, "Find entities",   handler, Event.CTRL_MASK, FIND_QUERY);
		new MyMenuItem(m, "Find prev",   handler, 0, FIND_PREV);
		new MyMenuItem(m, "Find next",   handler, 0, FIND_NEXT);
	}

	public static MyMenuItem cutMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		MyMenuItem	ret = new MyMenuItem(m, "Cut group",		  handler, Event.CTRL_MASK, CUT);
		return(ret);
	}

	public static MyMenuItem addcutMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		MyMenuItem	ret = new MyMenuItem(m, "Cut additional group",	  handler, Event.CTRL_MASK|Event.SHIFT_MASK, ADD_CUT);
		return(ret);
	}


	public static MyMenuItem pasteMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		MyMenuItem	ret = new MyMenuItem(m, "Paste group", handler, Event.CTRL_MASK, PASTE);
		return(ret);
	}

	public static void alignMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Align (top/horiz.)",      handler, Event.ALT_MASK, A_HORIZ_TOP);
		new MyMenuItem(m, "Align (center/horiz.)",   handler, Event.ALT_MASK|Event.SHIFT_MASK, A_HORIZ_CENTER);
		new MyMenuItem(m, "Align (bottom/horiz.)",   handler, Event.ALT_MASK, A_HORIZ_BOTTOM);
		new MyMenuItem(m, "Align (left/vertical)",   handler, Event.ALT_MASK, A_VERTICAL_LEFT);
		new MyMenuItem(m, "Align (center/vertical)", handler, Event.ALT_MASK|Event.SHIFT_MASK, A_VERTICAL_CENTER);
		new MyMenuItem(m, "Align (right/vertical)",  handler, Event.ALT_MASK, A_VERTICAL_RIGHT);

		new MyMenuItem(m, "Same size",				 handler, Event.ALT_MASK, SZ_WIDTH_HEIGHT);
		new MyMenuItem(m, "Same width",              handler, Event.ALT_MASK, SZ_WIDTH);
		new MyMenuItem(m, "Same height",             handler, Event.ALT_MASK, SZ_HEIGHT);
		new MyMenuItem(m, "Equal spacing (horiz.)",  handler, Event.ALT_MASK|Event.SHIFT_MASK, SPC_HORIZ);
		new MyMenuItem(m, "Equal spacing (vertical)",handler, Event.ALT_MASK|Event.SHIFT_MASK, SPC_VERTICAL);

		new MyMenuItem(m, "Move group up",   handler,   0, MOVE_GROUP_UP);
		new MyMenuItem(m, "Move group down",   handler, 0, MOVE_GROUP_DOWN);
		new MyMenuItem(m, "Move group left",  handler,  0, MOVE_GROUP_LEFT);
		new MyMenuItem(m, "Move group right", handler,  0, MOVE_GROUP_RIGHT);

		new MyMenuItem(m, "Grid decrease",	  handler,                0, GRID_DECREASE);
		new MyMenuItem(m, "Grid increase",	  handler, Event.SHIFT_MASK, GRID_INCREASE);
	}

	public static void groupMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Put group in container",  handler, Event.ALT_MASK, A_GROUP);
	}

	public static void fitLabelMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Fit to label", handler, Event.ALT_MASK, A_FIT_LABEL);
	}

	/* N.B. All menu check items must have different key code */

	public void layoutMenuItem(JComponent m, LandscapeEditorCore handler)
	{
		LandscapeLayouter layout;

		layout = m_fliphorizontally;
		if (layout == null) {
			m_fliphorizontally = layout = new FlipLayoutHorizontally(handler);
		}
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);

		layout = m_flipvertically;
		if (layout == null) {
			m_flipvertically = layout = new FlipLayoutVertically(handler);
		}
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
		addSeparator(m);

		layout = m_gridhorizontally;
		if (layout == null) {
			m_gridhorizontally = layout = new GridGroupHorizontally(handler);
		}
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);

		layout = m_gridvertically;
		if (layout == null) {
			m_gridvertically = layout = new GridGroupVertically(handler);
		}
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, 0);
		addSeparator(m);

		layout = m_laysugiyama;
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, SUGIYAMA_LAYOUT);

		layout = m_laysimplex;
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, SIMPLEX_LAYOUT);

		layout = m_laymatrix;
		new MyMenuItem(m, layout.getMenuLabel(), layout, 0, MATRIX_LAYOUT);

		new MyMenuItem(m, "Reconfigure layouters", handler, Event.ALT_MASK, RELAYOUT_ALL);
		new MyMenuItem(m, "Close all", handler, Event.ALT_MASK, Do.CLOSE_ALL);
		new MyMenuItem(m, "Open all", handler, Event.ALT_MASK|Event.SHIFT_MASK, Do.OPEN_ALL);
	}

	public void showMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_query_persist  = new MyCheckBoxMenuItem(m, "Query Persists",        QUERY_PERSIST_DEFAULT, handler, Event.ALT_MASK, QUERY_PERSIST);					/* Q */
		m_top_clients    = new MyCheckBoxMenuItem(m, "Clients at top",        TOP_CLIENTS_DEFAULT,    handler, Event.ALT_MASK, TOP_CLIENTS);					/* t */
		m_show_desc      = new MyCheckBoxMenuItem(m, "Show descriptions",     SHOW_DESC_DEFAULT,      handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_DESC);		/* D */
		m_show_fb        = new MyCheckBoxMenuItem(m, "Show feedback",         SHOW_FB_DEFAULT,        handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_FB);		/* B */
		m_show_clients   = new MyCheckBoxMenuItem(m, "Show clients",          SHOW_CLIENTS_DEFAULT,   handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_CLIENTS);	/* S */
		m_show_suppliers = new MyCheckBoxMenuItem(m, "Show suppliers",        SHOW_SUPPLIERS_DEFAULT, handler, Event.ALT_MASK, SHOW_SUPPLIERS);					/* s */
		m_show_dst_cardinals = new MyCheckBoxMenuItem(m, "Show dst cardinals",   SHOW_DST_CARDINALS_DEFAULT, handler, Event.ALT_MASK, SHOW_DST_CARDINALS);					/* k */
		m_show_src_cardinals = new MyCheckBoxMenuItem(m, "Show src cardinals",   SHOW_SRC_CARDINALS_DEFAULT, handler, Event.ALT_MASK|Event.SHIFT_MASK, SHOW_SRC_CARDINALS);					/* k */
		m_use_compaction = new MyCheckBoxMenuItem(m, "Compact clients/suppliers", USE_COMPACTION_DEFAULT, handler, Event.ALT_MASK|Event.SHIFT_MASK, USE_COMPACTION); /* P */
		m_fix_scrollbars = new MyCheckBoxMenuItem(m, "Fixed scrollbars",      FIX_SCROLLBARS_DEFAULT, handler, Event.ALT_MASK, FIX_SCROLLBARS);
		m_left_tabbox    = new MyCheckBoxMenuItem(m, "Tabbox on left",        LEFT_TABBOX_DEFAULT ,   handler, Event.ALT_MASK|Event.SHIFT_MASK, LEFT_TABBOX);
		m_tabs_scroll    = new MyCheckBoxMenuItem(m, "Tabs scroll",           TABS_SCROLL_DEFAULT ,   handler, Event.ALT_MASK|Event.SHIFT_MASK, TABS_SCROLL);
		m_lift_edges     = new MyCheckBoxMenuItem(m, "Lift edges",            LIFT_EDGES_DEFAULT,     handler, Event.SHIFT_MASK,                LIFT_EDGES);
		m_visible_edges  = new MyCheckBoxMenuItem(m, "Visible edges in C/S",  VISIBLE_EDGES_DEFAULT,  handler, Event.ALT_MASK|Event.SHIFT_MASK, VISIBLE_EDGES);
	}

	public void bestEdgeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		m_best_edge     = new MyCheckBoxMenuItem(m, "Inflection point edge", true, handler, Event.ALT_MASK|Event.SHIFT_MASK, BEST_EDGE);		/* E */
		m_tb_edge       = new MyCheckBoxMenuItem(m, "Top/Bottom edge",       false, handler, Event.ALT_MASK, TB_EDGE);						/* a */
		m_direct_edge   = new MyCheckBoxMenuItem(m, "Direct edge",           false, handler, Event.ALT_MASK, DIRECT_EDGE);					/* e */
		m_side_edge     = new MyCheckBoxMenuItem(m, "Direct+Side edges",     false, handler, Event.ALT_MASK|Event.SHIFT_MASK, SIDE_EDGE);					/* G */
	}

	public static void helpMenuItem(JComponent m, ToolBarEventHandler handler, String type)
	{
		new MyMenuItem(m, "About Landscape" + type, handler, 0, ABOUT_PROGRAM);
		new MyMenuItem(m, "Show About URL",  handler, 0, ABOUT_URL);
		new MyMenuItem(m, "Show Help  URL",  handler, 0, HELP_URL);
	}

	public void tocMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Open/close TOC", handler,          Event.CTRL_MASK,SWITCH_TOC);
		new MyMenuItem(m, "Align TOC with diagram",  handler,          Event.ALT_MASK, TOC_PATH);
		m_toc_hidden     = new MyCheckBoxMenuItem(m, "Hide TOC",              TOC_HIDDEN_DEFAULT ,    handler, Event.ALT_MASK, TOC_HIDDEN);
	}

	public static void navigateEdgeMenu(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Open to lowest level",    handler, Event.ALT_MASK, EDGE_OPEN_LOW);		// Open all edges to real src,dst
		new MyMenuItem(m, "Open edge destination",   handler, Event.ALT_MASK, EDGE_OPEN_DST);		// Open all edges to real dst
		new MyMenuItem(m, "Open edge source",        handler, Event.ALT_MASK, EDGE_OPEN_SRC);		// Open all edges to real src
		new MyMenuItem(m, "Close to top level",      handler, Event.ALT_MASK, EDGE_CLOSE_LOW);		// Close all edges to real src,dst
		new MyMenuItem(m, "Close edge destination",  handler, Event.ALT_MASK, EDGE_CLOSE_DST);		// Close all edges to real dst
		new MyMenuItem(m, "Close edge source",       handler, Event.ALT_MASK, EDGE_CLOSE_SRC);		// Close all edges to real src
		new MyMenuItem(m, "Navigate to destination", handler, Event.ALT_MASK, EDGE_NAVIGATE_DST);	// Make the destination the new root
		new MyMenuItem(m, "Navigate to source",      handler, Event.ALT_MASK, EDGE_NAVIGATE_SRC);	// Make the source the new root
	}

	public static void navigateEntityMenu(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Descend",                 handler, 0,                DESCEND);
		new MyMenuItem(m, "Ascend",                  handler, Event.SHIFT_MASK, ASCEND);
		new MyMenuItem(m, "Previous",                handler, Event.ALT_MASK,   PREV_HISTORY);
		new MyMenuItem(m, "Next",                    handler, Event.ALT_MASK | Event.SHIFT_MASK, NEXT_HISTORY);
	}

	public static void deleteEdgeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Delete edge", handler,         0, DELETE);
	}

	public static void editAttributesMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Edit attributes", handler,                       0, EDIT_ATTRIBUTES);
		new MyMenuItem(m, "Edit entity class attributes", handler,           Event.SHIFT_MASK, EDIT_ENTITY_CLASS);
	}

	public static void editRelationMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		Do.editAttributesMenuItem(m, handler);
		new MyMenuItem(m, "Change arrow settings", handler,           Event.ALT_MASK, ARROW_DIMENSIONS);
	}

	public static void queryMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Forward query", handler,                                  0, FORWARD_QUERY);
		new MyMenuItem(m, "Forward closure", handler, Event.SHIFT_MASK, FORWARD_CLOSURE);
		new MyMenuItem(m, "Backward query", handler,                                0, BACKWARD_QUERY);
		new MyMenuItem(m, "Backward closure", handler,       Event.SHIFT_MASK, BACKWARD_CLOSURE);
		new MyMenuItem(m, "Contents query", handler, Event.SHIFT_MASK, CONTENTS_QUERY);
		new MyMenuItem(m, "Content closure", handler, Event.ALT_MASK, CONTENT_CLOSURE);
	}

	public static void hideMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Hide/show destination edges", handler,                            0, DST_EDGES);
		new MyMenuItem(m, "Hide/show edges to inside", handler,     Event.SHIFT_MASK, ENTERING_EDGES);
		new MyMenuItem(m, "Hide/show source edges", handler,                        0, SRC_EDGES);
		new MyMenuItem(m, "Hide/show edges from inside", handler, Event.SHIFT_MASK, EXITING_EDGES);
		new MyMenuItem(m, "Hide/show internal edges", handler,        Event.SHIFT_MASK, INTERNAL_EDGES);
		new MyMenuItem(m, "Hide/show contents", handler,                             0, SHOW_CONTENTS);
		new MyMenuItem(m, "Toggle grouping flag", handler,            Event.SHIFT_MASK, GROUPING_FLAG);
	}

	public static void fontMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Decrease label font size", handler,                 0, DECREASE_LABEL_FONT);
		new MyMenuItem(m, "Increase label font size", handler,  Event.SHIFT_MASK, INCREASE_LABEL_FONT);
		new MyMenuItem(m, "Set Font",                 handler,  Event.ALT_MASK,   SET_FONT);
	}

	public static void scaleMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Set to viewport", handler, Event.CTRL_MASK, SET_TO_VIEWPORT);
		new MyMenuItem(m, "Scale smaller in X dim", handler,                         0, DECREASE_WIDTH);
		new MyMenuItem(m, "Scale larger in X dim", handler,           Event.SHIFT_MASK, INCREASE_WIDTH);
		new MyMenuItem(m, "Scale smaller in Y dim", handler,                         0, DECREASE_HEIGHT);
		new MyMenuItem(m, "Scale larger in Y dim", handler,           Event.SHIFT_MASK, INCREASE_HEIGHT);
		new MyMenuItem(m, "Scale smaller", handler,                                  0, DECREASE_SIZE);
		new MyMenuItem(m, "Scale larger", handler,                    Event.SHIFT_MASK, INCREASE_SIZE);
		new MyMenuItem(m, "Reduce item", handler,                     Event.ALT_MASK,   DECREASE_MAG);
		new MyMenuItem(m, "Magnify item", handler, Event.ALT_MASK|    Event.SHIFT_MASK, INCREASE_MAG);

	}

	public static void activeMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Toggle active  relations", handler,           Event.SHIFT_MASK, TOGGLE_RELATION_ALL);
		new MyMenuItem(m, "Toggle active  relation 1",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_1);
		new MyMenuItem(m, "Toggle active  relation 2",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_2);
		new MyMenuItem(m, "Toggle active  relation 3",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_3);
		new MyMenuItem(m, "Toggle active  relation 4",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_4);
		new MyMenuItem(m, "Toggle active  relation 5",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_5);
		new MyMenuItem(m, "Toggle active  relation 6",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_6);
		new MyMenuItem(m, "Toggle active  relation 7",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_7);
		new MyMenuItem(m, "Toggle active  relation 8",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_8);
		new MyMenuItem(m, "Toggle active  relation 9",    handler,           Event.SHIFT_MASK, TOGGLE_RELATION_9);
	}

	public static void visibleMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "Toggle visible relations", handler,                              0, TOGGLE_LEGEND_ALL);
		new MyMenuItem(m, "Toggle visible relation 1",    handler,                          0, TOGGLE_LEGEND_1);
		new MyMenuItem(m, "Toggle visible relation 2",    handler,                          0, TOGGLE_LEGEND_2);
		new MyMenuItem(m, "Toggle visible relation 3",    handler,                          0, TOGGLE_LEGEND_3);
		new MyMenuItem(m, "Toggle visible relation 4",    handler,                          0, TOGGLE_LEGEND_4);
		new MyMenuItem(m, "Toggle visible relation 5",    handler,                          0, TOGGLE_LEGEND_5);
		new MyMenuItem(m, "Toggle visible relation 6",    handler,                          0, TOGGLE_LEGEND_6);
		new MyMenuItem(m, "Toggle visible relation 7",    handler,                          0, TOGGLE_LEGEND_7);
		new MyMenuItem(m, "Toggle visible relation 8",    handler,                          0, TOGGLE_LEGEND_8);
		new MyMenuItem(m, "Toggle visible relation 9",    handler,                          0, TOGGLE_LEGEND_9);
	}

	public static void drawMenuItem(JComponent m, ToolBarEventHandler handler)
	{
		new MyMenuItem(m, "New entity", handler,                                    0, NEW_ENTITY);
		new MyMenuItem(m, "New edge",             handler,            Event.SHIFT_MASK, NEW_EDGE);
		new MyMenuItem(m, "Delete entity", handler,		                             0, DELETE);
		new MyMenuItem(m, "Delete container", handler,                               0, DELETE_CONTAINER);
		new MyMenuItem(m, "Move redbox's into entity", handler,       Event.SHIFT_MASK, MOVE_REDBOXES);

	}

	private static void setMyCheckBoxMenuItemState(MyCheckBoxMenuItem m, boolean value)
	{
		if (m != null) {
			m.setState(value);
	}	}

	public Do()
	{
		m_layouters    = new LandscapeLayouter[3];

		m_layouters[0] = m_laysimplex;
		m_layouters[1] = m_laysugiyama;
		m_layouters[2] = m_laymatrix;
	}

	public boolean isTopClients()
	{
		return m_top_clients_state;
	}

	public void setTopClients(boolean value)
	{
		m_top_clients_state = value;
		setMyCheckBoxMenuItemState(m_top_clients, value);
	}

	public boolean isShowDesc()
	{
		return m_show_desc_state;
	}

	public void setShowDesc(boolean value)
	{
		m_show_desc_state = value;
		setMyCheckBoxMenuItemState(m_show_desc, value);
	}

	public boolean isShowFeedback()
	{
		return m_show_fb_state;
	}

	public void setShowFeedback(boolean value)
	{
		m_show_fb_state = value;
		setMyCheckBoxMenuItemState(m_show_fb, value);
	}

	public boolean isShowClients()
	{
		return m_show_clients_state;
	}

	public void setShowClients(boolean value)
	{
		m_show_clients_state = value;
		setMyCheckBoxMenuItemState(m_show_clients, value);
	}

	public boolean isShowSuppliers()
	{
		return m_show_suppliers_state;
	}

	public void setShowSuppliers(boolean value)
	{
		m_show_suppliers_state = value;
		setMyCheckBoxMenuItemState(m_show_suppliers, value);
	}

	public boolean isShowDstCardinals()
	{
		return m_show_dst_cardinals_state;
	}

	public void setShowDstCardinals(boolean value)
	{
		m_show_dst_cardinals_state = value;
		setMyCheckBoxMenuItemState(m_show_dst_cardinals, value);
	}

	public boolean isShowSrcCardinals()
	{
		return m_show_src_cardinals_state;
	}

	public void setShowSrcCardinals(boolean value)
	{
		m_show_src_cardinals_state = value;
		setMyCheckBoxMenuItemState(m_show_src_cardinals, value);
	}

	public boolean isUseCompaction()
	{
		return m_use_compaction_state;
	}

	public void setUseCompaction(boolean value)
	{
		m_use_compaction_state = value;
		setMyCheckBoxMenuItemState(m_use_compaction, value);
	}

	public boolean isQueryPersist()
	{
		return m_query_persist_state;
	}

	public void setQueryPersist(boolean value)
	{
		m_query_persist_state = value;
		setMyCheckBoxMenuItemState(m_query_persist, value);
	}

	public boolean isFixScrollBars()
	{
		return m_fix_scrollbars_state;
	}


	public void setFixScrollBars(boolean value)
	{
		m_fix_scrollbars_state = value;
		setMyCheckBoxMenuItemState(m_fix_scrollbars, value);
	}

	public boolean isLeftTabbox()
	{
		return m_left_tabbox_state;
	}

	public void setLeftTabbox(boolean value)
	{
		m_left_tabbox_state = value;
		setMyCheckBoxMenuItemState(m_left_tabbox, value);
	}

	public boolean isTabsScroll()
	{
		return m_tabs_scroll_state;
	}

	public void setTabsScroll(boolean value)
	{
		m_tabs_scroll_state = value;
		setMyCheckBoxMenuItemState(m_tabs_scroll, value);
	}

	public boolean isLiftEdges()
	{
		return m_lift_edges_state;
	}

	public void setLiftEdges(boolean value)
	{
		m_lift_edges_state = value;
		setMyCheckBoxMenuItemState(m_lift_edges, value);
	}

	public boolean isVisibleEdges()
	{
		return m_visible_edges_state;
	}

	public void setVisibleEdges(boolean value)
	{
		m_visible_edges_state = value;
		setMyCheckBoxMenuItemState(m_visible_edges, value);
	}

	public boolean isTocHidden()
	{
		return m_toc_hidden_state;
	}

	public void setTocHiddenState(boolean value)
	{
		m_toc_hidden_state = value;
		TOC_HIDDEN_DEFAULT = value;
	}

	public void setTocHidden(boolean value)
	{
		m_toc_hidden_state = value;
		setMyCheckBoxMenuItemState(m_toc_hidden, value);
	}

	public static int fontHeight(Font font)
	{
		Toolkit tk = Toolkit.getDefaultToolkit();

		FontMetrics fm = tk.getFontMetrics(font);
		return (fm.getHeight());
	}

	public void setBestEdge()
	{
		m_edge_state = BEST_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, true);
		setMyCheckBoxMenuItemState(m_direct_edge, false);
		setMyCheckBoxMenuItemState(m_tb_edge, false);
		setMyCheckBoxMenuItemState(m_side_edge, false);
	}

	public void setTbEdge()
	{
		m_edge_state = TB_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, false);
		setMyCheckBoxMenuItemState(m_direct_edge, false);
		setMyCheckBoxMenuItemState(m_tb_edge, true);
		setMyCheckBoxMenuItemState(m_side_edge, false);
	}

	public void setDirectEdge()
	{
		m_edge_state = DIRECT_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, false);
		setMyCheckBoxMenuItemState(m_direct_edge, true);
		setMyCheckBoxMenuItemState(m_tb_edge, false);
		setMyCheckBoxMenuItemState(m_side_edge, false);
	}

	public void setSideEdge()
	{
		m_edge_state = SIDE_EDGE_STATE;
		setMyCheckBoxMenuItemState(m_best_edge, false);
		setMyCheckBoxMenuItemState(m_direct_edge, false);
		setMyCheckBoxMenuItemState(m_tb_edge, false);
		setMyCheckBoxMenuItemState(m_side_edge, true);
	}

	public int	getEdgeMode()
	{
		return m_edge_state;
	}

	public void setEdgeMode(int mode) 
	{
		switch (mode) {
		case BEST_EDGE_STATE:
			setBestEdge();
			break;
		case TB_EDGE_STATE:
			setTbEdge();
			break;
		case DIRECT_EDGE_STATE:
			setDirectEdge();
			break;
		case SIDE_EDGE_STATE:
			setSideEdge();
			break;
	}	}

	public static boolean isFillArrowhead()
	{
		return m_fill_arrowhead_state;
	}

	public static void setFillArrowheadState(boolean value)
	{
		m_fill_arrowhead_state = value;
	}

	public static boolean isCenterArrowhead()
	{
		return m_center_arrowhead_state;
	}

	public static void setCenterArrowheadState(boolean value)
	{
		m_center_arrowhead_state = value;
	}
}
