package lsedit;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.event.MouseEvent;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class EditModeHandler extends LandscapeModeHandler /* extends Object */ {

	// Supported modes

	protected MoveModeHandler	  m_moveHandler;
	protected ResizeModeHandler	  m_resizeHandler;
	protected NavigateModeHandler m_navHandler;
	protected GroupModeHandler	  m_groupingHandler;
	protected NewEdgeModeHandler  m_newEdgeModeHandler;

	private  LandscapeModeHandler m_handler = null;
	private	 long			      m_lastUp;
	private  boolean		 	  m_mouseIsDown = false;

	// Supported popups

	protected JPopupMenu		  m_rootEntityPopup;
	protected JPopupMenu		  m_entityPopup;
	protected JPopupMenu		  m_relationPopup;

	protected JPopupMenu buildRootPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Root options");

		m1 = new JMenu("Draw");
		Do.fontMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Move");
		Do.groupAllMenuItem(m1, m_ls);
		m.addSeparator();
		Do.scaleMenuItem(m1, m_ls);
		m.add(m1);
		return(m);
	}

	protected JPopupMenu buildEntityPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Entity options");

		m1 = new JMenu("Navigate");
		Do.navigateEntityMenu(m1, m_ls);
		m.add(m1);
		m1 = new JMenu("Query");
		Do.queryMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Elide");
		Do.hideMenuItem(m1, m_ls);
		m.add(m1);

		m1 = new JMenu("Draw");
		Do.drawMenuItem(m1, m_ls);
		m1.addSeparator();
		Do.editAttributesMenuItem(m1, m_ls);
		m1.addSeparator();
		Do.fontMenuItem(m1, m_ls);
		m.addSeparator();
		m.add(m1);

		m1 = new JMenu("Move");
		Do.groupAllMenuItem(m1, m_ls);
		m.addSeparator();
		Do.scaleMenuItem(m1, m_ls);
		m.add(m1);

		return(m);
	}

	protected JPopupMenu buildRelationPopup()
	{
		JPopupMenu m;
		JMenu	   m1;
		
		m = new JPopupMenu("Edge options");
		Do.navigateEdgeMenu(m, m_ls);
		Do.deleteEdgeMenuItem(m, m_ls);
		Do.editRelationMenuItem(m, m_ls);
		return(m);
	}

	// --------------
	// Public methods
	// --------------

	public EditModeHandler(LandscapeEditorCore ls) 
	{
		super(ls);

		m_moveHandler        = new MoveModeHandler(this);
		m_resizeHandler      = new ResizeModeHandler(this);
		m_navHandler         = new NavigateModeHandler(this);
		m_groupingHandler    = new GroupModeHandler(this);
	}

	public boolean mouseIsDown()
	{
		return m_mouseIsDown;
	}

	public 	LandscapeModeHandler getSubHandler()
	{
//		System.out.println("EditModeHandler.getSubHandler");
		return(m_handler);
	}

	public 	void setSubHandler(LandscapeModeHandler handler)
	{
//		System.out.println("EditModeHandler.setSubHandler from " + m_handler + " to " + handler);
		if (m_handler != null) {
			m_handler.cleanup();
		}
		m_handler = handler;
	}

	public void cleanup() 
	{
//		System.out.println("EditModeHandler.cleanup");
		setSubHandler(null);
	}

	protected static void usesObject(Object c, Object object)
	{
		if (c instanceof MyMenuItem) {
			((MyMenuItem) c).setObject(object);
			return;
		}
		if (c instanceof JMenu) {
			JMenu 		c1;
			JMenuItem	item;
			int		i;
			
			c1 = (JMenu) c;
			for (i = c1.getItemCount(); i > 0; ) {
				item = c1.getItem(--i);
				if (item != null) {
					usesObject(item, object);
			}	}
			return;
		}				
		if (c instanceof Container) {
			Container	c1;
			int			i;

			c1 = (Container) c;
			for (i = c1.getComponentCount(); i > 0; ) {
				usesObject(c1.getComponent(--i), object);
			}
			return;
		}
//		System.out.println("EditModeHandler.usesObject " + c);
	}

	public void moveGroup(int key)
	{
		m_groupingHandler.moveGroup(key);
	}
	
	public void newEdge(Object object)
	{
		if (m_newEdgeModeHandler == null) {
			m_newEdgeModeHandler = new NewEdgeModeHandler(this);
		}
		m_newEdgeModeHandler.activate(object);
	}
			
	public void rightClickEntity(MouseEvent ev, EntityInstance e, int x, int y)
	{
		Diagram		diagram = m_ls.getDiagram();
		JPopupMenu	m;

		if (e == diagram.getRootInstance()) {
			m = m_rootEntityPopup;
			if (m == null) {
				m_rootEntityPopup = m = buildRootPopup();
			}
		} else {
			m = m_entityPopup;
			if (m == null) {
				m_entityPopup = m = buildEntityPopup();
		}	}
	
		usesObject(m, e);
		FontCache.setMenuTreeFont(m); 
		m_ls.add(m);
		m.show(m_ls.getContentPane(), m_ls.getDiagramX()+x, m_ls.getDiagramY()+y);
	}

	public void rightClickRelation(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		JPopupMenu	m;

		m = m_relationPopup;
		if (m == null) {
			m_relationPopup = m = buildRelationPopup();
		}
		usesObject(m, ri);
		FontCache.setMenuTreeFont(m); 
		m_ls.add(m);
		m.show(m_ls.getContentPane(), m_ls.getDiagramX()+x, m_ls.getDiagramY()+y);
	}

	public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("EditModeHandler entity mousedown\n");

		if (ev.isMetaDown()) {
			rightClickEntity(ev, e, x, y);
			return;
		}

		m_mouseIsDown     = true;
//		System.out.println("EditModeHandler.entityPressed " + m_handler);
		if (m_handler != null) {
			m_handler.entityPressed(ev, e, x, y);
			return;
		}
		Diagram	diagram = m_ls.getDiagram();

		if (e == diagram.getDrawRoot()) {
			if (diagram.clearFlags()) {
				diagram.redrawDiagram();
		}	}

		if (ev.isControlDown()) {
			m_navHandler.entityPressed(ev, e, x, y);
			return;
		} 
		if (ev.isShiftDown()) {
			m_groupingHandler.entityPressed(ev, e, x, y);
			return;
		}
		// Determine if bend/IO move, resize, or group move/activate

		m_resizeHandler.entityPressed(ev, e, x, y);
		if (m_handler != null) {
			return;
		}
		m_moveHandler.entityPressed(ev, e, x, y);
		if (m_handler != null) {
			return;
		}
		m_groupingHandler.entityPressed(ev, e, x, y);
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y)
	{
		if (m_mouseIsDown) {
			long newUp = ev.getWhen();

//			System.out.println("EditModeHandler.entityReleased " + m_handler);
			if (newUp - m_lastUp < 300) {
//				System.out.println("Double click");
				m_ls.setCursor(Cursor.DEFAULT_CURSOR);
				mouseDoubleClick(ev, e);
				m_lastUp = 0;
			} else if (m_handler != null) {
				m_handler.entityReleased(ev, e, x, y);
			}
			m_lastUp    = newUp;
			m_mouseIsDown = false;
	}	}

	public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y) 
	{

//		System.out.println("EditModeHandler edge mousedown\n");

		if (ev.isMetaDown()) {
			rightClickRelation(ev, ri, x, y);
			return;
		}
		Diagram	diagram = m_ls.getDiagram();
		m_mouseIsDown   = true;

		if (m_handler != null) {
//			System.out.println("EditModeHandler.relationPressed " + m_handler);
			m_handler.relationPressed(ev, ri, x, y);
			return;
		} 

		if (!ev.isControlDown()) {
			if (ev.isShiftDown()) {
				m_groupingHandler.relationPressed(ev, ri, x, y);
				return;
			}
			diagram.clearFlags();

			// Determine if edge point move
			m_moveHandler.relationPressed(ev, ri, x, y);
			if (m_handler == null) {
				m_groupingHandler.relationPressed(ev, ri, x, y);
		}	}	
	}

	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y)
	{
		if (m_mouseIsDown) {
			long newUp = ev.getWhen();

			if (newUp - m_lastUp < 300) {

//				System.out.println("Double click");
				m_ls.setCursor(Cursor.DEFAULT_CURSOR);
				mouseDoubleClick(ev, ri);
				m_lastUp = 0;
			} else {
				m_lastUp = newUp;
//				System.out.println("EditModeHandler.relationReleased " + m_handler);
				if (m_handler != null) {
					m_handler.relationReleased(ev, ri, x, y);
			}	}
		}
		m_mouseIsDown = false;
	}
	
	public void mouseDoubleClick(MouseEvent ev, Object object) 
	{
		m_ls.processKey(Do.DESCEND, (ev.getModifiers() & (Event.SHIFT_MASK|Event.ALT_MASK|Event.CTRL_MASK|Event.META_MASK)), object);
	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y) 
	{
//		System.out.println("EditModeHandler.moveOverThing " + x + "x" + y);
		if (m_handler != null) {
			m_handler.movedOverThing(ev, thing, x, y);
			return;
		}
		m_resizeHandler.movedOverThing(ev, thing, x, y);
		if (m_handler == null) {
			m_moveHandler.movedOverThing(ev, thing, x, y);
	}	}

	public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("EditModeHandler.entityDragged " + m_handler);
		if (m_handler != null) {
			m_handler.entityDragged(ev, e, x, y);
		}
	}

	public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
//		System.out.println("EditModeHandler.relationDragged " + m_handler);
		if (m_handler != null) {
			m_handler.relationDragged(ev, ri, x, y);
		}
	}
}
