package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class Elision_u_Button extends ToolBarButton
{
	protected static final String description = "Hide/show edges whose target are selected entities";

	protected String getDesc() {
		return description;
	}

	protected void paintIcon(Graphics gc) {
		Dimension dim = getSize();

		int w = dim.width/2;
		int h = dim.height/2 - MARGIN*2;
		
		gc.setColor(Color.cyan);
		gc.fillRect(MARGIN*2, dim.height/2, w, h);

		gc.setColor(Color.black);
		gc.drawRect(MARGIN*2, dim.height/2, w, h);

		int x = MARGIN*2 + w/2;

		drawEdge(gc, x, MARGIN*2, x, dim.height/2);
	}

	public Elision_u_Button(ToolBarEventHandler teh) {
		super(teh);
		setKeystroke(0, Do.DST_EDGES);
	}
}
