package lsedit;

import java.awt.Color;
import java.awt.Font;

import javax.swing.JTextField;

public class Feedback extends JTextField {

	public final static String DEFAULT_FEEDBACK_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_FEEDBACK_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_FEEDBACK_FONT_SIZE  = 11;

	protected static Font m_textFont = FontCache.get(DEFAULT_FEEDBACK_FONT_NAME, DEFAULT_FEEDBACK_FONT_STYLE, DEFAULT_FEEDBACK_FONT_SIZE);

	// --------------
	// Public Methods
	// --------------

	public Feedback(String helpString) 
	{
		setToolTipText(helpString);

		setBackground(Diagram.boxColour);
		setForeground(Color.black);
		setFont(m_textFont);
		setEditable(false);
		setVisible(true);
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		setFont(font);
	}

	public void set(String str) 
	{
		setText(str);
		revalidate();
	}

	public String get() 
	{
		return(getText());
	}
}

