package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.undo.UndoableEdit;

class DeletedHistoryEntry
{
	protected EntityInstance	m_e;

	public DeletedHistoryEntry(EntityInstance e)
	{
		m_e = e;
	}

	public EntityInstance getEntity()
	{
		return m_e;
	}

	public String toString()
	{
		return m_e.getEntityLabel();
	}
}

public class HistoryBox extends JComponent implements ToolBarEventHandler, MouseListener, MouseMotionListener
{
	public class ShowReallyDelete extends JDialog implements ActionListener {

		protected LandscapeEditorCore	m_ls;
		protected JButton				m_ok;
		protected JButton				m_cancel;
		
		public ShowReallyDelete(LandscapeEditorCore ls)
		{
			super(ls.getFrame(), "Delete History", true);

			JFrame			frame;
			Container		contentPane;
			JPanel			grid;
			JPanel			panel;
			JLabel			label;
			int				x, y;
			
			m_ls       = ls;

			frame = ls.getFrame();

			x      = m_tabbedPane.getX() + 20;
			y      = m_tabbedPane.getY() + 20;
			setLocation(x, y);
			setForeground(ColorCache.get(0,0,0));
			setBackground(ColorCache.get(192,192,192));
			setFont(FontCache.get("Dialog",Font.PLAIN,12));

			contentPane = getContentPane();
			
			grid           = new JPanel();
			grid.setLayout(new GridLayout(1,1));

			label          = new JLabel("Confirm deletion?");
			grid.add(label);
			
			contentPane.add(grid, BorderLayout.CENTER);
			 
			panel = new JPanel();
			panel.setLayout(new FlowLayout());

			m_ok = new JButton("Ok");
			panel.add(m_ok);
			m_ok.addActionListener(this);
			m_cancel = new JButton("Cancel");
			panel.add(m_cancel);
			m_cancel.addActionListener(this);

			contentPane.add(panel, BorderLayout.SOUTH);

			// Resize the window to the preferred size of its components

			this.pack();
			show();
		}

		// ActionListener interface

		public void actionPerformed(ActionEvent ev)
		{
			Object	source;

			// Pop down the window when the button is clicked.
			// System.out.println("event: " + ev);

			source = ev.getSource();

			if (source == m_ok || source == m_cancel) {
				if (source == m_ok) {
					clear();
				}
				this.setVisible(false);
				return;
		}	}
	}

	protected static final int MARGIN    = 5;
	protected static final int GAP       = 5; 

	protected static final int TY_CLEAR	 = 0;
	protected static final int TY_RAISED = 1;
	protected static final int TY_SUNK	 = 2;

	protected LandscapeEditorCore   m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;

	public static Dimension         m_preferredSize    = new Dimension(0,0);
	public static int				m_disable_history  = 0;

	public    static final String m_helpStr	 = "This box shows the history of navigation within the current diagram.";


	public final static String DEFAULT_HISTORY_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_HISTORY_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_HISTORY_FONT_SIZE  = 11;

	protected static     Font		 m_textFont	 = FontCache.get(DEFAULT_HISTORY_FONT_NAME, DEFAULT_HISTORY_FONT_STYLE, DEFAULT_HISTORY_FONT_SIZE);
	protected static	 FontMetrics m_fm        = null;
	protected static	 int		 m_fontheight;
	protected static	 int		 m_baseline;

	protected Vector		m_history = new Vector(1000);
	protected int			m_style;
	protected int			m_over    = -1;		// What the mouse is over
	protected int			m_at      = -1;		// What we are logically at (-1 means no current position)

	protected void navigateTo(EntityInstance e)
	{
		++m_disable_history;
		m_ls.navigateTo(e);
		--m_disable_history;
		repaint();
	}

	// --------------
	// Public methods 
	// --------------

	public HistoryBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		m_ls          = ls;
		m_tabbedPane  = tabbedPane;

		setBackground(Diagram.boxColour);
//		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED); 
		m_scrollPane.setViewportView(this);
		tabbedPane.addTab("History", null, m_scrollPane, m_helpStr);
		addMouseListener(this);
		addMouseMotionListener(this);
	}

	public void clear()
	{
		m_history.removeAllElements();
		m_at   = -1;
		m_over = -1;
		m_ls.setHistoryButtons(HistoryBox.this);
		fillHistoryBox();
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
		m_fm       = null;
	}

	public void textFontChanged(Font font)
	{
		fillHistoryBox();
	}

/*
	public Dimension getPreferredSize()
	{
		Dimension d = super.getPreferredSize();

		System.out.println("HistoryBox.getPreferredSize " + d);
		return d;
	}

	public Dimension getSize()
	{
		Dimension d = super.getSize();

		System.out.println("HistoryBox.getSize " + d);
		return d;
	}
*/

	public void activate() 
	{
		fillHistoryBox();
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && m_scrollPane == active);
	}

	public void fillHistoryBox()
	{
		if (isActive()) {
			repaint();
	}	}

	public void setNewPreferredSize()
	{
//		System.out.println("HistoryBox.setNewPreferredSize " + m_preferredSize);
		setPreferredSize(m_preferredSize);
		setSize(m_preferredSize);
		m_scrollPane.revalidate();
	}

	public void addEntity(EntityInstance e)
	{
		int			w, h;
		boolean		ret;
		Vector		v;
		FontMetrics	fm;
		Vector		history = m_history;

		if (m_disable_history == 0) {
			m_at = history.size();
			history.addElement(e);

			if ((fm = m_fm) == null) {
				m_fm = fm    = getFontMetrics(HistoryBox.m_textFont);
				m_fontheight = fm.getHeight();
				m_baseline   = m_fontheight - fm.getDescent();
			}
			w    = fm.stringWidth(e.getEntityLabel())       + HistoryBox.GAP * 2;
			h    = history.size() * HistoryBox.m_fontheight + HistoryBox.GAP * 3;
			
			if (w > HistoryBox.m_preferredSize.width || h > HistoryBox.m_preferredSize.height) {
				if (w > HistoryBox.m_preferredSize.width) {
					HistoryBox.m_preferredSize.width  = w;
				}
				if (h > HistoryBox.m_preferredSize.height) {
					HistoryBox.m_preferredSize.height = h;
				}
				setNewPreferredSize();
			}
			fillHistoryBox();
	}	}

	public Dimension getMaximumSize()
	{
		return(getPreferredSize());
	}

	public void paintComponent(Graphics g)
	{
		Vector v   = m_history;

		if (v != null) {
			int				fontheight = m_fontheight;
			int				baseline   = m_baseline;
			int				height     = fontheight;
			int				at	       = m_at;
			String			label;

			Enumeration		en;
			int				over = m_over;
			int				i;
			Object			object;
			EntityInstance	e;

			g.setFont(m_textFont);

			for (i = m_history.size(); i > 0; ) {
				object = m_history.elementAt(--i);
				if (object instanceof EntityInstance) {
					e = (EntityInstance) object;
					if (i == over) {
						if (m_style != MapBox.TY_CLEAR) {
							Color color;

							color = g.getColor();
							g.setColor(Color.BLACK);
							g.draw3DRect(0, height, m_preferredSize.width-1, fontheight-2, m_style == TY_RAISED);
							g.setColor(color);
					}	} 
					if (i == at) {
						g.setColor(Color.RED);
					} else {
						g.setColor(Color.BLUE);
					}
					label = e.getEntityLabel();
				} else {
					g.setColor(Color.BLACK);
					label = object.toString();
				}
				g.drawString(label, MARGIN, height+baseline);
				height      += fontheight;
	}	}	}

	public boolean hasPrevious()
	{

		if (m_history.size() > 1) {
			int	at;

			at = m_at;
			if (at == -1) {
				at = m_history.size() - 1;
			}
			for (; --at >= 0; ) {
				if (m_history.elementAt(at) instanceof EntityInstance) {
					return true;
		}	}	}
		return false;
	}

	public void navigatePrevious()
	{
		if (m_history.size() > 1) {
			int		at;
			Object	object;

			at = m_at;
			if (at == -1) {
				at = m_history.size() - 1;
			}
			for (; --at >= 0; ) {
				object = m_history.elementAt(at);
				if (object instanceof EntityInstance) {
					m_over = -1;
					m_at   = at;
					navigateTo((EntityInstance) object);
					return;
	}	}	}	}

	public boolean hasNext()
	{
		int	at = m_at;

		if (at >= 0) {
			for (; ++at < m_history.size(); ) {
					if (m_history.elementAt(at) instanceof EntityInstance) {
					return true;
		}	}	}
		return false;
	}

	public void navigateNext()
	{
		int	at = m_at;

		if (at >= 0) {
			Object object;

			for (; ++at < m_history.size(); ) {
				object = m_history.elementAt(at);
				if (object instanceof EntityInstance) {
					m_over = -1;
					m_at   = at;
					navigateTo((EntityInstance) object);
					return;
	}	}	}	}

	public void containerCut(EntityInstance e)
	{
		Vector			history = m_history;
		int				size    = history.size();
		int				over    = m_over;
		int				i;
		Object			object;
		EntityInstance	e1;
		boolean			change  = false;

		for (i =  0; i < size; ++i) {
			object = m_history.elementAt(i);
			if (object instanceof EntityInstance) {
				e1 = (EntityInstance) object;
				if (e == e1) {
					m_history.set(i, new DeletedHistoryEntry(e1));  
					if (m_at == i) {
						m_at = -1;
					}
					change = true;
					continue;
		}	}	}
		if (change) {
			fillHistoryBox();
	}	}

	public void containerUncut(EntityInstance e)
	{
		Vector			history = m_history;
		int				size    = history.size();
		int				over    = m_over;
		int				i;
		Object			object;
		EntityInstance	e1;
		boolean			change  = false;

		for (i =  0; i < size; ++i) {
			object = m_history.elementAt(i);
			if (object instanceof DeletedHistoryEntry) {
				e1 = ((DeletedHistoryEntry) object).getEntity();
				if (e == e1) {
					m_history.set(i, e);  
					change = true;
					continue;
		}	}	}
		if (change) {
			fillHistoryBox();
	}	}

	public void entityCut(EntityInstance e)
	{
		Vector			history = m_history;
		int				size    = history.size();
		Object			object;
		int				i;
		EntityInstance	e1;
		boolean			change  = false;

		for (i = 0; i < size; ++i) {
			object = m_history.elementAt(i);
			if (object instanceof EntityInstance) {
				e1 = (EntityInstance) object;
				if (e.hasDescendantOrSelf(e1)) {
					m_history.set(i, new DeletedHistoryEntry(e1));  
					if (m_at == i) {
						m_at = -1;
					}
					change = true;
					continue;
		}	}	}
		if (change) {
			fillHistoryBox();
	}	}

	public void entityPasted(EntityInstance e)
	{
		Vector			history = m_history;
		int				size    = history.size();
		Object			object;
		int				i;
		EntityInstance	e1;
		boolean			change  = false;

		for (i = 0; i < size; ++i) {
			object = m_history.elementAt(i);
			if (object instanceof DeletedHistoryEntry) {
				e1 = ((DeletedHistoryEntry) object).getEntity();
				if (e.reallyHasDescendantOrSelf(e1)) {
					m_history.set(i, e1);  
					change = true;
					continue;
		}	}	}
		if (change) {
			fillHistoryBox();
	}	}

	protected void mouseAt(int y)
	{
		int	size = m_history.size();
		if (size > 0) {
			int	over = size - (y / m_fontheight);
			int style;

			if (over < 0) {
				style = HistoryBox.TY_CLEAR;
				over  = -1;
			} else if (over >= size) {
				style = HistoryBox.TY_CLEAR;
				over  = size;
			} else {
				style = HistoryBox.TY_RAISED;
			}
			if (style != m_style || over != m_over) {
				m_style = style;
				m_over  = over;
				repaint();
	}	}	}

	// MouseListener interface

	public void mouseClicked(MouseEvent ev)
	{
	}

	public void mouseEntered(MouseEvent ev)
	{
		mouseAt(ev.getY());
	}

	public void mouseExited(MouseEvent ev)
	{
		m_style = MapBox.TY_CLEAR;
		repaint();
	}

	public void mousePressed(MouseEvent ev)
	{
		int		size    = m_history.size();

		if (size > 0) {
			Vector	history = m_history;
			int		over;

			if (ev.isMetaDown()) {
				JPopupMenu	m =  new JPopupMenu("History options");
				new MyMenuItem(m, "Dispose", this, -1, Do.DELETE);
				FontCache.setMenuTreeFont(m); 
				m.show(this, ev.getX(), ev.getY());
				return;
			}

			m_over  = over = size - (ev.getY() / m_fontheight);
			m_style = MapBox.TY_SUNK;
			if (over >= 0 && over < size) {
				EntityInstance	e = (EntityInstance) history.elementAt(over);
				m_at = over;
				navigateTo(e);
			}
			repaint();
	}	}

	public void mouseReleased(MouseEvent ev)
	{

		m_style = MapBox.TY_CLEAR;
		repaint();
	}

	// MouseMotionListener interface

	public void mouseDragged(MouseEvent ev)
	{
		mouseAt(ev.getY());

	}

	public void mouseMoved(MouseEvent ev)
	{
		mouseAt(ev.getY());
	}

	// ToolBarEventHandler

	 public void processKeyEvent(int key, int modifiers, Object object)
	 {
		switch (key) {
			case Do.DELETE:
			{
				ShowReallyDelete dialog = new ShowReallyDelete(m_ls);
				dialog.dispose();
				break;
	 }	}	}

	 public void showInfo(String msg)
	 {
	 }		
}



