package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import java.awt.event.ActionEvent;

// Base class for layout classes accessed by Landscape Editor
//
// For a layouter to be available in the Landscape Editor, an instance entry
// must appear in the layouterList array in class LayouterManager.java

abstract public class LandscapeLayouter implements ToolBarEventHandler
{
	protected LandscapeEditorCore m_ls;

	protected void beep() 
	{
		System.out.print("\007");
		System.out.flush();
	}	 

	protected EntityInstance parentOfSet(Vector	set)
	{
		EntityInstance	e, parent, parent1;
		Enumeration		en;

		parent = null;
		for (en = set.elements(); en.hasMoreElements(); ) {
			e     = (EntityInstance) en.nextElement();
			parent1 = e.getContainedBy();
			if (parent == null) {
				parent = parent1;
			} else if (parent != parent1) {
				parent = null;
				break;
		}	}
		return(parent);
	}

	// --------------
	// Public methods
	// --------------

	public LandscapeLayouter(LandscapeEditorCore ls) 
	{
		m_ls = ls;
	}

	public LandscapeEditorCore getLs()
	{
		return m_ls;
	}

	// -----------------------
	// Abstract public methods
	// -----------------------

	// Called by system to obtain menu entry label for this layout routine

	abstract String getName();

	abstract String getMenuLabel();

	// This needs to be subclassed if layout is used to automate layout for missing coordinates

	public void doLayout1(Vector selectedBoxes, EntityInstance container, boolean update)
	{
	}

	// Called by the system when a layout is requested
	// Needs to be supplied by layout classes which derive from this
	// base class.
	//
	// Returns a status/error message string.


	abstract public String doLayout(Diagram dg);

	public void configure(LandscapeEditorCore ls)
	{
	}

	public boolean isConfigurable()
	{
		return false;
	}

	// ToolBarEventHandler

	public void actionPerformed(ActionEvent ev)
	{
	}

	public void showInfo(String msg)
	{
	}
}

