package lsedit;

public class LsLink extends Object {

	public static final int TARGET_TOP	 = 0;		 // Whole browser window
	public static final int TARGET_NEW	 = 1;		 // New browser window 
	public static final int TARGET_FRAME = 2;		 // Applet frame
	public static final int TARGET_TOC	 = 3;		 // TOC frame
	public static final int TARGET_LIST	 = 4;		 // Listing box
	public static final int TARGET_HELP  = 5;		 // Help box
	public static final int TARGET_APP	 = 6;		 // Menu command to app

	public static final String TARGET_APP_STR = "TARGET_APP";

	public String url;
	public int	  target; 



	protected static final String targets[] = 
		{	"TARGET_TOP", 
			"TARGET_NEW", 
			"TARGET_FRAME", 
			"TARGET_TOC", 
			"TARGET_LIST",
			"TARGET_HELP", 
			TARGET_APP_STR
		};



	public static String expand(String src, EntityInstance e, LandscapeEditorCore ls)
	{
		return Util.expand(src, e.getId(), ls);
	}



	public static String expand(String src, RelationInstance ri, LandscapeEditorCore ls)
	{	
		String id = "(" + ri.getRelationClass().getId() + "&" +	ri.getSrc().getId() + "&" +	 ri.getDst().getId() + ")";
		return Util.expand(src, id, ls);
	}



	public static int convertTarget(String tgtStr) 
	{
		for (int i=0; i<targets.length; i++) {
			if (tgtStr.equals(targets[i])) {
				return i;
			}
		}
		return -1;
	}

	public LsLink(String url, int target) 
	{
		MsgOut.dprintln("Link: " + url + " Target: " + target + " (" + targets[target] + ")");
		this.url = url; 
		this.target = target; 
	}



	public LsLink(String url, String target) 
	{
		MsgOut.dprintln("Link: " + url + " Target: " + target);

		this.url = url;
		if (target.length() == 1) {
			int val = Integer.parseInt(target);
			if (val >= 0 && val < targets.length) {
				this.target = val; 
			}
		} else {
			this.target = convertTarget(target);
		}
	}
}

