package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.Cursor;

public class MatrixLayout extends LandscapeLayouter  implements ToolBarEventHandler {

	public final static double BORDER = 0.0333;	// 1/30 of graph all round
	public final static double XGAP   = 0.2;		// Make gap 1/5 of space
	public final static double YGAP   = 0.2;		// Make gap 1/5 of space

	protected static double m_border  = BORDER;
	protected static double m_xgap    = XGAP;
	protected static double m_ygap    = YGAP;

	public MatrixLayout(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "Matrix";
	}

	public String getMenuLabel() 
	{
		return "Layout in a matrix";
	} 

	public static double getBorder()
	{
		return m_border;
	}

	public void setBorder(double value)
	{
		m_border = value;
	}

	public static double getXGap()
	{
		return m_xgap;
	}

	public void setXGap(double value)
	{
		m_xgap = value;
	}

	public static double getYGap()
	{
		return m_ygap;
	}

	public void setYGap(double value)
	{
		m_ygap = value;
	}

	public boolean isConfigurable()
	{
		return true;
	}

	public void configure(LandscapeEditorCore ls)
	{
		MatrixConfigure configure = new MatrixConfigure(this, BORDER, XGAP, YGAP, m_border, m_xgap, m_ygap);

		configure.dispose();
	}

	// The doLayout method executes the Matrix algorithm
	// Assumption: All boxes selected are in the same container.

	public void doLayout1(Vector selectedBoxes, EntityInstance container, boolean update) 
	{
		int				size = selectedBoxes.size();
		int				width, height, dimension, x, y, w, h, gapw, gaph, w1, h1, x1, y1, row, col, i, gaps;
		EntityInstance	e;
		double			xrel, yrel, widthrel, heightrel, dgaps;

		width  = container.getWidth();
		height = container.getHeight();
		x      = (int) (((double) width)  * m_border / 2.0);
		y      = (int) (((double) height) * m_border / 2.0);
		w      = width  - 2 * x;
		h      = height - 2 * y;

		if (w < 1 || h < 1) {
			return;
		}

		switch (size) {
		case 0:
			return;
		case 1:
			dimension = 1;
			gapw      = 0;
			gaph      = 0;
			w1        = w;
			h1        = h;
			break;
		default:
			dimension = (int) (Math.ceil(Math.sqrt(size)));
			gaps      = dimension - 1;
			dgaps     = (double) gaps;
			gapw      = (int) ((m_xgap * ((double) w))/dgaps); // Size of the gaps
			gaph      = (int) ((m_ygap * ((double) h))/dgaps);
			w1        = (w - (gapw * gaps)) / dimension;
			h1        = (h - (gaph * gaps)) / dimension;
		}
		
		if (w1 < 1 || h1 < 1) {
			return;
		}

		widthrel  = ((double) (w1 - gapw))/((double) width);
		heightrel = ((double) (h1 - gaph))/((double) height);

		SortVector.byString(selectedBoxes, true /* ascending */);

		row = col = 0;
		for (i = 0; i < size; ++i) {
			e = (EntityInstance) selectedBoxes.elementAt(i);
			x1 = x;
			if (col != 0) {
				x1 += col*w1 + gapw;
			}
			xrel = ((double) x1)/((double) width);
			y1 = y;
			if (row != 0) {
				y1 += row*h1 + gaph;
			}
			yrel = ((double) y1)/((double) height);

			if (update) {
				e.updateRelLocal(xrel, yrel, widthrel, heightrel);
			} else {
				e.setRelLocal(xrel, yrel, widthrel, heightrel);
			}
			if (++col == dimension) {
				++row;
				col = 0;
		}	}

//		System.out.println("Matrix done");

	} // doLayout


  // The doLayout method executes the Coffman-Graham Layer Assignment
  // algorithm and the Sugiyama algorithm on the boxes selected.
  // Assumption: All boxes selected are in the same container.

	public String doLayout(Diagram dg) 
	{
		EntityInstance parent;

		// get user's selection of boxes to be laid out

		m_ls.setLayouter(this);
		m_ls.setCursor(Cursor.WAIT_CURSOR);

		Vector selectedBoxes = dg.getGroup();
		if (selectedBoxes == null) {
			  beep();
			  return "No group selected";
		}

		parent = parentOfSet(selectedBoxes);
		if (parent == null) {
			return	"Matrix layouter requires that all things laid out share same parent";
		}
		dg.beginUndoRedo("Matrix layout");
		doLayout1(selectedBoxes, parent, true /* Updating */);
		dg.endUndoRedo();

		m_ls.setCursor(Cursor.DEFAULT_CURSOR);

		return "Graph redrawn using Matrix Layout";
	} // doLayout

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.rescaleDiagram();
			m_ls.repaintDg();
	}	}
} 





