package lsedit;

import java.awt.event.MouseEvent;

// This is the handler used if CTRL is pressed when mouse down occurs

public class NavigateModeHandler extends LandscapeModeHandler
{
	protected EditModeHandler	m_parent;
	protected boolean			m_middleButton;

	protected final static String titleStr = "Navigate mode options";
	protected final static String helpStr = "Left - Enter (in viewer)\nCtrl+Left Exit\nMiddle - Enter (new viewer)";

	// --------------
	// Public methods
	// --------------

	public NavigateModeHandler(EditModeHandler parent) 
	{
		super(parent.m_ls);
		m_parent = parent;
	}

	public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
//		System.out.println("NavigateModeHandler entityPressed\n");

		m_middleButton = ev.isAltDown();
		if (e.isClickable()) {
			e.drawHighlight();
			m_parent.setSubHandler(this);
		}
	}

	// Consider the thing pressed (not dragged) when still inside it
	// This allows for mouse shake.
	
	public void entityDragged(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		if (e.isClickable()) {
			if (e.containsDiagramPoint(x, y)) {
				e.drawHighlight();
			} else {
				e.undrawHighlight();
		}	}
	}

	public void entityReleased(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		System.out.println("NavigateModeHandler entityReleased e=" + e + " middle_button=" + m_middleButton);

		if (e.isHighlight()) {
			m_ls.followLink(e, m_middleButton);
		}
		m_parent.cleanup();
	}
}

