package lsedit;

import java.util.Enumeration;
import java.util.Vector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;

public class ResultBox extends JComponent implements Scrollable 
{
	protected static final Color	m_titleColor = Color.red.darker();

	public final static String DEFAULT_RESULT_TITLE_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_RESULT_TITLE_FONT_STYLE = Font.BOLD;
	public final static int    DEFAULT_RESULT_TITLE_FONT_SIZE  = 14;


	protected static       Font		m_titleFont  = FontCache.get(DEFAULT_RESULT_TITLE_FONT_NAME, DEFAULT_RESULT_TITLE_FONT_STYLE, DEFAULT_RESULT_TITLE_FONT_SIZE);

	public final static String DEFAULT_RESULT_TEXT_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_RESULT_TEXT_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_RESULT_TEXT_FONT_SIZE  = 11;

	protected static       Font		m_textFont	 = FontCache.get(DEFAULT_RESULT_TEXT_FONT_NAME, DEFAULT_RESULT_TEXT_FONT_STYLE, DEFAULT_RESULT_TEXT_FONT_SIZE);
	protected static final String	m_indent     = "    ";

	// <entity name> [<entity class name>]

	class ResultLabel extends JLabel
	{
		public ResultLabel()
		{
			super();
			setHorizontalAlignment(LEFT);
			setHorizontalTextPosition(LEFT);
			setFont(m_textFont);
		}

		public String toString()
		{
			return(getText());
		}
	}

	// <entity> [ {<class>} ]

	class ResultEntity extends ResultLabel implements MouseListener
	{
		protected EntityInstance		m_entity;
		protected boolean				m_visible;

		public ResultEntity(String indent, EntityInstance entity, boolean showClass)
		{
			super();

			String		text;
			
			m_entity  = entity;
			m_visible = true;
			text     = indent + entity.getEntityLabel();
			if (showClass) {
				text += " {" + entity.getClassLabel() + "}";
			}
			setText(text);
			setForeground(Color.blue);
			setToolTipText(entity.getDescription());
			addMouseListener(this);
		}

		public void entityCut(EntityInstance e)
		{
			if (m_visible && e.hasDescendantOrSelf(m_entity)) {
				m_visible = false;
				setForeground(Color.black);
				repaint();
		}	}

		// Have to be careful here could have a remaining delete
		// under a paste operation

		public void entityPasted(EntityInstance e)
		{
			EntityInstance entity = m_entity;

			if (!m_visible && e.hasDescendantOrSelf(entity)) {
				Enumeration	en;

				while (e != null) {
					if (e == m_entity) {
						m_visible = true;
						setForeground(Color.blue);
						repaint();
						break;
					}
					for (en = e.getChildren(); ; ) {
						if (!en.hasMoreElements()) {
							e = null;
							break;
						}
						e = (EntityInstance) en.nextElement();
						if (e.hasDescendantOrSelf(entity)) {
							break;
		}	}	}	}	}

		public void containerCut(EntityInstance e)
		{
			if (m_visible && e == m_entity) {
				m_visible = false;
				setForeground(Color.black);
				repaint();
		}	}

		public void containerUncut(EntityInstance e)
		{
			EntityInstance entity = m_entity;

			if (!m_visible && e == m_entity) {
				m_visible = true;
				setForeground(Color.blue);
				repaint();
		}	}

		// MouseListener interface

		public void mouseClicked(MouseEvent e)
		{
		}

		public void mouseEntered(MouseEvent e)
		{
			if (m_visible) {
				setForeground(Color.red);
				repaint();
		}	}

		public void mouseExited(MouseEvent e)
		{
			if (m_visible) {
				setForeground(Color.blue);
				repaint();
		}	}

		public void mousePressed(MouseEvent ev)
		{
		}

		public void mouseReleased(MouseEvent ev)
		{
			if (m_visible) {
				setForeground(Color.blue);
				m_ls.followLink(m_entity, false);
		}	}
	}

	class HorizontalResult extends JComponent
	{
		public HorizontalResult()
		{	
			super();
			setAlignmentX(LEFT_ALIGNMENT);
			setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		}

		public String toString()
		{
			int			i, cnt;
			Component	component;
			String		string;

			cnt      = getComponentCount();
			string   = "";
			for (i = 0; i < cnt; ++i) {
				component = getComponent(i);
				string += component.toString();
			}
			return string;
		}
	}

	class VerticalResult extends JComponent
	{
		public VerticalResult()
		{
			super();
			setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		}

		public String toString()
		{
			int			i, cnt;
			Component	component;
			String		string;

			cnt      = getComponentCount();
			string   = "";
			for (i = 0; i < cnt; ++i) {
				component = getComponent(i);
				string   += component.toString() + "\n";
			}
			return string;
		}
	}

	//  <Entity name> [<relation class>] <Entity name>

	class ResultRelation extends HorizontalResult
	{
		protected RelationInstance		m_relation;

		public ResultRelation(String indent, RelationInstance relation, boolean hideRc)
		{	
			super();

			ResultEntity	resultEntity;
			ResultLabel		rc;

			m_relation = relation;
			resultEntity = new ResultEntity(indent, relation.getSrc(), false);
			add(resultEntity);
			if (!hideRc) {
				rc = new ResultLabel();
				rc.setText(" " + relation.getClassLabel());
				rc.setHorizontalAlignment(JLabel.CENTER);
				add(rc);
			}
			resultEntity = new ResultEntity(" ", relation.getDst(), false);
			add(resultEntity);
		}

		public boolean matches(RelationInstance relation)
		{
			return(m_relation.matches(relation));
		}
	}

	// <ResultEntity> <rc> [*|?] 
	// [*|?] <rc> <ResultEntity>

	class ResultSetHeader extends HorizontalResult
	{
		public ResultSetHeader(EntityInstance entity, RelationClass relationClass, boolean forward, boolean closure)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			ResultLabel			rc, label;
			Object				object;
			EntityInstance		e;
			RelationInstance	r;
			String				type;

			if (closure) {
				type = "*";
			} else {
				type = "?";
			}

			rc           = new ResultLabel();
			rc.setText(" " + relationClass.getLabel());
			rc.setHorizontalAlignment(JLabel.CENTER);
			label        = new ResultLabel();


			if (forward) {
				resultEntity = new ResultEntity("", entity, false);
				label.setText(" " + type);
				label.setHorizontalAlignment(JLabel.LEFT);
				add(resultEntity);
				add(rc);
				add(label);
			} else {
				label        = new ResultLabel();
				label.setText(type);
				label.setHorizontalAlignment(JLabel.LEFT);
				resultEntity = new ResultEntity(" ", entity, false);
				add(label);
				add(rc);
				add(resultEntity);
			}
		}

		public ResultSetHeader(EntityInstance entity, Vector list)
		{
			super();

			ResultEntity	resultEntity;
			ResultLabel		label;

			resultEntity = new ResultEntity("", entity, false);
			label        = new ResultLabel();
			label.setText(" contains (" + list.size() + " items):");
			add(resultEntity);
			add(label);
		}
	}

	/*
		<entity> <relation class> ?
			<entity>
			...
			<entity>
	 */

	class ResultSet extends VerticalResult
	{
		public ResultSet(EntityInstance entity, RelationClass relationClass, Vector entities, boolean forward, boolean closure)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			ResultRelation		resultRelation;
			Object				object;
			EntityInstance		e;
			RelationInstance	r;

			add(new ResultSetHeader(entity, relationClass, forward, closure));
			for (en = entities.elements(); en.hasMoreElements(); ) {
				object = en.nextElement();
				if (object instanceof EntityInstance) {
					e = (EntityInstance) object;
					resultEntity = new ResultEntity(m_indent, e, false);
					add(resultEntity);
				} else {
					r = (RelationInstance) object;
					resultRelation = new ResultRelation(m_indent, r, true);
					add(resultRelation); 
			}	}
		}
	}

	/*
		<entity> <relation class> ?
			<entity>
			...
			<entity>
	 */

	class ResultContents extends VerticalResult
	{
		public ResultContents(EntityInstance entity, Vector entities)
		{
			super();

			Enumeration			en;
			ResultEntity		resultEntity;
			Object				object;
			EntityInstance		e;

			add(new ResultSetHeader(entity, entities));
			for (en = entities.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				resultEntity = new ResultEntity(m_indent, e, true);
				add(resultEntity);
			}
		}
	}

	protected static final int	horizontal_margin    = 10;
	protected static final int	vertical_indent      = 10;

	public    static final String m_helpStr = "This box shows the results of queries, and groupings";


	protected LandscapeEditorCore	m_ls;
	protected JTabbedPane			m_tabbedPane;
	protected JScrollPane			m_scrollPane;
	protected BoxLayout				m_boxLayout;

	protected void entityCut(JComponent parent, EntityInstance e)
	{
		int	i;
		JComponent	child;

		for (i = parent.getComponentCount(); i > 0; ) {
			child = (JComponent) parent.getComponent(--i);
			if (child instanceof ResultEntity) {
				((ResultEntity) child).entityCut(e);
			}
			entityCut(child, e);
	}	}

	protected void entityPasted(JComponent parent, EntityInstance e)
	{
		int	i;
		JComponent	child;

		for (i = parent.getComponentCount(); i > 0; ) {
			child = (JComponent) parent.getComponent(--i);
			if (child instanceof ResultEntity) {
				((ResultEntity) child).entityPasted(e);
			}
			entityPasted(child, e);
	}	}

	protected void containerCut(JComponent parent, EntityInstance e)
	{
		int	i;
		JComponent	child;

		for (i = parent.getComponentCount(); i > 0; ) {
			child = (JComponent) parent.getComponent(--i);
			if (child instanceof ResultEntity) {
				((ResultEntity) child).containerCut(e);
			}
			containerCut(child, e);
	}	}

	protected void containerUncut(JComponent parent, EntityInstance e)
	{
		int	i;
		JComponent	child;

		for (i = parent.getComponentCount(); i > 0; ) {
			child = (JComponent) parent.getComponent(--i);
			if (child instanceof ResultEntity) {
				((ResultEntity) child).containerUncut(e);
			}
			containerUncut(child, e);
	}	}

	// --------------
	// Public methods 
	// --------------

	public ResultBox(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super();

		m_boxLayout = new BoxLayout(this, BoxLayout.Y_AXIS);
		setLayout(m_boxLayout);
		
		Dimension d;

		m_ls         = ls;
		m_tabbedPane = tabbedPane;

		setBackground(Diagram.boxColour);
		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setBounds(0, 0, tabbedPane.getWidth(), tabbedPane.getHeight());
		d            = m_scrollPane.getSize();
		setLocation(0,0);
		setSize(d);
		setPreferredSize(d);
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("Results", null, m_scrollPane, m_helpStr);
	}

	public static Font getTitleFont()
	{
		return m_titleFont;
	}

	public static void setTitleFont(Font font)
	{
		m_titleFont = font;
	}

	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void entityCut(EntityInstance e)
	{
		entityCut(this, e);
	}

	public void entityPasted(EntityInstance e)
	{
		entityPasted(this, e);
	}

	public void containerCut(EntityInstance e)
	{
		containerCut(this, e);
	}

	public void containerUncut(EntityInstance e)
	{
		containerUncut(this, e);
	}

	public void clear() 
	{
		removeAll();
		validate();
		repaint();
	}

	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		
		if (isVisible()) {
			Component active;

			active = m_tabbedPane.getSelectedComponent();
			return(active != null && m_scrollPane == active);
		}
		return(false);
	}

	public void setResultTitle(String title)
	{
		clear();
		if (title != null) {
			ResultLabel	label = new ResultLabel();
			label.setText(title);
			label.setHorizontalAlignment(JLabel.LEFT);
			label.setFont(m_titleFont);
			label.setForeground(m_titleColor);
			add(label);
			add(Box.createVerticalStrut(5));
	}	}

	public void addResultEntity(EntityInstance e)
	{
//		activate();
		add(new ResultEntity("", e, false));

	}

	public void addRelation(RelationInstance r)
	{
//		activate();
		add(new ResultRelation("", r, false));
	}

	public void addForwardRelation(EntityInstance e, RelationClass rc, Vector list)
	{
//		activate();
		add(new ResultSet(e, rc, list, true, false /* Not closure */));
	}
		
	public void addBackRelation(EntityInstance e, RelationClass rc, Vector list)
	{
//		activate();
		add(new ResultSet(e, rc, list, false, false));
	}
	
	protected void addRelations(EntityInstance e, RelationClass rc, Vector list, boolean src)
	{
//		activate();
		add(new ResultSet(e, rc, list, src, true));
	}

	protected void addContents(EntityInstance e, Vector list)
	{
//		activate();
		add(new ResultContents(e, list));
	}

	public void addText(String message)
	{
		if (message != null) {
//			activate();
			ResultLabel	label = new ResultLabel();
			label.setText(message);
			label.setHorizontalAlignment(JLabel.LEFT);
			label.setForeground(Color.black);
			add(label);
	}	}

	public void done(String footer)
	{
		if (footer != null) {
			add(Box.createVerticalStrut(10));
			addText(footer);
		}
		setPreferredSize(m_boxLayout.preferredLayoutSize(this));
		validate();

		m_scrollPane.revalidate();
	}

	/* Show a list of entity labels vertically in order contained in vector 
	 * Used by GROUP ALL and FIND
	 */

	public void showResults(String title, Vector v, String footer) 
	{
		setResultTitle(title);

		if (v.size() > 0) {
			Enumeration		en;
			EntityInstance	e;

			for (en = v.elements(); en.hasMoreElements(); ) {
				e = (EntityInstance) en.nextElement();
				addResultEntity(e);
			}
		} else {
			footer = "No entities";
		}
		done(footer);
	}

/*
	public void paintComponent(Graphics g)
	{
		super.paintComponent(g);

		int	width, height;

		width   = getWidth();
		height  = getHeight();
		
		// For debugging
		g.setColor(Color.green);
		g.drawLine(0, 0, width, height);
		g.drawLine(0, height, width, 0);
	}
*/

	public String toString()
	{
		int			i, cnt;
		Component	component;
		String		string;

		cnt      = getComponentCount();
		string   = "";
		for (i = 0; i < cnt; ++i) {
			component = getComponent(i);
			string += component.toString() + "\n---\n";
		}
		return string;
	}
	
	// Scrollable interface
	// We need to implement this to stop iterative size changes..
	// The resultbox knows what size it wants to be and sets it on every validate
	// If we don't disable it the viewport tries to change the size to fit the window every time it validates

	public Dimension getPreferredScrollableViewportSize()
	{
		return(getSize());
	}
	 
	public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(50);
	}
	 
	public boolean getScrollableTracksViewportHeight() 
	{
		return(false);
	}

	public boolean getScrollableTracksViewportWidth() 
	{
		return(false);
	}

	public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction)
	{
		return(10);
	} 
}






