package lsedit;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JPanel;

public class Ta extends JPanel
{
	public final static String INSTANCE_ID				= "$INSTANCE";	
	public final static String INHERIT_RELN				= "$INHERIT";

	public final static String CONTAIN_ID				= "contain"; 
	public final static String EDGEMODE_ID				= "edgemode"; 
	public final static String TOPCLIENTS_ID			= "topclients"; 
	public final static String WANTCLIENTS_ID			= "wantclients"; 
	public final static String WANTSUPPLIERS_ID			= "wantsuppliers"; 
	public final static String WANTCARDINALS_ID			= "wantcardinals"; 
	public final static String SCALE_ID					= "scale";
	public final static String RELN_HIDDEN_ID			= "reln_hidden";
	public final static String NAVLINK_ID				= "navlink";

	private final static int	UPDATE_FREQ = 250; 

	public    final static String ROOT_ID = "$ROOT";
	private   final static String BG_STR = "0.75";			// String value of BG

	// Non-first order attributes of $ROOT

	private final static String g_rootAttributes[] =
		{ SCALE_ID, 
		  RELN_HIDDEN_ID, 
		  EDGEMODE_ID, 
		  NAVLINK_ID, 
		  TOPCLIENTS_ID,
		  WANTCLIENTS_ID,
		  WANTSUPPLIERS_ID,
		  WANTCARDINALS_ID
		};

	// Values

	protected LandscapeEditorCore	m_ls;
	private   Diagram				m_diagram;					// The actual diagram instance else null
	protected EntityInstance		m_rootInstance;				// The root instance of the graph
	
	private   Hashtable m_entityClasses	  = new Hashtable(10);

	// The set of relationClasses
	protected Hashtable m_relationClasses = new Hashtable(5);

	private   Hashtable m_attrNames	      = new Hashtable(20);
	private   Vector	m_numToRel		  = new Vector(10);

	public    RelationClass		m_relationBaseClass; 
	public    EntityClass		m_entityBaseClass;

	protected RelationClass		m_defaultRelationClass = null;
	protected int				m_numRelationClasses = 0;

	protected EntityClass		m_defaultEntityClass = null;
	private   int				m_numEntityClasses = 0; 

	private   boolean			m_universalScheme = false;

	private   Object			m_context;

	/* Must detect use of legacy coordinates and convert after diagram loaded
	 * since attributes may not be in tree order so won't know parent dimensions
	 * necessarily when doing conversion from legacy coordinates to relative ones
	 */

	boolean						m_uses_local_coordinates;

	/* Used in writing raw */

	private boolean				m_schemeSetup = false;
	protected String			m_resString = null;

	protected int				progressCount;
	protected boolean			m_changedFlag = false;
	
	protected int				m_numberEntities;
	protected int				m_numberRelations;
	// -----------------
	// Protected methods
	// -----------------

	// Overloaded by Diagram to return the actual diagram pointer
	protected Diagram getDiagram()
	{
		return(null);
	}

	public boolean getChangedFlag()
	{
		return m_changedFlag;
	}

	private void updateProgress() 
	{
		progressCount++;

		StringBuffer sb = new StringBuffer("Loading: ");
		for (int i=0; i<progressCount; i++) {
			sb.append('*');
		}
		m_ls.doFeedback(new String(sb));
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private EntityClass addEntityClass(String id) 
	{
		EntityClass ec = (EntityClass) m_entityClasses.get(id); 

		if (ec == null) {
			ec = new EntityClass(id, m_numEntityClasses++, m_entityBaseClass /* parent class */, m_diagram);
			m_entityClasses.put(id, ec);
			if (m_defaultEntityClass == null) {
				m_defaultEntityClass = ec;
			}
		}
		return ec;
	}

	// After this method has been called however many times
	// need to fillLegendBox again

	private RelationClass addRelationClass(String id) 
	{
		RelationClass rc = (RelationClass) m_relationClasses.get(id);		// Lookup in the hash table

		if (rc == null) {
			rc = new RelationClass(id, m_numRelationClasses, m_relationBaseClass, m_diagram);
			m_relationClasses.put(id, rc);
			m_numToRel.addElement(rc);
			m_numRelationClasses++;
			if (m_defaultRelationClass == null)
				m_defaultRelationClass = rc;
		}
		return rc;
	}

	private void registerAttrName(String id) 
	{
		if (m_attrNames.get(id) == null) {
			m_attrNames.put(id, id);
		}
	}

	private void registerAttrNames(Attribute attr) {

		while(attr != null) {
			registerAttrName(attr.id);
			attr = attr.next;
		}
	}

	/* Only called from process raw fact tuples.. don't need to manage TOC */

	private EntityInstance addEntity(EntityClass ec, String eid) 
	{
		EntityInstance e = ec.newEntity(eid);
		EntityCache.put(e);
		// For now make it contained by root
		m_rootInstance.addContainment(e);
		return e;
	}

	private void addEdge(EntityInstance src, EntityInstance dst, RelationClass rc)
	{

/*
		String key = Util.hashEdge(rc, src, dst);
		if (edges.contains(key))
			return;
		edges.put(key, key);
*/
		RelationInstance ri = rc.newRelation(src, dst);
		src.addRelation(ri, dst); 
	}

	// Setup for universal scheme
	// This is employed if there are no SCHEME TUPLES

	public boolean isUniversalScheme()
	{
		return m_universalScheme;
	}

	private void setupUniversalScheme() 
	{
		m_relationBaseClass.addRelation(m_entityBaseClass, m_entityBaseClass);
		m_universalScheme = true;
	}

	// Section processing methods

	private void 
	processSchemeTuples(LandscapeTokenStream ts) throws IOException {

		for (;;) {

			Tuple tuple = ts.nextTuple();

			if (tuple == null) {
				return;
			}

//			System.out.println("Schema Tuples: " + tuple);

			RelationClass rc = null;

			boolean inheritance = tuple.token1.equals(INHERIT_RELN);			// $INHERIT

			if (inheritance) {
				if (tuple.token2.equals(EntityClass.ENTITY_BASE_CLASS_ID)) {	// $ENTITY
					ts.errorNS("Improper use of $ENTITY with $INHERIT");
					return;
				}
			} else { 
				rc = addRelationClass(tuple.token1);
			}

			EntityClass ec1 = addEntityClass(tuple.token2); 
			EntityClass ec2 = addEntityClass(tuple.token3);

			if (inheritance) {

				String msg = ec1.addParentClass(ec2);
				if (msg != null)
					ts.errorNS(msg);
			} else {
				rc.addRelation(ec1, ec2);		// If not already present
			}
		}
	}

	private void processSchemeAttributes(LandscapeTokenStream ts) throws IOException 
	{

		for (;;) {

			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				return;
			}

//			System.out.println("Schema Attributes: " + ar);

			if (ar.id.startsWith("(")) {
				StringTokenizer st = new StringTokenizer(ar.id, "() ");
				String rel = st.nextToken();

				RelationClass rc = (RelationClass) m_relationClasses.get(rel);

				if (rc != null) {
					Attribute attr = ar.attributes;
					while(attr != null) { 
						rc.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else {
					ts.errorNS("Can't process record. Missing relation class '" + rel + "'");
				}
			} else {

				if (ar.id.equals(ROOT_ID)) {
					Attribute attr = ar.attributes;

					while(attr != null) {
						m_rootInstance.addAttribute(attr);
						attr = attr.next;
					}
					registerAttrNames(ar.attributes);
				} else { 

					EntityClass ec = (EntityClass) m_entityClasses.get(ar.id);

					if (ec != null) {
						Attribute attr = ar.attributes;
						while(attr != null) {
							ec.addAttribute(attr);
							attr = attr.next;
						}
						registerAttrNames(ar.attributes);
					} else {
						ts.errorNS("Can't process record. Missing entity class '" + ar.id + "'");
					}
				}
			}
		}
	}

	private void processFactTuples(LandscapeTokenStream ts) throws IOException 
	{
		Tuple	tuple;
		int		ne = 0;
		int		nr = 0;

		MsgOut.vprint("\nFACT TUPLE : ");

		while ((tuple = ts.nextTuple()) != null) {

//			System.out.println(ne + "/" + nr + ":Fact Tuple: " + tuple);

			if (tuple.token1.equals(INSTANCE_ID)) {

				// 
				// $INSTANCE instanceId classId
				//

				ne++;
		
				if ((ne % UPDATE_FREQ) == 0) {
					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Entities: " + ne);
				}		


				EntityInstance e = EntityCache.get(tuple.token2);

				if (e == null) {

					// New $INSTANCE

					EntityClass ec = (EntityClass) m_entityClasses.get(tuple.token3);


					if (ec == null && isUniversalScheme()) {
						ec = m_entityBaseClass;
					}	

					if (ec != null) {
						e = ec.newEntity(tuple.token2);
						EntityCache.put(e);

						// For now make it contained by root

						m_rootInstance.addContainment(e);

					}  else {
						ts.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
					}
				} else {

					EntityClass ec = e.getEntityClass();

					if (ec.hasId(tuple.token3)) {
						ts.warning("Redeclaration of " + e.toString());
					} else {

						ts.errorNS("Attempt to declare " + e.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + ec.getId());
					}
				}
			} else {

				// Relation tuple definition
				//
				// relationClass entityInstance entityInstance
				//

				nr++;

				if ((nr % UPDATE_FREQ) == 0) {

					MsgOut.vprint(".");
					updateProgress();
					m_ls.showInfo("Relations: " + nr);
				}		



				RelationClass rc  = (RelationClass)	 m_relationClasses.get(tuple.token1);
				EntityInstance e1 = EntityCache.get(tuple.token2);
				EntityInstance e2 = EntityCache.get(tuple.token3);

				if (m_universalScheme) {

					// Implicit declaration upon use

					if (rc == null) {
						rc = m_relationBaseClass;
					}

					if (e1 == null) {
						e1 = m_entityBaseClass.newEntity(tuple.token2);
						EntityCache.put(e1);
						m_rootInstance.addContainment(e1);
					}

					if (e2 == null) {
						e2 = m_entityBaseClass.newEntity(tuple.token3);
						EntityCache.put(e2);
						m_rootInstance.addContainment(e2);
					}
				}

				if (rc == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
				} else if (e1 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
				} else if (e2 == null) {
					ts.errorNS("Can't process: " + "(" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
				} else {

					EntityClass ec1 = e1.getEntityClass();
					EntityClass ec2 = e2.getEntityClass();

					if (tuple.token1.equals(CONTAIN_ID)) {
						// Right now it is contained by root, so
						// remove from root's containment, and
						// make it contained by another e1.

						if (e2.isMarked(EntityInstance.IN_TREE_MARK)) {
							System.out.println("Entity " + e2 + " has multiple parents");
						} else {
							if (m_rootInstance.removeContainment(e2)) {
								e2.orMark(EntityInstance.IN_TREE_MARK);
								e1.addContainment(e2);
							} else {
								System.out.println("Entity " + e2 + " not in unassigned collection waiting containment");
						}	}
					} else {
						addEdge(e1, e2, rc);
					}
				}
			}
		}
		m_numberEntities  = ne;
		m_numberRelations = nr;
	}

	private void processFactAttributes(LandscapeTokenStream ts) throws IOException 
	{
		int n = 0;

		MsgOut.vprint("\nFACT ATTRIBUTE : ");
		for (;;) {
			AttributeRecord ar = ts.nextRecord();
			if (ar == null) {
				break;
			}

//			System.out.println("Fact Attribute: " + ar);
				
			n++; 

			if ((n % UPDATE_FREQ) == 0) {
				MsgOut.vprint(".");
				updateProgress();
				m_ls.showInfo("Attr Records: " + n);
			}

			MsgOut.vprintln("Processing record: " + ar.id);

			if (ar.id.startsWith("(")) {
				// Attributes assigned to a relation tuple (rare)

				Tuple tuple = new Tuple(ar.id);

				RelationClass  rc  = (RelationClass)	m_relationClasses.get(tuple.token1);
				EntityInstance src = EntityCache.get(tuple.token2);
				EntityInstance dst = EntityCache.get(tuple.token3);

				if (rc == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing relation '" + tuple.token1 + "'");
				} else if (src == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token2 + "'");
				} else if (dst == null) {
					ts.errorNS("Can't process record for " + ar.id + ". " + "Missing entity '" + tuple.token3 + "'");
				} else {
					RelationInstance ri = src.getRelation(rc, dst);

					if (ri == null) {
						ts.errorNS("Can't process record. " + "Missing relation " + ar.id);
					} else {
						ri.assignAttributes(ar.attributes);
						registerAttrNames(ar.attributes);
					}
				}
			}  else {

				EntityInstance e;

				if (ar.id.equals(ROOT_ID)) {
					e = m_rootInstance;
				} else {
					e = EntityCache.get(ar.id);
				}
				if (e != null) {
					e.assignAttributes(ar.attributes);
					registerAttrNames(ar.attributes);
				} else if (m_universalScheme) {

					// Create it

					e = m_entityBaseClass.newEntity(ar.id);
					EntityCache.put(e);

					m_rootInstance.addContainment(e);

					e.assignAttributes(ar.attributes);

					registerAttrNames(ar.attributes);

				} else {

					ts.errorNS("Can't process record. " + "Missing entity '" + ar.id + "'");
				}
			}
		}
	}



	// *** And now for output ***

	private void writeSchemeTuples(PrintStream ps) throws IOException 
	{
		ps.print("// Landscape TA file\n\n");
		ps.print("SCHEME TUPLE :\n\n// The ERD\n\n"); 

		Enumeration en0 = enumEntityClassesInOrder();

		while(en0.hasMoreElements()) {
			EntityClass ec = (EntityClass) en0.nextElement();
			if (ec != m_entityBaseClass) {
				Enumeration en = ec.getParentElements();
				while (en.hasMoreElements()) {
					EntityClass parent = (EntityClass) en.nextElement();
					if (parent != m_entityBaseClass) {
						ps.print(INHERIT_RELN + " " + ec.getId() + " " + parent.getId() + "\n");
					}
				}
			}
		}
		ps.print("\n");
		for (en0 = enumRelationClassesInOrder(); en0.hasMoreElements(); ) {	// Output in same order as input
			RelationClass rc = (RelationClass) en0.nextElement();
			rc.writeRelations(ps); 
		}
	}

	private void writeSchemeAttributes(PrintStream ps) throws IOException 
	{
		Enumeration en;

		ps.print("\n\nSCHEME ATTRIBUTE :\n\n");
		ps.print("// EntityClass attributes\n\n");
		// Write attributes for entity classes 

		for (en = m_entityClasses.elements(); en.hasMoreElements(); ) {
			EntityClass ec = (EntityClass) en.nextElement(); 
			ec.writeAttributes(ps);
		}

		// Write attributes for relation classes 

		for (en = m_relationClasses.elements(); en.hasMoreElements(); ) {
			RelationClass rc = (RelationClass) en.nextElement();
			rc.writeAttributes(ps);
		}
	}

	private void writeFactAttributes(PrintStream ps) throws IOException
	{
		ps.print("\n\nFACT ATTRIBUTE :\n\n"); 
		m_rootInstance.writeAttributes(ps); 
	}

	private void writeFactTuples(PrintStream ps) throws IOException 
	{
		ps.print("\n\nFACT TUPLE :\n\n"); 
		ps.print("// Instances of entity classes\n\n");
		m_rootInstance.writeInstances(ps);
		m_rootInstance.writeRelations(ps); 
	}

	private void computeRelCoordinates()
	{
		m_rootInstance.computeRelCoordinates(m_rootInstance.xRelLocal(), m_rootInstance.yRelLocal(), m_rootInstance.widthRelLocal(), m_rootInstance.heightRelLocal() );
	}

	public void emptyDiagram() 
	{
		EntityInstance	e;

		m_uses_local_coordinates = false;
		m_schemeSetup = true;
		setupUniversalScheme();

		m_defaultEntityClass   = m_entityBaseClass;
		m_defaultRelationClass = m_relationBaseClass;
		e = m_entityBaseClass.newEntity("BLANK");
		EntityCache.put(e);
		m_rootInstance.addContainment(e);
	} 

	private void parseStream(InputStream is, String src, URL context) {

		MsgOut.vprintln("Parse TA file: " + src);

		m_uses_local_coordinates = false;

		try {
			BufferedInputStream bis = new BufferedInputStream(is);

			LandscapeTokenStream ts = new LandscapeTokenStream(bis, src);

			for (;;) {
				int sec = ts.nextSection();

				if (sec == LandscapeTokenStream.EOF) {
					MsgOut.vprintln("");
					break;
				}
				try { 
					switch(sec) {

					case LandscapeTokenStream.SCHEME_TUPLE:

						// regSrcInfo(src, sec);

						m_schemeSetup = true;
						m_universalScheme = false;

						processSchemeTuples(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.SCHEME_ATTRIBUTE:

						// regSrcInfo(src, sec);

						if (!m_schemeSetup) {
							m_schemeSetup = true;
							setupUniversalScheme();
						}
						processSchemeAttributes(ts);
						updateProgress();
						break;



					case LandscapeTokenStream.FACT_TUPLE:

						// regSrcInfo(src, sec);

						if (!m_schemeSetup) {
							m_schemeSetup = true;
							setupUniversalScheme();
						}

						processFactTuples(ts);
						break;



					case LandscapeTokenStream.FACT_ATTRIBUTE:

						// int srcIndex = regSrcInfo(src, sec);

						processFactAttributes(ts);
						break;


					case LandscapeTokenStream.INCLUDE_FILE:

						if (m_context == null) {
							parseFile(ts.getIncludeFile(), null);
						} else {
							parseURL(ts.getIncludeFile(), context);
						}
						MsgOut.vprintln("Back to TA file: " + src);
						break; 
					}

				}

				catch (IOException e) {

					MsgOut.println("IO error reading landscape"); 
					m_resString = e.toString();
					break; 
				}
			}
			StringCache.clear();
			bis.close(); 
			is.close();

			if (m_uses_local_coordinates) {
				computeRelCoordinates();
			}
		}

		catch (Exception e) {
			m_resString = e.toString();
			System.out.println("Parse error: " + m_resString);
		}


	} // end parseStream() 

	private URL parseURL(String taURL, URL context) {

		progressCount = 0;

		updateProgress();

		try {

			URL lsURL;

			if (context == null) {
				lsURL = new URL(taURL);
			} else {
				lsURL = new URL(context, taURL);
			}

			MsgOut.dprintln("Opening URL: " + taURL);
			InputStream is = lsURL.openStream();
			MsgOut.dprintln("opened");
			parseStream(is, taURL, lsURL);
			return lsURL; 
		}
		catch(Exception e) {
			m_resString = e.toString();
			return null;
		}
	}


	// Called from diagram.loadDiagram to parse a file or an include within a file

	private File parseFile(String taFile, File context) 
	{
		progressCount = 0;

		updateProgress();

		try {
			File file;

			if (context == null)
				file = new File(taFile);
			else {
				String dir = getDir(context);

				file = new File(dir, taFile);
			}

			FileInputStream fis = new FileInputStream(file);

			parseStream(fis, taFile, null);
			return file;

		} catch (Exception e) {
			m_resString = e.toString();
			return null;
		}
	}

	// --------------
	// Public methods
	// --------------

	public Ta(LandscapeEditorCore ls) 
	{
		m_ls      = ls;
		m_diagram = getDiagram();

		// Must create this before create $ROOT
		// Need a navlink attribute on rootInstance

		m_entityBaseClass = new EntityClass(EntityClass.ENTITY_BASE_CLASS_ID, m_numEntityClasses++, null, m_diagram);							// $ENTITY
		m_entityClasses.put(EntityClass.ENTITY_BASE_CLASS_ID, m_entityBaseClass);

		// Create root entity

		m_rootInstance = new EntityInstance(m_entityBaseClass, ROOT_ID); 	// $ROOT
		m_rootInstance.setRelLocal(0.0, 0.0, 1.0, 1.0);
		m_rootInstance.prepostorder(1);									// Ensure root always has preorder == 1
		
		EntityCache.put(m_rootInstance);

		for (int i = 0; i < g_rootAttributes.length; i++) {
			m_rootInstance.addAttribute( new Attribute(g_rootAttributes[i], null));
		}

		AttributeValueItem av = new AttributeValueItem(BG_STR);																			// 0.75

		av.next = new AttributeValueItem(BG_STR);
		av.next.next = new AttributeValueItem(BG_STR);
		m_rootInstance.addAttribute(new Attribute("color", av));																			// $ROOT (0.75 0.75 0.75)


		m_relationBaseClass =	 new RelationClass(RelationClass.RELATION_BASE_CLASS_ID, m_numRelationClasses++, null /* parent */, m_diagram);	// $RELATION
		m_relationClasses.put(RelationClass.RELATION_BASE_CLASS_ID, m_relationBaseClass);													// Add to hash table
		m_numToRel.addElement(m_relationBaseClass);

		RelationClass rc = new RelationClass(CONTAIN_ID, m_numRelationClasses++, m_relationBaseClass, m_diagram);								// contain
		m_relationClasses.put(CONTAIN_ID, rc);																							// Add to hash table
		m_numToRel.addElement(rc);
	}

	public LandscapeEditorCore getLs() 
	{
		return m_ls;
	}

	public RelationClass nameToRelationClass(String name) 
	{
		if (m_relationClasses.containsKey(name)) {

		   return (RelationClass) m_relationClasses.get(name);

		}
		return null;
	}

	public Enumeration enumRelationClasses() 
	{
		return m_relationClasses.elements(); 
	}

	public Enumeration enumRelationClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_relationClasses); 
	}

	public int numRelationClasses() 
	{
		return m_numRelationClasses;
	}

	public Enumeration enumEntityClasses() 
	{
		return m_entityClasses.elements(); 
	}

	public Enumeration enumEntityClassesInOrder() 
	{
		return OrderedHashTableEnumeration.elements(m_entityClasses); 
	}

	public int numEntityClasses() 
	{
		return m_numEntityClasses;
	}

	public Object getContext() 
	{
		return m_context;
	}

	public void setContext(Object context) 
	{
		m_context = context;
	}

	public String getContextName() 
	{
		if (m_context instanceof File) {
			return Util.nameFromPath(((File) m_context).getPath()); 
		}
		return m_rootInstance.getEntityLabel();
	}

	public String getDir(File file) 
	{
		if (file.isAbsolute()) {
			return file.getParent();
		}
		return (new File(file.getAbsolutePath())).getParent();
	}

	public String getDir() 
	{
		return getDir((File) m_context);
	}

	public String getAbsolutePath() 
	{
		if (m_context != null) {
			if (m_context instanceof File) {
				return ((File) m_context).getAbsolutePath();
			}
//			return ((URL) m_context).toExternalForm();
		}
		return null;
	}

	public RelationClass numToRelationClass(int n) 
	{
		return (RelationClass) m_numToRel.elementAt(n);
	}

	// Save the landscape in the output stream

	public void saveDiagram(OutputStream os, boolean markEnd) throws IOException
	{
		BufferedOutputStream bos = new BufferedOutputStream(os);
		PrintStream ps = new PrintStream(bos);

		writeSchemeTuples(ps);
		writeSchemeAttributes(ps);
		writeFactTuples(ps);
		writeFactAttributes(ps);

		if (markEnd) {
			ps.print("END\n");
		}
		ps.flush();
		ps.close();
		m_changedFlag = false;
	}

	public String loadTA(String taPath, Object context) {

		Attribute	attr;
		boolean		option;

		m_resString = null;

		if (taPath == null) {
			emptyDiagram();
		} else {
			char lc	  = taPath.charAt(taPath.length()-1);

			if (lc == File.separatorChar) {
				taPath = taPath.substring(0, taPath.length()-1);
			}

			if (context instanceof URL || Util.isHTTP(taPath)) {
				MsgOut.dprintln("Parse a URL");
				setContext(parseURL(taPath, (URL) context));
			} else {
				MsgOut.dprintln("Parse a file");
				setContext(parseFile(taPath, (File) context));
		}	}
	
		if (m_defaultEntityClass == null) {
			m_defaultEntityClass = m_entityBaseClass;
		}
		if (m_defaultRelationClass == null) {
			m_defaultRelationClass = m_relationBaseClass;
		}
			
		if (m_context == null) {
			return m_resString;
		}
		return null;
	}
	
	public int getNumberEntitiesLoaded()
	{
		return m_numberEntities;
	}

	public int getNumberRelationsLoaded()
	{
		return m_numberRelations;
	}
}

