package lsedit;

import java.awt.FontMetrics;
import java.util.Vector;

import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class UndoableTa extends Ta implements UndoableEditListener  
{
	class MyUndoManager extends UndoManager {
		
		MyUndoManager() 
		{
		}

		public Vector getEdits()
		{
			return edits;
		}

		public UndoableEdit getEditToBeRedone()
		{
			return((UndoableEdit) editToBeRedone());
		} 
		
		public void massChange(UndoableEdit undoableEdit, boolean redo)
		{
			if (redo) {
				redoTo(undoableEdit);
			} else {
				undoTo(undoableEdit);
			}
		}
		
		public int	countEdits()
		{
			return(edits.size());
		} 
	}

	protected MyUndoManager			m_undoManager      = new MyUndoManager();
	protected String				m_compoundEditName = null;
	protected MyCompoundEdit		m_compoundEdit     = null;
	protected int					m_compoundEditCnt  = -1;
	protected boolean				m_useCompoundEdit  = true;

	// -----------------
	// Protected methods
	// -----------------

	protected void updateMenu()
	{
		m_ls.setEnabledRedo(m_undoManager.canRedo());
		m_ls.setEnabledUndo(m_undoManager.canUndo());
	}

	public UndoableTa(LandscapeEditorCore ls)
	{
		super(ls);
	}

	public boolean useCompoundEdit()
	{
		return m_useCompoundEdit;
	}

	public void setUseCompoundEdit(boolean value)
	{
		m_useCompoundEdit = value;
	}

	public int getLimit()
	{
		return m_undoManager.getLimit();
	}

	public void setLimit(int limit)
	{
		m_undoManager.setLimit(limit);
	}

	public Vector getEdits()
	{
		return m_undoManager.getEdits();
	}

	public UndoableEdit getEditToBeRedone()
	{
		return m_undoManager.getEditToBeRedone();
	}

	public int countEdits()
	{
		return m_undoManager.countEdits();
	}

	public void massChange(UndoableEdit undoableEdit, boolean redo)
	{
		m_undoManager.massChange(undoableEdit, redo);
	}

	public void discardAllEdits()
	{
		m_undoManager.discardAllEdits();
	}

 	public boolean addEditToManager(UndoableEdit anEdit) 
	{	
		int			w, h;
		boolean		ret;
		Vector		v;

		if (anEdit instanceof MyPaintableUndoableEdit) {
			w   = ((MyPaintableUndoableEdit) anEdit).getPreferredWidth();
		} else {
			FontMetrics	fm;

			fm   = getFontMetrics(UndoBox.m_textFont);
			w    = fm.stringWidth(anEdit.getPresentationName());
		}

		ret = m_undoManager.addEdit(anEdit);
		v   = getEdits();
		if (v == null) {
			h = 0;
		} else {
			h = v.size() * UndoBox.HEIGHT;
		}
		h += UndoBox.GAP * 3;
		w += UndoBox.GAP * 2;

		if (w > UndoBox.m_preferredSize.width || h > UndoBox.m_preferredSize.height) {
			if (w > UndoBox.m_preferredSize.width) {
				UndoBox.m_preferredSize.width  = w;
			}
			if (h > UndoBox.m_preferredSize.height) {
				UndoBox.m_preferredSize.height = h;
			}
			m_ls.setPreferredSizeUndo();
		}
		m_ls.fillUndoBox();
		return(ret);
	}

	public void	beginUndoRedo(String name)
	{
		if (m_useCompoundEdit) {
			m_compoundEditName = name;
			m_compoundEdit     = null;
			m_compoundEditCnt  = 0;
	}	}

	public void endUndoRedo()
	{
		if (m_compoundEdit != null) {
			m_compoundEdit.end();
			m_compoundEdit = null;
		}
		m_compoundEditName = null;
		m_compoundEditCnt  = -1;
	}

	public boolean logEdit(UndoableEdit anEdit) 
	{	
		boolean ret;

		m_changedFlag = true;
		if (m_compoundEditCnt < 0) {
			ret = addEditToManager(anEdit);
		} else {
			switch (m_compoundEditCnt) {
			case 0:
				ret            = addEditToManager(anEdit);
				break;
			case 1:
				m_compoundEdit = new MyCompoundEdit(m_compoundEditName);
				ret            = m_compoundEdit.addEdit(anEdit);
				ret            = addEditToManager(m_compoundEdit);
				break;
			default:
				ret            = m_compoundEdit.addEdit(anEdit);
			}
			++m_compoundEditCnt;
		}
		updateMenu();
		if (!ret) {
			m_ls.error("logEdit failed");
		}
		return(ret);
	}

	public void undoableEditHappened(UndoableEditEvent e)
	{
		m_undoManager.undoableEditHappened(e);
		updateMenu();
	}

	public void undo()
	{
		String s;

		if (!m_undoManager.canUndo()) {
			s = "Nothing to undo";
		} else {
			m_undoManager.undo();
			updateMenu();
//			m_ls.redrawDg();	// TODO: might get smarter about this
//			repaint();
			s = "Undo done";
		}
		m_ls.fillUndoBox();
		m_ls.doFeedback(s);
	}

	public void redo()
	{
		String s;

		if (!m_undoManager.canRedo()) {
			s = "Nothing to redo";
		} else { 
			m_undoManager.redo();
			m_ls.doFeedback("Redo done");
			updateMenu();
//			m_ls.redrawDg();
//			repaint();
			s = "Redo done";
		}
		m_ls.fillUndoBox();
		m_ls.doFeedback(s);
	}
}

