package lsedit;

/* This class caches entities in the current diagram
 */

public class EntityCache {

	static class Entry {
		public EntityInstance 	m_value;
		public Entry			m_next;

		protected Entry(EntityInstance e, Entry next) 
		{
			m_value = e;
			m_next  = next;
		}
	};

    private static Entry m_table[] = null;

    /**
     * The total number of entries in the hash table.
     */

    private static int m_count = 0;

    /**
     * Returns the number of keys in this hashtable.
     *
     * @return  the number of keys in this hashtable.
     */

    public static int size() 
	{
		return m_count;
    }

    /**
     * Clears this hashtable so that it contains no keys. 
     */
    
	public static void clear() 
	{
		m_table = null;
		m_count = 0;
    }

    /**
	  * Add a new Entity to the cache
      */
    
	public static void put(EntityInstance e) 
	{
		Entry	table[] = m_table;
		int		index;

		if (table == null) {
			table   = new Entry[0x40000];	// 262,144
			m_table = table;
		} 
		index = e.getId().hashCode() & 0x3FFFF;

		{
			Entry			entry;
			EntityInstance	e1;

			for (entry = table[index] ; entry != null ; entry = entry.m_next) {
				e1 = entry.m_value;
				if (e1.getId().equals(e.getId())) {
					if (e == e1) {
						return;
		}	}	}	}

		// Creates the new entry.
		table[index] = new Entry(e, table[index]);;
		++m_count;
    }

	public static void remove(EntityInstance e) 
	{
		Entry	table[] = m_table;
		int		index;

		if (table != null) {
			index = e.getId().hashCode() & 0x3FFFF;

			Entry			entry, prev;
			EntityInstance	e1;

			for (entry = table[index], prev = null ; entry != null ; prev = entry, entry = entry.m_next) {
				if (e == entry.m_value) {
					if (prev != null) {
						prev.m_next = entry.m_next;
					} else {
						table[index] = entry.m_next;
					}
					entry.m_value = null;
					--m_count;
					return;
		}	}	}
		System.out.println("EntityCache: can't remove " + e);
    }

    /**
     * Returns the Font having this property.
     *
     */
    
	public static EntityInstance get(String id) 
	{
		Entry			table[] = m_table;
		Entry			entry;
		EntityInstance	e;
	
		if (table != null) {
			for (entry = table[id.hashCode() & 0x3FFFF] ; entry!= null ; entry = entry.m_next) {
				e = entry.m_value;
				if (id.equals(e.getId())) {
					return e;
		}	}	}
		return null;
    }

	/* For debugging [Can't use toString -- static class] */

	public static void show()
	{
		Entry	table[] = m_table;
		Entry	entry;
		int		index, length;

		if (table == null) {
			System.out.println("Null Entity Cache");
		}
		if (m_count == 0) {
			System.out.println("Empty Entity Cache");
		}
		length = table.length;
		for (index = 0; index < length; ++index) {
			entry = table[index];
			if (entry != null) {
				System.out.print(index + ": ");
				for (; entry != null; entry = entry.m_next) {
					System.out.print(" " + entry.m_value);
				}
				System.out.println("");
	}	}	}
}
