package lsedit;

import java.util.Enumeration;



public class FlipLayoutHorizontally extends LandscapeLayouter implements ToolBarEventHandler {

	public FlipLayoutHorizontally(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "FlipHorizontal";
	}

	public String getMenuLabel() 
	{
		return "Flip layout horizontally";
	}

	public String doLayout(Diagram dg) 
	{
		EntityInstance pe = dg.getDrawRoot();
		Enumeration en;
		EntityInstance ce;

		dg.beginUndoRedo("Flip Layout Horizontally");
		for (en = pe.getChildren(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			ce.updatexRelLocal(1.0 - ce.xRelLocal() - ce.widthRelLocal());
		}
		dg.endUndoRedo();
		return "Layout flipped horizontally";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram				dg;
		String				rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			dg.redrawDiagram();
			m_ls.doFeedback(rmsg);
	}	}
}

