package lsedit;

import java.util.Enumeration;
import java.util.Vector;



public class GridGroupHorizontally extends LandscapeLayouter  implements ToolBarEventHandler 
{
	public GridGroupHorizontally(LandscapeEditorCore ls) 
	{
		super(ls);
	}

	public String getName()
	{
		return "GroupHorizontal";
	}

	public String getMenuLabel() 
	{
		return "Layout group horizontally";
	}

	public String doLayout(Diagram dg) 
	{
		Vector		cset;
		double		scaleX;
		double		startX, x, y, height, width;
		double		newX, newY, newHeight, newWidth;
		double		gap;
		int			num;
		Enumeration	en;
		EntityInstance ke, ce;   

		cset = dg.getGroup();
		if (cset == null) {
			beep();
			return "No group selected";
		}
		ke = dg.getKeyEntity();
		if (ke == null) {
			beep();
			return "No key entitity";
		}

		num    = 0;
		width  = 0;
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			width += ce.widthRelLocal();
			++num;
		}

		if (num == 0) {
			return "Empty group";
		}
		
		dg.beginUndoRedo("Layout grid horizontally");

		newX               = ke.xRelLocal();
		y      = newY      = ke.yRelLocal();
		newWidth           = ke.widthRelLocal();
		height = newHeight = ke.heightRelLocal();

		gap    = (width/(num*10.0));	// Presume the gap is 0.1 of the average width
		width += gap*(num-1);			
		startX = newX;

		if (width + startX > 0.95) {
			startX = 0.95 - width;
			if (startX < 0.05) {
				startX = 0.05;
			}
			newX = startX;
		}

		if (width + startX > 0.95) {
			scaleX = 0.95/(width+startX);
			gap     *= scaleX;
			newWidth = ke.widthRelLocal()*scaleX;
		} else {
			scaleX = 1.0;
		}

		ke.updateRelLocal(newX, newY, newWidth, newHeight);

		x = startX + ke.widthRelLocal(); 
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			if (ce != ke) {
				x += gap;
				newX      = x;
				newY      = y;
				newWidth  = ce.widthRelLocal();
				newHeight = height;
				if (scaleX != 1.0) {
					newWidth *= scaleX;
				}
				ce.updateRelLocal(newX, newY, newWidth, newHeight);
				x += ce.widthRelLocal();
		}	}
		dg.endUndoRedo();
		return "Laid out group to grid horizontally";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.redrawDiagram();
	}	}

}

