package lsedit;

import java.util.Enumeration;
import java.util.Vector;



public class GridGroupVertically extends LandscapeLayouter  implements ToolBarEventHandler {

	public GridGroupVertically(LandscapeEditorCore ls)
	{
		super(ls);
	}

	public String getName()
	{
		return "GroupVertical";
	}

	public String getMenuLabel() 
	{
		return "Layout group vertically";
	}

	public String doLayout(Diagram dg) 
	{
		Vector		cset;
		double		scaleY;
		double		startY, x, y, height, width;
		double		newX, newY, newWidth, newHeight;
		double		gap;
		int			num;
		Enumeration	en;
		EntityInstance ke, ce;   


		cset = dg.getGroup();
		if (cset == null) {
			beep();
			return "No group selected";
		}
		ke = dg.getKeyEntity();
		if (ke == null) {
			beep();
			return "No key entitity";
		}

		num    = 0;
		height = 0;
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			height += ce.heightRelLocal();
			++num;
		}

		if (num == 0) {
			return "Empty group";
		}

		dg.beginUndoRedo("Layout Grid Vertically");

		x      = newX     = ke.xRelLocal();
		newY              = ke.yRelLocal();
		width  = newWidth = ke.widthRelLocal();
		newHeight         = ke.heightRelLocal();

		gap    = (height/(num*10.0));	// Presume the gap is 0.1 of the average height
		height += gap*(num-1);			
		startY = newY;

		if (height + startY > 0.95) {
			startY = 0.95 - height;
			if (startY < 0.05) {
				startY = 0.05;
			}
			newY = startY;
		}

		if (height + startY > 0.95) {
			scaleY = 0.95/(height+startY);
			gap       *= scaleY;
			newHeight *= scaleY;
		} else {
			scaleY = 1.0;
		}

		ke.updateRelLocal(newX, newY, newWidth, newHeight);

		y = startY + ke.heightRelLocal(); 
		for (en = cset.elements(); en.hasMoreElements(); ) {
			ce = (EntityInstance) en.nextElement();
			if (ce != ke) {

				y += gap;
				newX     = x;
				newY     = y;
				newWidth = width;
				newHeight = ce.heightRelLocal();

				if (scaleY != 1.0) {
					newHeight *= scaleY;
				}
				ce.updateRelLocal(newX, newY, newWidth, newHeight);

				y += newHeight;
		}	}

		dg.endUndoRedo();
		return "Laid out group to grid vertically";
	}

	public void processKeyEvent(int key, int modifiers, Object object) 
	{
		Diagram	dg;
		String	rmsg;

		dg = m_ls.getDiagram();
		if (dg != null) {
			rmsg = doLayout(dg);
			m_ls.doFeedback(rmsg);
			dg.redrawDiagram();
	}	}
}