package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.util.*;
import java.io.*; 
import javax.swing.*;
import javax.swing.undo.UndoableEdit;

// 3 dimension objects have foreground colors, labels etc.
// This is everything but line objects such as edges

public abstract class LandscapeObject3D extends LandscapeObject {

	class UpdateDescription extends MyUndoableEdit implements UndoableEdit
	{
		LandscapeObject3D	 m_o;
		String				 m_old;
		String				 m_new;

		UpdateDescription(LandscapeObject3D o, String value)
		{
			m_o   = o;
			m_old = o.m_description;
			m_new = value;
			if (logEdit(this)) {
				o.m_description = value;
		}	}

		public String getPresentationName() 
		{
			return m_o + " Description";
		}

		public void undo()
		{
			m_o.m_description = m_old;
		}

		public void redo()
		{
			m_o.m_description = m_new;
		}
	}	

	class UpdateLabel extends MyUndoableEdit implements UndoableEdit
	{
		LandscapeObject3D	 m_o;
		String				 m_old;
		String				 m_new;

		UpdateLabel(LandscapeObject3D o, String value)
		{
			m_o   = o;
			m_old = o.m_label;
			m_new = value;
			if (logEdit(this)) {
				redo();
		}	}

		public String getPresentationName() 
		{
			return m_o + " Label " + m_new;
		}

		public void undo()
		{
			m_o.setLabel(m_old);
		}

		public void redo()
		{
			m_o.setLabel(m_new);
		}
	}	

	class UpdateLabelColor extends MyPaintableUndoableEdit implements UndoableEdit
	{
		LandscapeObject3D	 m_o;
		Color                m_old;
		Color                m_new;

		UpdateLabelColor(LandscapeObject3D o, Color value)
		{
			m_o   = o;
			m_old = o.m_labelColor;
			m_new = value;
			if (logEdit(this)) {
				o.m_labelColor = value;
		}	}

		public String getPresentationName() 
		{
			return m_o + " LabelColor ";
		}

		public void undo()
		{
			m_o.m_labelColor = m_old;
		}

		public void redo()
		{
			m_o.m_labelColor = m_new;
		}

		public void paintComponent(Graphics g, int x, int y)
		{
			paintComponentColor(g, x, y, m_new);
		}
	
		public int getPreferredWidth()
		{
			return(getPreferredWidthColor(m_o));
		}
	}

	class UpdateColorWhenOpen extends MyPaintableUndoableEdit implements UndoableEdit
	{
		LandscapeObject3D	 m_o;
		Color                m_old;
		Color                m_new;

		UpdateColorWhenOpen(LandscapeObject3D o, Color value)
		{
			m_o   = o;
			m_old = o.m_colorWhenOpen;
			m_new = value;
			if (logEdit(this)) {
				o.m_colorWhenOpen = value;
		}	}

		public String getPresentationName() 
		{
			return m_o + " ColorWhenOpen ";
		}

		public void undo()
		{
			m_o.m_colorWhenOpen = m_old;
		}

		public void redo()
		{
			m_o.m_colorWhenOpen = m_new;
		}

		public void paintComponent(Graphics g, int x, int y)
		{
			paintComponentColor(g, x, y, m_new);
		}
	
		public int getPreferredWidth()
		{
			return(getPreferredWidthColor(m_o));
		}
	}

	private String	m_id;			// The id of this entity or class (the name that identifies it uniquely in TA)
	private String	m_description;	// The description of this entity or class
	private String	m_label;		// The label for this entity or class

	/* Logical color's need to be kept separate from the JComponent colors
	 * otherwise when we paint a component we set its actual color to its
	 * logical color loosing the fact that it may not have had a logical color
	 * to begin with (ie. null->red if the class was red)
	 */

	private Color	m_labelColor  = null;
	private	Color	m_colorWhenOpen;

	// --------------
	// Public methods 
	// --------------

	public LandscapeObject3D() 
	{
		super();
	}

	public String toString() 
	{
		return m_id;
	}

	public String getId() 
	{
		return m_id;
	}

	public void setId(String id) 
	{
		m_id = id;
	}

	public boolean hasId(String id) 
	{
		return m_id.equals(id);
	}

	public String getDescription() 
	{
		return m_description;
	}

	public void setDescription(String description) 
	{
		if (description != null && description.length() == 0) {
			description = null;
		}
		m_description = description;
	}

	public void updateDescription(String description)
	{
		if (description == null) {
			if (m_description == null) {
				return;
			}
		} else if (description.equals(m_description)) {
			return;
		}
		new UpdateDescription(this, description);
	}

	protected void setLabel(String label)
	{
		JComponent swingObject = getSwingObject();

		m_label = label;
		if (swingObject != null) {
			swingObject.setToolTipText(label);
	}	}

	public void updateLabel(String label)
	{
		if (label == null) {
			if (m_label == null) {
				return;
			}
		} else if (label.equals(m_label)) {
			return;
		}
		new UpdateLabel(this, label);
	}

	protected String getLabel()
	{
		return(m_label);
	}

	public boolean hasLabelColor()
	{
		return(m_labelColor != null);
	}

	public Color getLabelColor() 
	{
		Color	ret;

		ret = m_labelColor;
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getLabelColor();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setLabelColor(Color color) 
	{
		m_labelColor = color;
	}

	public void updateLabelColor(Color color)
	{
		if (color == null) {
			if (m_labelColor == null) {
				return;
			}
		} else if (color.equals(m_labelColor)) {
			return;
		}
		new UpdateLabelColor(this, color);
	}

	public boolean hasColorWhenOpen()
	{
		return(m_colorWhenOpen != null);
	}

	public Color getColorWhenOpen() 
	{
		Color	ret;

		ret = m_colorWhenOpen;
		if (ret == null) {
			LandscapeClassObject	superclass;

			for (int i = 0; (superclass = derivedFrom(i)) != null; ++i) {
				ret = superclass.getColorWhenOpen();
				if (ret != null) {
					break;
		}	}	}
		return ret;
	}

	public void setColorWhenOpen(Color color) 
	{
		m_colorWhenOpen = color;
	}

	public void updateColorWhenOpen(Color color)
	{
		if (color == null) {
			if (m_colorWhenOpen == null) {
				return;
			}
		} else if (color.equals(m_colorWhenOpen)) {
			return;
		}
		new UpdateColorWhenOpen(this, color);
	}

	public boolean canEditAttribute(int index)
	{
		if (index == 0) {
			// This is the id of the object
			return(false);
		}
		return(super.canEditAttribute(index));
	}
}

