package lsedit;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

import javax.swing.JComponent;

// This handler is strictly concerned with moving the I/O points

public class MoveModeHandler extends LandscapeModeHandler
{
	// A small JComponent so that the whole handler doesn't need to be one
	// This object just draws a circle where the end point will be relocated

	protected class DrawOutline extends JComponent
	{
		public DrawOutline()
		{
			super();
			setForeground(Color.BLACK);
		}

		public void paintComponent(Graphics g)
		{
			super.paintComponent(g);

			if (m_ept != null) {
				g.drawOval((int) m_ept.m_x-6, (int) m_ept.m_y-6, 12, 12);
	}	}	}

	protected DrawOutline		m_drawOutline;				// The outline drawn
	protected EditModeHandler	m_parent;
	protected EdgePoint			m_ept;
	protected int			    m_active = 0;
	protected int				m_cursor = Cursor.DEFAULT_CURSOR;

	protected EdgePoint overEdgePoint(Object thing, int x, int y)
	{
		EdgePoint edgepoint = null;

		if (thing instanceof RelationInstance) {
			RelationInstance ri = (RelationInstance) thing;
			edgepoint           = ri.mouseOverEdgePoint(x, y);
		}
		return edgepoint;
	}

	// IO points

	protected RealPoint getFactors(int x, int y) 
	{
		// Can only have factors along edges 
		// Find closest edge and calculate new width and height factors

		Rectangle lyt = m_ept.getEntity().getDiagramBounds();

		double xp = x;
		double yp = y;

		double dl = Math.abs(xp - lyt.x);
		double dr = Math.abs(xp - (lyt.x + lyt.width));
		double dt = Math.abs(yp - lyt.y);
		double db = Math.abs(yp - (lyt.y + lyt.height));

		double wf, hf;

		if (dl < dr) {
			if (dt < db) {
				if (dt < dl) {
					// Top
					wf = (xp - lyt.x)/lyt.width;
					hf = 0.0;
				} else {
					// Left
					wf = 0.0;
					hf = (yp - lyt.y)/lyt.height;
				}
			} else if (db < dl) {
				// Bottom
				wf = (xp - lyt.x)/lyt.width;
				hf = 1.0;
			} else {
				// Left
				wf = 0.0;
				hf = (yp - lyt.y)/lyt.height;
			}
		} else {
			if (dt < db) {
				if (dt < dr) {
					// Top
					wf = (xp - lyt.x)/lyt.width;
					hf = 0.0;
				} else {
					// Right
					wf = 1.0;
					hf = (yp - lyt.y)/lyt.height;
				}
			} else if (db < dr) {
				// Bottom
				wf = (xp - lyt.x)/lyt.width;
				hf = 1.0;
			} else {
				// Right
				wf = 1.0;
				hf = (yp - lyt.y)/lyt.height;
			}
		}

		wf = Math.max(0.0, Math.min(1.0, wf));	// Normalize
		hf = Math.max(0.0, Math.min(1.0, hf));
		return new RealPoint(wf, hf);
	}

	protected boolean moveIOStart(int x, int y)
	{
		Diagram	diagram = m_ls.getDiagram();

		m_active = 2;
		m_ls.setCursor(Cursor.CROSSHAIR_CURSOR);
		m_drawOutline.setBounds(0, 0,diagram.getWidth(), diagram.getHeight());
		m_drawOutline.setVisible(true);
		diagram.add(m_drawOutline /* JLayeredPane.PALETTE_LAYER */ , 0);

		RealPoint factors = getFactors(x, y);
		m_ls.doFeedback("I/O point at factors (" + factors.getX() + ", " + factors.getY() + ")");
		return true;
	}

	protected void moveIOMotion(int x, int y) 
	{
		RealPoint factors = getFactors(x, y);

		m_ls.setCursor(Cursor.CROSSHAIR_CURSOR);

		m_ept.m_wf = factors.getX();
		m_ept.m_hf = factors.getY();
		m_ept.isDefault = false;
		m_ept.rescale();		/// Recompute where the edge point now is in the diagram
		// Need to do this because otherwise relations clip when redrawn as a consequence of drawOutline causing diagram repaint having diagram as bounds
		m_ept.computeRelationBounds();
		m_drawOutline.repaint();
		m_ls.doFeedback("I/O point at factors (" + m_ept.getX() + "/" + factors.getX() + ", " + m_ept.getY() + "/" + factors.getY() + ")");
	}

	// --------------
	// Public methods
	// --------------

	public MoveModeHandler(EditModeHandler parent) 
	{
		super(parent.m_ls);
		m_parent = parent;
		m_drawOutline = new DrawOutline();
	}

	public void cleanup()
	{
		m_ept    = null;
		switch (m_active) {
		case 2:
			{
				Diagram diagram = m_ls.getDiagram();

				m_drawOutline.setVisible(false);
				diagram.remove(m_drawOutline);
			}
		case 1:
			m_active = 0;
			if (m_cursor != Cursor.DEFAULT_CURSOR) {
				m_cursor = Cursor.DEFAULT_CURSOR;
				m_ls.setCursor(m_cursor);
	}	}	}

	public void movedOverThing(MouseEvent ev, Object thing, int x, int y) 
	{

		switch (m_active) {
		case 0:
			m_ept = overEdgePoint(thing, x, y);
			if (m_ept == null) {
				return;
			}
			m_cursor = Cursor.CROSSHAIR_CURSOR;
			m_parent.setSubHandler(this);
			m_active = 1;
			break;
		case 1:
			m_ept = overEdgePoint(thing, x, y);
			if (m_ept == null) {
				m_active = 0;
				m_parent.cleanup();
				return;
		}	}
		m_ls.setCursor(m_cursor);
	}

	public void entityPressed(MouseEvent ev, EntityInstance e, int x, int y) 
	{
		if (m_active == 1) {
			moveIOStart(x, y);
		} 
	}

	public void relationPressed(MouseEvent ev, RelationInstance ri, int x, int y)
	{
//		System.out.println("MoveModeHandler relationPressed\n");

		movedOverThing(ev, ri, x, y);
		if (m_active == 1) {
			moveIOStart(x, y);
		} 
	}

	public void relationDragged(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
//		System.out.println("MoveModeHandler relationDragged\n");
		if (m_ept != null) {
			moveIOMotion(x, y);
		} 
	}

	public void relationReleased(MouseEvent ev, RelationInstance ri, int x, int y) 
	{
//		System.out.println("MoveModeHandler relationReleased\n");
		m_ls.clearFeedback();
		if (m_ept != null) {
			m_ls.redrawDg();
		}
		m_parent.cleanup();
	}
}

