package lsedit;

import java.awt.Component;

import javax.swing.JSplitPane;

/* 
Attempt to fix a known bug with dividerlocation not working when split panes nested

Clearly, this is not fixed as of JDK 1.2.2 even.
Here's a way to extend JSplitPane that worked
for me and encapsulates the workaround to get
an early setDividerLocation to work:
        boolean firstValidate = true;
        public void validate() {
          if (firstValidate) {
            setDividerLocation(0.5);
            firstValidate = false;
          }
          super.validate();
        }
Jon Steelman

WED SEP 17 01:11 A.M. 2003
dbouard

I am using JDK 1.4.2 and this bug is not fixed. 
The test program bellow always show the same behaviour.

http://developer.java.sun.com/developer/bugParade/bugs/4101306.html
*/

class MySplitPane extends JSplitPane
{
	double	m_proportionalLocation = 0.0;

	public MySplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent)
	{
		super(newOrientation, newLeftComponent, newRightComponent);
	}

	public void setDividerLocation(double proportionalLocation)
	{
		super.setDividerLocation(proportionalLocation);
		m_proportionalLocation = proportionalLocation;
	}

	public void validate()
	{
		if (m_proportionalLocation != 0.0) {
			super.setDividerLocation(m_proportionalLocation);
			m_proportionalLocation = 0.0;
		}
		super.validate();
	}
}
