package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/* In a large diagram the m_tree can be huge .. therefore we compute
 * the contents of m_tree only when needed and discard ASAP
 */

public class TextTree extends JComponent implements MouseListener
{
	public    static final String m_helpStr	 = "Right click for menu.";
	
	protected static final String[] m_say    = 
	{
		"Table of contents is hidden",
		"Press Alt-v or click to show TOC"
	};

	protected static final int margin     = 10;
	protected static final int say_height = 30;

	protected static final Color titleColor = Color.red.darker();

	public final static String DEFAULT_TOC_FONT_NAME  = FontCache.DEFAULT_FONT_NAME;
	public final static int    DEFAULT_TOC_FONT_STYLE = Font.PLAIN;
	public final static int    DEFAULT_TOC_FONT_SIZE  = 11;

	protected static Font m_textFont  = FontCache.get(DEFAULT_TOC_FONT_NAME, DEFAULT_TOC_FONT_STYLE, DEFAULT_TOC_FONT_SIZE);

	// Need subclass since want to have special rendering

	class MyTreeCellRenderer extends DefaultTreeCellRenderer /* extends JLabel */
	{
		public MyTreeCellRenderer()
		{
		}

		public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus)
		{
			Component				c;
			DefaultMutableTreeNode	node;
			EntityInstance			e;
			Object					object;
			int						cnt;

			c      = super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
			node   = (DefaultMutableTreeNode) value;
			object = node.getUserObject();
			if (object instanceof EntityInstance) {
				e    = (EntityInstance) object;
				cnt  = e.numChildren();
				if (cnt > 1) {
					setText(e.getEntityLabel() + " (" + cnt + ")");
				}
			} 
/*			// Some really bizarre things show up here IJD  
			else {
				System.out.println("Tree userObject=" + object.getClass() + ": " + object);
			}
 */
			return(c);
	}	}

	// Need to subclass since want to pass right click mouse events up chain 

	class MyTree extends JTree implements MouseListener
	{
		protected TextTree	m_tocBox;

		public MyTree(TextTree tocBox)
		{
			super();

			m_tocBox = tocBox;
			setCellRenderer(new MyTreeCellRenderer());
			addMouseListener(this);
		}
	
		// Generic 	MouseListener interface

		public void mouseClicked(MouseEvent ev)
		{
			if (ev.isMetaDown()) {
				int				x, y;
				TreePath		selPath;
				TreeNode		treeNode;
				EntityInstance	e;
				Diagram			diagram;
					
				x       = ev.getX();
				y       = ev.getY();
				selPath = getPathForLocation(x, y);
				if(selPath == null) {
					m_tocBox.mouseClicked(ev);
				} else {
					treeNode = (TreeNode) selPath.getLastPathComponent();
					if (treeNode != null) {
						e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
						if (e != null) {
							diagram = m_ls.getDiagram();
							if (diagram != null) {
								diagram.navigateTo(e);
		}	}	}	}	}	}
	

		public void mouseEntered(MouseEvent ev)
		{
		}

		public void mouseExited(MouseEvent e)
		{
		}

		public void mousePressed(MouseEvent ev)
		{
		}

		public void mouseReleased(MouseEvent ev)
		{
		}
	}

	protected LandscapeEditorCore m_ls;

	protected MyTree			  m_tree;
	protected JPanel			  m_say_panel;
	protected JComponent		  m_use;

	protected JTabbedPane		  m_tabbedPane;
	protected JScrollPane		  m_scrollPane;
	protected JLabel[]			  m_say_labels;

	/* If hidden and first time actually tabbed to this set visible */

	protected boolean			  m_firsttime = true;

	// --------------
	// Public methods 
	// --------------

	public TextTree(LandscapeEditorCore ls, JTabbedPane tabbedPane) 
	{
		super();

		int						i, cnt;
		JLabel					say;

		setLayout(null);

		m_ls          = ls;
		m_tabbedPane  = tabbedPane;
		m_say_panel   = new JPanel();
//		m_say_panel.setBackground(Color.lightGray);

		m_say_panel.setLayout(new GridLayout(0, 1));

		cnt   = m_say.length;
		m_say_labels = new JLabel[cnt];
		for (i = 0; i < cnt; ++i) {
			m_say_labels[i] = say = new JLabel(m_say[i]);
			say.setBackground(Diagram.boxColour);
			say.setForeground(Color.red);
			say.setFont(m_textFont);
//			say.setPreferredSize(new Dimension(100,40));
			say.setVisible(true);
			m_say_panel.add(say);
		}
		m_say_panel.setSize(m_say_panel.getPreferredSize());
		fillTOC();

		setToolTipText(m_helpStr);

		m_scrollPane = new JScrollPane();
		m_scrollPane.setBounds(0,0,tabbedPane.getWidth(), tabbedPane.getHeight());
		setBounds(0, 0, tabbedPane.getWidth(), tabbedPane.getHeight());
		m_scrollPane.setViewportView(this);

		tabbedPane.addTab("TOC", null, m_scrollPane, m_helpStr);
		addMouseListener(this);
	}
	
	public static Font getTextFont()
	{
		return m_textFont;
	}

	public static void setTextFont(Font font)
	{
		m_textFont = font;
	}

	public void textFontChanged(Font font)
	{
		JLabel	say;
		int		i, cnt;
		
		cnt        = m_say_labels.length;
		for (i = 0; i < cnt; ++i) {
			say = m_say_labels[i];
			say.setFont(font);
		}
		m_tree.setFont(font);
		fillTOC();
	}

	public void firstTime()
	{
		m_firsttime = true;
	}

 	public void activate() 
	{
		m_tabbedPane.setSelectedComponent(m_scrollPane);
	}

	public boolean isActive() 
	{
		Component active;

		if (!isVisible()) {
			return(false);
		}
		active = m_tabbedPane.getSelectedComponent();
		return(active != null && m_scrollPane == active);
	}

	protected JPopupMenu buildPopup()
	{
		JPopupMenu	m;
		Diagram		diagram = m_ls.getDiagram();

		
		m = new JPopupMenu("TOC options");


		if (m_use != null && m_use == m_tree && diagram != null) {
			Vector	clipboard = diagram.getClipboard();
			// Get paths of all selected nodes
			TreePath[] paths = m_tree.getSelectionPaths();
			MyMenuItem	m1;
			if (clipboard == null || clipboard.size() == 0) {
				if (paths != null && paths.length > 0) {
					m1 = Do.cutMenuItem(m, m_ls);
					m1.setObject(this);
					m1 = Do.addcutMenuItem(m, m_ls);
					m1.setObject(this);
				}
			} else {
				if (paths != null && paths.length == 1) {
					m1 = Do.pasteMenuItem(m, m_ls);
					m1.setObject(this);
		}	}	}
		m_ls.tocMenuItem(m, m_ls);
		FontCache.setMenuTreeFont(m); 
		return(m);
	}

	// Identify the nodes to cut

	public Vector getGroup()
	{
		Vector	ret = null;

		if (m_use != null && m_use == m_tree) {
			MutableTreeNode	treeNode;
			EntityInstance	e;
			int				i, cnt;
			TreePath[]		paths = m_tree.getSelectionPaths();

			if (paths != null && (cnt = paths.length) > 0) {
				ret = new Vector(cnt);
				for (i = 0; i < cnt; ++i) {
					treeNode = (MutableTreeNode) paths[i].getLastPathComponent();
					e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
					ret.add(e);
		}	}	}
		return(ret);
	}

	// Identify the single selected node where we are to paste

	public EntityInstance targetEntity()
	{
		if (m_use != null && m_use == m_tree) {
			MutableTreeNode	treeNode;
			EntityInstance	e;
			TreePath[]		paths = m_tree.getSelectionPaths();

			if (paths != null && paths.length == 1) {
				treeNode = (MutableTreeNode) paths[0].getLastPathComponent();
				e = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
				return(e);
		}	}	
		return(null);
	}

	protected void syncSizes()
	{
		Dimension d;

		d     = m_use.getPreferredSize();
		m_use.setSize(d);
		setSize(d);
	}

	// Free all memory used by TOC

	public void emptyTOC()
	{
		removeAll();
		m_use = null;
		if (m_tree != null) {
			m_tree = null;
	}	}

	protected void fillTOC(DefaultMutableTreeNode node, EntityInstance e)
	{
		Enumeration				en;	
		EntityInstance			child;
		DefaultMutableTreeNode	below;

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			below = new DefaultMutableTreeNode(child);
			node.add(below); 
			fillTOC(below, child);
	}	}

	protected void fillTOC() 
	{
		Diagram diagram = m_ls.getDiagram();
		JComponent	use;

		removeAll();
		m_use  = null;
		m_tree = null;

//		System.out.println("TextTree.fillToc() " + m_ls.isTocHidden());

		if (m_firsttime) {
			if (m_ls.isTocHidden()) {
				m_ls.setTocHiddenState(false);
				m_firsttime = false;
		}	}

		if (m_ls.isTocHidden() || diagram == null) {
			use = m_say_panel;
			setSize(use.getPreferredSize());
		} else {
			DefaultTreeCellRenderer	renderer;

			m_tree = new MyTree(this);
			m_tree.setBackground(Diagram.boxColour);
			m_tree.setFont(m_textFont);
			m_tree.setEditable(false);
			m_tree.setShowsRootHandles(true);
			renderer = (DefaultTreeCellRenderer) m_tree.getCellRenderer();
			renderer.setBackgroundNonSelectionColor(Diagram.boxColour);
//			renderer.setBackgroundSelectionColor(Color.BLUE); 
			m_tree.setCellRenderer(renderer);
			m_tree.getSelectionModel().setSelectionMode(TreeSelectionModel.DISCONTIGUOUS_TREE_SELECTION);
			m_tree.setDragEnabled(true);

			EntityInstance root;
			DefaultMutableTreeNode	top;
			
			root = diagram.getRootInstance();
			top  = new DefaultMutableTreeNode(root);
			m_tree.setModel(new DefaultTreeModel(top, false));
			fillTOC(top, root);

			use = m_tree;
		}
		add(use);
		m_use = use;
		syncSizes();
		use.setVisible(true);
		repaint();
	}

	protected MutableTreeNode locateTreeNode(MutableTreeNode treeNode, EntityInstance e)
	{
		Enumeration		children;
		EntityInstance	e1;
		MutableTreeNode	ret;

		e1 = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
		if (e == e1) {
			return(treeNode);
		}
		if (e1.hasDescendant(e)) {
			for (children = treeNode.children(); children.hasMoreElements(); ) {
				ret = locateTreeNode((MutableTreeNode) children.nextElement(), e);
				if (ret != null) {
					return(ret);
		}	}	}
		return(null);
	}

	protected MutableTreeNode locateTreeNode(EntityInstance e)
	{
		int					cnt;
		TreePath			path;
		MutableTreeNode		treeNode;
		MutableTreeNode		ret;

		ret = null;
		if (e != null) {
			path     = m_tree.getPathForRow(0);
			if (path != null) {
				treeNode = (MutableTreeNode) path.getLastPathComponent();
				if (treeNode != null) {
					ret = locateTreeNode(treeNode, e);
		}	}	}
		return(ret);
	}
	
	private static void insertTOC(DefaultTreeModel model, MutableTreeNode parent, EntityInstance e)
	{
		MutableTreeNode	newNode = new DefaultMutableTreeNode(e);
		Enumeration		en;
		EntityInstance	child;
    
		// Insert new node as last child of node
		model.insertNodeInto(newNode, parent, parent.getChildCount());

		for (en = e.getChildren(); en.hasMoreElements(); ) {
			child = (EntityInstance) en.nextElement();
			insertTOC(model, newNode, child);
	}	}
		
	public void insertTOC(EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			// Have an m_tree and showing it
			node = locateTreeNode(e.getContainedBy());
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();
				insertTOC(model, node, e);			
	}	}	}

	public void deleteTOC(EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			node = locateTreeNode(e);
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();			
				// Remove node; if node has descendants, all descendants are removed as well
				model.removeNodeFromParent(node);
	}	}	}

	public void containerCut(EntityInstance e)
	{
		MutableTreeNode	node;

		if (m_use != null && m_use == m_tree) {
			node = locateTreeNode(e);
			if (node != null) {
				DefaultTreeModel	model   = (DefaultTreeModel) m_tree.getModel();			
				Enumeration			children;
				MutableTreeNode		parent, child;

				parent = (MutableTreeNode) node.getParent();
				for (children = node.children(); children.hasMoreElements(); ) {
					child = (MutableTreeNode) children.nextElement();
					// Remove child; if child has descendants, all descendants are removed as well
					model.removeNodeFromParent(child);
    				// Insert new node as last child of grandparent
					model.insertNodeInto(child, parent, parent.getChildCount());
				}
				model.removeNodeFromParent(node);
	}	}	}

	public void containerUncut(EntityInstance e)
	{
		if (m_use != null && m_use == m_tree) {
			Enumeration			children;
			EntityInstance		e1;

			for (children = e.getChildren(); children.hasMoreElements(); ) {
				e1 = (EntityInstance) children.nextElement();
				deleteTOC(e1);
			}
			insertTOC(e);
	}	}

	public void validate()
	{
		m_use.setBounds(0, 0, getWidth(), getHeight());
	}

	public Dimension getPreferredSize()
	{
		/* Silliness -- simply creating JMenuItems can cause logic to try to layout things before we
		 * have setup
		 */

		if (m_use != null) {
			return(m_use.getPreferredSize());
		}
		return new Dimension(0,0);
	}

	public void setBounds(int x, int y, int width, int height)
	{	
		super.setBounds(x, y, width, height);
		if (m_use != null) {
			m_use.setBounds(x, y, width, height);
	}	}
			
	protected void closeAll()
	{
		int			i, cnt;

		cnt = m_tree.getRowCount();
		for (i = cnt; i > 0; ) {
			m_tree.collapseRow(--i);
		}
	}
		
	protected void expandTo(EntityInstance e)
	{
		int				cnt;
		TreePath		path;
		TreeNode		treeNode;
		EntityInstance	e1;

		closeAll();
		m_tree.clearSelection();
		if (e != null) {
			for (cnt = 0; cnt < m_tree.getRowCount(); ++cnt) {
				path     = m_tree.getPathForRow(cnt);
				treeNode = (TreeNode) path.getLastPathComponent();
				if (treeNode != null) {
					e1 = (EntityInstance) ((DefaultMutableTreeNode) treeNode).getUserObject();
					if (e1 != null) {
						if (e1 == e) {
							m_tree.setSelectionRow(cnt);
							m_tree.scrollRowToVisible(cnt);
							break;
						}
						if (e1.hasDescendant(e)) {
							m_tree.expandRow(cnt);
	}	}	}	}	}	} 
		
	public void toc_path()
	{
		Diagram diagram = m_ls.getDiagram();
		EntityInstance e;

		if (diagram != null) {
			m_ls.setTocHidden(false);
			activate();
			e = diagram.getDrawRoot();
			expandTo(e);
			syncSizes();
	}	}

	protected void expandAll()
	{
		int	cnt;

		for (cnt = 0; cnt < m_tree.getRowCount(); ++cnt) {
			m_tree.expandRow(cnt);
	}	}

	// Open up or close down the Table of contents

	public void switch_TOC()
	{
		int	cnt;

		m_ls.setTocHidden(false);
		activate();
		cnt = m_tree.getRowCount();
		if (cnt > 1) {
			closeAll();
		} else {
			expandAll();
		}
		syncSizes();
	}	

	// Generic 	MouseListener interface

	public void mouseClicked(MouseEvent ev)
	{
		
		if (!ev.isMetaDown()) {
			if (m_ls.isTocHidden()) {
				m_ls.setTocHidden(false);
			}
		} else {
			int				x, y;
			TreePath		selPath;
			TreeNode		treeNode;
			EntityInstance	e;
			Diagram			diagram;
			JPopupMenu		popupMenu;
					
			x         = ev.getX();
			y         = ev.getY();
			popupMenu = buildPopup();
			add(popupMenu);
			popupMenu.show(this, x, y);
			remove(popupMenu);
	}	}

	public void mouseEntered(MouseEvent ev)
	{
	}

	public void mouseExited(MouseEvent e)
	{
	}

	public void mousePressed(MouseEvent ev)
	{
	}

	public void mouseReleased(MouseEvent ev)
	{
	}



}





