package lsedit;


public class Version {
	public final static int MAJOR = 7;
	public final static int MINOR = 0;
	public final static int BUILD = 37;
	public final static String COMPILED = "August 2nd, 2004";

	public static String Number()
	{
		return(MAJOR + "." + MINOR + "." + BUILD);
	}

	public static String CompileDate()
	{
		return("Compiled: " + COMPILED);
	}

	public static String Detail(String property)
	{
		String result;

		try {
			// This will fail if an applet
			result = System.getProperty(property);
		} catch (Exception e) {
				result = "";
		};
		return(result);
	}

	public static String authorsAndCopyright()
	{
		String  result;

		result	= Version.Number() + "\n\n" + Version.CompileDate() + "\n";
		result += "Developed at the University of Waterloo under the supervision of Prof. Ric Holt\n";
		result += "Original Author: Gary Farmaner\n";
		result += "Rewritten in Swing by Ian Davis\n";

		return result;
	}

	public static String Details(Diagram diagram)
	{
		String  result;
		Runtime	r
		;
		// System.getProperties().list(System.out);

		result	= authorsAndCopyright();

		try		{ //set if possible
				result += "LSEDIT is part of the Software Landscape tool suite\n\n";
				result += " licensed to CTBTO by Telepresence Systems, Inc. (www.telepres.com)\n";
				result += " under contact No. 01/2/20/163\n\n";
				result += "Run Time Engine: " + Detail("java.vendor") + " " + Detail("java.version") + "\n";
				result += "Virtual Machine: " + Detail("java.vm.name") + " " + Detail("java.vm.version") + "\n";
				result += "V/M Vendor: " + Detail("java.vm.vendor") + "\n"; 
				result += "Operating System: '" + Detail("os.name") + "' " + Detail("os.arch") + " " + Detail("os.version") + "\n";
				result += "Patch level: " + Detail("sun.os.patch.level") + "\n";
				result += "User id: " + Detail("user.name") + "\n";
				result += "Directory: " + Detail("user.dir") + "\n";

				r       = Runtime.getRuntime();
				result += "Memory: " + r.totalMemory() + " - Free: " + r.freeMemory() + " = " + (r.totalMemory() - r.freeMemory()) + " Max: " + r.maxMemory() + "\n";
				r.gc();
				result += "Memory: " + r.totalMemory() + " - Free: " + r.freeMemory() + " = " + (r.totalMemory() - r.freeMemory()) + " Max: " + r.maxMemory() + "\n";
				if (diagram != null) {
					result += "Entities: " + diagram.getNumberEntitiesLoaded() + " Relations: " + diagram.getNumberRelationsLoaded() + "\n";
//						result += "Sizes: " + sizeOf(EntityInstance) + "+" + sizeOf(EntityComponent) + " " + sizeOf(RelationInstance) + "+" + sizeOf(RelationComponent) + "\n";
				}

		} catch (Exception e) {}

		return(result);
	}
}

/* History:
   6.0.0 -- Changes by Ian Davis

   April 4th (All day) 9:30-10pm
   
   Placed all source in package lsedit.
   Fixed minor compile problems under latest version of sun.
   Added code to close window when x pressed in Top Right hand corner.
   Enhanced the version information.
   Changed file prompt to prompt using java.awt.FileDialog
   Made right tabbed box go away completely when turned off
   Activated appropriate right tab so will display properly when turned back on

   April 5th		   10:30-4pm
   Removed some debug output
   Made animation optional to improve refresh rate.
   By default now in options menu "Show animations" is set to false.
   Changed cursor back to default after double click of mouse
   Removed some null pointer exceptions (rather by guessing desired behaviour)

   6.0.1 

   April 7th
   Corrected bug in drawing edges introduced in 6.0.0
   Worked towards understanding lsedit layout strategy
   Cleaned up code
   Traced layout problem to	  Diagram.setToViewport()
   Attempting to decipher what occurs beneath this.
   Quite bemused since right now nothing makes much sense.
   Concerns include:
	(1) rootInstance.getChildBoundingBoxLocal();
		  this only gets the bounding box of its own children, not its decendants.
		  Is there a presumption that children strictly contained within parent.
	(2) old formula for y scale was bizarre.
		  yScale = (height-width/16)/bb.height;	 [ changed to function purely of height]
	(3) don't understand dx and dy at all..	 Don't see how using only height and width one
		can correct positions of children.
	(4) translateChildrenLocal changes local values using dx and dy for both children and bends
		But bends not considered in computing what the bounding box was

   April 8th-10
   Released 6.0.1

   6.0.2

   Began exploring the refresh problem
   Tracked bug down to repaints() on both mouse down and mouse up pairs
   Have changed code to paint group flags in tight relationship to setting/clearing group flag
   Have delayed painting of group to be moved until move actually begins to avoid need to refresh
   Removed debug messages
   Released 6.0.2

   6.0.3

   April 14th

   Corrected the way in which point positions were cached.	There was a problem that simply rescaling
   the point positions when want to actually say discard the cache of point positions doesn't work
   because the x,y positions of the objects containing these points may not yet be right.

   6.0.4

   April 16th

   Added source file provided by eric.
   Rewrote Stringlinizer.  Potentially some problems now with <A ...> </A> tags.. No idea what was
   being attempted before here.	 Investigated types of object.	Investigated setting color of
   objects manually.

   April 17th

   Added ability to assign open color to entity.  "opencolor=value".
   Added dynamic color changes to object through P or menu.
   Hopefully all works when saved.

   6.0.5

   Corrected displaying of descriptions in Legend box
   Corrected minor error in drawing flags on box.. An outline is one pixel wider than a fill.
   Enhanced color chooser to allow for an alpha
   Fixed bug in forward edge tracing

   6.0.6

   Wednesday April 24th

   Changed how flags were cleared
   Removed key codes from popup menus
   Removed U/u/S/s from entity popup menu
   Removed U/u/S/s from toolbar
   Removed fit child to container
   Removed save landscape raw from File menu
   Removed print all to eps files
   Moved towards handling resize of objects correctly
   Cleaned up forward/back reporting on result tab logic
   Improved/rewrote again stringLiner
   Corrected infinite loop in util

   6.0.7

   Wednesday April 25th 2002

   Added feedback message to description box when over feedback box, so can read entire error message.
   Refresh entire drawing if selecting a box clears highlighting anywhere
   Renamed edit button to menu button
   Removed duplication of this button
   Added code to remove menu popup on mouse down if no mouse up seen.	This is purely preventative code
   for a bug not well understood.

  6.0.8

  Thursday April 26th. 2002

  Fixed problems with Forward/Back refs..

  6.0.9

  Friday April 27th, 2002

  Removed minMax button on applet
  Changed client/suppliers so will compress rather than not draw if can't reduce while still being too wide

  6.0.10

  Added short cut keys back into menus and toolbar buttons u/s etc.

  6.0.11

  Added ability to change color of classes and relations from Legendbox
  Added ability to query things in the legend box
  Added popup menus

  6.0.12

  Changed to 4 character tabs in source code -- no release

  6.0.13

  Added CorrectBadLayout to handle irregularities in input TA file
  Huge amount of cleanup
  Completely rewrote how attributes were edited, etc

  6.0.14

  Allowed class style changes to impact on diagram
  Fixed bug in StringLinizer

  6.0.15

  Added ability to change class an entity belongs to through editing attributes
  Changed creation of new entity to use EditAttribute logic (simplifies code to maintain)

  6.0.16

  Very unclear whether this version was ever released. Work stopped so that a co-op
  student could implement 6.0.17. and 6.0.16 was where it stopped.  However, co-op
  student never did take on programming task.

  6.0.17

  Fix depth limit problems.  Converted code from using absolute external coordinate
  system to relative to parent coordinate system.  Huge rewrite of all graph drawing
  software. (Also reworked lslayout and lsadjust).

  6.0.18

  Minor cleanup.. stopped allowing drag of boxes into $ROOT box.
  Corrected problems saving and restoring raw dumps.

  6.0.19

  Changed RelationInstance.findNearestSeg to work with doubles instead of ints and
  to check for threshold^2 > dist^2 thus avoiding expensive sqrt operation.  N.B.
  Since working in pixels threshold^2 > dist^2 iff threshold > dist.

  Fixed:  PR 5. When attempting to highlight an arrow after a forward or back trace, 
  non-visible arrows may be selected that are in the same region.  Select a node,
  do a forward or back trace.  Try to select a visible arrow that overlaps with a 
  non-visible arrow (at their intersection), both arrows will be selected.

  Fixed:  PR 7. When doing an "same size" (or width/height), the entity will not 
  fully resize if the new size brings part of it outside the window.  Suggest maybe a 
  better course of action would be to do the full resize, then relocate the entity so 
  that it is entirely inside the window. To-repeat: Place an entity at the right edge 
  of the window.  Select it, then select a wider entity.  Click Arrange, then "Same width".

  (New rules: if width > 1 width = 1; if (width+x>1) x= 1-width; ) etc. 

  6.0.19a

  Fixed correction of PR5 fix.

  6.0.20

  Changed to not emit default values of attributes

  7.0.1

  Absolutely huge rewrite.. to work under swing..
  This is essentially an entirely new product..
  Key enhancements are -- interrupt handling quite different (interrupts now come in at listeners)
  Drawing of relations quite different  (Objects created to do the actual drawing)
  Management of draw src/dst quite different (The draw src/dst always indicates where an edge is drawn from/to)
  Management of heirachy -- this is now done using pre/post order numbers
  Integer arithmetic used rather than doubles everywhere.
  Scroll panes added all over the place
  TOC box redone as a tree..
  All keystrokes tied to menu accelerators and accessible from menus.
  The list goes on and on
  
  7.0.2
  
  Changed tokenizer to reuse strings to save memory

  7.0.3

  Fixed moving of edge cardinals in sync with box.

  7.0.4

  Fixed moving edge cardinals better :-)
  Fixed problems with TOC not first requested then requested
  Made Cntl-V immediate

  7.0.5

  Changed to use layout manager

  7.0.6

  Moved TOC into tab box, fixed minor bugs

  7.0.7

  Do is no longer a subclass of JPanel and this ripples up.
  LandscapeViewerCore adds to the originial contentPane() instead of being a replacement content pane... this fixes problems
  Changed lsedit to use split pane three ways..
  Changed -G to be <percent>x<percent> indicating fraction of layout to be occupied by diagram.  0 = none.. 100 = all.

  7.0.8

  Fixed bug when dragging into new box loosing edges (need call to prepostorder)
  Fixed bug with 0-9 not actually changing the diagram (changed to use doClick() so simulates precisely the action of a real click)
  Changed query box numbers to match legend box numbers

  7.0.9

  Rewrote printing from the ground up.

  7.0.10

  Cleaned up tab box images so don't scroll
  Fixed performance problem.(zero sized boxes are considered closed)
  Made TOC align with editorial changes to the main diagram
  Added back in notion of TOC visible or not loaded
  Allow cutting and pasting in TOC

  7.0.11

  Reworked LandscapeEditorFrame so could be invoked from arbitrary java code
  Reworked LandscapeEditorFrame so that could run either LandscapeEditorCore or LandscapeViewerCore
  Removed  LandscapeEditorApp
  Moved all TA read/write code into ta.java

  7.0.12

  Change Landscape objects so have JComponent rather than are a JComponent
  Reduced memory requirements for edges substantially
  Allowed editing of relations and relation classes
  Removed BaseEntity
  Added   EntityComponent/RelationComponent

  7.0.13

  Made avgX a constant inside a sort -- not recomputed for each compare
  Fixed a slew of bugs

  7.0.14

  Change Legend to handle hiding of entities
  
  7.0.15

  Added undo/redo

  7.0.16

  Added undo/redo for creating new entitites
  Added ability to change undo/redo limit

  7.0.17

  Added cut and paste to undo/redo set
  Moved m_clipboard to have separate copy for each diagram.

  7.0.18

  Can now load TA without first running through lslayout (automatically uses sugiyama layout on each level)
  Can now load TA without a schema
  Changed sugiyama algorithm to handle relative addressing
  Reworked color chooser in hope of eliminating keys not working subsequently under linux (also changed editAttribute)
  Cleaned up update/delete pasting operations so sync resultbox with TOC and with diagram
  Don't allow inserts into root if anything already there
  Added 'l' (layout) as shortcut for sugiyama algorithm
  Don't exclude base relations from diagram
  Changed minor bug in how relations converted to textual string description
  Result box now shows absent entities in black -- can't navigate to them
  Recursive copy when pasting into TOC
  Fixed numerous bugs

  7.0.19

  Fixed minor bugs with scroll bar, things not showing when inserted, and not being insertable when no schema

  7.0.20

  Changes made by Andrew Malton to handle creating edges

  7.0.21

  Retrofitted some of my ongoing changes into Andrews changes
  Added labels to class type
  Reworked drawing of labels for groups
  Encapsulated changes to xrel, yrel, widthrel and heightrel
  Removed fitto -- hardly needed with relative addressing

  7.0.22

  Fixed many PR's

  1. Changed History tab to Undo
  2. Show count of children in TOC if > 1
  3. Delete now deletes whatever is selected be it entity/relation/both
  4. Undoing delete containing updates TOC correctly
  5. Can undo deletion of edges
  6. Removed all logic to handle reading/writing raw TA binary encripted files
  7. Accept all class's and attribute in schema-less files
  8. Accept both single and double quote delimiters as quoted text.
  9. Remove keystrokes to change tab box (do with mouse)
 10. Same size/align commands now show up as single undo operation

 7.0.23

 1.  Removed FONT_CORRECTION as obsolete
 2.  Cleaned up mode handling 
 3.  Added idleModeHandler
 4.  Added newEdgeModeHandler

 7.0.24

 1.  Added outline for moveGroupHandler
 2.  Allowed modeHandlers to be activated by a move as well as by an enter
 3.  Cleaned up how cursors managed
 4.  Open the TOC automatically the first time it is tabbed to within a diagram
 5.  Cleaned up cutting of a container wrt result box and TOC
 6.  Allow repeated cuts
 
 7.0.25

 1.  Changed default layout so performed late when things drawn -- not when loaded
 2.  Added simplex algorithm
 3.  Added -n option to select simplex algorithm as default
 4.  Added 'n' command to layout using simplex algorithm
 5.  Added 'j' command to layout everything below a node using desired layout algorithm
 6.  Removed useless classes

 7.0.26

 1.  Added history to menu
 2.  Cleaned up drop down
 3.  Cleaned up \n in attribute data when saving
 4.  Removed distinct keys for editing entities/relations
 5.  Changed so that missing relative x,y,width,height computed when requested.

  7.0.27

  1. Removed LandscapeViewerCore merging functionality into LandscapeEditorCore
  2. Removed ViewModeHandler merging functionality into EditModeHandler
  3. Removed all action code from EditModeHandler moving into LandscapeEditorCore
     (This reduced 3 case statements into a single case statement on action)
  4. Moved all diagram intensive actions from LandscapeEditorCore into Diagram
  5. Cleaned up simplex algorithm graph layout
  6. Made simplex algorithm default layouter

  7.0.28

  1. Made further improvements to Relayoutall and Simplex algorithm
  2. TestForClose now sees changes
  3. Augmented reporting re saving of .lsedit
  4. Fixed problems with Fit label
  5. Fixed open/closing when drag and dropping into boxes
  6. Toggling containment now toggles all selected entities to open or closed

  7.0.29

  1. Created a cache of fonts
  2. Changed how closed fonts are computed -- no longer a fixed array of closed fonts since cached
  3. Allowed all parts of diagram to have font changed
  4. Reversed color of cardinals

  7.0.30

   0. Moved FontCache to its own class
   1. Allowed fonts to be changed
   2. Reworked ArrowDimensions so that resized fonts fit
   3. Created ColorCache
   4. Extended JColorChooser to allow clearing of color cache
   5. Created EntityCache
   6. Added Create New Diagram (Cntl-N)
   7. Changed EditAttributes to consider font size
   8. Changed menus to set Font
   9. Allow fonts to be reset to default
  10. Saved selected fonts on exit
  11. Added -b/ig option to automatically set all fonts large
  12. Improved performance by making EntityCache static and fixed hash
  13. Fixed edge creation problem
  14. Cleaned up code

 7.0.31

   1.  Moved cardinals[] to EntityComponent to save space
   2.  Added Src Cardinals (Alk-K)
   3.  Added ability to ask for open arrows (Alt-d)
   4.  Added ability to put arrows in center of edges (Alt-d)
   5.  Fixed PREV/NEXT handling
   6.  Added dynamic PREV/NEXT tool buttons
   7.  Remove things in find set as they are deleted elsewhere
   8.  Added History tab
   9.  Added matrix (m) layout
   10. Added close all boxes (Alt-r) reachable from layout.
   11. Added open all boxes (Alt-R)  reachable from layout
   12. Cleanded up code and fixed various PR's
   13. Added dynamic UP/DOWN history buttons

 7.0.32

   1.  Added Alt-M and Alt-Shift-M to zoom in and out on an entity
        (Exact positioning of diagram on centre of entity proved impossible to achieve --
		 No idea why????)
   2.  Got running as an applet -- sort of anyway
         www.textserver.com/lsedit

 7.0.33

   1.  Cleaned up problems with Applet failing because trying to use null frame in find
   2.  Cleaned up file menu items not appropriate for an applet.
   3.  Added rudimentary ability to load file into applet.. You have to know the name
       of the file to be loaded.
        (Would be very nice to have a server side JFileChooser component so that one
		 could see choices.  Perhaps this could be implemented on top of HTTP by using
		 some sort of low level get directory contents -- available solutions to this
		 problem all require a backend server application running to convey filenames
		 to applet which seems silly.)
   4.  Glitzed up the tab pane. Right clicking on the tabs allows changing of tab painting
       rules.  Problem.. if switch to scroll the scoll steals the mouse clicks and one has
	   to right click on the border of the JTabbedPanel to bring up menu to turn off
	   scrolling.
   5.  Added informative information to applet.
   6.  Set default action on F11 to be to navigate to www.swag.uwaterloo
   7.  Set default action on F12 to be to navigate to www.swag.uwaterloo/lsedit [Doesn't yet exist]

 7.0.34

   1.  Changed default cardinal point size from 7 to 9
   2.  Added tooltip to cardinals
   3.  Allowed layout algorithms to be customised (Configure Layout)
   4.  Fixed relayout logic
   5.  Added scroll tab option to menu so can turn off easily
   6.  Changed command line method of preselecting layouter to allow scaling to new layouters
   7.  Changed tool tip on prev history
   8.  Now showing cursors in applets
   9.  Allow relation class to default color from superclass
   10. Show label of relation class in relation class label color
   11. Reworked sugiyama layout to agree more closely with matrix layout rules.
   12. Consider only visible edges when laying out simplex graph.
   13. Dispose of dialogs when done

 7.0.35

   1.  Can now undo relayout of a subtree and relayout when inserting children
   2.  Removed ability to perform background loading
         Files to be loaded in background are now simply listed in file menu
   3.  Unified diagram and menu edge mode flags (so that menu reflects settings in diagram)
   4.  Added footer to results in results tab so can tell where end of results are
   5.  Show edges to/from drawRoot
   6.  Remember defaulted label values in entity versus actual label values in TA so can write out same
   7.  Queries now show true information in result box -- not lifted information
   8.  Forward/Back queries on suppliers and clients are specifically wrt diagram only
   9.  Can now select multiple edges using Shift and mouse click
   10. Result's now scroll properly
   11. Added Align Bottom to set of possible alignments (seemed to be missing)
   12. Made all alignments adjust to be forgiving where alignment requested impossible due to clipping
   13. Added new edge mode DIRECT+SIDE.  Same as direct but whenever an edge is from an ancestor->descendant
       edge starts on left side of ancestor.  Similarly whenever an edge is from descendant->ancestor edge
	   goes to right side of ancestor.  This helps visually to spot such types of edge.
   14  Convert newlines to \n in descriptions and class descriptions when writing TA
   15. Deleted entities now show in history as black names -- can't navigate to such deleted entities.
   16. History no longer adds things navigated to using prev/next or clicks on history.
   17. Changed CLOSE EDITOR to prompt for saving and then switch to blank new landscape
   18. Saves relation style in TA
   19. Results now align on left (not center)
   20. Replaced string cache with call to String.intern -- seems functionality already largely provided
       by java.lang.  Should save memory.

 7.0.36

    1. Added ability to read from gzip, zip and jar compressed sources primarily to speed data transfer to
	   applets.  Any path ending in ".zip", ".gzip" or ".jar" ignoring case is presumed to be in the
	   corresponding internally compressed format.  For zip files and jar files the path name may be
	   followed by [....] containing the name of the subfile within the zip to be loaded...

	   eg. xyz/set.zip[c488.ls.ta] would load the c488.ls.ta subfile within the set.zip file.

	   If no subfile is specified the first subfile found is presumed to be the one that is to be read.
	   This is primarily intended to simplify the case where the zip file contains only one subfile.

	   gzip has not been tested.

	2. Added logic to invoke external browser.

 7.0.37

    1. Improved file selection for selecting browser



*/
