/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lsedit.ClientSet;
import lsedit.Diagram;
import lsedit.DiagramCoordinates;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.SortVector;
import lsedit.SupplierSet;

public abstract class ClientSupplierSet
extends JPanel
implements DiagramCoordinates {
    public static final int CLIENT_SUPPLIER_HEIGHT = 50;
    public static final int GAP = 5;
    public static final String DEFAULT_CLIENT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_CLIENT_FONT_STYLE = 0;
    public static final int DEFAULT_CLIENT_FONT_SIZE = 10;
    protected static Font m_clientFont = FontCache.get("Helvetica", 0, 10);
    protected LandscapeEditorCore m_ls;
    protected Diagram m_diagram;
    protected JLabel m_label = null;
    protected EntityInstance m_drawRoot;
    protected Vector m_set;
    protected int m_fullSize;
    protected int m_displayedSize;

    protected int calcWidth(Graphics graphics) {
        int n = 0;
        Enumeration enumeration = this.m_set.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Dimension dimension = entityInstance.getFitDim(graphics, 0, true);
            n += dimension.width;
        }
        return n;
    }

    protected EntityInstance mostFrequentParent() {
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        int[] nArray = new int[this.m_set.size()];
        Enumeration enumeration = this.m_set.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            EntityInstance entityInstance2 = entityInstance.getEnterableParent();
            if (entityInstance2.hasDescendantOrSelf(this.m_drawRoot)) continue;
            int n = vector.indexOf(entityInstance2);
            if (n < 0) {
                nArray[vector.size()] = 1;
                vector.addElement(entityInstance2);
                continue;
            }
            int n2 = n;
            nArray[n2] = nArray[n2] + 1;
        }
        int n = 0;
        int n3 = -1;
        for (int i = 0; i < vector.size(); ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
            n3 = i;
        }
        if (n3 < 0) {
            return null;
        }
        return (EntityInstance)vector.elementAt(n3);
    }

    protected boolean elimDescendents(EntityInstance entityInstance) {
        Vector vector = this.m_set;
        boolean bl = false;
        int n = vector.size();
        while (n > 0) {
            EntityInstance entityInstance2;
            if (!entityInstance.hasDescendantOrSelf(entityInstance2 = (EntityInstance)vector.elementAt(--n))) continue;
            entityInstance2.nandMark(6);
            vector.remove(n);
            bl = true;
        }
        return bl;
    }

    protected void sort() {
        if (this.m_set.size() > 1) {
            SortVector.byAvgX(this.m_set, true);
        }
    }

    protected void addSet() {
        int n = this.m_set.size();
        if (n != 0) {
            int n2 = (n + 1) * 5;
            int n3 = this.getWidth();
            int n4 = n3 - n2;
            Graphics graphics = this.m_ls.getGraphics();
            int n5 = this.calcWidth(graphics);
            double d = (double)n4 / (double)n5;
            double d2 = 5.0;
            if (d > 2.0) {
                d = 2.0;
                d2 += (double)(n4 - n5 * 2) / 2.0;
            }
            int n6 = this.getX();
            int n7 = this.getY();
            int n8 = this.getHeight();
            Enumeration enumeration = this.m_set.elements();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
                entityInstance.removeAll();
                Dimension dimension = entityInstance.getFitDim(graphics, 0, true);
                double d3 = d * (double)dimension.width;
                int n9 = (int)d3;
                entityInstance.setBothBounds(n6, n7, (int)d2, 0, n9, n8);
                entityInstance.setVisible(true);
                d2 += d3 + 5.0;
                entityInstance.addUnder(this);
            }
        }
    }

    public ClientSupplierSet(Diagram diagram) {
        this.setLayout(null);
        this.m_diagram = diagram;
        this.m_ls = diagram.getLs();
        this.m_set = new Vector();
    }

    public static Font getClientSupplierFont() {
        return m_clientFont;
    }

    public static void setClientSupplierFont(Font font) {
        m_clientFont = font;
    }

    public Vector getFullSet() {
        return this.m_set;
    }

    public int getFullSetSize() {
        return this.m_fullSize;
    }

    public int getDisplaySetSize() {
        return this.m_displayedSize;
    }

    public void removeAll() {
        super.removeAll();
        this.m_set.removeAllElements();
        this.m_fullSize = 0;
        this.m_displayedSize = 0;
    }

    public static void compact(ClientSet clientSet, SupplierSet supplierSet) {
        block18: {
            EntityInstance entityInstance;
            EntityInstance entityInstance2;
            Vector vector = clientSet.getFullSet();
            Vector vector2 = supplierSet.getFullSet();
            int n = vector.size();
            while (n > 0) {
                for (entityInstance2 = entityInstance = (EntityInstance)vector.elementAt(--n); entityInstance2 != null; entityInstance2 = entityInstance2.getContainedBy()) {
                    if (!entityInstance2.isMarked(4)) continue;
                    entityInstance.nandMark(2);
                    entityInstance2.orMark(2);
                    vector.remove(n);
                }
            }
            boolean bl = false;
            n = vector2.size();
            while (n > 0) {
                entityInstance = (EntityInstance)vector2.elementAt(--n);
                for (entityInstance2 = entityInstance.getContainedBy(); entityInstance2 != null; entityInstance2 = entityInstance2.getContainedBy()) {
                    if (!entityInstance2.isMarked(2)) continue;
                    entityInstance.nandMark(4);
                    entityInstance2.orMark(4);
                    vector2.remove(n);
                    bl = true;
                }
            }
            if (bl) {
                n = vector.size();
                while (n > 0) {
                    if (!(entityInstance = (EntityInstance)vector.elementAt(--n)).isMarked(4)) continue;
                    vector.remove(n);
                    vector2.addElement(entityInstance);
                }
            }
            if (!clientSet.m_ls.isUseCompaction()) {
                return;
            }
            int n2 = clientSet.getWidth();
            int n3 = supplierSet.getWidth();
            if (n2 <= 0 && n3 <= 0) break block18;
            Graphics graphics = clientSet.m_ls.getGraphics();
            int n4 = -1;
            int n5 = -1;
            do {
                bl = false;
                if (n2 > 0) {
                    if (n4 < 0) {
                        n4 = clientSet.calcWidth(graphics) + 5 * (vector.size() + 1);
                    }
                    if (n4 > n2) {
                        entityInstance2 = clientSet.mostFrequentParent();
                        if (entityInstance2 == null) {
                            n4 = n2;
                        } else {
                            bl = true;
                            clientSet.elimDescendents(entityInstance2);
                            entityInstance2.orMark(2);
                            if (supplierSet.elimDescendents(entityInstance2)) {
                                entityInstance2.orMark(4);
                                vector2.addElement(entityInstance2);
                                n5 = -1;
                            } else {
                                vector.addElement(entityInstance2);
                            }
                            n4 = -1;
                        }
                    }
                }
                if (n3 <= 0) continue;
                if (n5 < 0) {
                    n5 = supplierSet.calcWidth(graphics) + 5 * (vector2.size() + 1);
                }
                if (n5 <= n3) continue;
                entityInstance2 = supplierSet.mostFrequentParent();
                if (entityInstance2 == null) {
                    n5 = n3;
                    continue;
                }
                bl = true;
                supplierSet.elimDescendents(entityInstance2);
                entityInstance2.orMark(4);
                if (clientSet.elimDescendents(entityInstance2)) {
                    entityInstance2.orMark(2);
                    n4 = -1;
                }
                vector2.addElement(entityInstance2);
                n5 = -1;
            } while (bl);
        }
    }

    public void order() {
        this.m_displayedSize = this.m_set.size();
        this.sort();
        this.addSet();
    }

    public int getDiagramX() {
        return this.getX();
    }

    public int getDiagramY() {
        return this.getY();
    }
}

