/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintStream;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.LandscapeClassObject;

public class EntityClass
extends LandscapeClassObject {
    public static final String ENTITY_BASE_CLASS_ID = "$ENTITY";
    public static final int ENTITY_STYLE_NONE = -1;
    public static final int ENTITY_STYLE_3DBOX = 0;
    public static final int ENTITY_STYLE_2DBOX = 1;
    public static final int ENTITY_STYLE_FILE = 2;
    public static final int ENTITY_STYLE_DISK = 3;
    public static final int ENTITY_STYLE_FOLDER = 4;
    public static final int ENTITY_STYLE_SOURCEOBJ = 5;
    public static final int ENTITY_STYLE_CLASS = 6;
    public static final int ENTITY_STYLE_GROUP = 7;
    public static final int ENTITY_STYLE_LABELLED_GROUP = 8;
    public static final String[] styleName = new String[]{"3D Box", "2D Box", "File", "Disk", "Folder", "Source Object", "Class", "Group", "Labelled Group"};
    private boolean m_shown = true;

    public EntityClass(String string, int n, EntityClass entityClass, Diagram diagram) {
        this.setId(string);
        this.setNid(n);
        this.setLabel(string);
        this.setLandscapeObjectDiagram(diagram);
        this.addParentClass(entityClass);
        this.setStyle(0);
        this.setObjectColor(Color.blue);
        this.setLabelColor(Color.cyan);
    }

    public static String getEntityStyleName(int n) {
        if (n < 0 || n >= styleName.length) {
            return "";
        }
        return styleName[n];
    }

    public String getStyleName(int n) {
        return EntityClass.getEntityStyleName(n);
    }

    public void setShown(boolean bl) {
        this.m_shown = bl;
    }

    public boolean isShown() {
        return this.m_shown;
    }

    public void writeAttributes(PrintStream printStream) throws IOException {
        printStream.print(this.qt(this.getId()) + " {\n");
        super.writeAttributes(printStream);
        printStream.print("}\n\n");
    }

    public EntityInstance newEntity(String string) {
        EntityInstance entityInstance = new EntityInstance(this, string);
        this.makeInstanceOfUs(entityInstance);
        return entityInstance;
    }

    public String addParentClass(EntityClass entityClass) {
        return this.addParentClass(entityClass, ENTITY_BASE_CLASS_ID);
    }

    public int getPrimaryAttributeCount() {
        return 7;
    }

    public String getLsAttributeNameAt(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "id";
                break;
            }
            case 1: {
                string = "class_label";
                break;
            }
            case 2: {
                string = "class_description";
                break;
            }
            case 3: {
                string = "class_style";
                break;
            }
            case 4: {
                string = "color";
                break;
            }
            case 5: {
                string = "labelcolor";
                break;
            }
            case 6: {
                string = "opencolor";
                break;
            }
            default: {
                string = super.getLsAttributeNameAt(n);
            }
        }
        return string;
    }

    public Object getLsAttributeValueAt(int n) {
        Object object;
        switch (n) {
            case 0: {
                object = this.getId();
                break;
            }
            case 1: {
                object = this.getLabel();
                break;
            }
            case 2: {
                object = this.getDescription();
                break;
            }
            case 3: {
                object = new Integer(this.getStyle());
                break;
            }
            case 4: {
                if (this.hasObjectColor()) {
                    object = this.getObjectColor();
                    break;
                }
                object = null;
                break;
            }
            case 5: {
                if (this.hasLabelColor()) {
                    object = this.getLabelColor();
                    break;
                }
                object = null;
                break;
            }
            case 6: {
                object = this.getColorWhenOpen();
                break;
            }
            default: {
                object = super.getLsAttributeValueAt(n);
            }
        }
        return object;
    }

    public void setAttributeValueAt(int n, Object object) {
        switch (n) {
            case 0: {
                this.setId((String)object);
                break;
            }
            case 1: {
                this.updateLabel((String)object);
                break;
            }
            case 2: {
                this.updateDescription((String)object);
                break;
            }
            case 3: {
                this.updateStyle((Integer)object);
                break;
            }
            case 4: {
                this.updateObjectColor((Color)object);
                break;
            }
            case 5: {
                this.updateLabelColor((Color)object);
                break;
            }
            case 6: {
                this.updateColorWhenOpen((Color)object);
                break;
            }
            default: {
                super.setAttributeValueAt(n, object);
            }
        }
    }

    public int getLsAttributeTypeAt(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 1: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 8;
                break;
            }
            default: {
                n2 = super.getLsAttributeTypeAt(n);
            }
        }
        return n2;
    }
}

