/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.MenuElement;

public class FontCache {
    public static final String DEFAULT_FONT_NAME = "Helvetica";
    public static final int DEFAULT_FONT_STYLE = 0;
    public static final int DEFAULT_FONT_SIZE = 12;
    public static final String DEFAULT_MENU_FONT_NAME = "Dialog";
    public static final int DEFAULT_MENU_FONT_STYLE = 1;
    public static final int DEFAULT_MENU_FONT_SIZE = 12;
    protected static Font m_menuFont = FontCache.get("Dialog", 1, 12);
    public static final String DEFAULT_DIALOG_FONT_NAME = "Dialog";
    public static final int DEFAULT_DIALOG_FONT_STYLE = 0;
    public static final int DEFAULT_DIALOG_FONT_SIZE = 12;
    protected static Font m_dialogFont = FontCache.get("Dialog", 0, 12);
    private static final int m_initialCapacity = 50;
    private static final float m_loadFactor = 0.75f;
    private static Entry[] m_table = null;
    private static int m_count = 0;
    private static int m_threshold = 37;

    public static int size() {
        return m_count;
    }

    public static boolean isEmpty() {
        return m_count == 0;
    }

    public static void clear() {
        Entry[] entryArray = m_table;
        if (entryArray != null) {
            int n = entryArray.length;
            while (--n >= 0) {
                entryArray[n] = null;
            }
        }
        m_count = 0;
    }

    protected static int hashCode(String string, int n, int n2) {
        return string.hashCode() ^ n ^ n2;
    }

    protected static void rehash() {
        Entry[] entryArray = m_table;
        int n = entryArray.length;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        m_threshold = (int)((float)n2 * 0.75f);
        m_table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.m_next;
                int n4 = (entry2.m_value.hashCode() & Integer.MAX_VALUE) % n2;
                entry2.m_next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    protected static void put(Font font, int n) {
        Entry[] entryArray = m_table;
        if (m_count >= m_threshold) {
            FontCache.rehash();
            entryArray = m_table;
            n = (font.hashCode() & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n] = new Entry(font, entryArray[n]);
        ++m_count;
    }

    public static Font get(String string, int n, int n2) {
        Font font;
        int n3;
        Entry[] entryArray = m_table;
        int n4 = FontCache.hashCode(string, n, n2);
        if (entryArray == null) {
            m_table = new Entry[50];
            n3 = (n4 & Integer.MAX_VALUE) % m_table.length;
        } else {
            n3 = (n4 & Integer.MAX_VALUE) % entryArray.length;
            Entry entry = entryArray[n3];
            while (entry != null) {
                font = entry.m_value;
                if (string.equals(font.getName()) && n == font.getStyle() && n2 == font.getSize()) {
                    return font;
                }
                entry = entry.m_next;
            }
        }
        font = new Font(string, n, n2);
        FontCache.put(font, n3);
        return font;
    }

    public static Font getDialogFont() {
        return m_dialogFont;
    }

    public static void setDialogFont(Font font) {
        m_dialogFont = font;
    }

    public static Font getMenuFont() {
        return m_menuFont;
    }

    public static void setMenuFont(Font font) {
        m_menuFont = font;
    }

    public static void setMenuFont(MenuElement menuElement, Font font) {
        MenuElement[] menuElementArray = menuElement.getSubElements();
        ((JComponent)((Object)menuElement)).setFont(font);
        if (menuElementArray != null) {
            for (int i = 0; i < menuElementArray.length; ++i) {
                FontCache.setMenuFont(menuElementArray[i], font);
            }
        }
    }

    public static void setMenuTreeFont(MenuElement menuElement) {
        FontCache.setMenuFont(menuElement, m_menuFont);
    }

    static class Entry {
        public Font m_value;
        public Entry m_next;

        protected Entry(Font font, Entry entry) {
            this.m_value = font;
            this.m_next = entry;
        }
    }
}

