/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;
import lsedit.Util;

public class FontChooser
extends JDialog
implements ItemListener,
ActionListener {
    private static final int m_fontPanelWidth = 150;
    private static final int m_fontPanelHeight = 100;
    private static final int m_fontPanelXMargin = 5;
    private static final int m_fontPanelYMargin = 10;
    public static final int TARGET_ALL = 0;
    public static final int TARGET_CLOSED = 1;
    public static final int TARGET_OPEN = 2;
    public static final int TARGET_OPEN_CLASS = 3;
    public static final int TARGET_CLIENTS = 4;
    public static final int TARGET_CARDINALS = 5;
    public static final int TARGET_RESULTS_TITLE = 6;
    public static final int TARGET_RESULTS_TEXT = 7;
    public static final int TARGET_LEGEND_TITLE = 8;
    public static final int TARGET_LEGEND_TEXT = 9;
    public static final int TARGET_QUERY_TITLE = 10;
    public static final int TARGET_QUERY_TEXT = 11;
    public static final int TARGET_TOC = 12;
    public static final int TARGET_UNDO = 13;
    public static final int TARGET_HISTORY = 14;
    public static final int TARGET_MAP = 15;
    public static final int TARGET_TITLE = 16;
    public static final int TARGET_TEXTBOX = 17;
    public static final int TARGET_FEEDBACK = 18;
    public static final int TARGET_MENU = 19;
    public static final int TARGET_DIALOG = 20;
    public static final int TARGET_LAST = 20;
    private static final String[] m_targetnames = new String[]{"ALL FONTS", "CLOSED LABEL", "OPEN LABEL", "OPEN CLASS LABEL", "CLIENT/SUPPIER LABEL", "CARDINALS", "RESULTS TITLE", "RESULTS TEXT", "LEGEND TITLE", "LEGEND TEXT", "QUERY TITLE", "QUERY TEXT", "TOC", "UNDO", "HISTORY", "MAP", "TITLE", "TEXTBOX", "FEEDBACK", "MENU", "DIALOG"};
    private static final String[] m_targetDescription = new String[]{"***ALL***", "closed label", "small label", "open class label", "client/supplier", "cardinal", "results title", "results text", "legend title", "legend text", "query title", "query text", "TOC", "undo", "map", "title", "text box", "feedback", "menu", "dialog"};
    private static final String[] m_stylenames = new String[]{"DEFAULT", "PLAIN", "BOLD", "ITALIC", "BOLD & ITALIC"};
    private static final String[] m_sizenames = new String[]{"DEFAULT", "4", "5", "6", "7", "8", "9", "10", "12", "14", "16", "18", "20", "22", "24", "26", "28", "30"};
    private static GraphicsEnvironment m_gEnv = null;
    private static String[] m_envfonts = null;
    private LandscapeEditorCore m_ls;
    private int m_target;
    private String m_targetname;
    private Font m_font;
    private String m_fontname;
    private int m_style;
    private int m_size;
    private boolean m_name_default;
    private boolean m_style_default;
    private boolean m_size_default;
    private FontPanel m_fontPanel;
    private JComboBox m_targets;
    private JComboBox m_fonts;
    private JComboBox m_sizes;
    private JComboBox m_styles;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JButton m_clearButton;

    protected void newFont(Font font) {
        this.m_font = font;
        this.m_fontname = font.getFamily();
        this.m_style = font.getStyle();
        this.m_size = font.getSize();
    }

    protected void newFont() {
        this.newFont(FontCache.get(this.m_fontname, this.m_style, this.m_size));
    }

    protected void setTarget(int n) {
        int n2;
        Font font = this.m_ls.getTargetFont(n);
        if (font == null) {
            return;
        }
        this.m_target = n;
        this.m_targetname = m_targetDescription[n];
        this.newFont(font);
        this.m_targets.setSelectedIndex(n);
        this.m_name_default = true;
        for (n2 = 1; n2 < m_envfonts.length; ++n2) {
            if (!this.m_fontname.equalsIgnoreCase(m_envfonts[n2])) continue;
            this.m_fonts.setSelectedIndex(n2);
            this.m_name_default = false;
            break;
        }
        if (this.m_name_default) {
            this.m_fonts.setSelectedIndex(0);
        }
        if (this.m_style < 4) {
            this.m_style_default = true;
            this.m_styles.setSelectedIndex(0);
        } else {
            this.m_style_default = false;
            this.m_styles.setSelectedIndex(this.m_style + 1);
        }
        String string = "" + this.m_size;
        this.m_size_default = true;
        for (n2 = 1; n2 < m_sizenames.length; ++n2) {
            if (!string.equals(m_sizenames[n2])) continue;
            this.m_sizes.setSelectedIndex(n2);
            this.m_size_default = false;
            break;
        }
        if (this.m_size_default) {
            this.m_sizes.setSelectedIndex(0);
        }
    }

    public FontChooser(JFrame jFrame, LandscapeEditorCore landscapeEditorCore) {
        super(jFrame, "Select font for target", true);
        Object object;
        this.m_ls = landscapeEditorCore;
        Container container = this.getContentPane();
        Font font = FontCache.getDialogFont();
        Font font2 = font.deriveFont(1);
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new GridLayout(2, 1));
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add("Center", jPanel5);
        jPanel6.add("East", jPanel4);
        jPanel.add("West", jPanel2);
        jPanel.add("Center", jPanel3);
        jPanel.add("East", jPanel6);
        container.add("North", jPanel);
        JLabel jLabel = new JLabel();
        jLabel.setText("Target");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(0);
        jPanel2.add(jLabel);
        jLabel = new JLabel();
        jLabel.setText("Fonts");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(0);
        jPanel3.add(jLabel);
        jLabel = new JLabel();
        jLabel.setText("Styles");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(0);
        jPanel5.add(jLabel);
        jLabel = new JLabel();
        jLabel.setText("Sizes");
        jLabel.setFont(font2);
        jLabel.setHorizontalAlignment(0);
        jPanel4.add(jLabel);
        this.m_targets = new JComboBox<String>(m_targetnames);
        this.m_targetname = "target";
        this.m_targets.setFont(font2);
        this.m_targets.setSelectedIndex(0);
        this.m_targets.setMaximumRowCount(9);
        this.m_targets.addItemListener(this);
        jPanel2.add(this.m_targets);
        if (m_gEnv == null) {
            m_gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        if (m_envfonts == null) {
            int n;
            m_envfonts = m_gEnv.getAvailableFontFamilyNames();
            object = new String[n + 1];
            for (n = m_envfonts.length; n > 0; --n) {
                object[n] = m_envfonts[n - 1];
            }
            object[0] = "DEFAULT";
            m_envfonts = object;
        }
        this.m_fonts = new JComboBox<String>(m_envfonts);
        this.m_fonts.setFont(font2);
        this.m_fonts.setMaximumRowCount(9);
        this.m_fonts.addItemListener(this);
        jPanel3.add(this.m_fonts);
        this.m_styles = new JComboBox<String>(m_stylenames);
        this.m_styles.setFont(font2);
        this.m_styles.setMaximumRowCount(9);
        this.m_styles.addItemListener(this);
        jPanel5.add(this.m_styles);
        this.m_sizes = new JComboBox<String>(m_sizenames);
        this.m_sizes.setFont(font2);
        this.m_sizes.setMaximumRowCount(9);
        this.m_sizes.addItemListener(this);
        jPanel4.add(this.m_sizes);
        this.m_fontPanel = new FontPanel();
        this.m_fontPanel.setBackground(Color.white);
        container.add("Center", this.m_fontPanel);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(1, 15, 15));
        this.m_okButton = new JButton("OK");
        this.m_okButton.setFont(font2);
        this.m_okButton.addActionListener(this);
        ((Container)object).add(this.m_okButton);
        this.m_clearButton = new JButton("Clear Cache");
        this.m_clearButton.setFont(font2);
        this.m_clearButton.addActionListener(this);
        ((Container)object).add(this.m_clearButton);
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.setFont(font2);
        this.m_cancelButton.addActionListener(this);
        ((Container)object).add(this.m_cancelButton);
        container.add("South", (Component)object);
        this.setLocation(20, 20);
        this.m_name_default = false;
        this.m_style_default = false;
        this.m_size_default = false;
        this.setTarget(0);
        this.pack();
        this.show();
    }

    public Font getFontChoice() {
        return this.m_font;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Object object = itemEvent.getSource();
            if (object == this.m_targets) {
                int n = this.m_targets.getSelectedIndex();
                this.setTarget(n);
            } else {
                if (object == this.m_fonts) {
                    int n = this.m_fonts.getSelectedIndex();
                    if (n == 0) {
                        this.m_name_default = true;
                        this.m_fontname = this.m_ls.getDefaultFontName(this.m_target);
                    } else {
                        this.m_name_default = false;
                        this.m_fontname = (String)this.m_fonts.getSelectedItem();
                    }
                } else if (object == this.m_styles) {
                    int n = this.m_styles.getSelectedIndex();
                    if (n == 0) {
                        this.m_style_default = true;
                        this.m_style = this.m_ls.getDefaultFontStyle(this.m_target);
                    } else {
                        this.m_style_default = false;
                        this.m_style = --n;
                    }
                } else {
                    int n = this.m_sizes.getSelectedIndex();
                    if (n == 0) {
                        this.m_size_default = true;
                        this.m_size = this.m_ls.getDefaultFontSize(this.m_target);
                    } else {
                        String string = (String)this.m_sizes.getSelectedItem();
                        Integer n2 = new Integer(string);
                        this.m_size = n2;
                        this.m_size_default = false;
                    }
                }
                this.newFont();
            }
            this.m_fontPanel.repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.m_cancelButton) {
            if (object == this.m_clearButton) {
                int n = FontCache.size();
                FontCache.clear();
                JOptionPane.showMessageDialog(this, n + " fonts have been removed from the cache");
                return;
            }
            if (object != this.m_okButton) {
                return;
            }
            this.m_ls.setTargetFont(this.m_target, this.m_font, this.m_name_default, this.m_style_default, this.m_size_default);
        }
        this.setVisible(false);
    }

    class FontPanel
    extends JPanel {
        public Dimension getPreferredSize() {
            return new Dimension(150, 100);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(Color.darkGray);
            graphics.setFont(FontChooser.this.m_font);
            String string = "Set " + FontChooser.this.m_targetname + " font " + FontChooser.this.m_fontname + " ";
            string = FontChooser.this.m_style < 4 ? string + m_stylenames[FontChooser.this.m_style + 1] : string + "style " + FontChooser.this.m_style;
            string = string + " size " + FontChooser.this.m_size;
            int n = FontChooser.this.getWidth();
            Util.drawStringWrapped(graphics, string, 5.0, 10.0, n - 10, 90.0, true, false);
        }
    }
}

