/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.HiArc;
import lsedit.HiGraphException;

public class HiGraph {
    int m_order;
    int m_width;
    int m_height;
    int m_xGap = -1;
    boolean m_horizontalArray = false;
    boolean m_dontReorder = false;
    boolean m_uniformDepth = false;
    boolean m_uniformWidth = false;
    boolean m_uniqueRank = false;
    Vector m_children = new Vector();
    HiArc m_parent = null;
    Vector m_out = new Vector();
    Vector m_in = new Vector();
    Vector m_self = new Vector();
    Vector m_hidden = null;
    int m_depth = 0;
    HiGraph m_duplicate;
    HiGraph m_sink = null;
    int m_sink_rank;
    int m_visited = 0;
    int m_inputs;
    int m_rank = 0;
    int m_weight;
    HiArc m_back = null;
    Vector m_span = null;
    int m_minbeneath;
    int m_postorder;
    int m_dummy_node = 0;
    static final int edgepointV = 1;
    static final int sinkV = 2;
    int m_position = 0;
    int m_rowweight = 0;
    int m_outside = 0;
    int m_x;
    int m_y;
    EntityInstance m_object;
    String m_label;

    public HiGraph(EntityInstance entityInstance, String string, int n, int n2) {
        this.m_object = entityInstance;
        this.m_width = n;
        this.m_height = n2;
        this.m_label = string;
    }

    public String toString() {
        return this.m_label;
    }

    public String label() {
        return this.m_label;
    }

    public int dummyNode() {
        return this.m_dummy_node;
    }

    public boolean edgePoint() {
        return this.m_dummy_node == 1;
    }

    public EntityInstance getReferencedObject() {
        return this.m_object;
    }

    public int x() {
        return this.m_x;
    }

    public int y() {
        return this.m_y;
    }

    public int width() {
        return this.m_width;
    }

    public void width(int n) {
        this.m_width = n;
    }

    public int height() {
        return this.m_height;
    }

    public void height(int n) {
        this.m_height = n;
    }

    public int depth() {
        return this.m_depth;
    }

    public int rank() {
        return this.m_rank;
    }

    public Vector children() {
        return this.m_children;
    }

    public Vector out() {
        return this.m_out;
    }

    public void rank(int n) {
        this.m_rank = n;
    }

    void sinkrank(int n) {
        if (this.m_sink != null) {
            this.m_sink.m_rank = n;
        }
        this.m_sink_rank = n;
    }

    public HiGraph newChild(EntityInstance entityInstance, String string, int n, int n2) {
        HiArc hiArc;
        HiGraph hiGraph = new HiGraph(entityInstance, string, n, n2);
        hiGraph.m_parent = hiArc = new HiArc(this, hiGraph, true);
        hiGraph.m_rank = hiGraph.m_depth = this.m_depth + 1;
        this.m_children.addElement(hiArc);
        return hiGraph;
    }

    public HiGraph newChild(int n) {
        String string;
        switch (n) {
            case 1: {
                string = "edgepoint";
                break;
            }
            case 2: {
                string = "sinkpoint";
                break;
            }
            default: {
                string = "";
            }
        }
        HiGraph hiGraph = this.newChild(null, string, 0, 0);
        hiGraph.m_dummy_node = n;
        return hiGraph;
    }

    public HiGraph newChild() {
        HiGraph hiGraph = this.newChild(1);
        return hiGraph;
    }

    public void xGap(int n) {
        this.m_xGap = n;
    }

    public int xGap() {
        return this.m_xGap;
    }

    public void horizontalArray(boolean bl) {
        this.m_horizontalArray = bl;
    }

    public boolean horizontalArray() {
        return this.m_horizontalArray;
    }

    public void dontReorder(boolean bl) {
        this.m_dontReorder = bl;
    }

    public boolean dontReorder() {
        return this.m_dontReorder;
    }

    public void uniqueRank(boolean bl) {
        this.m_uniqueRank = bl;
    }

    public boolean uniqueRank() {
        return this.m_uniqueRank;
    }

    public void uniformDepth(boolean bl) {
        this.m_uniformDepth = bl;
    }

    public boolean uniformWidth() {
        return this.m_uniformWidth;
    }

    public void uniformWidth(boolean bl) {
        this.m_uniformWidth = bl;
    }

    public boolean uniformDepth() {
        return this.m_uniformDepth;
    }

    public HiArc newInputArc(HiGraph hiGraph) {
        HiArc hiArc = new HiArc(hiGraph, this);
        if (hiGraph == this) {
            this.m_self.addElement(hiArc);
        } else {
            hiGraph.m_out.addElement(hiArc);
            this.m_in.addElement(hiArc);
        }
        return hiArc;
    }

    void newInputArc(HiArc hiArc) {
        this.m_in.addElement(hiArc);
    }

    void newOutputArc(HiArc hiArc) {
        hiArc.from(this);
        this.m_out.addElement(hiArc);
    }

    public HiArc newOutputArc(HiGraph hiGraph) {
        return hiGraph.newInputArc(this);
    }

    static void removeArc(Vector vector, HiArc hiArc) throws HiGraphException {
        if (vector == null || hiArc == null || !vector.removeElement(hiArc)) {
            String string = "Can't remove " + hiArc;
            if (vector == null) {
                string = string + " from null vector";
            }
            if (hiArc != null) {
                for (int i = 0; i < 2; ++i) {
                    HiGraph hiGraph;
                    HiGraph hiGraph2 = hiGraph = i == 0 ? hiArc.from() : hiArc.to();
                    if (vector == hiGraph.m_children) {
                        string = string + " from " + hiGraph + ".m_children";
                    }
                    if (vector == hiGraph.m_in) {
                        string = string + " from " + hiGraph + ".m_in";
                    }
                    if (vector == hiGraph.m_out) {
                        string = string + " from " + hiGraph + ".m_out";
                    }
                    if (vector == hiGraph.m_self) {
                        string = string + " from " + hiGraph + ".m_self";
                    }
                    if (vector != hiGraph.m_span) continue;
                    string = string + " from " + hiGraph + ".m_span";
                }
            }
            throw new HiGraphException(string);
        }
    }

    public HiArc locateInputArc(HiGraph hiGraph, boolean bl) {
        Vector vector = hiGraph == this ? this.m_self : this.m_in;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph2 = hiArc.from();
            if (hiGraph2 == hiGraph) {
                return hiArc;
            }
            if (!bl || hiGraph2.m_dummy_node == 0 || hiGraph2.locateInputArc(hiGraph, bl) == null) continue;
            return hiArc;
        }
        return null;
    }

    private void dispose_internal() throws HiGraphException {
        HiGraph hiGraph;
        HiArc hiArc;
        Enumeration enumeration = this.m_in.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph = hiArc.from();
            if (hiGraph == this || hiArc.to() != this) {
                throw new HiGraphException(this + " has an illegal input arc " + hiArc);
            }
            HiGraph.removeArc(hiGraph.m_out, hiArc);
        }
        enumeration = this.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph = hiArc.to();
            if (hiArc.from() != this || hiGraph == this) {
                throw new HiGraphException(this + " has an illegal output arc " + hiArc);
            }
            HiGraph.removeArc(hiGraph.m_in, hiArc);
        }
        this.m_in.removeAllElements();
        this.m_out.removeAllElements();
        this.m_self.removeAllElements();
        enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            hiGraph = hiArc.to();
            hiGraph.dispose_internal();
        }
        this.m_children.removeAllElements();
        if (this.m_hidden != null) {
            this.m_hidden.removeAllElements();
            this.m_hidden = null;
        }
        this.m_in = null;
        this.m_out = null;
        this.m_self = null;
        this.m_parent = null;
        this.m_children = null;
    }

    public void dispose() throws HiGraphException {
        if (this.m_parent != null) {
            HiGraph hiGraph = this.m_parent.from();
            if (!hiGraph.m_children.removeElement(this.m_parent) && !hiGraph.m_hidden.removeElement(this.m_parent)) {
                throw new HiGraphException("Can't disconnect " + this + " from " + hiGraph);
            }
        }
        this.dispose_internal();
    }

    void removeDummy() throws HiGraphException {
        int n = this.m_children.size();
        int n2 = 0;
        while (n2 < n) {
            HiArc hiArc = (HiArc)this.m_children.elementAt(n2);
            HiGraph hiGraph = hiArc.to();
            if (hiGraph.m_dummy_node == 1) {
                HiArc hiArc2 = (HiArc)hiGraph.m_in.elementAt(0);
                HiGraph hiGraph2 = hiArc2.from();
                HiArc hiArc3 = (HiArc)hiGraph.m_out.elementAt(0);
                hiArc3.from(hiGraph2);
                hiGraph2.m_out.removeElement(hiArc2);
                hiGraph2.m_out.addElement(hiArc3);
                this.m_children.removeElementAt(n2);
                --n;
                continue;
            }
            hiGraph.removeDummy();
            ++n2;
        }
    }

    void orderBy() {
        int n = this.m_children.size();
        for (int i = 0; i < n; ++i) {
            HiArc hiArc;
            HiArc hiArc2 = (HiArc)this.m_children.elementAt(i);
            HiGraph hiGraph = hiArc2.to();
            int n2 = i;
            for (int j = i + 1; j < n; ++j) {
                hiArc = (HiArc)this.m_children.elementAt(j);
                HiGraph hiGraph2 = hiArc.to();
                if (hiGraph2.m_order >= hiGraph.m_order) continue;
                n2 = j;
                hiGraph = hiGraph2;
            }
            if (n2 == i) continue;
            hiArc2 = (HiArc)this.m_children.elementAt(i);
            hiArc = (HiArc)this.m_children.elementAt(n2);
            this.m_children.setElementAt(hiArc2, n2);
            this.m_children.setElementAt(hiArc, i);
        }
    }

    public void orderByRank() {
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph = hiArc.to();
            hiGraph.m_order = hiGraph.m_rank;
        }
        this.orderBy();
    }

    public void describe() {
        HiArc hiArc;
        System.out.println("\nDescription of " + this.label());
        System.out.println("Depth=" + this.m_depth + " rank=" + this.m_rank + "-" + this.m_sink_rank + " position=" + this.m_position);
        System.out.println("x=" + this.m_x + " y=" + this.m_y + " width=" + this.m_width + " height=" + this.m_height);
        System.out.println(" Weight=" + this.m_weight + " outside=" + this.m_outside + " type=" + this.m_dummy_node);
        if (this.m_parent != null) {
            System.out.println("   Parent: " + this.m_parent);
        }
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            System.out.println("    Child: " + hiArc);
        }
        if (this.m_hidden != null) {
            enumeration = this.m_hidden.elements();
            while (enumeration.hasMoreElements()) {
                hiArc = (HiArc)enumeration.nextElement();
                System.out.println("   Hidden: " + hiArc);
            }
        }
        enumeration = this.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            System.out.println("   Arc to: " + hiArc);
        }
        enumeration = this.m_in.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            System.out.println(" Arc from: " + hiArc);
        }
        enumeration = this.m_self.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            System.out.println(" Self arc: " + hiArc);
        }
    }

    public void dump() {
        HiArc hiArc;
        String string = "";
        for (int i = this.m_rank; i > 0; --i) {
            string = string + " ";
        }
        string = string + this.label() + "[rank=" + this.m_rank;
        if (this.m_rank != this.m_sink_rank) {
            string = string + "-" + this.m_sink_rank;
        }
        string = string + "/" + this.m_position + "/" + this.m_order + "{" + this.m_x + "," + this.m_y + ":" + this.m_width + "," + this.m_height + "}]";
        if (this.m_back != null) {
            string = string + " back=" + this.m_back;
        }
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            if ((string = string + " " + hiArc).length() <= 70) continue;
            System.out.println(string);
            string = " ";
        }
        string = string + " | ";
        enumeration = this.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            string = string + " " + hiArc;
        }
        string = string + " | ";
        enumeration = this.m_in.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            string = string + " " + hiArc;
        }
        if (this.m_self.size() != 0) {
            string = string + " | ";
            enumeration = this.m_self.elements();
            while (enumeration.hasMoreElements()) {
                hiArc = (HiArc)enumeration.nextElement();
                string = string + " " + hiArc;
            }
        }
        System.out.println(string);
        enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph = hiArc.to();
            hiGraph.dump();
        }
    }

    private void duplicateNodes() {
        this.m_duplicate = new HiGraph(this.m_object, this.m_label, this.m_width, this.m_height);
        this.m_duplicate.m_depth = this.m_depth;
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph = hiArc.to();
            hiGraph.duplicateNodes();
        }
    }

    private void duplicateEdges() {
        HiArc hiArc;
        HiGraph hiGraph;
        HiGraph hiGraph2;
        HiArc hiArc2;
        HiGraph hiGraph3 = this.m_duplicate;
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            hiArc2 = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc2.to();
            hiGraph = hiGraph2.m_duplicate;
            hiArc = new HiArc(hiGraph3, hiGraph, true);
            hiGraph3.m_children.addElement(hiArc);
            hiGraph.m_parent = hiArc;
            hiGraph2.duplicateEdges();
        }
        enumeration = this.m_out.elements();
        while (enumeration.hasMoreElements()) {
            hiArc2 = (HiArc)enumeration.nextElement();
            hiGraph2 = hiArc2.to();
            hiGraph = hiGraph2.m_duplicate;
            hiArc = new HiArc(hiGraph3, hiGraph);
            hiGraph3.m_out.addElement(hiArc);
            hiGraph.m_in.addElement(hiArc);
        }
        enumeration = this.m_self.elements();
        while (enumeration.hasMoreElements()) {
            hiArc2 = (HiArc)enumeration.nextElement();
            hiArc = new HiArc(hiGraph3, hiGraph3);
            hiGraph3.m_self.addElement(hiArc);
        }
    }

    private void clearReferences() {
        this.m_duplicate = null;
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph = hiArc.to();
            hiGraph.clearReferences();
        }
    }

    HiGraph duplicate() {
        this.duplicateNodes();
        this.duplicateEdges();
        HiGraph hiGraph = this.m_duplicate;
        this.clearReferences();
        return hiGraph;
    }

    void shift(int n, int n2) {
        this.m_x += n;
        this.m_y += n2;
        Enumeration enumeration = this.m_children.elements();
        while (enumeration.hasMoreElements()) {
            HiArc hiArc = (HiArc)enumeration.nextElement();
            HiGraph hiGraph = hiArc.to();
            hiGraph.shift(n, n2);
        }
    }
}

