/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.Scrollable;
import lsedit.Diagram;
import lsedit.EntityInstance;
import lsedit.FontCache;
import lsedit.LandscapeEditorCore;

public class MapBox
extends JComponent
implements Scrollable {
    protected static final int GAP = 5;
    public static final String DEFAULT_MAP_FONT_NAME = "Helvetica";
    public static final int DEFAULT_MAP_FONT_STYLE = 0;
    public static final int DEFAULT_MAP_FONT_SIZE = 10;
    protected static Font m_textFont = FontCache.get("Helvetica", 0, 10);
    protected static final int TY_CLEAR = 0;
    protected static final int TY_RAISED = 1;
    protected static final int TY_SUNK = 2;
    protected LandscapeEditorCore m_ls;
    protected JTabbedPane m_tabbedPane;
    protected JScrollPane m_scrollPane;
    protected String m_title;
    protected EntityInstance m_e = null;
    protected int m_last_scrollPane_width = 0;
    protected double m_last_ratio = 0.0;
    public static final String m_helpStr = "This box shows stylized versions of landscapes representing the path from the top of the containment hierarchy to the current landscape, with green boxes highlighting steps in the path.";

    public MapBox(LandscapeEditorCore landscapeEditorCore, JTabbedPane jTabbedPane) {
        this.m_ls = landscapeEditorCore;
        this.m_tabbedPane = jTabbedPane;
        this.m_title = "Map";
        this.setLayout(null);
        this.setBackground(Diagram.boxColour);
        this.setToolTipText(m_helpStr);
        this.m_scrollPane = new JScrollPane();
        this.m_scrollPane.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.setBounds(0, 0, jTabbedPane.getWidth(), jTabbedPane.getHeight());
        this.m_scrollPane.setViewportView(this);
        jTabbedPane.addTab(this.m_title, null, this.m_scrollPane, m_helpStr);
    }

    public static Font getTextFont() {
        return m_textFont;
    }

    public static void setTextFont(Font font) {
        m_textFont = font;
    }

    public void textFontChanged(Font font) {
        if (this.m_e != null) {
            this.fill(this.m_e);
        } else {
            this.validate();
            this.repaint();
        }
    }

    public void activate() {
        this.m_tabbedPane.setSelectedComponent(this.m_scrollPane);
    }

    public boolean isActive() {
        if (!this.isVisible()) {
            return false;
        }
        Component component = this.m_tabbedPane.getSelectedComponent();
        return component != null && this.m_scrollPane == component;
    }

    public Dimension getPreferredSize() {
        Diagram diagram = this.m_ls.getDiagram();
        if (diagram == null) {
            this.m_last_ratio = 0.0;
        } else {
            Insets insets = this.m_scrollPane.getInsets();
            int n = this.m_scrollPane.getWidth() - 5 - insets.right - insets.left;
            int n2 = diagram.getWidth();
            int n3 = diagram.getHeight();
            double d = (double)n3 / (double)n2;
            if (n != this.m_last_scrollPane_width || d != this.m_last_ratio) {
                int n4 = n - 5;
                if (n4 < 0) {
                    n4 = 0;
                }
                int n5 = (int)((double)n4 * d);
                int n6 = this.getComponentCount();
                int n7 = n6 * (n5 + 5);
                Dimension dimension = new Dimension(n, n7);
                this.setPreferredSize(dimension);
                this.setSize(dimension);
                this.setMaximumSize(dimension);
                this.m_last_scrollPane_width = n;
                this.m_last_ratio = d;
            }
        }
        return super.getPreferredSize();
    }

    public void addAll(EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        if (entityInstance != null && (entityInstance2 = entityInstance.getContainedBy()) != null) {
            this.addAll(entityInstance2);
            if (entityInstance.isEnterable()) {
                this.add(new Map(this, entityInstance));
            }
        }
    }

    public void fill(EntityInstance entityInstance) {
        this.m_e = entityInstance;
        this.removeAll();
        this.addAll(entityInstance);
        this.m_last_scrollPane_width = -1;
        this.getPreferredSize();
        this.validate();
        this.setVisible(true);
        this.repaint();
    }

    public void validate() {
        super.validate();
        double d = this.m_last_ratio;
        if (d > 0.0) {
            int n = 5;
            int n2 = 0;
            int n3 = this.m_last_scrollPane_width - 10;
            int n4 = (int)((double)n3 * d);
            Dimension dimension = new Dimension(n3, n4);
            int n5 = this.getComponentCount();
            for (int i = 0; i < n5; ++i) {
                Map map = (Map)this.getComponent(i);
                map.setLocation(n, n2);
                map.setSize(dimension);
                map.setMinimumSize(dimension);
                map.setPreferredSize(dimension);
                map.setMaximumSize(dimension);
                n2 += n4 + 5;
            }
        }
    }

    public Dimension getMaximumSize() {
        return this.getSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return 50;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    class Map
    extends JComponent
    implements MouseListener {
        protected int m_style;
        protected JLabel m_label;
        protected EntityInstance m_entity;

        public Map(MapBox mapBox2, EntityInstance entityInstance) {
            this.setLayout(null);
            this.m_style = 0;
            this.m_entity = entityInstance;
            EntityInstance entityInstance2 = entityInstance.getContainedBy();
            this.m_label = new JLabel(entityInstance2 != null ? entityInstance2.getEntityLabel() : "", 0);
            this.m_label.setForeground(Color.black);
            this.m_label.setFont(m_textFont);
            this.m_label.setLocation(0, 0);
            this.add(this.m_label);
            this.setToolTipText(entityInstance.getEntityLabel());
            this.addMouseListener(this);
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            this.m_label.setSize(n3, 20);
        }

        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int n3 = this.m_label.getHeight();
            if (this.m_style != 0) {
                graphics.setColor(Diagram.boxColour);
                graphics.draw3DRect(0, 0, n - 2, n2 - 2, this.m_style == 1);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
            EntityInstance entityInstance = this.m_entity.getContainedBy();
            if (entityInstance != null) {
                entityInstance.paintMap(graphics, (int)((double)n * 0.166), n3 + 5, (int)((double)n * 0.66), n2 - n3 - 10, this.m_entity, 0);
            }
        }

        public void validate() {
            super.validate();
            int n = MapBox.this.m_last_scrollPane_width - 10;
            int n2 = this.m_label.getHeight();
            this.m_label.setBounds(0, 0, n, n2);
        }

        public String toString() {
            return "Map " + this.m_label.getText() + " " + this.getBounds();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.m_style = 1;
            this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.m_style = 0;
            this.repaint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_style = 2;
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.m_style = 0;
            MapBox.this.m_ls.followLink(this.m_entity.getContainedBy(), false);
        }
    }
}

